package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题：DycProBaseCallEsbUtilCreateContractForTyBO
 * 描述：创建合同（糖业）BO
 */
@Data
public class DycProBaseCallEsbUtilCreateContractForTyBO implements Serializable {

    private static final long serialVersionUID = -2085719862070635050L;

    /**
     * 订单 id
     */
    private Long orderId;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 创建客户 ID（公司 id）
     */
    private String createCompanyID;

    /**
     * 订单状态（固定传 21）
     */
    private Integer orderStatus;

    /**
     * 支付方式（1: 货到付款, 2: 邮局付款, 4: 在线支付, 5: 公司转账, 6: 银行转账, 7: 网银钱包, 101: 金采支付）
     * 固定传 101
     */
    private String payType;

    /**
     * 订单总金额
     */
    private BigDecimal orderAmount;

    /**
     * 订单税额
     * 商城无此数据，不会返回？
     */
    private BigDecimal orderTaxPrice;

    /**
     * 订单裸价
     * 商城无此数据，不会返回？
     */
    private BigDecimal orderNakedPrice;

    /**
     * 创建人 ID（用户 id）
     */
    private String createId;

    /**
     * E+userId
     */
    private String QiWeiUserId;

    /**
     * 创建时间（下单时间）
     */
    private String createDate;

    /**
     * 订单备注
     */
    private String orderDesc;

    /**
     * 收件人（收货联系人）
     */
    private String userAddressName;

    /**
     * 收件人邮箱（收货联系人邮箱）
     */
    private String userAddressMail;

    /**
     * 收件人电话（收货联系人电话）
     */
    private String userAddressPhone;

    /**
     * 收件地址（收货地址）
     */
    private String receiveInfo;

    /**
     * 创建时间戳
     * 商城无此数据，不会返回？
     */
    private Long createTimeStamp;

    /**
     * 电商供应商【0: 京东, 3: 西域】
     */
    private String sourceType;

    /**
     * 订单类型【0 - 标准订单 1- 费用 2-固定资产】
     * 固定传值？
     */
    private Integer orderType;

    /**
     * 合同编号【没用，合同编号可以从电商生成】
     * 商城无此数据，不会返回？
     */
    private String contractCode;

    /**
     * 内部电商供应商编码，只有sourceType=999是才有值
     * 商城无此数据，不会返回？
     */
    private String storeCode;

    /**
     * 创建人所属公司名称
     */
    private String createCompanyName;

    /**
     * 创建人姓名
     */
    private String createUserName;

    /**
     *
     */
    private String NeedDepartment;

    /**
     *
     */
    private Long StoreId;

    /**
     * 传供应商名称
     */
    private String StoreName;

    /**
     *
     */
    private Long SubCompanyId;

    /**
     * 采购申请单ID
     */
    private String PurchaseApplyId;

    /**
     * 采购申请单编码
     */
    private String PurchaseApplyCode;

    /**
     * 订单行明细（销售单明细）
     */
    private List<DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO> orderDetails;

}
