/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agrchng.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngMainDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngQryDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrItemChngDTO;
import com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngItemSaveService;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngItemSaveReqBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngItemSaveRspBO;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngItemSaveService"})
public class DycProAgrChngItemSaveServiceImpl
implements DycProAgrChngItemSaveService {
    @Autowired
    private DycProAgrChngRepository agrChngRepository;

    @Override
    @PostMapping(value={"saveAgrChngItem"})
    public DycProAgrChngItemSaveRspBO saveAgrChngItem(@RequestBody DycProAgrChngItemSaveReqBO reqBO) {
        DycProAgrChngItemSaveRspBO rspBO = new DycProAgrChngItemSaveRspBO();
        this.validateParam(reqBO);
        DycProAgrChngMainDTO dycProAgrChngMainDTO = new DycProAgrChngMainDTO();
        dycProAgrChngMainDTO.setChngApplyId(reqBO.getChngApplyId());
        List dycProAgrItemChngDTOs = JSON.parseArray((String)JSON.toJSONString(reqBO.getAgrItemChngList()), DycProAgrItemChngDTO.class);
        dycProAgrItemChngDTOs.forEach(each -> each.setChngApplyId(reqBO.getChngApplyId()));
        dycProAgrChngMainDTO.setAgrItemChngBOList(dycProAgrItemChngDTOs);
        this.agrChngRepository.saveAgrItemChng(dycProAgrChngMainDTO);
        this.validateAgrItemChngList(reqBO, rspBO);
        return rspBO;
    }

    private void validateParam(DycProAgrChngItemSaveReqBO reqBO) {
        if (null == reqBO.getOperType()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getChngApplyId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010chngApplyId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBO.getAgrItemChngList())) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrItemChngList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void validateAgrItemChngList(DycProAgrChngItemSaveReqBO reqBO, DycProAgrChngItemSaveRspBO rspBO) {
        boolean chngItemValidateFlag = true;
        if (reqBO.getOperType() == 2) {
            DycProAgrChngQryDTO qryDTO = new DycProAgrChngQryDTO();
            qryDTO.setChngApplyId(reqBO.getChngApplyId());
            qryDTO.setPageNo(Integer.valueOf(1));
            qryDTO.setPageSize(Integer.valueOf(1));
            RspPage agrItemChngListPage = this.agrChngRepository.getAgrItemChngListPage(qryDTO);
            int total = agrItemChngListPage.getRecordsTotal() / 1000 + 1;
            block0: for (int i = 1; i <= total; ++i) {
                DycProAgrChngQryDTO qry = new DycProAgrChngQryDTO();
                qry.setChngApplyId(reqBO.getChngApplyId());
                qry.setPageNo(Integer.valueOf(i));
                qry.setPageSize(Integer.valueOf(1000));
                RspPage agrItemChngList = this.agrChngRepository.getAgrItemChngListPage(qry);
                if (CollectionUtils.isEmpty((Collection)agrItemChngList.getRows())) continue;
                for (DycProAgrItemChngDTO row : agrItemChngList.getRows()) {
                    if (null == row.getAgrItemNumber()) {
                        chngItemValidateFlag = false;
                        rspBO.setChngItemValidateFlag(chngItemValidateFlag);
                        continue block0;
                    }
                    if (null != row.getSupplyPrice()) continue;
                    chngItemValidateFlag = false;
                    rspBO.setChngItemValidateFlag(chngItemValidateFlag);
                    continue block0;
                }
            }
        }
    }
}

