/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrItemChngOperRecorAgrItemChngType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrItemInitCommFlag;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngQryDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrCommSkuPriceInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrItemChngOperRecorDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrItemListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrItemListQryPageService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemListQryReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemListQryRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrItemListQryPageService"})
public class DycProAgrItemListQryPageServiceImpl
implements DycProAgrItemListQryPageService {
    @Autowired
    private DycProAgrRepository agrMainRepository;
    @Autowired
    private DycProAgrChngRepository agrChngRepository;

    @Override
    @PostMapping(value={"qryAgrItemListPage"})
    public DycProAgrItemListQryRspBO qryAgrItemListPage(@RequestBody DycProAgrItemListQryReqBO reqBO) {
        if (reqBO.getAgrOrderQryFlag().booleanValue() && reqBO.getAgrObjPrimaryId() == null) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u5bf9\u8c61\u552f\u4e00ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProAgrItemListQryDTO qryDTO = (DycProAgrItemListQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProAgrItemListQryDTO.class);
        if (reqBO.getIgnoreChngApplyId() != null) {
            DycProAgrChngQryDTO qry = new DycProAgrChngQryDTO();
            qry.setChngApplyId(reqBO.getIgnoreChngApplyId());
            qry.setAgrItemChngType(Integer.valueOf(DmcAgrItemChngOperRecorAgrItemChngType.REDUCE.getCode()));
            qry.setPageNo(Integer.valueOf(1));
            qry.setPageSize(Integer.valueOf(999999));
            RspPage agrItemChngOperRecorListPage = this.agrChngRepository.getAgrItemChngOperRecorListPage(qry);
            if (!CollectionUtils.isEmpty((Collection)agrItemChngOperRecorListPage.getRows())) {
                qryDTO.setIgnoreAgrItemIds(agrItemChngOperRecorListPage.getRows().stream().map(DycProAgrItemChngOperRecorDTO::getAgrItemId).collect(Collectors.toList()));
            }
        }
        RspPage agrItemListPage = this.agrMainRepository.selectAgrItemListPage(qryDTO);
        DycProAgrItemListQryRspBO rspBO = (DycProAgrItemListQryRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)agrItemListPage), DycProAgrItemListQryRspBO.class));
        DycProAgrMainDTO dycProAgrMainDTO = new DycProAgrMainDTO();
        if (reqBO.getAgrOrderQryFlag().booleanValue()) {
            DycProAgrListQryDTO agrListQryDTO = new DycProAgrListQryDTO();
            agrListQryDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
            List agrMainList = this.agrMainRepository.selectAgrMainList(agrListQryDTO);
            dycProAgrMainDTO = (DycProAgrMainDTO)agrMainList.get(0);
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (DycProAgrItemBO each : rspBO.getRows()) {
                if (each.getInitCommFlag() == null) continue;
                each.setInitCommFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)DmcAgrItemInitCommFlag.class.getSimpleName(), (String)each.getInitCommFlag().toString()));
                if (!reqBO.getAgrOrderQryFlag().booleanValue()) continue;
                if (Integer.valueOf(DmcAgrMainTradeMode.MY.getCode()).equals(dycProAgrMainDTO.getTradeMode())) {
                    each.setSalePrice(this.computeSkuPrice(dycProAgrMainDTO.getSupplierId(), each));
                    continue;
                }
                each.setSalePrice(each.getSupplyPrice());
            }
        }
        return rspBO;
    }

    private BigDecimal computeSkuPrice(Long supplierId, DycProAgrItemBO agrItemBO) {
        DycProAgrCommSkuPriceInfoHandleDTO handleDTO = new DycProAgrCommSkuPriceInfoHandleDTO();
        handleDTO.setSupplierPrice(agrItemBO.getSupplyPrice());
        handleDTO.setSupplierId(supplierId);
        handleDTO.setAgrId(agrItemBO.getAgrId());
        handleDTO.setManageCatalogId(agrItemBO.getManageCatalogId());
        handleDTO.setPriceRuleType(DycProAgrConstants.PriceRuleType.AGR);
        DycProAgrCommSkuPriceInfoDTO result = this.agrChngRepository.computeSkuAgrPrice(handleDTO);
        return result.getSalePrice();
    }
}

