/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.stock.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.dmc.repository.measure.api.DycProCommMeasureInfoRespository;
import com.tydic.dyc.pro.dmc.repository.measure.dto.DycProCommMeasureInfoDTO;
import com.tydic.dyc.pro.dmc.repository.measure.dto.DycProCommMeasureInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.stock.api.DycProCommSkuStockInfoRepository;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoQryDTO;
import com.tydic.dyc.pro.dmc.service.stock.api.DycProCommQrySkuStockInfoListService;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommQrySkuStockInfoBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommQrySkuStockInfoListReqBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommQrySkuStockInfoListRspBO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.stock.api.DycProCommQrySkuStockInfoListService"})
public class DycProCommQrySkuStockInfoListServiceImpl
implements DycProCommQrySkuStockInfoListService {
    @Autowired
    private DycProCommSkuStockInfoRepository commSkuStockInfoRepository;
    @Autowired
    private DycProCommMeasureInfoRespository commMeasureInfoRepository;

    @PostMapping(value={"qrySkuStockList"})
    public DycProCommQrySkuStockInfoListRspBO qrySkuStockList(@RequestBody DycProCommQrySkuStockInfoListReqBO reqBO) {
        DycProCommQrySkuStockInfoListRspBO rspBO = new DycProCommQrySkuStockInfoListRspBO();
        DycProCommSkuStockInfoQryDTO queryDTO = new DycProCommSkuStockInfoQryDTO();
        queryDTO.setSkuIdList(reqBO.getSkuIdList());
        List result = this.commSkuStockInfoRepository.getStockList(queryDTO);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            rspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result), DycProCommQrySkuStockInfoBO.class));
            Map<Object, Object> measureMap = new HashMap();
            DycProCommMeasureInfoQryDTO dycProCommMeasureInfoDTO = new DycProCommMeasureInfoQryDTO();
            dycProCommMeasureInfoDTO.setMeasureNameList(result.stream().map(DycProCommSkuStockInfoDTO::getSaleMeasureName).distinct().collect(Collectors.toList()));
            List measureList = this.commMeasureInfoRepository.getMeasureList(dycProCommMeasureInfoDTO);
            if (!CollectionUtils.isEmpty((Collection)measureList)) {
                measureMap = measureList.stream().collect(Collectors.toMap(DycProCommMeasureInfoDTO::getMeasureName, DycProCommMeasureInfoDTO::getDecimalLimit, (o1, o2) -> o1));
            }
            for (DycProCommQrySkuStockInfoBO item : rspBO.getRows()) {
                Integer limit = (Integer)measureMap.get(item.getSaleMeasureName());
                if (null == limit) {
                    limit = 0;
                }
                item.setOriginNum(item.getOriginNum());
                item.setTotalNum(item.getTotalNum());
                item.setUnsaleNum(item.getUnsaleNum());
                item.setSaledNum(item.getSaledNum());
                item.setDecimalLimit(limit);
            }
        }
        return rspBO;
    }
}

