/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.stock.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuStockInfoRecordsChangeType;
import com.tydic.dyc.pro.dmc.repository.stock.api.DycProCommSkuStockInfoRepository;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoRecordsDTO;
import com.tydic.dyc.pro.dmc.service.stock.api.DycProCommUpdateSkuStockService;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommUpdateSkuStockReqBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommUpdateSkuStockRspBO;
import java.util.ArrayList;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.stock.api.DycProCommUpdateSkuStockService"})
public class CommUpdateSkuStockServiceImpl
implements DycProCommUpdateSkuStockService {
    @Autowired
    private DycProCommSkuStockInfoRepository commSkuStockInfoRepository;

    @Override
    @PostMapping(value={"updateSkuStock"})
    public DycProCommUpdateSkuStockRspBO updateSkuStock(@RequestBody DycProCommUpdateSkuStockReqBO reqBO) {
        DycProCommUpdateSkuStockRspBO rspBO = new DycProCommUpdateSkuStockRspBO();
        this.validateParam(reqBO);
        DycProCommSkuStockInfoDTO stockInfo = this.commSkuStockInfoRepository.getStockInfoById(reqBO.getStockId());
        DycProCommSkuStockInfoDTO updateStockInfo = new DycProCommSkuStockInfoDTO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateStockInfo);
        updateStockInfo.setStockId(reqBO.getStockId());
        if (Integer.valueOf(DmcCommSkuStockInfoRecordsChangeType.TOTAL_ADD.getCode()).equals(reqBO.getChangeType())) {
            updateStockInfo.setTotalNum(stockInfo.getTotalNum().add(reqBO.getChangeNum()));
            updateStockInfo.setUnsaleNum(stockInfo.getUnsaleNum().add(reqBO.getChangeNum()));
        }
        if (Integer.valueOf(DmcCommSkuStockInfoRecordsChangeType.TOTAL_REDUCE.getCode()).equals(reqBO.getChangeType())) {
            updateStockInfo.setTotalNum(stockInfo.getTotalNum().subtract(reqBO.getChangeNum()));
            updateStockInfo.setUnsaleNum(stockInfo.getUnsaleNum().subtract(reqBO.getChangeNum()));
        }
        ArrayList<DycProCommSkuStockInfoRecordsDTO> skuStockInfoRecordsList = new ArrayList<DycProCommSkuStockInfoRecordsDTO>();
        DycProCommSkuStockInfoRecordsDTO dycProCommSkuStockInfoRecordsDTO = new DycProCommSkuStockInfoRecordsDTO();
        dycProCommSkuStockInfoRecordsDTO.setChangeType(reqBO.getChangeType());
        dycProCommSkuStockInfoRecordsDTO.setChangeNum(reqBO.getChangeNum());
        dycProCommSkuStockInfoRecordsDTO.setBeforeTotalNum(stockInfo.getTotalNum());
        dycProCommSkuStockInfoRecordsDTO.setAfterTotalNum(updateStockInfo.getTotalNum());
        dycProCommSkuStockInfoRecordsDTO.setBeforeUnsaleNum(stockInfo.getUnsaleNum());
        dycProCommSkuStockInfoRecordsDTO.setAfterUnsaleNum(updateStockInfo.getUnsaleNum());
        skuStockInfoRecordsList.add(dycProCommSkuStockInfoRecordsDTO);
        updateStockInfo.setSkuStockInfoRecordsList(skuStockInfoRecordsList);
        this.commSkuStockInfoRepository.updateSkuStock(updateStockInfo);
        return rspBO;
    }

    private void validateParam(DycProCommUpdateSkuStockReqBO reqBO) {
        if (null == reqBO.getStockId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010stockId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getChangeNum()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010changeNum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getChangeType()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010changeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

