/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.channel.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.channel.api.DycProCommChannelRepository;
import com.tydic.dyc.pro.dmc.repository.channel.dto.DycProCommChannelGuideCatalogInfoDTO;
import com.tydic.dyc.pro.dmc.repository.channel.dto.DycProCommGuideCatalogManageRelDTO;
import com.tydic.dyc.pro.dmc.service.channel.api.DycProCommChannelQueryChannelRelGuideCatalogListService;
import com.tydic.dyc.pro.dmc.service.channel.bo.DycProCommChannelGuideCatalogInfoBO;
import com.tydic.dyc.pro.dmc.service.channel.bo.DycProCommChannelQueryChannelRelGuideCatalogListReqBO;
import com.tydic.dyc.pro.dmc.service.channel.bo.DycProCommChannelQueryChannelRelGuideCatalogListRspBO;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.channel.api.DycProCommChannelQueryChannelRelGuideCatalogListService"})
public class DycProCommChannelQueryChannelRelGuideCatalogListServiceImpl
implements DycProCommChannelQueryChannelRelGuideCatalogListService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommChannelQueryChannelRelGuideCatalogListServiceImpl.class);
    @Autowired
    private DycProCommChannelRepository dycProChannelRepository;

    @Override
    @PostMapping(value={"queryChannelRelGuideCatalogList"})
    public DycProCommChannelQueryChannelRelGuideCatalogListRspBO queryChannelRelGuideCatalogList(@RequestBody DycProCommChannelQueryChannelRelGuideCatalogListReqBO reqBO) {
        this.var(reqBO);
        DycProCommChannelQueryChannelRelGuideCatalogListRspBO rspBO = new DycProCommChannelQueryChannelRelGuideCatalogListRspBO();
        DycProCommChannelGuideCatalogInfoDTO channelGuideCatalogInfoDTO = (DycProCommChannelGuideCatalogInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProCommChannelGuideCatalogInfoDTO.class);
        List allNodesDTO = this.dycProChannelRepository.queryChannelRelatedGuideCatalog(channelGuideCatalogInfoDTO);
        for (DycProCommChannelGuideCatalogInfoDTO catalogInfoDTO : allNodesDTO) {
            if (!StringUtils.isBlank((CharSequence)catalogInfoDTO.getIcon())) continue;
            catalogInfoDTO.setIcon("weixiu1");
        }
        List allNodesBO = JSON.parseArray((String)JSON.toJSONString((Object)allNodesDTO), DycProCommChannelGuideCatalogInfoBO.class);
        DycProCommChannelGuideCatalogInfoBO rows = this.buildTree(allNodesBO, reqBO);
        rspBO.setRows(rows);
        return rspBO;
    }

    private void var(DycProCommChannelQueryChannelRelGuideCatalogListReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getChannelId())) {
            throw new ZTBusinessException("\u9891\u9053ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public DycProCommChannelGuideCatalogInfoBO buildTree(List<DycProCommChannelGuideCatalogInfoBO> allNodesBO, DycProCommChannelQueryChannelRelGuideCatalogListReqBO reqBO) {
        DycProCommChannelGuideCatalogInfoBO rows = new DycProCommChannelGuideCatalogInfoBO();
        rows.setGuideCatalogId(0L);
        rows.setGuideCatalogName("\u5bfc\u8d2d\u7c7b\u76ee");
        rows.setChannelId(reqBO.getChannelId());
        rows.setGuideCatalogUpperId(0L);
        rows.setGuideCatalogLevel(0);
        rows.setGuideCatalogUpperName("\u65e0");
        rows.setGuideCatalogPath("0");
        if (allNodesBO == null || allNodesBO.isEmpty()) {
            rows.setGuideCatalogMaxOrder(0);
            return rows;
        }
        allNodesBO = allNodesBO.stream().filter(bo -> DycProCommConstants.GuideCatalogLevel.FIRST.equals(bo.getGuideCatalogLevel()) || DycProCommConstants.GuideCatalogLevel.SECOND.equals(bo.getGuideCatalogLevel()) || DycProCommConstants.GuideCatalogLevel.THIRD.equals(bo.getGuideCatalogLevel())).collect(Collectors.toList());
        log.debug("allNodesBO:{}", allNodesBO);
        Map<Long, List<DycProCommChannelGuideCatalogInfoBO>> nodeMap = allNodesBO.stream().collect(Collectors.groupingBy(DycProCommChannelGuideCatalogInfoBO::getGuideCatalogUpperId));
        Map<Long, List<Long>> manageRelMap = Collections.emptyMap();
        List guideCatalogManageRel = allNodesBO.stream().map(node -> {
            DycProCommGuideCatalogManageRelDTO guideCatalogManageRelDTO = new DycProCommGuideCatalogManageRelDTO();
            guideCatalogManageRelDTO.setGuideCatalogId(node.getGuideCatalogId());
            return guideCatalogManageRelDTO;
        }).collect(Collectors.toList());
        List manageRelDTOList = this.dycProChannelRepository.selectGuideCatalogRelatedCatalog(guideCatalogManageRel);
        if (!ObjectUtils.isEmpty((Object)manageRelDTOList)) {
            manageRelMap = manageRelDTOList.stream().collect(Collectors.groupingBy(DycProCommGuideCatalogManageRelDTO::getGuideCatalogId, Collectors.mapping(DycProCommGuideCatalogManageRelDTO::getManageCatalogId, Collectors.toList())));
        }
        List<DycProCommChannelGuideCatalogInfoBO> rootNodes = nodeMap.get(0L);
        for (DycProCommChannelGuideCatalogInfoBO node2 : rootNodes) {
            this.buildTreeRecursive(node2, nodeMap, manageRelMap);
        }
        rows.setChildren(rootNodes);
        if (CollectionUtils.isEmpty(rows.getChildren())) {
            rows.setGuideCatalogMaxOrder(0);
        } else {
            rows.setGuideCatalogMaxOrder(rows.getChildren().size());
            rows.getChildren().sort(Comparator.comparing(DycProCommChannelGuideCatalogInfoBO::getGuideCatalogOrder));
            this.sortChildren(rows.getChildren(), null);
        }
        return rows;
    }

    private void buildTreeRecursive(DycProCommChannelGuideCatalogInfoBO node, Map<Long, List<DycProCommChannelGuideCatalogInfoBO>> nodeMap, Map<Long, List<Long>> manageRelMap) {
        List<DycProCommChannelGuideCatalogInfoBO> children = nodeMap.get(node.getGuideCatalogId());
        List<Long> mangeCatalogIds = manageRelMap.get(node.getGuideCatalogId());
        node.setManageCatalogIds(mangeCatalogIds);
        node.setChildren(children);
        if (!CollectionUtils.isEmpty(children)) {
            for (DycProCommChannelGuideCatalogInfoBO child : children) {
                this.buildTreeRecursive(child, nodeMap, manageRelMap);
            }
        }
    }

    private void sortChildren(List<DycProCommChannelGuideCatalogInfoBO> nodes, String guideCatalogUpperName) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        nodes.sort(Comparator.comparing(DycProCommChannelGuideCatalogInfoBO::getGuideCatalogOrder));
        for (DycProCommChannelGuideCatalogInfoBO node : nodes) {
            List<DycProCommChannelGuideCatalogInfoBO> children;
            node.setCurrentGuideCatalogMaxOrder(nodes.size());
            if (StringUtils.isBlank((CharSequence)guideCatalogUpperName)) {
                node.setGuideCatalogUpperName(node.getGuideCatalogName());
            } else {
                node.setGuideCatalogUpperName(guideCatalogUpperName + "/" + node.getGuideCatalogName());
            }
            if (CollectionUtils.isEmpty(node.getChildren())) {
                node.setGuideCatalogMaxOrder(0);
            } else {
                node.setGuideCatalogMaxOrder(node.getChildren().size());
            }
            if ((children = node.getChildren()) == null || children.isEmpty()) continue;
            this.sortChildren(children, node.getGuideCatalogUpperName());
        }
    }
}

