/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.mcode.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.repository.mcode.api.DycProCommMcodeRepository;
import com.tydic.dyc.pro.dmc.repository.mcode.dto.DycProCommMCodingLogInfoDTO;
import com.tydic.dyc.pro.dmc.repository.mcode.dto.DycProCommMCodingLogInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.mcode.dto.DycProCommMdmMaterielInfoDTO;
import com.tydic.dyc.pro.dmc.repository.mcode.dto.DycProCommMdmMaterielInfoQryDTO;
import com.tydic.dyc.pro.dmc.service.mcode.api.DycProCommQueryMdmMaterielInfoPageListService;
import com.tydic.dyc.pro.dmc.service.mcode.bo.DycProCommMdmMaterielInfoBO;
import com.tydic.dyc.pro.dmc.service.mcode.bo.DycProCommQueryMdmMaterielInfoPageListReqBO;
import com.tydic.dyc.pro.dmc.service.mcode.bo.DycProCommQueryMdmMaterielInfoPageListRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.mcode.api.DycProCommQueryMdmMaterielInfoPageListService"})
public class DycProCommQueryMdmMaterielInfoPageListServiceImpl
implements DycProCommQueryMdmMaterielInfoPageListService {
    @Autowired
    private DycProCommMcodeRepository dycProCommMcodeRepository;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;

    @Override
    @PostMapping(value={"queryMdmMaterielInfoPageList"})
    public DycProCommQueryMdmMaterielInfoPageListRspBO queryMdmMaterielInfoPageList(@RequestBody DycProCommQueryMdmMaterielInfoPageListReqBO reqBO) {
        DycProCommMdmMaterielInfoQryDTO qryDTO = (DycProCommMdmMaterielInfoQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProCommMdmMaterielInfoQryDTO.class);
        RspPage page = this.dycProCommMcodeRepository.queryMdmMaterielInfoListByCondition(qryDTO);
        ArrayList<DycProCommMdmMaterielInfoBO> rows = new ArrayList<DycProCommMdmMaterielInfoBO>();
        if (page.getRows() != null && !page.getRows().isEmpty()) {
            List mCodes = page.getRows().stream().map(DycProCommMdmMaterielInfoDTO::getMCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List mIds = page.getRows().stream().map(DycProCommMdmMaterielInfoDTO::getMId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            HashMap<String, Long> mCodeToSkuCount = new HashMap<String, Long>();
            for (String mCode : mCodes) {
                Long cnt = this.commSkuInfoMapper.countByMCode(mCode);
                mCodeToSkuCount.put(mCode, Optional.ofNullable(cnt).orElse(0L));
            }
            HashMap<Long, String> mIdToPcGroupNames = new HashMap<Long, String>();
            for (Long mId : mIds) {
                DycProCommMCodingLogInfoQryDTO codingQry = new DycProCommMCodingLogInfoQryDTO();
                codingQry.setMId(mId);
                codingQry.setPageNo(Integer.valueOf(1));
                codingQry.setPageSize(Integer.valueOf(1000));
                RspPage codingPage = this.dycProCommMcodeRepository.queryMcodeCodingLogPageListByCondition(codingQry);
                if (codingPage.getRows() == null || codingPage.getRows().isEmpty()) continue;
                String joined = String.join((CharSequence)",", codingPage.getRows().stream().map(DycProCommMCodingLogInfoDTO::getProfessionalCompanyCatalogGroupName).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new)));
                mIdToPcGroupNames.put(mId, joined);
            }
            for (DycProCommMdmMaterielInfoDTO each : page.getRows()) {
                DycProCommMdmMaterielInfoBO bo = new DycProCommMdmMaterielInfoBO();
                bo.setMId(each.getMId());
                bo.setMCode(each.getMCode());
                bo.setMName(each.getMName());
                bo.setZlMaterialCode(each.getZlMaterialCode());
                bo.setZlMaterialName(each.getZlMaterialName());
                bo.setUnit(each.getUnit());
                bo.setManageCatalogPathName(each.getManageCatalogPathName());
                bo.setSource(each.getSysId());
                if (null != bo.getSource()) {
                    bo.setSourceStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommUpcSource", (String)bo.getSource()));
                }
                bo.setRelatedSkuCount(mCodeToSkuCount.getOrDefault(each.getMCode(), 0L));
                bo.setProfessionalCompanyCatalogGroupMapping((String)mIdToPcGroupNames.get(each.getMId()));
                rows.add(bo);
            }
        }
        DycProCommQueryMdmMaterielInfoPageListRspBO rsp = new DycProCommQueryMdmMaterielInfoPageListRspBO();
        rsp.setRows(rows);
        rsp.setPageNo(page.getPageNo());
        rsp.setTotal(page.getTotal());
        rsp.setRecordsTotal(page.getRecordsTotal());
        return rsp;
    }
}

