/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.pricerule.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleSkuRangeTypeEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleChngRecordRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleChngQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleSkuRangeChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleSkuRangeInfoDTO;
import com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommUpdatePriceRuleInfoService;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommPriceRuleAgrBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommPriceRuleInfoBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommPriceRuleSupplierBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommUpdatePriceRuleInfoReqBO;
import com.tydic.dyc.pro.dmc.service.pricerule.bo.DycProCommUpdatePriceRuleInfoRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.pricerule.api.DycProCommUpdatePriceRuleInfoService"})
public class DycProCommUpdatePriceRuleInfoServiceImpl
implements DycProCommUpdatePriceRuleInfoService {
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;
    @Autowired
    private DycProCommPriceRuleChngRecordRepository dycProCommPriceRuleChngRecordRepository;
    @Autowired
    DycProCommOperateRecordRepository dycProCommOperateRecordRepository;

    @Override
    @PostMapping(value={"updatePriceRuleInfo"})
    public DycProCommUpdatePriceRuleInfoRspBO updatePriceRuleInfo(@RequestBody DycProCommUpdatePriceRuleInfoReqBO reqBO) {
        DycProCommPriceRuleChngRecordDTO existRuleChngRecordDTO = this.queryExistChngRecord(reqBO);
        DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO = new DycProCommPriceRuleInfoQryDTO();
        dycProCommPriceRuleInfoQryDTO.setPriceRuleId(reqBO.getPriceRuleInfoBO().getPriceRuleId());
        DycProCommPriceRuleInfoDTO detailDto = this.dycProCommPriceRuleInfoRepository.queryPriceRuleInfoDetail(dycProCommPriceRuleInfoQryDTO);
        if (detailDto == null) {
            throw new ZTBusinessException("\u89c4\u5219\u4e0d\u5b58\u5728\uff01");
        }
        DycProCommPriceRuleInfoDTO updateRuleInfoDTO = this.buildPriceRuleInfo(detailDto, reqBO);
        List<DycProCommPriceRuleSkuRangeInfoDTO> priceRuleSkuRangeInfoDTOList = this.buildParamSkuRang(reqBO);
        updateRuleInfoDTO.setPriceRuleSkuRangeInfoDTOList(priceRuleSkuRangeInfoDTOList);
        Map<Long, DycProCommPriceRuleSkuRangeInfoDTO> paramMapBo = this.buildParamMap(reqBO, priceRuleSkuRangeInfoDTOList);
        List<DycProCommPriceRuleSkuRangeChngRecordDTO> skuRangeChngRecordDTOSResult = this.buildSkuChngRecord(existRuleChngRecordDTO, reqBO, paramMapBo);
        String existStr = "" + detailDto.getEnableHigherMarketPriceFlag() + detailDto.getRoundRule();
        String paramStr = "" + reqBO.getPriceRuleInfoBO().getEnableHigherMarketPriceFlag() + reqBO.getPriceRuleInfoBO().getRoundRule();
        if (!CollectionUtils.isEmpty(skuRangeChngRecordDTOSResult) || !existStr.equals(paramStr)) {
            DycProCommPriceRuleChngRecordDTO dycProCommPriceRuleChngRecordDTO = this.buildRuleChngRecord(existRuleChngRecordDTO, reqBO, detailDto);
            dycProCommPriceRuleChngRecordDTO.setSkuRangeChngRecordDTOs(skuRangeChngRecordDTOSResult);
            this.dycProCommPriceRuleChngRecordRepository.addPriceRuleChngRecord(dycProCommPriceRuleChngRecordDTO);
        }
        this.dycProCommPriceRuleInfoRepository.updatePriceRuleInfo(updateRuleInfoDTO);
        this.addOperateRecord(reqBO, updateRuleInfoDTO);
        return new DycProCommUpdatePriceRuleInfoRspBO();
    }

    private void addOperateRecord(DycProCommUpdatePriceRuleInfoReqBO reqBO, DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        DycProCommOperateRecordDTO dycProCommOperateRecordDTO = new DycProCommOperateRecordDTO();
        dycProCommOperateRecordDTO.setOperateRecordId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProCommOperateRecordDTO.setObjId(dycProCommPriceRuleInfoDTO.getPriceRuleId());
        dycProCommOperateRecordDTO.setObjType(DycProCommConstants.OperateRecordObjType.PRICE_RULE);
        dycProCommOperateRecordDTO.setOperateUserId(reqBO.getUserId());
        dycProCommOperateRecordDTO.setOperateUserName(reqBO.getName());
        dycProCommOperateRecordDTO.setOperateUserAccount(reqBO.getUserName());
        dycProCommOperateRecordDTO.setOperateTime(new Date());
        dycProCommOperateRecordDTO.setActionName(DmcCommOperateRecordActionTypeEnum.UPDATE.getValue());
        dycProCommOperateRecordDTO.setObjCode(dycProCommPriceRuleInfoDTO.getPriceRuleCode());
        dycProCommOperateRecordDTO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.UPDATE.getCode())));
        this.dycProCommOperateRecordRepository.addOperateRecord(dycProCommOperateRecordDTO);
    }

    private Map<Long, DycProCommPriceRuleSkuRangeInfoDTO> buildParamMap(DycProCommUpdatePriceRuleInfoReqBO reqBO, List<DycProCommPriceRuleSkuRangeInfoDTO> priceRuleSkuRangeInfoDTOList) {
        Map<Object, Object> paramMapBo = new HashMap();
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR.getCode()))) {
            paramMapBo = priceRuleSkuRangeInfoDTOList.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getAgrId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode()))) {
            paramMapBo = priceRuleSkuRangeInfoDTOList.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getCatalogId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER.getCode()))) {
            paramMapBo = priceRuleSkuRangeInfoDTOList.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getSupplierId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode()))) {
            paramMapBo = priceRuleSkuRangeInfoDTOList.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getCatalogId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
            paramMapBo = priceRuleSkuRangeInfoDTOList.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getPriceRuleId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode()))) {
            paramMapBo = priceRuleSkuRangeInfoDTOList.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getCatalogId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SKU.getCode()))) {
            paramMapBo = priceRuleSkuRangeInfoDTOList.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getSkuId, Function.identity()));
        }
        return paramMapBo;
    }

    private DycProCommPriceRuleChngRecordDTO buildRuleChngRecord(DycProCommPriceRuleChngRecordDTO existRuleChngRecordDTO, DycProCommUpdatePriceRuleInfoReqBO reqBO, DycProCommPriceRuleInfoDTO detailDto) {
        DycProCommPriceRuleChngRecordDTO dycProCommPriceRuleChngRecordDTO = (DycProCommPriceRuleChngRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getPriceRuleInfoBO()), DycProCommPriceRuleChngRecordDTO.class);
        if (existRuleChngRecordDTO != null) {
            dycProCommPriceRuleChngRecordDTO.setPriceRuleChngRecordId(existRuleChngRecordDTO.getPriceRuleChngRecordId());
        } else {
            dycProCommPriceRuleChngRecordDTO.setPriceRuleStatus(detailDto.getPriceRuleStatus());
            dycProCommPriceRuleChngRecordDTO.setPriceRuleStatusOld(detailDto.getPriceRuleStatus());
            dycProCommPriceRuleChngRecordDTO.setEnableHigherMarketPriceFlagOld(detailDto.getEnableHigherMarketPriceFlag());
            dycProCommPriceRuleChngRecordDTO.setRoundRuleOld(detailDto.getRoundRule());
            dycProCommPriceRuleChngRecordDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PENDING);
        }
        dycProCommPriceRuleChngRecordDTO.setCreateUserId(reqBO.getUserId());
        dycProCommPriceRuleChngRecordDTO.setCreateUserName(reqBO.getName());
        dycProCommPriceRuleChngRecordDTO.setCreateUserAccount(reqBO.getUserName());
        dycProCommPriceRuleChngRecordDTO.setCreateOrgId(reqBO.getOrgId());
        dycProCommPriceRuleChngRecordDTO.setCreateOrgName(reqBO.getOrgName());
        dycProCommPriceRuleChngRecordDTO.setCreateCompanyId(reqBO.getCompanyId());
        dycProCommPriceRuleChngRecordDTO.setCreateCompanyName(reqBO.getCompanyName());
        dycProCommPriceRuleChngRecordDTO.setCreateOrgPath(reqBO.getOrgPath());
        dycProCommPriceRuleChngRecordDTO.setCreateTime(new Date());
        dycProCommPriceRuleChngRecordDTO.setPriority(detailDto.getPriority());
        dycProCommPriceRuleChngRecordDTO.setPriceRuleCode(detailDto.getPriceRuleCode());
        dycProCommPriceRuleChngRecordDTO.setPriceRuleType(detailDto.getPriceRuleType());
        return dycProCommPriceRuleChngRecordDTO;
    }

    private DycProCommPriceRuleChngRecordDTO queryExistChngRecord(DycProCommUpdatePriceRuleInfoReqBO reqBO) {
        DycProCommPriceRuleChngQryDTO ruleChngQryDTO = new DycProCommPriceRuleChngQryDTO();
        ruleChngQryDTO.setPriceRuleId(reqBO.getPriceRuleInfoBO().getPriceRuleId());
        ruleChngQryDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PROGRESS);
        List ruleChngRecordDTOs = this.dycProCommPriceRuleChngRecordRepository.queryPriceRuleChngRecordList(ruleChngQryDTO);
        if (!CollectionUtils.isEmpty((Collection)ruleChngRecordDTOs)) {
            throw new ZTBusinessException("\u89c4\u5219\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        ruleChngQryDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PENDING);
        List ruleChngRecordDTOs1 = this.dycProCommPriceRuleChngRecordRepository.queryPriceRuleChngRecordList(ruleChngQryDTO);
        if (!CollectionUtils.isEmpty((Collection)ruleChngRecordDTOs1)) {
            return (DycProCommPriceRuleChngRecordDTO)ruleChngRecordDTOs1.get(0);
        }
        return null;
    }

    private List<DycProCommPriceRuleSkuRangeChngRecordDTO> buildSkuChngRecord(DycProCommPriceRuleChngRecordDTO existRuleChngRecordDTO, DycProCommUpdatePriceRuleInfoReqBO reqBO, Map<Long, DycProCommPriceRuleSkuRangeInfoDTO> paramMapBo) {
        DycProCommPriceRuleSkuRangeChngRecordDTO skuRangeChngRecordDTO;
        DycProCommPriceRuleSkuRangeChngRecordDTO chngDto;
        DycProCommPriceRuleSkuRangeInfoDTO existDto;
        DycProCommPriceRuleSkuRangeInfoDTO paramDto;
        Map<Long, DycProCommPriceRuleSkuRangeChngRecordDTO> chngMapDto = this.queryChngMap(reqBO, existRuleChngRecordDTO);
        Map<Long, DycProCommPriceRuleSkuRangeInfoDTO> existMapDto = this.queryExistMap(reqBO);
        ArrayList<DycProCommPriceRuleSkuRangeChngRecordDTO> skuRangeChngRecordDTOSResult = new ArrayList<DycProCommPriceRuleSkuRangeChngRecordDTO>();
        for (Long key : paramMapBo.keySet()) {
            String paramStr;
            paramDto = paramMapBo.get(key);
            existDto = existMapDto.get(key);
            chngDto = chngMapDto.get(key);
            skuRangeChngRecordDTO = this.buildSkuRangeChngRecordDTO(paramDto, reqBO.getPriceRuleInfoBO());
            if (existDto != null) {
                String existStr = existDto.getPriceRiseRate() + existDto.getPriceRiseType() + existDto.getLadderPriceRule();
                if (!existStr.equals(paramStr = paramDto.getPriceRiseRate() + paramDto.getPriceRiseType() + paramDto.getLadderPriceRule())) {
                    if (chngDto != null) {
                        if (chngDto.getChngType().equals(DycProCommConstants.PriceRuleChngType.ADD)) {
                            skuRangeChngRecordDTO.setChngType(DycProCommConstants.PriceRuleChngType.ADD);
                            skuRangeChngRecordDTO.setPriceRiseTypeOld(skuRangeChngRecordDTO.getPriceRiseType());
                            skuRangeChngRecordDTO.setPriceRiseRateOld(skuRangeChngRecordDTO.getPriceRiseRate());
                            skuRangeChngRecordDTO.setLadderPriceRuleOld(skuRangeChngRecordDTO.getLadderPriceRule());
                            skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
                            continue;
                        }
                        String originStr = chngDto.getPriceRiseRateOld() + chngDto.getPriceRiseTypeOld();
                        if (paramStr.equals(originStr)) continue;
                        skuRangeChngRecordDTO.setChngType(DycProCommConstants.PriceRuleChngType.UPDARE);
                        skuRangeChngRecordDTO.setPriceRiseTypeOld(chngDto.getPriceRiseTypeOld());
                        skuRangeChngRecordDTO.setPriceRiseRateOld(chngDto.getPriceRiseRateOld());
                        skuRangeChngRecordDTO.setLadderPriceRuleOld(chngDto.getLadderPriceRuleOld());
                        skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
                        continue;
                    }
                    skuRangeChngRecordDTO.setChngType(DycProCommConstants.PriceRuleChngType.UPDARE);
                    skuRangeChngRecordDTO.setPriceRiseRateOld(existDto.getPriceRiseRate());
                    skuRangeChngRecordDTO.setPriceRiseTypeOld(existDto.getPriceRiseType());
                    skuRangeChngRecordDTO.setLadderPriceRuleOld(existDto.getLadderPriceRule());
                    skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
                    continue;
                }
                if (chngDto == null) continue;
                skuRangeChngRecordDTO.setChngType(chngDto.getChngType());
                skuRangeChngRecordDTO.setPriceRiseTypeOld(chngDto.getPriceRiseTypeOld());
                skuRangeChngRecordDTO.setPriceRiseRateOld(chngDto.getPriceRiseRateOld());
                skuRangeChngRecordDTO.setLadderPriceRuleOld(chngDto.getLadderPriceRuleOld());
                skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
                continue;
            }
            if (chngDto != null) {
                String chngStr = chngDto.getPriceRiseRateOld() + chngDto.getPriceRiseTypeOld() + chngDto.getLadderPriceRuleOld();
                if (chngStr.equals(paramStr = paramDto.getPriceRiseRate() + paramDto.getPriceRiseType() + paramDto.getLadderPriceRule())) continue;
                skuRangeChngRecordDTO.setChngType(DycProCommConstants.PriceRuleChngType.UPDARE);
                skuRangeChngRecordDTO.setPriceRiseRateOld(chngDto.getPriceRiseRateOld());
                skuRangeChngRecordDTO.setPriceRiseTypeOld(chngDto.getPriceRiseTypeOld());
                skuRangeChngRecordDTO.setLadderPriceRuleOld(chngDto.getLadderPriceRuleOld());
                skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
                continue;
            }
            skuRangeChngRecordDTO.setChngType(DycProCommConstants.PriceRuleChngType.ADD);
            skuRangeChngRecordDTO.setPriceRiseTypeOld(skuRangeChngRecordDTO.getPriceRiseType());
            skuRangeChngRecordDTO.setPriceRiseRateOld(skuRangeChngRecordDTO.getPriceRiseRate());
            skuRangeChngRecordDTO.setLadderPriceRuleOld(skuRangeChngRecordDTO.getLadderPriceRule());
            skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
        }
        for (Long existKey : existMapDto.keySet()) {
            paramDto = paramMapBo.get(existKey);
            existDto = existMapDto.get(existKey);
            chngDto = chngMapDto.get(existKey);
            if (paramDto != null) continue;
            skuRangeChngRecordDTO = this.buildSkuRangeChngRecordDTO(existDto, reqBO.getPriceRuleInfoBO());
            if (chngDto == null) {
                skuRangeChngRecordDTO.setChngType(DycProCommConstants.PriceRuleChngType.DELETE);
                skuRangeChngRecordDTO.setPriceRiseTypeOld(existDto.getPriceRiseType());
                skuRangeChngRecordDTO.setPriceRiseRateOld(existDto.getPriceRiseRate());
                skuRangeChngRecordDTO.setLadderPriceRule(existDto.getLadderPriceRule());
                skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
                continue;
            }
            if (!chngDto.getChngType().equals(DycProCommConstants.PriceRuleChngType.UPDARE)) continue;
            skuRangeChngRecordDTO.setChngType(DycProCommConstants.PriceRuleChngType.DELETE);
            skuRangeChngRecordDTO.setPriceRiseTypeOld(chngDto.getPriceRiseTypeOld());
            skuRangeChngRecordDTO.setPriceRiseRateOld(chngDto.getPriceRiseRateOld());
            skuRangeChngRecordDTO.setLadderPriceRuleOld(chngDto.getLadderPriceRuleOld());
            skuRangeChngRecordDTOSResult.add(skuRangeChngRecordDTO);
        }
        return skuRangeChngRecordDTOSResult;
    }

    private DycProCommPriceRuleSkuRangeChngRecordDTO buildSkuRangeChngRecordDTO(DycProCommPriceRuleSkuRangeInfoDTO dto, DycProCommPriceRuleInfoBO priceRuleInfoBO) {
        DycProCommPriceRuleSkuRangeChngRecordDTO skuRangeChngRecordDTO = new DycProCommPriceRuleSkuRangeChngRecordDTO();
        if (priceRuleInfoBO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setAgrId(dto.getAgrId());
            skuRangeChngRecordDTO.setAgrName(dto.getAgrName());
            skuRangeChngRecordDTO.setAgrCode(dto.getAgrCode());
        }
        if (priceRuleInfoBO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setAgrId(dto.getAgrId());
            skuRangeChngRecordDTO.setAgrName(dto.getAgrName());
            skuRangeChngRecordDTO.setAgrCode(dto.getAgrCode());
            skuRangeChngRecordDTO.setCatalogId(dto.getCatalogId());
            skuRangeChngRecordDTO.setCatalogName(dto.getCatalogName());
        }
        if (priceRuleInfoBO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setSupplierId(dto.getSupplierId());
            skuRangeChngRecordDTO.setSupplierName(dto.getSupplierName());
        }
        if (priceRuleInfoBO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setSupplierId(dto.getSupplierId());
            skuRangeChngRecordDTO.setSupplierName(dto.getSupplierName());
            skuRangeChngRecordDTO.setCatalogId(dto.getCatalogId());
            skuRangeChngRecordDTO.setCatalogName(dto.getCatalogName());
        }
        if (priceRuleInfoBO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
        }
        if (priceRuleInfoBO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setCatalogId(dto.getCatalogId());
            skuRangeChngRecordDTO.setCatalogName(dto.getCatalogName());
        }
        if (priceRuleInfoBO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SKU.getCode()))) {
            skuRangeChngRecordDTO.setPriceRuleId(dto.getPriceRuleId());
            skuRangeChngRecordDTO.setSkuId(dto.getSkuId());
            skuRangeChngRecordDTO.setSkuCode(dto.getSkuCode());
            skuRangeChngRecordDTO.setSkuName(dto.getSkuName());
        }
        skuRangeChngRecordDTO.setPriceRiseRate(dto.getPriceRiseRate());
        skuRangeChngRecordDTO.setPriceRiseType(dto.getPriceRiseType());
        skuRangeChngRecordDTO.setLadderPriceRule(dto.getLadderPriceRule());
        return skuRangeChngRecordDTO;
    }

    private Map<Long, DycProCommPriceRuleSkuRangeChngRecordDTO> queryChngMap(DycProCommUpdatePriceRuleInfoReqBO reqBO, DycProCommPriceRuleChngRecordDTO ruleChngRecordDTO) {
        Map<Long, Object> chngMapDto = new HashMap<Long, DycProCommPriceRuleSkuRangeChngRecordDTO>();
        if (ruleChngRecordDTO != null) {
            DycProCommPriceRuleChngQryDTO skuRangeChngQryDTO = new DycProCommPriceRuleChngQryDTO();
            skuRangeChngQryDTO.setPriceRuleChngRecordId(ruleChngRecordDTO.getPriceRuleChngRecordId());
            List skuRangeChngRecordDTOs = this.dycProCommPriceRuleChngRecordRepository.queryPriceRuleSkuRangeChngRecordList(skuRangeChngQryDTO);
            if (!CollectionUtils.isEmpty((Collection)skuRangeChngRecordDTOs)) {
                if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR.getCode()))) {
                    chngMapDto = skuRangeChngRecordDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeChngRecordDTO::getAgrId, Function.identity()));
                }
                if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode()))) {
                    chngMapDto = skuRangeChngRecordDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeChngRecordDTO::getCatalogId, Function.identity()));
                }
                if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER.getCode()))) {
                    chngMapDto = skuRangeChngRecordDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeChngRecordDTO::getSupplierId, Function.identity()));
                }
                if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode()))) {
                    chngMapDto = skuRangeChngRecordDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeChngRecordDTO::getCatalogId, Function.identity()));
                }
                if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
                    chngMapDto = skuRangeChngRecordDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeChngRecordDTO::getPriceRuleId, Function.identity()));
                }
                if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode()))) {
                    chngMapDto = skuRangeChngRecordDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeChngRecordDTO::getCatalogId, Function.identity()));
                }
                if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SKU.getCode()))) {
                    chngMapDto = skuRangeChngRecordDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeChngRecordDTO::getSkuId, Function.identity()));
                }
            }
        }
        return chngMapDto;
    }

    private Map<Long, DycProCommPriceRuleSkuRangeInfoDTO> queryExistMap(DycProCommUpdatePriceRuleInfoReqBO reqBO) {
        DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO = new DycProCommPriceRuleInfoQryDTO();
        dycProCommPriceRuleInfoQryDTO.setPriceRuleId(reqBO.getPriceRuleInfoBO().getPriceRuleId());
        List skuRangeInfoExistDTOs = this.dycProCommPriceRuleInfoRepository.queryPriceRuleSkuRangeList(dycProCommPriceRuleInfoQryDTO);
        Map<Object, Object> existMapDto = new HashMap();
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR.getCode()))) {
            existMapDto = skuRangeInfoExistDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getAgrId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode()))) {
            existMapDto = skuRangeInfoExistDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getCatalogId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER.getCode()))) {
            existMapDto = skuRangeInfoExistDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getSupplierId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode()))) {
            existMapDto = skuRangeInfoExistDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getCatalogId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
            existMapDto = skuRangeInfoExistDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getPriceRuleId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode()))) {
            existMapDto = skuRangeInfoExistDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getCatalogId, Function.identity()));
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SKU.getCode()))) {
            existMapDto = skuRangeInfoExistDTOs.stream().collect(Collectors.toMap(DycProCommPriceRuleSkuRangeInfoDTO::getSkuId, Function.identity()));
        }
        return existMapDto;
    }

    private List<DycProCommPriceRuleSkuRangeInfoDTO> buildParamSkuRang(DycProCommUpdatePriceRuleInfoReqBO reqBO) {
        DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO;
        ArrayList<DycProCommPriceRuleSkuRangeInfoDTO> priceRuleSkuRangeInfoDTOList = new ArrayList<DycProCommPriceRuleSkuRangeInfoDTO>();
        DycProCommPriceRuleInfoBO priceRuleInfoBO = reqBO.getPriceRuleInfoBO();
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR.getCode()))) {
            DycProCommPriceRuleAgrBO priceRuleAgrBO = reqBO.getPriceRuleAgrBO();
            dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)priceRuleAgrBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
            dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(reqBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRuleId(priceRuleInfoBO.getPriceRuleId());
            priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode()))) {
            reqBO.getPriceRuleCataLogBOs().forEach(dycProCommPriceRuleCatalogBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleCatalogBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
                dycProCommPriceRuleSkuRangeInfoDTO.setAgrId(reqBO.getPriceRuleAgrBO().getAgrId());
                dycProCommPriceRuleSkuRangeInfoDTO.setAgrCode(reqBO.getPriceRuleAgrBO().getAgrCode());
                dycProCommPriceRuleSkuRangeInfoDTO.setAgrName(reqBO.getPriceRuleAgrBO().getAgrName());
                dycProCommPriceRuleSkuRangeInfoDTO.setValueShiwFlag(Integer.valueOf(1));
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRuleId(priceRuleInfoBO.getPriceRuleId());
                priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER.getCode()))) {
            DycProCommPriceRuleSupplierBO priceRuleSupplierBO = reqBO.getPriceRuleSupplierBO();
            dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)priceRuleSupplierBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
            dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(reqBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
            dycProCommPriceRuleSkuRangeInfoDTO.setPriceRuleId(priceRuleInfoBO.getPriceRuleId());
            priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode()))) {
            reqBO.getPriceRuleCataLogBOs().forEach(dycProCommPriceRuleCatalogBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleCatalogBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
                dycProCommPriceRuleSkuRangeInfoDTO.setSupplierId(reqBO.getPriceRuleSupplierBO().getSupplierId());
                dycProCommPriceRuleSkuRangeInfoDTO.setSupplierName(reqBO.getPriceRuleSupplierBO().getSupplierName());
                dycProCommPriceRuleSkuRangeInfoDTO.setValueShiwFlag(Integer.valueOf(1));
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRuleId(priceRuleInfoBO.getPriceRuleId());
                priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
            DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO2 = new DycProCommPriceRuleSkuRangeInfoDTO();
            dycProCommPriceRuleSkuRangeInfoDTO2.setLadderPriceRule(reqBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
            dycProCommPriceRuleSkuRangeInfoDTO2.setPriceRiseRate(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
            dycProCommPriceRuleSkuRangeInfoDTO2.setPriceRiseType(reqBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
            dycProCommPriceRuleSkuRangeInfoDTO2.setPriceRuleId(reqBO.getPriceRuleInfoBO().getPriceRuleId());
            dycProCommPriceRuleSkuRangeInfoDTO2.setPriceRuleId(priceRuleInfoBO.getPriceRuleId());
            priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO2);
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode()))) {
            reqBO.getPriceRuleCataLogBOs().forEach(dycProCommPriceRuleCatalogBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleCatalogBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(dycProCommPriceRuleCatalogBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRuleId(priceRuleInfoBO.getPriceRuleId());
                dycProCommPriceRuleSkuRangeInfoDTO.setValueShiwFlag(Integer.valueOf(1));
                priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
        if (reqBO.getPriceRuleInfoBO().getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SKU.getCode()))) {
            reqBO.getPriceRuleSkuBOs().forEach(dycProCommPriceRuleSkuBO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleSkuBO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                dycProCommPriceRuleSkuRangeInfoDTO.setLadderPriceRule(dycProCommPriceRuleSkuBO.getDycProCommPriceRuleRuleBO().getLadderPriceRule());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseRate(dycProCommPriceRuleSkuBO.getDycProCommPriceRuleRuleBO().getPriceRiseRate());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRiseType(dycProCommPriceRuleSkuBO.getDycProCommPriceRuleRuleBO().getPriceRiseType());
                dycProCommPriceRuleSkuRangeInfoDTO.setPriceRuleId(priceRuleInfoBO.getPriceRuleId());
                priceRuleSkuRangeInfoDTOList.add(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
        return priceRuleSkuRangeInfoDTOList;
    }

    private DycProCommPriceRuleInfoDTO buildPriceRuleInfo(DycProCommPriceRuleInfoDTO detailDto, DycProCommUpdatePriceRuleInfoReqBO reqBO) {
        DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO = (DycProCommPriceRuleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getPriceRuleInfoBO()), DycProCommPriceRuleInfoDTO.class);
        dycProCommPriceRuleInfoDTO.setUpdateUserId(reqBO.getUserId());
        dycProCommPriceRuleInfoDTO.setUpdateUserName(reqBO.getName());
        dycProCommPriceRuleInfoDTO.setUpdateUserAccount(reqBO.getUserName());
        dycProCommPriceRuleInfoDTO.setUpdateOrgId(reqBO.getOrgId());
        dycProCommPriceRuleInfoDTO.setUpdateOrgName(reqBO.getOrgName());
        dycProCommPriceRuleInfoDTO.setUpdateCompanyId(reqBO.getCompanyId());
        dycProCommPriceRuleInfoDTO.setUpdateCompanyName(reqBO.getCompanyName());
        dycProCommPriceRuleInfoDTO.setUpdateOrgPath(reqBO.getOrgPath());
        dycProCommPriceRuleInfoDTO.setUpdateTime(new Date());
        return dycProCommPriceRuleInfoDTO;
    }
}

