/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.bansrecord.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlMapBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateBatchReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateBatchRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingBansRuleBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.dmc.dao.CommBansRecordMapper;
import com.tydic.dyc.pro.dmc.po.CommBansRecordAggPO;
import com.tydic.dyc.pro.dmc.po.CommBansRecordPO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.api.DycProCommBansRecordRepository;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoQryDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProCommBansRecordRepositoryImpl
implements DycProCommBansRecordRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProCommBansRecordRepositoryImpl.class);
    @Autowired
    private CommBansRecordMapper commBansRecordMapper;
    @Autowired
    private NosqlClient nosqlClient;
    @Value(value="${ucc.es.index}")
    private String skuIndexName;

    @Override
    public void addBansRecordBatchAndSyncNosql(List<DycProCommBansRecordInfoDTO> reqBo, boolean syncNosql) {
        ArrayList<CommBansRecordPO> insertPos = new ArrayList<CommBansRecordPO>();
        for (DycProCommBansRecordInfoDTO recordInfoDTO : reqBo) {
            CommBansRecordPO recordPO = (CommBansRecordPO)JSON.parseObject((String)JSONObject.toJSONString((Object)recordInfoDTO), CommBansRecordPO.class);
            Long recordId = Sequence.getInstance().nextId();
            recordPO.setBansRecordId(recordId);
            insertPos.add(recordPO);
        }
        if (!CollectionUtils.isEmpty(insertPos)) {
            this.commBansRecordMapper.insertBatch(insertPos);
        }
        if (syncNosql) {
            for (DycProCommBansRecordInfoDTO recordInfoDTO : reqBo) {
                this.syncNoSqlBySku(recordInfoDTO.getSkuId());
            }
        }
    }

    @Override
    public void updateBansRecordBatchAndSyncNosql(List<DycProCommBansRecordInfoDTO> reqBo) {
        for (DycProCommBansRecordInfoDTO recordInfoDTO : reqBo) {
            LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
            queryWrapperX.eq(CommBansRecordPO::getSkuId, (Object)recordInfoDTO.getSkuId());
            queryWrapperX.eqIfPresent(CommBansRecordPO::getBansRuleId, (Object)recordInfoDTO.getBansRuleId());
            queryWrapperX.eqIfPresent(CommBansRecordPO::getBansType, (Object)recordInfoDTO.getBansType());
            queryWrapperX.inIfPresent(CommBansRecordPO::getBansRuleId, recordInfoDTO.getBansRuleIds());
            CommBansRecordPO recordPO = (CommBansRecordPO)JSON.parseObject((String)JSONObject.toJSONString((Object)recordInfoDTO), CommBansRecordPO.class);
            recordPO.setBansType(null);
            recordPO.setSkuId(null);
            recordPO.setBansRuleId(null);
            int count = this.commBansRecordMapper.update((Object)recordPO, (Wrapper)queryWrapperX);
            if (count <= 0) continue;
            this.syncNoSqlBySku(recordInfoDTO.getSkuId());
        }
    }

    @Override
    public void updateBansRecordBatchAndSyncNosql(DycProCommBansRecordInfoHandleDTO reqDto) {
        LambdaQueryWrapperX updateWrapperX = new LambdaQueryWrapperX();
        updateWrapperX.in(CommBansRecordPO::getSkuId, reqDto.getSkuIdList());
        updateWrapperX.eqIfPresent(CommBansRecordPO::getBansRuleId, (Object)reqDto.getBansRuleId());
        updateWrapperX.eqIfPresent(CommBansRecordPO::getBansType, (Object)reqDto.getBansType());
        CommBansRecordPO recordPO = (CommBansRecordPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqDto), CommBansRecordPO.class);
        this.commBansRecordMapper.update((Object)recordPO, (Wrapper)updateWrapperX);
        if (reqDto.isSyncNosql()) {
            LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
            queryWrapperX.in(CommBansRecordPO::getSkuId, reqDto.getSkuIdList());
            List recordPOS = this.commBansRecordMapper.selectList((Wrapper)queryWrapperX);
            if (!CollectionUtils.isEmpty((Collection)recordPOS)) {
                Map<Long, List<CommBansRecordPO>> skuBansMap = recordPOS.stream().collect(Collectors.groupingBy(CommBansRecordPO::getSkuId));
                ArrayList nosqlMapBOS = new ArrayList();
                skuBansMap.forEach((skuId, commBansRecordPOS) -> {
                    List bansRuleList = JSON.parseArray((String)JSONObject.toJSONString((Object)commBansRecordPOS), DycProEsIndexMappingBansRuleBO.class);
                    NosqlMapBO nosqlMapBO = new NosqlMapBO();
                    nosqlMapBO.setId(skuId.toString());
                    HashMap<String, Object> skuDataMap = new HashMap<String, Object>();
                    skuDataMap.put("bansRuleList", JSON.parseObject((String)JSON.toJSONString((Object)bansRuleList), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]));
                    nosqlMapBO.setMaps(skuDataMap);
                    nosqlMapBOS.add(nosqlMapBO);
                });
                NosqlUpdateBatchReqBO nosqlUpdateBatchReqBO = new NosqlUpdateBatchReqBO();
                nosqlUpdateBatchReqBO.setIndex(this.skuIndexName);
                nosqlUpdateBatchReqBO.setNosqlBOList(nosqlMapBOS);
                NosqlUpdateBatchRsqBO nosqlUpdateBatchRsqBO = this.nosqlClient.updateBatch(nosqlUpdateBatchReqBO);
                if (!"0000".equals(nosqlUpdateBatchRsqBO.getRespCode())) {
                    throw new ZTBusinessException("\u7981\u552e\u8bb0\u5f55\u66f4\u65b0sku\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateBatchRsqBO.getRespDesc());
                }
            }
        }
    }

    @Override
    public List<DycProCommBansRecordInfoDTO> queryBansRecordList(DycProCommBansRecordInfoQryDTO dycProCommBansRecordInfoQryDTO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.eqIfPresent(CommBansRecordPO::getSkuId, (Object)dycProCommBansRecordInfoQryDTO.getSkuId());
        queryWrapper.inIfPresent(CommBansRecordPO::getSkuId, dycProCommBansRecordInfoQryDTO.getSkuIdList());
        queryWrapper.eqIfPresent(CommBansRecordPO::getBansType, (Object)dycProCommBansRecordInfoQryDTO.getBansType());
        queryWrapper.gtIfPresent(CommBansRecordPO::getBansEndDate, (Object)dycProCommBansRecordInfoQryDTO.getBansEndDate());
        queryWrapper.eqIfPresent(CommBansRecordPO::getBansRuleId, (Object)dycProCommBansRecordInfoQryDTO.getBansRuleId());
        List pos = this.commBansRecordMapper.selectList((Wrapper)queryWrapper);
        return JSONArray.parseArray((String)JSONObject.toJSONString((Object)pos), DycProCommBansRecordInfoDTO.class);
    }

    @Override
    public List<DycProCommBansRecordInfoHandleDTO> qrySkuBansCount(DycProCommBansRecordInfoHandleDTO reqDto) {
        List<DycProCommBansRecordInfoHandleDTO> dycProCommBansRecordInfoHandleDTOS = new ArrayList<DycProCommBansRecordInfoHandleDTO>();
        CommBansRecordAggPO commBansRecordAggPO = (CommBansRecordAggPO)JSON.parseObject((String)JSON.toJSONString((Object)reqDto), CommBansRecordAggPO.class);
        List commBansRecordAggPOS = this.commBansRecordMapper.qrySkuBansCount(commBansRecordAggPO);
        if (!CollectionUtils.isEmpty((Collection)commBansRecordAggPOS)) {
            dycProCommBansRecordInfoHandleDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commBansRecordAggPOS), DycProCommBansRecordInfoHandleDTO.class);
        }
        return dycProCommBansRecordInfoHandleDTOS;
    }

    @Override
    public void deleteBansRecord(DycProCommBansRecordInfoDTO dycProCommBansRecordInfoDTO) {
        LambdaQueryWrapperX deleteWrapper = new LambdaQueryWrapperX();
        deleteWrapper.eq(CommBansRecordPO::getSkuId, (Object)dycProCommBansRecordInfoDTO.getSkuId());
        deleteWrapper.eqIfPresent(CommBansRecordPO::getBansType, (Object)dycProCommBansRecordInfoDTO.getBansType());
        this.commBansRecordMapper.delete((Wrapper)deleteWrapper);
    }

    @Override
    public void addBansRecord(List<DycProCommBansRecordInfoDTO> dtoList) {
        List commBansRecordPOS = JSONArray.parseArray((String)JSON.toJSONString(dtoList), CommBansRecordPO.class);
        commBansRecordPOS.forEach(commBansRecordPO -> commBansRecordPO.setBansRecordId(Long.valueOf(Sequence.getInstance().nextId())));
        this.commBansRecordMapper.insertBatch((Collection)commBansRecordPOS);
    }

    @Override
    public void syncNosql(Long skuId) {
        this.syncNoSqlBySku(skuId);
    }

    private void syncNoSqlBySku(Long skuId) {
        LambdaQueryWrapperX queryWrapperX3 = new LambdaQueryWrapperX();
        queryWrapperX3.eq(CommBansRecordPO::getSkuId, (Object)skuId);
        queryWrapperX3.gt(CommBansRecordPO::getBansEndDate, (Object)new Date());
        List recordPOS = this.commBansRecordMapper.selectList((Wrapper)queryWrapperX3);
        List bansRuleList = JSON.parseArray((String)JSONObject.toJSONString((Object)recordPOS), DycProEsIndexMappingBansRuleBO.class);
        DycProEsIndexMappingSkuBO updateIndexMappingSkuBO = new DycProEsIndexMappingSkuBO();
        updateIndexMappingSkuBO.setBansRuleList(bansRuleList);
        NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
        nosqlUpdateSingleReqBO.setIndex(this.skuIndexName);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(skuId));
        nosqlBO.setObject((Object)updateIndexMappingSkuBO);
        nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
        log.info("\u66f4\u65b0es\u5f00\u59cb" + JSONObject.toJSONString((Object)nosqlBO));
        NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
        if (!"0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u66f4\u65b0sku\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
        }
    }
}

