/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.checkrule.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleStatusEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommCheckRuleInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommCheckRuleItemInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommCheckRuleRangeInfoMapper;
import com.tydic.dyc.pro.dmc.po.CommCheckRuleAndSkuRangePO;
import com.tydic.dyc.pro.dmc.po.CommCheckRuleInfoPO;
import com.tydic.dyc.pro.dmc.po.CommCheckRuleItemInfoPO;
import com.tydic.dyc.pro.dmc.po.CommCheckRuleRangeInfoPO;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckSupplierDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycProCommCheckRuleInfoRepositoryImpl
implements DycProCommCheckRuleInfoRepository {
    @Autowired
    private CommCheckRuleInfoMapper commCheckRuleInfoMapper;
    @Autowired
    private CommCheckRuleItemInfoMapper commCheckRuleItemInfoMapper;
    @Autowired
    private CommCheckRuleRangeInfoMapper commCheckRuleRangeInfoMapper;

    @Override
    public void addCheckRuleInfo(DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        CommCheckRuleInfoPO commCheckRuleInfoPO = (CommCheckRuleInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRuleInfoDTO), CommCheckRuleInfoPO.class);
        Long checkRuleId = dycProCommCheckRuleInfoDTO.getCheckRuleId();
        if (checkRuleId == null) {
            checkRuleId = Sequence.getInstance().nextId();
        }
        dycProCommCheckRuleInfoDTO.setCheckRuleId(checkRuleId);
        commCheckRuleInfoPO.setCheckRuleId(checkRuleId);
        this.commCheckRuleInfoMapper.insert((Object)commCheckRuleInfoPO);
        List<CommCheckRuleRangeInfoPO> checkRuleRangeInfoPOList = this.buildRangeInfo(dycProCommCheckRuleInfoDTO);
        if (!CollectionUtils.isEmpty(checkRuleRangeInfoPOList)) {
            for (CommCheckRuleRangeInfoPO commCheckRuleRangeInfoPO : checkRuleRangeInfoPOList) {
                commCheckRuleRangeInfoPO.setRangeId(Long.valueOf(Sequence.getInstance().nextId()));
                commCheckRuleRangeInfoPO.setCheckRuleId(checkRuleId);
            }
            this.commCheckRuleRangeInfoMapper.insertBatch(checkRuleRangeInfoPOList);
        }
        if (!CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckRuleItemInfoDTOList())) {
            List commCheckRuleItemInfoPOs = JSON.parseArray((String)JSON.toJSONString(dycProCommCheckRuleInfoDTO.getCheckRuleItemInfoDTOList()), CommCheckRuleItemInfoPO.class);
            for (CommCheckRuleItemInfoPO commCheckRuleItemInfoPO : commCheckRuleItemInfoPOs) {
                commCheckRuleItemInfoPO.setCheckItemId(Long.valueOf(Sequence.getInstance().nextId()));
                commCheckRuleItemInfoPO.setCheckRuleId(checkRuleId);
            }
            this.commCheckRuleItemInfoMapper.insertBatch((Collection)commCheckRuleItemInfoPOs);
        }
    }

    private List<CommCheckRuleRangeInfoPO> buildRangeInfo(DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        ArrayList<CommCheckRuleRangeInfoPO> checkRuleRangeInfoPOList = new ArrayList<CommCheckRuleRangeInfoPO>();
        if (CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckSupplierDTOList()) && CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckCatalogDTOList())) {
            CommCheckRuleRangeInfoPO commCheckRuleRangeInfoPO = new CommCheckRuleRangeInfoPO();
            commCheckRuleRangeInfoPO.setSupplierId(Long.valueOf(-1L));
            commCheckRuleRangeInfoPO.setSupplierName("\u5168\u90e8");
            commCheckRuleRangeInfoPO.setCatalogId(Long.valueOf(-1L));
            commCheckRuleRangeInfoPO.setCatalogName("\u5168\u90e8");
            commCheckRuleRangeInfoPO.setValueShiwFlag(Integer.valueOf(1));
            checkRuleRangeInfoPOList.add(commCheckRuleRangeInfoPO);
        }
        if (!CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckSupplierDTOList()) && CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckCatalogDTOList())) {
            dycProCommCheckRuleInfoDTO.getCheckSupplierDTOList().forEach(dycProCommCheckSupplierDTO -> {
                CommCheckRuleRangeInfoPO commCheckRuleRangeInfoPO = new CommCheckRuleRangeInfoPO();
                commCheckRuleRangeInfoPO.setSupplierId(dycProCommCheckSupplierDTO.getSupplierId());
                commCheckRuleRangeInfoPO.setSupplierName(dycProCommCheckSupplierDTO.getSupplierName());
                commCheckRuleRangeInfoPO.setCatalogId(Long.valueOf(-1L));
                commCheckRuleRangeInfoPO.setCatalogName("\u5168\u90e8");
                commCheckRuleRangeInfoPO.setValueShiwFlag(Integer.valueOf(1));
                checkRuleRangeInfoPOList.add(commCheckRuleRangeInfoPO);
            });
        }
        if (CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckSupplierDTOList()) && !CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckCatalogDTOList())) {
            dycProCommCheckRuleInfoDTO.getCheckCatalogDTOList().forEach(dycProCommCheckCatalogDTO -> {
                CommCheckRuleRangeInfoPO commCheckRuleRangeInfoPO = new CommCheckRuleRangeInfoPO();
                commCheckRuleRangeInfoPO.setSupplierId(Long.valueOf(-1L));
                commCheckRuleRangeInfoPO.setSupplierName("\u5168\u90e8");
                commCheckRuleRangeInfoPO.setCatalogId(dycProCommCheckCatalogDTO.getCatalogId());
                commCheckRuleRangeInfoPO.setCatalogName(dycProCommCheckCatalogDTO.getCatalogName());
                commCheckRuleRangeInfoPO.setParentCatalogId(dycProCommCheckCatalogDTO.getParentCatalogId());
                commCheckRuleRangeInfoPO.setLastLevelFlag(dycProCommCheckCatalogDTO.getLastLevelFlag());
                commCheckRuleRangeInfoPO.setValueShiwFlag(Integer.valueOf(1));
                checkRuleRangeInfoPOList.add(commCheckRuleRangeInfoPO);
            });
        }
        if (!CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckSupplierDTOList()) && !CollectionUtils.isEmpty(dycProCommCheckRuleInfoDTO.getCheckCatalogDTOList())) {
            dycProCommCheckRuleInfoDTO.getCheckSupplierDTOList().forEach(dycProCommCheckSupplierDTO -> dycProCommCheckRuleInfoDTO.getCheckCatalogDTOList().forEach(dycProCommCheckCatalogDTO -> {
                CommCheckRuleRangeInfoPO commCheckRuleRangeInfoPO = new CommCheckRuleRangeInfoPO();
                commCheckRuleRangeInfoPO.setSupplierId(dycProCommCheckSupplierDTO.getSupplierId());
                commCheckRuleRangeInfoPO.setSupplierName(dycProCommCheckSupplierDTO.getSupplierName());
                commCheckRuleRangeInfoPO.setCatalogId(dycProCommCheckCatalogDTO.getCatalogId());
                commCheckRuleRangeInfoPO.setCatalogName(dycProCommCheckCatalogDTO.getCatalogName());
                commCheckRuleRangeInfoPO.setParentCatalogId(dycProCommCheckCatalogDTO.getParentCatalogId());
                commCheckRuleRangeInfoPO.setLastLevelFlag(dycProCommCheckCatalogDTO.getLastLevelFlag());
                commCheckRuleRangeInfoPO.setValueShiwFlag(Integer.valueOf(1));
                checkRuleRangeInfoPOList.add(commCheckRuleRangeInfoPO);
            }));
        }
        return checkRuleRangeInfoPOList;
    }

    @Override
    public void deleteCheckRuleInfo(DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        CommCheckRuleInfoPO commCheckRuleInfoPO = new CommCheckRuleInfoPO();
        commCheckRuleInfoPO.setCheckRuleId(dycProCommCheckRuleInfoDTO.getCheckRuleId());
        commCheckRuleInfoPO.setDelFlag(DycProCommConstants.DelFlag.YES);
        commCheckRuleInfoPO.setUpdateUserId(dycProCommCheckRuleInfoDTO.getUpdateUserId());
        commCheckRuleInfoPO.setUpdateUserName(dycProCommCheckRuleInfoDTO.getUpdateUserName());
        commCheckRuleInfoPO.setUpdateOrgId(dycProCommCheckRuleInfoDTO.getUpdateOrgId());
        commCheckRuleInfoPO.setUpdateOrgName(dycProCommCheckRuleInfoDTO.getUpdateOrgName());
        commCheckRuleInfoPO.setUpdateCompanyId(dycProCommCheckRuleInfoDTO.getUpdateCompanyId());
        commCheckRuleInfoPO.setUpdateCompanyName(dycProCommCheckRuleInfoDTO.getUpdateCompanyName());
        commCheckRuleInfoPO.setUpdateOrgPath(dycProCommCheckRuleInfoDTO.getUpdateOrgPath());
        commCheckRuleInfoPO.setUpdateTime(dycProCommCheckRuleInfoDTO.getUpdateTime());
        this.commCheckRuleInfoMapper.updateById((Object)commCheckRuleInfoPO);
    }

    @Override
    public void deleteCheckRuleInfoByReal(DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        this.commCheckRuleInfoMapper.deleteById((Serializable)dycProCommCheckRuleInfoDTO.getCheckRuleId());
        LambdaQueryWrapper queryRuleItemWrapper = new LambdaQueryWrapper();
        queryRuleItemWrapper.eq(CommCheckRuleItemInfoPO::getCheckRuleId, (Object)dycProCommCheckRuleInfoDTO.getCheckRuleId());
        this.commCheckRuleItemInfoMapper.delete((Wrapper)queryRuleItemWrapper);
        LambdaQueryWrapper queryRuleRangeWrapper = new LambdaQueryWrapper();
        queryRuleRangeWrapper.eq(CommCheckRuleRangeInfoPO::getCheckRuleId, (Object)dycProCommCheckRuleInfoDTO.getCheckRuleId());
        this.commCheckRuleRangeInfoMapper.delete((Wrapper)queryRuleRangeWrapper);
    }

    @Override
    public RspPage<DycProCommCheckRuleInfoDTO> queryCheckRuleInfoListPage(DycProCommCheckRuleInfoQryDTO dycProCommCheckRuleInfoQryDTO) {
        RspPage rspPage = new RspPage();
        CommCheckRuleInfoPO qryPo = (CommCheckRuleInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRuleInfoQryDTO), CommCheckRuleInfoPO.class);
        Page pg = new Page((long)dycProCommCheckRuleInfoQryDTO.getPageNo().intValue(), (long)dycProCommCheckRuleInfoQryDTO.getPageSize().intValue());
        Page checkRuleInfoDTOs = this.commCheckRuleInfoMapper.queryListPage(qryPo, dycProCommCheckRuleInfoQryDTO.getSupplierName(), pg);
        if (StringUtils.hasText((String)dycProCommCheckRuleInfoQryDTO.getSupplierName()) && !CollectionUtils.isEmpty((Collection)checkRuleInfoDTOs.getRecords())) {
            ArrayList checkRuleIds = new ArrayList();
            checkRuleInfoDTOs.getRecords().forEach(commCheckRuleAndSkuRangePO -> {
                if (!commCheckRuleAndSkuRangePO.getSupplierName().equals("\u5168\u90e8")) {
                    checkRuleIds.add(commCheckRuleAndSkuRangePO.getCheckRuleId());
                }
            });
            if (!checkRuleIds.isEmpty()) {
                LambdaQueryWrapper queryRuleRangeWrapper = new LambdaQueryWrapper();
                queryRuleRangeWrapper.in(CommCheckRuleRangeInfoPO::getCheckRuleId, checkRuleIds);
                queryRuleRangeWrapper.groupBy(CommCheckRuleRangeInfoPO::getCheckRuleId, (Object[])new SFunction[]{CommCheckRuleRangeInfoPO::getSupplierId});
                List pos = this.commCheckRuleRangeInfoMapper.selectList((Wrapper)queryRuleRangeWrapper);
                HashMap checkRuleAndSkuRangePOMap = new HashMap();
                pos.forEach(commCheckRuleRangeInfoPO -> {
                    String str = (String)checkRuleAndSkuRangePOMap.get(commCheckRuleRangeInfoPO.getCheckRuleId());
                    str = str != null ? str + "," + commCheckRuleRangeInfoPO.getSupplierName() : commCheckRuleRangeInfoPO.getSupplierName();
                    checkRuleAndSkuRangePOMap.put(commCheckRuleRangeInfoPO.getCheckRuleId(), str);
                });
                checkRuleInfoDTOs.getRecords().forEach(commCheckRuleAndSkuRangePO -> {
                    if (checkRuleAndSkuRangePOMap.get(commCheckRuleAndSkuRangePO.getCheckRuleId()) != null) {
                        commCheckRuleAndSkuRangePO.setSupplierName((String)checkRuleAndSkuRangePOMap.get(commCheckRuleAndSkuRangePO.getCheckRuleId()));
                    }
                });
            }
        }
        rspPage.setRows(JSONArray.parseArray((String)JSON.toJSONString((Object)checkRuleInfoDTOs.getRecords()), DycProCommCheckRuleInfoDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }

    @Override
    public DycProCommCheckRuleInfoDTO queryCheckRuleInfoDetail(DycProCommCheckRuleInfoQryDTO dycProCommCheckRuleInfoQryDTO) {
        LambdaQueryWrapper queryRuleWrapper = new LambdaQueryWrapper();
        queryRuleWrapper.eq(CommCheckRuleInfoPO::getCheckRuleId, (Object)dycProCommCheckRuleInfoQryDTO.getCheckRuleId());
        queryRuleWrapper.eq(CommCheckRuleInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
        CommCheckRuleInfoPO commCheckRuleInfoPO = (CommCheckRuleInfoPO)this.commCheckRuleInfoMapper.selectOne((Wrapper)queryRuleWrapper);
        if (commCheckRuleInfoPO == null) {
            return null;
        }
        DycProCommCheckRuleInfoDTO dto = (DycProCommCheckRuleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)commCheckRuleInfoPO), DycProCommCheckRuleInfoDTO.class);
        if (dycProCommCheckRuleInfoQryDTO.getQueryRangeFlag().booleanValue()) {
            QueryWrapper querySupplierWrapper = new QueryWrapper();
            querySupplierWrapper.select(new String[]{"DISTINCT SUPPLIER_ID,SUPPLIER_NAME"});
            querySupplierWrapper.eq((Object)"CHECK_RULE_ID", (Object)dycProCommCheckRuleInfoQryDTO.getCheckRuleId());
            List supplierInfoPOs = this.commCheckRuleRangeInfoMapper.selectList((Wrapper)querySupplierWrapper);
            if (!CollectionUtils.isEmpty((Collection)supplierInfoPOs)) {
                List checkSupplierDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)supplierInfoPOs), DycProCommCheckSupplierDTO.class);
                dto.setCheckSupplierDTOList(checkSupplierDTOList);
            }
            QueryWrapper queryCatalogWrapper = new QueryWrapper();
            queryCatalogWrapper.select(new String[]{"DISTINCT CATALOG_ID,CATALOG_NAME"});
            queryCatalogWrapper.eq((Object)"CHECK_RULE_ID", (Object)dycProCommCheckRuleInfoQryDTO.getCheckRuleId());
            queryCatalogWrapper.eq((Object)"LAST_LEVEL_FLAG", (Object)1);
            List catalogInfoPOs = this.commCheckRuleRangeInfoMapper.selectList((Wrapper)queryCatalogWrapper);
            if (!CollectionUtils.isEmpty((Collection)catalogInfoPOs)) {
                List checkCatalogDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)catalogInfoPOs), DycProCommCheckCatalogDTO.class);
                dto.setCheckCatalogDTOList(checkCatalogDTOList);
            }
        }
        if (dycProCommCheckRuleInfoQryDTO.getQueryItemFlag().booleanValue()) {
            LambdaQueryWrapper queryRuleItemWrapper = new LambdaQueryWrapper();
            queryRuleItemWrapper.eq(CommCheckRuleItemInfoPO::getCheckRuleId, (Object)dycProCommCheckRuleInfoQryDTO.getCheckRuleId());
            List commCheckRuleItemInfoPOs = this.commCheckRuleItemInfoMapper.selectList((Wrapper)queryRuleItemWrapper);
            if (!CollectionUtils.isEmpty((Collection)commCheckRuleItemInfoPOs)) {
                List checkRuleItemInfoDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)commCheckRuleItemInfoPOs), DycProCommCheckRuleItemInfoDTO.class);
                dto.setCheckRuleItemInfoDTOList(checkRuleItemInfoDTOList);
            }
        }
        return dto;
    }

    @Override
    public void updateCheckRuleInfoStatus(DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        CommCheckRuleInfoPO commCheckRuleInfoPO = new CommCheckRuleInfoPO();
        commCheckRuleInfoPO.setCheckRuleId(dycProCommCheckRuleInfoDTO.getCheckRuleId());
        commCheckRuleInfoPO.setCheckRuleStatus(dycProCommCheckRuleInfoDTO.getCheckRuleStatus());
        commCheckRuleInfoPO.setUpdateUserId(dycProCommCheckRuleInfoDTO.getUpdateUserId());
        commCheckRuleInfoPO.setUpdateUserName(dycProCommCheckRuleInfoDTO.getUpdateUserName());
        commCheckRuleInfoPO.setUpdateOrgId(dycProCommCheckRuleInfoDTO.getUpdateOrgId());
        commCheckRuleInfoPO.setUpdateOrgName(dycProCommCheckRuleInfoDTO.getUpdateOrgName());
        commCheckRuleInfoPO.setUpdateCompanyId(dycProCommCheckRuleInfoDTO.getUpdateCompanyId());
        commCheckRuleInfoPO.setUpdateCompanyName(dycProCommCheckRuleInfoDTO.getUpdateCompanyName());
        commCheckRuleInfoPO.setUpdateOrgPath(dycProCommCheckRuleInfoDTO.getUpdateOrgPath());
        commCheckRuleInfoPO.setUpdateTime(dycProCommCheckRuleInfoDTO.getUpdateTime());
        this.commCheckRuleInfoMapper.updateById((Object)commCheckRuleInfoPO);
    }

    @Override
    public List<DycProCommCheckCatalogDTO> queryCheckRuleCatalogTree(DycProCommCheckRuleInfoQryDTO dycProCommCheckRuleInfoQryDTO) {
        QueryWrapper queryCatalogWrapper = new QueryWrapper();
        queryCatalogWrapper.select(new String[]{"DISTINCT CATALOG_ID,CATALOG_NAME,PARENT_CATALOG_ID,LAST_LEVEL_FLAG,VALUE_SHIW_FLAG"});
        queryCatalogWrapper.eq((Object)"CHECK_RULE_ID", (Object)dycProCommCheckRuleInfoQryDTO.getCheckRuleId());
        queryCatalogWrapper.ne((Object)"CATALOG_ID", (Object)-1);
        List catalogInfoPOs = this.commCheckRuleRangeInfoMapper.selectList((Wrapper)queryCatalogWrapper);
        if (!CollectionUtils.isEmpty((Collection)catalogInfoPOs)) {
            List checkCatalogDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)catalogInfoPOs), DycProCommCheckCatalogDTO.class);
            return checkCatalogDTOList;
        }
        return null;
    }

    @Override
    public List<DycProCommCheckRuleInfoDTO> querySkuEffectCheckRule(DycProCommCheckRuleInfoQryDTO dycProCommCheckRuleInfoQryDTO) {
        CommCheckRuleAndSkuRangePO commCheckRuleAndSkuRangePO = (CommCheckRuleAndSkuRangePO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRuleInfoQryDTO), CommCheckRuleAndSkuRangePO.class);
        List checkRulePos = null;
        commCheckRuleAndSkuRangePO.setCheckRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommCheckRuleStatusEnum.ENABLE.getCode())));
        if (dycProCommCheckRuleInfoQryDTO.getCheckRuleType().equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()))) {
            checkRulePos = this.commCheckRuleInfoMapper.querySkuEffectCheckRule(commCheckRuleAndSkuRangePO);
        } else {
            LambdaQueryWrapper queryRuleItemWrapper = new LambdaQueryWrapper();
            queryRuleItemWrapper.eq(CommCheckRuleInfoPO::getCheckRuleType, (Object)dycProCommCheckRuleInfoQryDTO.getCheckRuleType());
            queryRuleItemWrapper.eq(CommCheckRuleInfoPO::getCheckRuleStatus, (Object)Integer.parseInt(DmcCommCheckRuleStatusEnum.ENABLE.getCode()));
            queryRuleItemWrapper.eq(CommCheckRuleInfoPO::getCheckSceneCode, (Object)dycProCommCheckRuleInfoQryDTO.getCheckSceneCode());
            queryRuleItemWrapper.eq(CommCheckRuleInfoPO::getCheckObjType, (Object)dycProCommCheckRuleInfoQryDTO.getCheckObjType());
            checkRulePos = this.commCheckRuleInfoMapper.selectList((Wrapper)queryRuleItemWrapper);
        }
        if (!CollectionUtils.isEmpty((Collection)checkRulePos)) {
            List checkRuleInfoDTOs = JSONArray.parseArray((String)JSON.toJSONString((Object)checkRulePos), DycProCommCheckRuleInfoDTO.class);
            checkRuleInfoDTOs.forEach(dycProCommCheckRuleInfoDTO -> {
                LambdaQueryWrapper queryRuleItemWrapper = new LambdaQueryWrapper();
                queryRuleItemWrapper.eq(CommCheckRuleItemInfoPO::getCheckRuleId, (Object)dycProCommCheckRuleInfoDTO.getCheckRuleId());
                List checkRuleItemPos = this.commCheckRuleItemInfoMapper.selectList((Wrapper)queryRuleItemWrapper);
                List checkRuleItemInfoDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)checkRuleItemPos), DycProCommCheckRuleItemInfoDTO.class);
                dycProCommCheckRuleInfoDTO.setCheckRuleItemInfoDTOList(checkRuleItemInfoDTOList);
            });
            return checkRuleInfoDTOs;
        }
        return null;
    }

    @Override
    public DycProCommCheckRuleInfoDTO queryCheckRuleInfoMain(DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        CommCheckRuleInfoPO po = (CommCheckRuleInfoPO)this.commCheckRuleInfoMapper.selectById((Serializable)dycProCommCheckRuleInfoDTO.getCheckRuleId());
        if (po == null) {
            return null;
        }
        return (DycProCommCheckRuleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)po), DycProCommCheckRuleInfoDTO.class);
    }
}

