/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.pricerule.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuSalePriceBO;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleHighMarketPriceRuleEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleRoundRuleEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleSkuRangeTypeEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommManageCatalogInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPriceRuleInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPriceRuleSkuRangeInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPropertyTemplateInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuPriceChngRecordMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuPriceInfoMapper;
import com.tydic.dyc.pro.dmc.po.CommManageCatalogInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPriceRuleInfoAndSkuRangePO;
import com.tydic.dyc.pro.dmc.po.CommPriceRuleInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPriceRuleSkuRangeInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPropertyTemplateInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuPriceChngRecordPO;
import com.tydic.dyc.pro.dmc.po.CommSkuPriceInfoPO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleSkuRangeInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoQryDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class DycProCommPriceRuleInfoRepositoryImpl
implements DycProCommPriceRuleInfoRepository {
    @Autowired
    private CommPriceRuleInfoMapper commPriceRuleInfoMapper;
    @Autowired
    private CommSkuPriceInfoMapper commSkuPriceInfoMapper;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;
    @Autowired
    private CommPropertyTemplateInfoMapper commPropertyTemplateInfoMapper;
    @Autowired
    private CommPriceRuleSkuRangeInfoMapper commPriceRuleSkuRangeInfoMapper;
    @Autowired
    private CommSkuPriceChngRecordMapper commSkuPriceChngRecordMapper;
    @Value(value="${ucc.es.index}")
    private String skuIndexName;
    @Autowired
    private NosqlClient nosqlClient;
    @Autowired
    private CommManageCatalogInfoMapper commManageCatalogInfoMapper;

    @Override
    public void addPriceRuleInfo(DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        CommPriceRuleInfoPO commPriceRuleInfoPO = (CommPriceRuleInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleInfoDTO), CommPriceRuleInfoPO.class);
        Long priceRuleId = Sequence.getInstance().nextId();
        commPriceRuleInfoPO.setPriceRuleId(priceRuleId);
        dycProCommPriceRuleInfoDTO.setPriceRuleId(priceRuleId);
        this.commPriceRuleInfoMapper.insert((Object)commPriceRuleInfoPO);
        ArrayList commPriceRuleSkuRangeInfoPOs = new ArrayList();
        dycProCommPriceRuleInfoDTO.getPriceRuleSkuRangeInfoDTOList().forEach(dycProCommPriceRuleSkuRangeInfoDTO -> {
            CommPriceRuleSkuRangeInfoPO commPriceRuleSkuRangeInfoPO = (CommPriceRuleSkuRangeInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleSkuRangeInfoDTO), CommPriceRuleSkuRangeInfoPO.class);
            Long skuRangeId = Sequence.getInstance().nextId();
            commPriceRuleSkuRangeInfoPO.setPriceRuleId(priceRuleId);
            commPriceRuleSkuRangeInfoPO.setSkuRangeId(skuRangeId);
            commPriceRuleSkuRangeInfoPOs.add(commPriceRuleSkuRangeInfoPO);
        });
        this.commPriceRuleSkuRangeInfoMapper.insertBatch(commPriceRuleSkuRangeInfoPOs);
    }

    @Override
    public List<DycProCommSkuPriceInfoDTO> getSkuPriceInfoList(DycProCommSkuPriceInfoQryDTO qryDTO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.inIfPresent(CommSkuPriceInfoPO::getSkuId, qryDTO.getSkuIds());
        queryWrapper.eqIfPresent(CommSkuPriceInfoPO::getPriceRuleId, (Object)qryDTO.getPriceRuleId());
        List result = this.commSkuPriceInfoMapper.selectList((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)result)) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)result), DycProCommSkuPriceInfoDTO.class);
    }

    @Override
    public RspPage<DycProCommPriceRuleInfoDTO> queryPriceRuleInfoListPage(DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO) {
        CommPriceRuleInfoAndSkuRangePO commPriceRuleInfoAndSkuRangePO = (CommPriceRuleInfoAndSkuRangePO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleInfoQryDTO), CommPriceRuleInfoAndSkuRangePO.class);
        Page pg = new Page((long)dycProCommPriceRuleInfoQryDTO.getPageNo().intValue(), (long)dycProCommPriceRuleInfoQryDTO.getPageSize().intValue());
        Page pos = this.commPriceRuleInfoMapper.queryPriceRuleInfoListPage(commPriceRuleInfoAndSkuRangePO, pg);
        RspPage rspPage = new RspPage();
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)pos.getRecords()), DycProCommPriceRuleInfoDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }

    @Override
    public List<DycProCommPriceRuleInfoDTO> queryPriceRuleInfoList(DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.eqIfPresent(CommPriceRuleInfoPO::getPriceRuleId, (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
        queryWrapper.eqIfPresent(CommPriceRuleInfoPO::getPriceRuleStatus, (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleStatus());
        queryWrapper.inIfPresent(CommPriceRuleInfoPO::getPriceRuleId, dycProCommPriceRuleInfoQryDTO.getPriceRuleIds());
        List pos = this.commPriceRuleInfoMapper.selectList((Wrapper)queryWrapper);
        return JSONArray.parseArray((String)JSON.toJSONString((Object)pos), DycProCommPriceRuleInfoDTO.class);
    }

    @Override
    public List<DycProCommPriceRuleSkuRangeInfoDTO> queryPriceRuleSkuRangeList(DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO) {
        LambdaQueryWrapperX queryRuleSkuRangeWrapper = new LambdaQueryWrapperX();
        queryRuleSkuRangeWrapper.eqIfPresent(CommPriceRuleSkuRangeInfoPO::getPriceRuleId, (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
        queryRuleSkuRangeWrapper.eqIfPresent(CommPriceRuleSkuRangeInfoPO::getValueShiwFlag, (Object)dycProCommPriceRuleInfoQryDTO.getValueShiwFlag());
        queryRuleSkuRangeWrapper.inIfPresent(CommPriceRuleSkuRangeInfoPO::getSkuId, dycProCommPriceRuleInfoQryDTO.getSkuIds());
        List commPriceRuleSkuRangeInfoPOS = this.commPriceRuleSkuRangeInfoMapper.selectList((Wrapper)queryRuleSkuRangeWrapper);
        return JSONArray.parseArray((String)JSON.toJSONString((Object)commPriceRuleSkuRangeInfoPOS), DycProCommPriceRuleSkuRangeInfoDTO.class);
    }

    @Override
    public DycProCommPriceRuleInfoDTO queryPriceRuleInfoDetail(DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO) {
        ArrayList<DycProCommPriceRuleSkuRangeInfoDTO> priceRuleSkuRangeInfoDTOList;
        LambdaQueryWrapper queryRuleWrapper = new LambdaQueryWrapper();
        queryRuleWrapper.eq(CommPriceRuleInfoPO::getPriceRuleId, (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
        queryRuleWrapper.eq(CommPriceRuleInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
        CommPriceRuleInfoPO commPriceRuleInfoPO = (CommPriceRuleInfoPO)this.commPriceRuleInfoMapper.selectOne((Wrapper)queryRuleWrapper);
        if (commPriceRuleInfoPO == null) {
            return null;
        }
        DycProCommPriceRuleInfoDTO dto = (DycProCommPriceRuleInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)commPriceRuleInfoPO), DycProCommPriceRuleInfoDTO.class);
        if (dto.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode())) || dto.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER.getCode()))) {
            QueryWrapper querySupplierWrapper = new QueryWrapper();
            querySupplierWrapper.select(new String[]{"DISTINCT SUPPLIER_ID,SUPPLIER_NAME,PRICE_RISE_TYPE,PRICE_RISE_RATE,LADDER_PRICE_RULE"});
            querySupplierWrapper.eq((Object)"PRICE_RULE_ID", (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
            List supplierList = this.commPriceRuleSkuRangeInfoMapper.selectList((Wrapper)querySupplierWrapper);
            priceRuleSkuRangeInfoDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)supplierList), DycProCommPriceRuleSkuRangeInfoDTO.class);
            dto.setPriceRuleSkuRangeInfoDTOList((List<DycProCommPriceRuleSkuRangeInfoDTO>)priceRuleSkuRangeInfoDTOList);
        }
        if (dto.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode())) || dto.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR.getCode()))) {
            QueryWrapper queryAgrWrapper = new QueryWrapper();
            queryAgrWrapper.select(new String[]{"DISTINCT AGR_ID,AGR_CODE,AGR_NAME,PRICE_RISE_TYPE,PRICE_RISE_RATE,LADDER_PRICE_RULE"});
            queryAgrWrapper.eq((Object)"PRICE_RULE_ID", (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
            List agrList = this.commPriceRuleSkuRangeInfoMapper.selectList((Wrapper)queryAgrWrapper);
            priceRuleSkuRangeInfoDTOList = JSONArray.parseArray((String)JSON.toJSONString((Object)agrList), DycProCommPriceRuleSkuRangeInfoDTO.class);
            dto.setPriceRuleSkuRangeInfoDTOList((List<DycProCommPriceRuleSkuRangeInfoDTO>)priceRuleSkuRangeInfoDTOList);
        }
        if (commPriceRuleInfoPO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
            LambdaQueryWrapper querySkuRangeWrapper = new LambdaQueryWrapper();
            querySkuRangeWrapper.eq(CommPriceRuleSkuRangeInfoPO::getPriceRuleId, (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
            CommPriceRuleSkuRangeInfoPO commPriceRuleSkuRangeInfoPO = (CommPriceRuleSkuRangeInfoPO)this.commPriceRuleSkuRangeInfoMapper.selectOne((Wrapper)querySkuRangeWrapper);
            priceRuleSkuRangeInfoDTOList = new ArrayList<DycProCommPriceRuleSkuRangeInfoDTO>();
            DycProCommPriceRuleSkuRangeInfoDTO priceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)commPriceRuleSkuRangeInfoPO), DycProCommPriceRuleSkuRangeInfoDTO.class);
            priceRuleSkuRangeInfoDTOList.add(priceRuleSkuRangeInfoDTO);
            dto.setPriceRuleSkuRangeInfoDTOList(priceRuleSkuRangeInfoDTOList);
        }
        return dto;
    }

    @Override
    public void updatePriceRuleInfo(DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        CommPriceRuleInfoPO updatePo = (CommPriceRuleInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleInfoDTO), CommPriceRuleInfoPO.class);
        this.commPriceRuleInfoMapper.updateById((Object)updatePo);
        LambdaQueryWrapper deleteSkuRangeWrapper = new LambdaQueryWrapper();
        deleteSkuRangeWrapper.eq(CommPriceRuleSkuRangeInfoPO::getPriceRuleId, (Object)updatePo.getPriceRuleId());
        this.commPriceRuleSkuRangeInfoMapper.delete((Wrapper)deleteSkuRangeWrapper);
        ArrayList commPriceRuleSkuRangeInfoPOs = new ArrayList();
        dycProCommPriceRuleInfoDTO.getPriceRuleSkuRangeInfoDTOList().forEach(dycProCommPriceRuleSkuRangeInfoDTO -> {
            CommPriceRuleSkuRangeInfoPO commPriceRuleSkuRangeInfoPO = (CommPriceRuleSkuRangeInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleSkuRangeInfoDTO), CommPriceRuleSkuRangeInfoPO.class);
            Long skuRangeId = Sequence.getInstance().nextId();
            commPriceRuleSkuRangeInfoPO.setPriceRuleId(updatePo.getPriceRuleId());
            commPriceRuleSkuRangeInfoPO.setSkuRangeId(skuRangeId);
            commPriceRuleSkuRangeInfoPOs.add(commPriceRuleSkuRangeInfoPO);
        });
        this.commPriceRuleSkuRangeInfoMapper.insertBatch(commPriceRuleSkuRangeInfoPOs);
    }

    @Override
    public List<DycProCommSkuPriceChngRecordDTO> getSkuPriceChngRecordList(DycProCommSkuPriceChngRecordDTO reqBO) {
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eq(CommSkuPriceChngRecordPO::getSkuId, (Object)reqBO.getSkuId());
        queryWrapperX.betweenIfPresent(CommSkuPriceChngRecordPO::getChngTime, (Object)reqBO.getChngStartTime(), (Object)reqBO.getChngEndTime());
        queryWrapperX.orderByAsc(CommSkuPriceChngRecordPO::getChngTime);
        List result = this.commSkuPriceChngRecordMapper.selectList((Wrapper)queryWrapperX);
        if (ObjectUtils.isEmpty((Object)result)) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)result), DycProCommSkuPriceChngRecordDTO.class);
    }

    @Override
    public DycProCommSkuPriceInfoDTO computeSkuPrice(DycProCommSkuPriceInfoHandleDTO handleDTO) {
        List commPriceRuleInfoAndSkuRangePOS;
        DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO = new DycProCommSkuPriceInfoDTO();
        CommPriceRuleInfoAndSkuRangePO po = (CommPriceRuleInfoAndSkuRangePO)JSON.parseObject((String)JSON.toJSONString((Object)handleDTO), CommPriceRuleInfoAndSkuRangePO.class);
        if (!StringUtils.hasText((String)handleDTO.getManageCatalogPath()) && handleDTO.getManageCatalogId() != null) {
            CommManageCatalogInfoPO commManageCatalogInfoPO = (CommManageCatalogInfoPO)this.commManageCatalogInfoMapper.selectById((Serializable)handleDTO.getManageCatalogId());
            if (commManageCatalogInfoPO == null) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u540e\u53f0\u7ba1\u7406\u7c7b\u76ee");
            }
            handleDTO.setManageCatalogPath(commManageCatalogInfoPO.getManageCatalogPath());
        }
        ArrayList catalogIds = new ArrayList();
        if (StringUtils.hasText((String)handleDTO.getManageCatalogPath())) {
            Arrays.asList(handleDTO.getManageCatalogPath().split("-")).forEach(catalogId -> catalogIds.add(Long.parseLong(catalogId)));
            po.setCatalogIds(catalogIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(commPriceRuleInfoAndSkuRangePOS = this.commPriceRuleInfoMapper.querySkuEffectPriceRuleInfoList(po)))) {
            CommPriceRuleInfoAndSkuRangePO commPriceRuleInfoAndSkuRangePO = (CommPriceRuleInfoAndSkuRangePO)commPriceRuleInfoAndSkuRangePOS.get(0);
            if (commPriceRuleInfoAndSkuRangePO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode())) || commPriceRuleInfoAndSkuRangePO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode())) || commPriceRuleInfoAndSkuRangePO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode()))) {
                HashMap catalogIdPriceRuleMap = new HashMap();
                CommPriceRuleInfoAndSkuRangePO finalCommPriceRuleInfoAndSkuRangePO = commPriceRuleInfoAndSkuRangePO;
                commPriceRuleInfoAndSkuRangePOS.forEach(commPriceRuleInfoAndSkuRangePO1 -> {
                    if (commPriceRuleInfoAndSkuRangePO1.getCatalogId() != null && commPriceRuleInfoAndSkuRangePO1.getSkuRangeType().equals(finalCommPriceRuleInfoAndSkuRangePO.getSkuRangeType())) {
                        catalogIdPriceRuleMap.put(commPriceRuleInfoAndSkuRangePO1.getCatalogId(), commPriceRuleInfoAndSkuRangePO1);
                    }
                });
                for (Long catalogId2 : catalogIds) {
                    if (!catalogIdPriceRuleMap.containsKey(catalogId2)) continue;
                    commPriceRuleInfoAndSkuRangePO = (CommPriceRuleInfoAndSkuRangePO)catalogIdPriceRuleMap.get(catalogId2);
                }
            }
            BigDecimal priceRiseRate = new BigDecimal(commPriceRuleInfoAndSkuRangePO.getPriceRiseRate());
            BigDecimal salePrice = null;
            if (commPriceRuleInfoAndSkuRangePO.getPriceRiseType().equals(DycProCommConstants.PriceRiseType.RATE)) {
                BigDecimal temp = new BigDecimal(1).add(priceRiseRate.divide(new BigDecimal(100), 4, RoundingMode.HALF_UP));
                salePrice = commPriceRuleInfoAndSkuRangePO.getRoundRule().equals(Integer.parseInt(DmcCommPriceRuleRoundRuleEnum.FOUR_FIVE.getCode())) ? handleDTO.getSupplierPrice().multiply(temp).setScale(2, RoundingMode.HALF_UP) : handleDTO.getSupplierPrice().multiply(temp).setScale(2, RoundingMode.CEILING);
            } else {
                salePrice = commPriceRuleInfoAndSkuRangePO.getRoundRule().equals(Integer.parseInt(DmcCommPriceRuleRoundRuleEnum.FOUR_FIVE.getCode())) ? handleDTO.getSupplierPrice().add(priceRiseRate).setScale(2, RoundingMode.HALF_UP) : handleDTO.getSupplierPrice().add(priceRiseRate).setScale(2, RoundingMode.HALF_UP);
            }
            if (salePrice.compareTo(handleDTO.getMarketPrice()) > 0) {
                if (commPriceRuleInfoAndSkuRangePO.getEnableHigherMarketPriceFlag().equals(Integer.parseInt(DmcCommPriceRuleHighMarketPriceRuleEnum.USER_MARKET_PRICE.getCode()))) {
                    salePrice = handleDTO.getMarketPrice();
                } else if (commPriceRuleInfoAndSkuRangePO.getEnableHigherMarketPriceFlag().equals(Integer.parseInt(DmcCommPriceRuleHighMarketPriceRuleEnum.USER_SUPPLIER_PRICE.getCode()))) {
                    salePrice = handleDTO.getSupplierPrice();
                }
            }
            dycProCommSkuPriceInfoDTO.setPriceRuleId(commPriceRuleInfoAndSkuRangePO.getPriceRuleId());
            dycProCommSkuPriceInfoDTO.setSalePrice(salePrice);
            dycProCommSkuPriceInfoDTO.setPriority(0);
            dycProCommSkuPriceInfoDTO.setLadderPriceRule(commPriceRuleInfoAndSkuRangePO.getLadderPriceRule());
            dycProCommSkuPriceInfoDTO.setPriceRiseType(commPriceRuleInfoAndSkuRangePO.getPriceRiseType());
            dycProCommSkuPriceInfoDTO.setPriceRiseRate(commPriceRuleInfoAndSkuRangePO.getPriceRiseRate());
            return dycProCommSkuPriceInfoDTO;
        }
        return null;
    }

    @Override
    public List<DycProCommSkuPriceInfoDTO> computeSkuPriceBySkus(DycProCommSkuPriceInfoHandleDTO handleDTO) {
        List<DycProCommSkuPriceInfoDTO> dtos = handleDTO.getDycProCommSkuPriceInfoDTOs();
        List skuIds = dtos.stream().map(DycProCommSkuPriceInfoDTO::getSkuId).collect(Collectors.toList());
        LambdaQueryWrapperX querySkuPriceWrapperX = new LambdaQueryWrapperX();
        querySkuPriceWrapperX.in(CommSkuPriceInfoPO::getSkuId, skuIds);
        List commSkuPriceInfoPOs = this.commSkuPriceInfoMapper.selectList((Wrapper)querySkuPriceWrapperX);
        Map skuIdPriceMap = commSkuPriceInfoPOs.stream().collect(Collectors.toMap(CommSkuPriceInfoPO::getSkuId, Function.identity()));
        Set priceRuleIds = commSkuPriceInfoPOs.stream().map(CommSkuPriceInfoPO::getPriceRuleId).collect(Collectors.toSet());
        LambdaQueryWrapperX queryPriceRuleWrapperX = new LambdaQueryWrapperX();
        queryPriceRuleWrapperX.in(CommPriceRuleInfoPO::getPriceRuleId, priceRuleIds);
        List commPriceRuleInfoPOs = this.commPriceRuleInfoMapper.selectList((Wrapper)queryPriceRuleWrapperX);
        Map priceRuleIdMap = commPriceRuleInfoPOs.stream().collect(Collectors.toMap(CommPriceRuleInfoPO::getPriceRuleId, Function.identity()));
        dtos.forEach(dycProCommSkuPriceInfoDTO -> {
            CommPriceRuleInfoPO commPriceRuleInfoPO;
            CommSkuPriceInfoPO commSkuPriceInfoPO = (CommSkuPriceInfoPO)skuIdPriceMap.get(dycProCommSkuPriceInfoDTO.getSkuId());
            if (commSkuPriceInfoPO != null && (commPriceRuleInfoPO = (CommPriceRuleInfoPO)priceRuleIdMap.get(commSkuPriceInfoPO.getPriceRuleId())) != null) {
                BigDecimal priceRiseRate = new BigDecimal(commSkuPriceInfoPO.getPriceRiseRate());
                BigDecimal salePrice = null;
                if (commSkuPriceInfoPO.getPriceRiseType().equals(DycProCommConstants.PriceRiseType.RATE)) {
                    BigDecimal temp = new BigDecimal(1).add(priceRiseRate.divide(new BigDecimal(100), 4, RoundingMode.HALF_UP));
                    salePrice = commPriceRuleInfoPO.getRoundRule().equals(Integer.parseInt(DmcCommPriceRuleRoundRuleEnum.FOUR_FIVE.getCode())) ? dycProCommSkuPriceInfoDTO.getSupplierPrice().multiply(temp).setScale(2, RoundingMode.HALF_UP) : dycProCommSkuPriceInfoDTO.getSupplierPrice().multiply(temp).setScale(2, RoundingMode.CEILING);
                } else {
                    salePrice = commPriceRuleInfoPO.getRoundRule().equals(Integer.parseInt(DmcCommPriceRuleRoundRuleEnum.FOUR_FIVE.getCode())) ? dycProCommSkuPriceInfoDTO.getSupplierPrice().add(priceRiseRate).setScale(2, RoundingMode.HALF_UP) : dycProCommSkuPriceInfoDTO.getSupplierPrice().add(priceRiseRate).setScale(2, RoundingMode.HALF_UP);
                }
                if (salePrice.compareTo(dycProCommSkuPriceInfoDTO.getMarketPrice()) > 0) {
                    if (commPriceRuleInfoPO.getEnableHigherMarketPriceFlag().equals(Integer.parseInt(DmcCommPriceRuleHighMarketPriceRuleEnum.USER_MARKET_PRICE.getCode()))) {
                        salePrice = dycProCommSkuPriceInfoDTO.getMarketPrice();
                    } else if (commPriceRuleInfoPO.getEnableHigherMarketPriceFlag().equals(Integer.parseInt(DmcCommPriceRuleHighMarketPriceRuleEnum.USER_SUPPLIER_PRICE.getCode()))) {
                        salePrice = dycProCommSkuPriceInfoDTO.getSupplierPrice();
                    }
                }
                dycProCommSkuPriceInfoDTO.setSalePrice(salePrice);
            }
        });
        return dtos;
    }

    @Override
    public RspPage<DycProCommSkuPriceInfoDTO> getSkuPriceInfoListPage(DycProCommSkuPriceInfoQryDTO qryDTO) {
        Page pg = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eqIfPresent(CommSkuPriceInfoPO::getPriceRuleId, (Object)qryDTO.getPriceRuleId());
        Page pos = (Page)this.commSkuPriceInfoMapper.selectPage((IPage)pg, (Wrapper)queryWrapperX);
        RspPage rspPage = new RspPage();
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)pos.getRecords()), DycProCommSkuPriceInfoDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }

    @Override
    public DycProCommSkuPriceInfoDTO getSkuPriceInfo(DycProCommSkuPriceInfoQryDTO qryDTO) {
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eq(CommSkuPriceInfoPO::getSkuId, (Object)qryDTO.getSkuId());
        queryWrapperX.eqIfPresent(CommSkuPriceInfoPO::getPriority, (Object)qryDTO.getPriority());
        CommSkuPriceInfoPO commSkuPriceInfoPO = (CommSkuPriceInfoPO)this.commSkuPriceInfoMapper.selectOne((Wrapper)queryWrapperX);
        if (commSkuPriceInfoPO == null) {
            return null;
        }
        return (DycProCommSkuPriceInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)commSkuPriceInfoPO), DycProCommSkuPriceInfoDTO.class);
    }

    @Override
    public RspPage<DycProCommPriceRuleSkuRangeInfoDTO> getSkuInfoListPage(DycProCommPriceRuleInfoQryDTO qryDTO) {
        Page pg = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        LambdaQueryWrapperX querySkuWrapperX = new LambdaQueryWrapperX();
        querySkuWrapperX.eq(CommSkuInfoPO::getTradeMode, (Object)1);
        querySkuWrapperX.eqIfPresent(CommSkuInfoPO::getAgrId, (Object)qryDTO.getAgrId());
        querySkuWrapperX.eqIfPresent(CommSkuInfoPO::getSupplierId, (Object)qryDTO.getSupplierId());
        ArrayList propertyTemplateIds = new ArrayList();
        if (qryDTO.getCatalogId() != null) {
            LambdaQueryWrapperX queryPropertyTemplateWrapperX = new LambdaQueryWrapperX();
            queryPropertyTemplateWrapperX.eq(CommPropertyTemplateInfoPO::getManageCatalogId, (Object)qryDTO.getCatalogId());
            List commPropertyTemplateInfoPOs = this.commPropertyTemplateInfoMapper.selectList((Wrapper)queryPropertyTemplateWrapperX);
            if (!CollectionUtils.isEmpty((Collection)commPropertyTemplateInfoPOs)) {
                commPropertyTemplateInfoPOs.forEach(commPropertyTemplateInfoPO -> propertyTemplateIds.add(commPropertyTemplateInfoPO.getPropertyTemplateId()));
            }
        }
        querySkuWrapperX.inIfPresent(CommSkuInfoPO::getPropertyTemplateId, propertyTemplateIds);
        Page pos = (Page)this.commSkuInfoMapper.selectPage((IPage)pg, (Wrapper)querySkuWrapperX);
        RspPage rspPage = new RspPage();
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)pos.getRecords()), DycProCommPriceRuleSkuRangeInfoDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProCommSkuPriceChngRecordDTO> querySkuPriceChangeListPage(DycProCommSkuPriceInfoQryDTO qryDTO) {
        Page pg = new Page((long)qryDTO.getPageNo().intValue(), (long)qryDTO.getPageSize().intValue());
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eqIfPresent(CommSkuPriceChngRecordPO::getSkuId, (Object)qryDTO.getSkuId());
        queryWrapperX.orderByDesc(CommSkuPriceChngRecordPO::getPriceChngRecordId);
        Page pos = (Page)this.commSkuPriceChngRecordMapper.selectPage((IPage)pg, (Wrapper)queryWrapperX);
        RspPage rspPage = new RspPage();
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)pos.getRecords()), DycProCommSkuPriceChngRecordDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }

    @Override
    public void updateSkuPriceInfoAndSyncNosql(DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO) {
        CommSkuPriceInfoPO commSkuPriceInfoPO = (CommSkuPriceInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommSkuPriceInfoDTO), CommSkuPriceInfoPO.class);
        this.commSkuPriceInfoMapper.updateById((Object)commSkuPriceInfoPO);
        DycProEsIndexMappingSkuBO updateIndexMappingSkuBO = new DycProEsIndexMappingSkuBO();
        BeanUtils.copyProperties((Object)commSkuPriceInfoPO, (Object)updateIndexMappingSkuBO);
        ArrayList<DycProEsIndexMappingSkuSalePriceBO> esSalePriceList = new ArrayList<DycProEsIndexMappingSkuSalePriceBO>();
        DycProEsIndexMappingSkuSalePriceBO esSkuSalePriceBO = new DycProEsIndexMappingSkuSalePriceBO();
        BeanUtils.copyProperties((Object)commSkuPriceInfoPO, (Object)esSkuSalePriceBO);
        esSalePriceList.add(esSkuSalePriceBO);
        updateIndexMappingSkuBO.setSalePriceList(esSalePriceList);
        NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
        nosqlUpdateSingleReqBO.setIndex(this.skuIndexName);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(commSkuPriceInfoPO.getSkuId()));
        nosqlBO.setObject((Object)updateIndexMappingSkuBO);
        nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
        NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
        if (!"0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u66f4\u65b0sku \u4ef7\u683c\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
        }
    }

    @Override
    public RspPage<DycProCommPriceRuleSkuRangeInfoDTO> queryPriceRuleSkuRangeListPage(DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO) {
        Page pg = new Page((long)dycProCommPriceRuleInfoQryDTO.getPageNo().intValue(), (long)dycProCommPriceRuleInfoQryDTO.getPageSize().intValue());
        LambdaQueryWrapperX queryWrapperX = new LambdaQueryWrapperX();
        queryWrapperX.eqIfPresent(CommPriceRuleSkuRangeInfoPO::getPriceRuleId, (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
        Page pos = (Page)this.commPriceRuleSkuRangeInfoMapper.selectPage((IPage)pg, (Wrapper)queryWrapperX);
        RspPage rspPage = new RspPage();
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)pos.getRecords()), DycProCommPriceRuleSkuRangeInfoDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }

    @Override
    public List<DycProCommPriceRuleSkuRangeInfoDTO> queryPriceRuleLastCatalogList(DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO) {
        LambdaQueryWrapperX queryRuleSkuRangeWrapper = new LambdaQueryWrapperX();
        queryRuleSkuRangeWrapper.eq(CommPriceRuleSkuRangeInfoPO::getPriceRuleId, (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
        List commPriceRuleSkuRangeInfoPOS = this.commPriceRuleSkuRangeInfoMapper.selectList((Wrapper)queryRuleSkuRangeWrapper);
        ArrayList<DycProCommPriceRuleSkuRangeInfoDTO> result = new ArrayList<DycProCommPriceRuleSkuRangeInfoDTO>();
        HashSet catalogIds = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)commPriceRuleSkuRangeInfoPOS)) {
            commPriceRuleSkuRangeInfoPOS.forEach(commPriceRuleSkuRangeInfoPO -> {
                LambdaQueryWrapperX queryCatalogWrapper = new LambdaQueryWrapperX();
                queryCatalogWrapper.like(CommManageCatalogInfoPO::getManageCatalogPath, (Object)commPriceRuleSkuRangeInfoPO.getCatalogId());
                queryCatalogWrapper.eq(CommManageCatalogInfoPO::getLastLevelFlag, (Object)1);
                List manageCatalogInfoPOs = this.commManageCatalogInfoMapper.selectList((Wrapper)queryCatalogWrapper);
                if (!CollectionUtils.isEmpty((Collection)manageCatalogInfoPOs)) {
                    manageCatalogInfoPOs.forEach(commManageCatalogInfoPO -> {
                        if (!catalogIds.contains(commManageCatalogInfoPO.getManageCatalogId())) {
                            DycProCommPriceRuleSkuRangeInfoDTO dto = new DycProCommPriceRuleSkuRangeInfoDTO();
                            dto.setAgrId(commPriceRuleSkuRangeInfoPO.getAgrId());
                            dto.setSupplierId(commPriceRuleSkuRangeInfoPO.getSupplierId());
                            dto.setCatalogId(commManageCatalogInfoPO.getManageCatalogId());
                            result.add(dto);
                            catalogIds.add(commManageCatalogInfoPO.getManageCatalogId());
                        }
                    });
                }
            });
        }
        return result;
    }

    @Override
    public void updatePriceRuleInfoStatus(DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        CommPriceRuleInfoPO commPriceRuleInfoPO = new CommPriceRuleInfoPO();
        commPriceRuleInfoPO.setPriceRuleId(dycProCommPriceRuleInfoDTO.getPriceRuleId());
        commPriceRuleInfoPO.setPriceRuleStatus(dycProCommPriceRuleInfoDTO.getPriceRuleStatus());
        commPriceRuleInfoPO.setUpdateUserId(dycProCommPriceRuleInfoDTO.getUpdateUserId());
        commPriceRuleInfoPO.setUpdateUserName(dycProCommPriceRuleInfoDTO.getUpdateUserName());
        commPriceRuleInfoPO.setUpdateOrgId(dycProCommPriceRuleInfoDTO.getUpdateOrgId());
        commPriceRuleInfoPO.setUpdateOrgName(dycProCommPriceRuleInfoDTO.getUpdateOrgName());
        commPriceRuleInfoPO.setUpdateCompanyId(dycProCommPriceRuleInfoDTO.getUpdateCompanyId());
        commPriceRuleInfoPO.setUpdateCompanyName(dycProCommPriceRuleInfoDTO.getUpdateCompanyName());
        commPriceRuleInfoPO.setUpdateOrgPath(dycProCommPriceRuleInfoDTO.getUpdateOrgPath());
        commPriceRuleInfoPO.setUpdateTime(dycProCommPriceRuleInfoDTO.getUpdateTime());
        this.commPriceRuleInfoMapper.updateById((Object)commPriceRuleInfoPO);
    }

    @Override
    public void deletePriceRuleInfo(DycProCommPriceRuleInfoDTO dycProCommPriceRuleInfoDTO) {
        this.commPriceRuleInfoMapper.deleteById((Serializable)dycProCommPriceRuleInfoDTO.getPriceRuleId());
        LambdaQueryWrapper deleteSkuRangeWrapper = new LambdaQueryWrapper();
        deleteSkuRangeWrapper.eq(CommPriceRuleSkuRangeInfoPO::getPriceRuleId, (Object)dycProCommPriceRuleInfoDTO.getPriceRuleId());
        this.commPriceRuleSkuRangeInfoMapper.delete((Wrapper)deleteSkuRangeWrapper);
    }

    @Override
    public RspPage<DycProCommPriceRuleSkuRangeInfoDTO> queryPriceRuleSelectedSkuListPage(DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO) {
        RspPage rspPage = new RspPage();
        Page pg = new Page((long)dycProCommPriceRuleInfoQryDTO.getPageNo().intValue(), (long)dycProCommPriceRuleInfoQryDTO.getPageSize().intValue());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CommPriceRuleSkuRangeInfoPO::getPriceRuleId, (Object)dycProCommPriceRuleInfoQryDTO.getPriceRuleId());
        Page pos = (Page)this.commPriceRuleSkuRangeInfoMapper.selectPage((IPage)pg, (Wrapper)queryWrapper);
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)pos.getRecords()), DycProCommPriceRuleSkuRangeInfoDTO.class));
        rspPage.setPageNo((int)pg.getCurrent());
        rspPage.setTotal((int)pg.getPages());
        rspPage.setRecordsTotal((int)pg.getTotal());
        return rspPage;
    }

    @Override
    public List<DycProCommPriceRuleSkuRangeInfoDTO> queryAgrCatalog(DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO) {
        List pos = this.commPriceRuleSkuRangeInfoMapper.queryAgrCatalog(dycProCommPriceRuleInfoQryDTO.getAgrId());
        List dto = JSONArray.parseArray((String)JSON.toJSONString((Object)pos), DycProCommPriceRuleSkuRangeInfoDTO.class);
        return dto;
    }
}

