/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.purchaseauth.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommPurchaseAuthConfigItemMapper;
import com.tydic.dyc.pro.dmc.dao.CommPurchaseAuthConfigMapper;
import com.tydic.dyc.pro.dmc.po.CommPurchaseAuthConfigItemPO;
import com.tydic.dyc.pro.dmc.po.CommPurchaseAuthConfigPO;
import com.tydic.dyc.pro.dmc.repository.purchaseauth.api.DycProCommPurchaseAuthRepository;
import com.tydic.dyc.pro.dmc.repository.purchaseauth.bo.DycProCommPurchaseAuthCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.purchaseauth.bo.DycProCommPurchaseAuthDTO;
import com.tydic.dyc.pro.dmc.repository.purchaseauth.bo.DycProCommPurchaseAuthInfoDTO;
import com.tydic.dyc.pro.dmc.repository.purchaseauth.bo.DycProCommPurchaseAuthQryDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProCommPurchaseAuthRepositoryImpl
implements DycProCommPurchaseAuthRepository {
    @Autowired
    private CommPurchaseAuthConfigMapper commPurchaseAuthConfigMapper;
    @Autowired
    private CommPurchaseAuthConfigItemMapper commPurchaseAuthConfigItemMapper;

    @Override
    public RspPage<DycProCommPurchaseAuthInfoDTO> qryPurchaseAuthList(DycProCommPurchaseAuthQryDTO reqBO) {
        if (null == reqBO.getAuthType()) {
            throw new ZTBusinessException("\u5165\u53c2\u91c7\u4e70\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RspPage rspPage = new RspPage();
        List<Object> configIdList = new ArrayList();
        if (null != reqBO.getCatalogId()) {
            LambdaQueryWrapperX queryItemWrapper = new LambdaQueryWrapperX();
            queryItemWrapper.likeIfPresent(CommPurchaseAuthConfigItemPO::getCatalogPath, reqBO.getCatalogId().toString() + "-");
            queryItemWrapper.eq(CommPurchaseAuthConfigItemPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
            List commPurchaseAuthConfigItemPOS = this.commPurchaseAuthConfigItemMapper.selectList((Wrapper)queryItemWrapper);
            if (CollectionUtils.isEmpty((Collection)commPurchaseAuthConfigItemPOS)) {
                rspPage.setPageNo(0);
                rspPage.setTotal(0);
                rspPage.setRecordsTotal(0);
                return rspPage;
            }
            configIdList = commPurchaseAuthConfigItemPOS.stream().map(a -> a.getConfigId()).collect(Collectors.toList());
        }
        Page page = new Page((long)reqBO.getPageNo().intValue(), (long)reqBO.getPageSize().intValue());
        page.setOptimizeCountSql(false);
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.likeIfPresent(CommPurchaseAuthConfigPO::getOrgName, reqBO.getOrgName());
        queryWrapper.likeIfPresent(CommPurchaseAuthConfigPO::getUpdateUserName, reqBO.getUpdateUserName());
        queryWrapper.eqIfPresent(CommPurchaseAuthConfigPO::getOrgType, (Object)reqBO.getOrgType());
        queryWrapper.eq(CommPurchaseAuthConfigPO::getAuthType, (Object)reqBO.getAuthType());
        queryWrapper.inIfPresent(CommPurchaseAuthConfigPO::getId, configIdList);
        queryWrapper.orderByAsc(CommPurchaseAuthConfigPO::getShowOrder);
        queryWrapper.orderByDesc(CommPurchaseAuthConfigPO::getUpdateTime);
        queryWrapper.eq(CommPurchaseAuthConfigPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
        queryWrapper.likeIfPresent(CommPurchaseAuthConfigPO::getCreateOrgPath, reqBO.getOrgCommPath());
        page = (Page)this.commPurchaseAuthConfigMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List commPurchaseAuthConfigPOS = new ArrayList();
        commPurchaseAuthConfigPOS = page.getRecords();
        if (!CollectionUtils.isEmpty(commPurchaseAuthConfigPOS)) {
            List dycProCommPurchaseAuthInfoDTOS = JSON.parseArray((String)JSON.toJSONString(commPurchaseAuthConfigPOS), DycProCommPurchaseAuthInfoDTO.class);
            for (DycProCommPurchaseAuthInfoDTO commPurchaseAuthConfigPO : dycProCommPurchaseAuthInfoDTOS) {
                LambdaQueryWrapperX queryItemWrapper = new LambdaQueryWrapperX();
                queryItemWrapper.eq(CommPurchaseAuthConfigItemPO::getConfigId, (Object)commPurchaseAuthConfigPO.getId());
                queryItemWrapper.eq(CommPurchaseAuthConfigItemPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
                List commPurchaseAuthConfigItemPOS = this.commPurchaseAuthConfigItemMapper.selectList((Wrapper)queryItemWrapper);
                List dycProCommPurchaseAuthCatalogDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commPurchaseAuthConfigItemPOS), DycProCommPurchaseAuthCatalogDTO.class);
                commPurchaseAuthConfigPO.setCatalogList(dycProCommPurchaseAuthCatalogDTOS);
            }
            rspPage.setRows(dycProCommPurchaseAuthInfoDTOS);
        }
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public void createPurchaseAuthConfig(DycProCommPurchaseAuthDTO reqBO) {
        if (null == reqBO.getAuthType()) {
            throw new ZTBusinessException("\u5165\u53c2\u91c7\u4e70\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrgType()) {
            throw new ZTBusinessException("\u5165\u53c2\u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getCatalogList())) {
            throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrgName())) {
            throw new ZTBusinessException("\u5165\u53c2\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getCatalogList())) {
            throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommPurchaseAuthCatalogDTO dycProCommodityCatalogBansDTO : reqBO.getCatalogList()) {
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getCatalogName())) {
                throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getCatalogPath())) {
                throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u6811\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != dycProCommodityCatalogBansDTO.getCatalogId()) continue;
            throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrgId()) {
            throw new ZTBusinessException("\u5165\u53c2\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List commPurchaseAuthConfigPOS = this.commPurchaseAuthConfigMapper.selectList((Wrapper)new LambdaQueryWrapperX().eq(CommPurchaseAuthConfigPO::getOrgId, (Object)reqBO.getOrgId()).eq(CommPurchaseAuthConfigPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (!CollectionUtils.isEmpty((Collection)commPurchaseAuthConfigPOS)) {
            throw new ZTBusinessException("\u8be5\u7ec4\u7ec7\u673a\u6784\u5df2\u6dfb\u52a0\u91c7\u4e70\u6743\u9650\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        CommPurchaseAuthConfigPO commPurchaseAuthConfigPO = (CommPurchaseAuthConfigPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), CommPurchaseAuthConfigPO.class);
        Long id = Sequence.getInstance().nextId();
        commPurchaseAuthConfigPO.setId(id);
        int total = reqBO.getOrgPath().length() - reqBO.getOrgPath().replace("-", "").length();
        commPurchaseAuthConfigPO.setShowOrder(Integer.valueOf(total));
        commPurchaseAuthConfigPO.setDelFlag(DycProCommConstants.DelFlag.NO);
        this.commPurchaseAuthConfigMapper.insert((Object)commPurchaseAuthConfigPO);
        List commPurchaseAuthConfigItemPOS = JSON.parseArray((String)JSON.toJSONString(reqBO.getCatalogList()), CommPurchaseAuthConfigItemPO.class);
        for (CommPurchaseAuthConfigItemPO commPurchaseAuthConfigItemPO : commPurchaseAuthConfigItemPOS) {
            Long itemId = Sequence.getInstance().nextId();
            commPurchaseAuthConfigItemPO.setItemId(itemId);
            commPurchaseAuthConfigItemPO.setConfigId(id);
            commPurchaseAuthConfigItemPO.setDelFlag(DycProCommConstants.DelFlag.NO);
        }
        this.commPurchaseAuthConfigItemMapper.insertBatch((Collection)commPurchaseAuthConfigItemPOS);
    }

    @Override
    public void editPurchaseAuthConfig(DycProCommPurchaseAuthDTO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getCatalogList())) {
            throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProCommPurchaseAuthCatalogDTO dycProCommodityCatalogBansDTO : reqBO.getCatalogList()) {
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getCatalogName())) {
                throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dycProCommodityCatalogBansDTO.getCatalogPath())) {
                throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76ee\u6811\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != dycProCommodityCatalogBansDTO.getCatalogId()) continue;
            throw new ZTBusinessException("\u5165\u53c2\u7c7b\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommPurchaseAuthConfigPO commPurchaseAuthConfigPO = (CommPurchaseAuthConfigPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), CommPurchaseAuthConfigPO.class);
        this.commPurchaseAuthConfigMapper.updateById((Object)commPurchaseAuthConfigPO);
        LambdaQueryWrapperX queryWrapperFile = new LambdaQueryWrapperX();
        queryWrapperFile.eq(CommPurchaseAuthConfigItemPO::getConfigId, (Object)reqBO.getId());
        queryWrapperFile.eq(CommPurchaseAuthConfigItemPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
        CommPurchaseAuthConfigItemPO itemPO = new CommPurchaseAuthConfigItemPO();
        itemPO.setDelFlag(DycProCommConstants.DelFlag.YES);
        this.commPurchaseAuthConfigItemMapper.update((Object)itemPO, (Wrapper)queryWrapperFile);
        List commPurchaseAuthConfigItemPOS = JSON.parseArray((String)JSON.toJSONString(reqBO.getCatalogList()), CommPurchaseAuthConfigItemPO.class);
        for (CommPurchaseAuthConfigItemPO commPurchaseAuthConfigItemPO : commPurchaseAuthConfigItemPOS) {
            Long itemId = Sequence.getInstance().nextId();
            commPurchaseAuthConfigItemPO.setItemId(itemId);
            commPurchaseAuthConfigItemPO.setConfigId(reqBO.getId());
            commPurchaseAuthConfigItemPO.setDelFlag(DycProCommConstants.DelFlag.NO);
        }
        this.commPurchaseAuthConfigItemMapper.insertBatch((Collection)commPurchaseAuthConfigItemPOS);
    }

    @Override
    public void deletePurchaseAuthConfig(DycProCommPurchaseAuthDTO reqBO) {
        LambdaQueryWrapperX queryWrapperPo = new LambdaQueryWrapperX();
        queryWrapperPo.eq(CommPurchaseAuthConfigPO::getId, (Object)reqBO.getId());
        queryWrapperPo.eq(CommPurchaseAuthConfigPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
        CommPurchaseAuthConfigPO configPO = new CommPurchaseAuthConfigPO();
        configPO.setDelFlag(DycProCommConstants.DelFlag.YES);
        this.commPurchaseAuthConfigMapper.update((Object)configPO, (Wrapper)queryWrapperPo);
        LambdaQueryWrapperX queryWrapperFile = new LambdaQueryWrapperX();
        queryWrapperFile.eq(CommPurchaseAuthConfigItemPO::getConfigId, (Object)reqBO.getId());
        queryWrapperFile.eq(CommPurchaseAuthConfigItemPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
        CommPurchaseAuthConfigItemPO itemPO = new CommPurchaseAuthConfigItemPO();
        itemPO.setDelFlag(DycProCommConstants.DelFlag.YES);
        this.commPurchaseAuthConfigItemMapper.update((Object)itemPO, (Wrapper)queryWrapperFile);
    }

    @Override
    public DycProCommPurchaseAuthInfoDTO qryPurchaseAuthCatalog(DycProCommPurchaseAuthDTO reqBO) {
        if (null == reqBO.getId() && StringUtils.isEmpty((CharSequence)reqBO.getOrgPath())) {
            throw new ZTBusinessException("\u5165\u53c2\u91c7\u4e70\u67e5\u8be2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBO.getId()) {
            DycProCommPurchaseAuthInfoDTO infoDTO = new DycProCommPurchaseAuthInfoDTO();
            LambdaQueryWrapperX queryItemWrapper = new LambdaQueryWrapperX();
            queryItemWrapper.eq(CommPurchaseAuthConfigItemPO::getConfigId, (Object)reqBO.getId());
            queryItemWrapper.eq(CommPurchaseAuthConfigItemPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
            List commPurchaseAuthConfigItemPOS = this.commPurchaseAuthConfigItemMapper.selectList((Wrapper)queryItemWrapper);
            List dycProCommPurchaseAuthCatalogDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commPurchaseAuthConfigItemPOS), DycProCommPurchaseAuthCatalogDTO.class);
            infoDTO.setCatalogList(dycProCommPurchaseAuthCatalogDTOS);
            return infoDTO;
        }
        CommPurchaseAuthConfigPO commPurchaseAuthConfigPO = (CommPurchaseAuthConfigPO)this.commPurchaseAuthConfigMapper.selectOne((Wrapper)new LambdaQueryWrapperX().eq(CommPurchaseAuthConfigPO::getOrgPath, (Object)reqBO.getOrgPath()).eq(CommPurchaseAuthConfigPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO));
        if (null != commPurchaseAuthConfigPO) {
            DycProCommPurchaseAuthInfoDTO infoDTO = new DycProCommPurchaseAuthInfoDTO();
            LambdaQueryWrapperX queryItemWrapper = new LambdaQueryWrapperX();
            queryItemWrapper.eq(CommPurchaseAuthConfigItemPO::getConfigId, (Object)commPurchaseAuthConfigPO.getId());
            queryItemWrapper.eq(CommPurchaseAuthConfigItemPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
            List commPurchaseAuthConfigItemPOS = this.commPurchaseAuthConfigItemMapper.selectList((Wrapper)queryItemWrapper);
            List dycProCommPurchaseAuthCatalogDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commPurchaseAuthConfigItemPOS), DycProCommPurchaseAuthCatalogDTO.class);
            infoDTO.setCatalogList(dycProCommPurchaseAuthCatalogDTOS);
            return infoDTO;
        }
        return null;
    }

    @Override
    public DycProCommPurchaseAuthInfoDTO qryPurchaseAuthCatalogAll(DycProCommPurchaseAuthInfoDTO dto) {
        DycProCommPurchaseAuthInfoDTO infoDTO = new DycProCommPurchaseAuthInfoDTO();
        LambdaQueryWrapperX queryItemWrapper = new LambdaQueryWrapperX();
        queryItemWrapper.eq(CommPurchaseAuthConfigPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
        queryItemWrapper.eq(CommPurchaseAuthConfigPO::getOrgPath, (Object)dto.getOrgPath());
        CommPurchaseAuthConfigPO commPurchaseAuthConfigPO = (CommPurchaseAuthConfigPO)this.commPurchaseAuthConfigMapper.selectOne((Wrapper)queryItemWrapper);
        if (null == commPurchaseAuthConfigPO) {
            int count;
            for (int i = count = dto.getOrgPath().split("-").length - 1; i > 0; --i) {
                String orgPath = DycProCommPurchaseAuthRepositoryImpl.truncateAfterNthDelimiter(dto.getOrgPath(), i, '-');
                LambdaQueryWrapperX queryItemWrappers = new LambdaQueryWrapperX();
                queryItemWrappers.eq(CommPurchaseAuthConfigPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
                queryItemWrappers.eq(CommPurchaseAuthConfigPO::getOrgPath, (Object)orgPath);
                CommPurchaseAuthConfigPO commPurchaseAuthConfigPONew = (CommPurchaseAuthConfigPO)this.commPurchaseAuthConfigMapper.selectOne((Wrapper)queryItemWrappers);
                if (null == commPurchaseAuthConfigPONew) continue;
                LambdaQueryWrapperX queryItemWrapper2 = new LambdaQueryWrapperX();
                queryItemWrapper2.eq(CommPurchaseAuthConfigItemPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
                queryItemWrapper2.eq(CommPurchaseAuthConfigItemPO::getConfigId, (Object)commPurchaseAuthConfigPONew.getId());
                List commPurchaseAuthConfigItemPOS = this.commPurchaseAuthConfigItemMapper.selectList((Wrapper)queryItemWrapper2);
                if (!CollectionUtils.isEmpty((Collection)commPurchaseAuthConfigItemPOS)) {
                    infoDTO.setOrgPath(commPurchaseAuthConfigPONew.getOrgPath());
                    List dycProCommPurchaseAuthCatalogDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commPurchaseAuthConfigItemPOS), DycProCommPurchaseAuthCatalogDTO.class);
                    infoDTO.setCatalogList(dycProCommPurchaseAuthCatalogDTOS);
                }
                return infoDTO;
            }
        } else {
            LambdaQueryWrapperX queryItemWrapper2 = new LambdaQueryWrapperX();
            queryItemWrapper2.eq(CommPurchaseAuthConfigItemPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO);
            queryItemWrapper2.eq(CommPurchaseAuthConfigItemPO::getConfigId, (Object)commPurchaseAuthConfigPO.getId());
            List commPurchaseAuthConfigItemPOS = this.commPurchaseAuthConfigItemMapper.selectList((Wrapper)queryItemWrapper2);
            if (!CollectionUtils.isEmpty((Collection)commPurchaseAuthConfigItemPOS)) {
                infoDTO.setOrgPath(commPurchaseAuthConfigPO.getOrgPath());
                List dycProCommPurchaseAuthCatalogDTOS = JSON.parseArray((String)JSON.toJSONString((Object)commPurchaseAuthConfigItemPOS), DycProCommPurchaseAuthCatalogDTO.class);
                infoDTO.setCatalogList(dycProCommPurchaseAuthCatalogDTOS);
            }
        }
        return infoDTO;
    }

    public static String truncateAfterNthDelimiter(String input, int n, char delimiter) {
        int index;
        if (input == null || n <= 0) {
            return input;
        }
        int delimiterCount = 0;
        char[] chars = input.toCharArray();
        for (index = 0; index < chars.length && (chars[index] != delimiter || ++delimiterCount != n); ++index) {
        }
        return index < chars.length ? input.substring(0, index) : input;
    }
}

