/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.sync.upc.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlAddBatchReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddBatchRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsindexMappingUpcBO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuQryDTO;
import com.tydic.dyc.pro.dmc.repository.upc.api.DycProCommUpcRepository;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcInfoDTO;
import com.tydic.dyc.pro.dmc.sync.upc.api.DycProCommSyncExtUpcInfoService;
import com.tydic.dyc.pro.dmc.sync.upc.bo.DycProCommSyncExtUpcInfoReqBO;
import com.tydic.dyc.pro.dmc.sync.upc.bo.DycProCommSyncExtUpcInfoRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.sync.upc.api.DycProCommSyncExtUpcInfoService"})
public class DycProCommSyncExtUpcInfoServiceImpl
implements DycProCommSyncExtUpcInfoService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommSyncExtUpcInfoServiceImpl.class);
    @Autowired
    private DycProCommUpcRepository dycProCommUpcRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private NosqlClient nosqlClient;
    @Value(value="${upc.es.index:dyc_pro_upc}")
    private String upcIndexName;

    @Override
    @PostMapping(value={"syncExtUpcInfo"})
    public DycProCommSyncExtUpcInfoRspBO syncExtUpcInfo(@RequestBody DycProCommSyncExtUpcInfoReqBO reqBO) {
        if (reqBO.getSyncEsSwitch().booleanValue()) {
            return this.fullSynchronization();
        }
        Long upcId = null;
        this.paramVerify(reqBO);
        DycProCommUpcInfoDTO queryUpcInfoDto = new DycProCommUpcInfoDTO();
        queryUpcInfoDto.setExtUpcId(reqBO.getExtUpcId());
        DycProCommUpcInfoDTO queryUpcInfoResultDto = this.dycProCommUpcRepository.getUpcMainInfoOneByCondition(queryUpcInfoDto);
        if (null == queryUpcInfoResultDto) {
            DycProCommUpcInfoDTO addUpcInfoDto = (DycProCommUpcInfoDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), DycProCommUpcInfoDTO.class);
            upcId = this.dycProCommUpcRepository.addUpcAllInfo(addUpcInfoDto);
        } else {
            upcId = queryUpcInfoResultDto.getUpcId();
        }
        if (reqBO.getSkuId() != null) {
            DycProCommSkuHandleDTO skuHandleDto = new DycProCommSkuHandleDTO();
            skuHandleDto.setSkuId(reqBO.getSkuId());
            skuHandleDto.setUpcId(upcId);
            DycProCommUpcInfoDTO upcInfo = new DycProCommUpcInfoDTO();
            BeanUtils.copyProperties((Object)reqBO, (Object)upcInfo);
            upcInfo.setUpcId(upcId);
            upcInfo.setCreateTime(new Date());
            skuHandleDto.setUpcInfo(upcInfo);
            this.dycProCommSkuRepository.updateSkuUpcInfoBySkuIdAndSyncNosql(skuHandleDto);
        }
        DycProCommUpcInfoDTO dto = this.dycProCommUpcRepository.getUpcMainInfoOneByCondition(queryUpcInfoDto);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(upcId));
        DycProEsindexMappingUpcBO syncSpuEsBo = new DycProEsindexMappingUpcBO();
        DycProCommSkuQryDTO dycProCommSkuQryDTO = new DycProCommSkuQryDTO();
        dycProCommSkuQryDTO.setUpcId(upcId);
        List dycProCommSkuHandleDTOS = this.dycProCommSkuRepository.qrySkuList(dycProCommSkuQryDTO);
        if (dycProCommSkuHandleDTOS != null && !dycProCommSkuHandleDTOS.isEmpty()) {
            Set supIds = dycProCommSkuHandleDTOS.stream().map(DycProCommSkuDTO::getSupplierId).filter(Objects::nonNull).collect(Collectors.toSet());
            syncSpuEsBo.setSupplierIdList(new ArrayList(supIds));
            syncSpuEsBo.setSkuNum(Integer.valueOf(dycProCommSkuHandleDTOS.size()));
        }
        BeanUtils.copyProperties((Object)dto, (Object)syncSpuEsBo);
        nosqlBO.setObject((Object)syncSpuEsBo);
        if (null == queryUpcInfoResultDto) {
            NosqlAddSingleReqBO nosqlAddSingleReqBO = new NosqlAddSingleReqBO();
            nosqlAddSingleReqBO.setIndex(this.upcIndexName);
            nosqlAddSingleReqBO.setNosqlBO(nosqlBO);
            NosqlAddSingleRsqBO nosqlAddSingleRsqBO = this.nosqlClient.addSingle(nosqlAddSingleReqBO);
            if (!"0000".equals(nosqlAddSingleRsqBO.getRespCode())) {
                throw new ZTBusinessException("sku\u6807\u51c6\u5546\u54c1\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddSingleRsqBO.getRespDesc());
            }
        } else {
            NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
            nosqlUpdateSingleReqBO.setIndex(this.upcIndexName);
            nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
            NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
            if (!"0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) {
                throw new ZTBusinessException("sku\u6807\u51c6\u5546\u54c1\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
            }
        }
        return new DycProCommSyncExtUpcInfoRspBO();
    }

    private DycProCommSyncExtUpcInfoRspBO fullSynchronization() {
        DycProCommUpcInfoDTO queryUpcInfoDto = new DycProCommUpcInfoDTO();
        List dycProCommUpcInfoDTOS = this.dycProCommUpcRepository.qryUpcInfoAll(queryUpcInfoDto);
        if (dycProCommUpcInfoDTOS != null && !dycProCommUpcInfoDTOS.isEmpty()) {
            List collect = dycProCommUpcInfoDTOS.stream().map(DycProCommUpcInfoDTO::getUpcId).collect(Collectors.toList());
            DycProCommSkuQryDTO dto = new DycProCommSkuQryDTO();
            dto.setUpcIds(collect);
            List dycProCommSkuHandleDTOS = this.dycProCommSkuRepository.qrySkuList(dto);
            Map<Long, Long> upcCountMap = dycProCommSkuHandleDTOS.stream().collect(Collectors.groupingBy(DycProCommSkuDTO::getUpcId, Collectors.counting()));
            Map upcSupIdMap = dycProCommSkuHandleDTOS.stream().collect(Collectors.groupingBy(DycProCommSkuDTO::getUpcId, Collectors.mapping(DycProCommSkuDTO::getSupplierId, Collectors.toSet())));
            NosqlAddBatchReqBO nosqlAddBatchReqBO = new NosqlAddBatchReqBO();
            nosqlAddBatchReqBO.setIndex(this.upcIndexName);
            ArrayList<NosqlBO> nosqlBOList = new ArrayList<NosqlBO>();
            for (DycProCommUpcInfoDTO dycProCommUpcInfoDTO : dycProCommUpcInfoDTOS) {
                NosqlBO nosqlBO = new NosqlBO();
                nosqlBO.setId(String.valueOf(dycProCommUpcInfoDTO.getUpcId()));
                DycProEsindexMappingUpcBO syncSpuEsBo = new DycProEsindexMappingUpcBO();
                BeanUtils.copyProperties((Object)dycProCommUpcInfoDTO, (Object)syncSpuEsBo);
                syncSpuEsBo.setSkuNum(Integer.valueOf(Math.toIntExact(upcCountMap.getOrDefault(dycProCommUpcInfoDTO.getUpcId(), 0L))));
                Set supIds = upcSupIdMap.get(dycProCommUpcInfoDTO.getUpcId());
                syncSpuEsBo.setSupplierIdList((List)(supIds != null ? new ArrayList(supIds) : null));
                if (StringUtils.isNotBlank((String)syncSpuEsBo.getManageCatalogPath())) {
                    String[] split = syncSpuEsBo.getManageCatalogPath().split("-");
                    ArrayList<Long> manageCatalogIdList = new ArrayList<Long>();
                    for (String s : split) {
                        String trimmed;
                        if (s == null || (trimmed = s.trim()).isEmpty()) continue;
                        try {
                            manageCatalogIdList.add(Long.valueOf(trimmed));
                        }
                        catch (NumberFormatException e) {
                            throw new ZTBusinessException("sku\u6807\u51c6\u5546\u54c1\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38: \u975e\u6570\u5b57\u5b57\u7b26\u4e32:" + s);
                        }
                    }
                    syncSpuEsBo.setManageCatalogIdList(manageCatalogIdList);
                }
                nosqlBO.setObject((Object)syncSpuEsBo);
                nosqlBOList.add(nosqlBO);
            }
            nosqlAddBatchReqBO.setNosqlBOList(nosqlBOList);
            NosqlAddBatchRsqBO nosqlAddBatchRsqBO = this.nosqlClient.addBatch(nosqlAddBatchReqBO);
            if (!"0000".equals(nosqlAddBatchRsqBO.getRespCode())) {
                throw new ZTBusinessException("sku\u6807\u51c6\u5546\u54c1\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddBatchRsqBO.getRespDesc());
            }
        }
        return new DycProCommSyncExtUpcInfoRspBO();
    }

    private void paramVerify(DycProCommSyncExtUpcInfoReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getExtUpcId())) {
            throw new ZTBusinessException("\u5916\u90e8\u6807\u51c6\u5546\u54c1id[extUpcId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getUpcCode())) {
            throw new ZTBusinessException("\u6807\u51c6\u5546\u54c1\u7f16\u7801[upcCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getUpcName())) {
            throw new ZTBusinessException("\u6807\u51c6\u5546\u54c1\u540d\u79f0[upcName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

