/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.pro.base.core.contentreview.api.DycProContentReviewAliyunImageScanService;
import com.tydic.dyc.pro.base.core.contentreview.api.DycProContentReviewAliyunTextScanService;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanReqBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanResultItemBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanRspBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanSubResultBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewImageScanTaskBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewTextScanReqBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewTextScanRspBO;
import com.tydic.dyc.pro.base.core.contentreview.bo.DycProContentReviewTextScanSubResultBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckItemCheckIndexEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckResultEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.AgrItemMapper;
import com.tydic.dyc.pro.dmc.dao.CommUpcInfoMapper;
import com.tydic.dyc.pro.dmc.po.CommUpcInfoPO;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRecordRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckObjCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordItemDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommPriceCheckRuleParamQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommPriceCheckRuleVerifyValueDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuQryDTO;
import com.tydic.dyc.pro.dmc.service.api.DycProCommExecCheckRuleForConsumerService;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommCheckRecordForConsumerBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommExecCheckRuleForConsumerReqBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommExecCheckRuleForConsumerRspBO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycProCommExecCheckRuleForConsumerServiceImpl
implements DycProCommExecCheckRuleForConsumerService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommExecCheckRuleForConsumerServiceImpl.class);
    @Autowired
    private DycProCommCheckRecordRepository dycProCommCheckRecordRepository;
    @Autowired
    private DycProContentReviewAliyunImageScanService dycProContentReviewAliyunImageScanService;
    @Autowired
    private DycProContentReviewAliyunTextScanService dycProContentReviewAliyunTextScanService;
    @Autowired
    private DycProCommCheckRuleInfoRepository dycProCommCheckRuleInfoRepository;
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private AgrItemMapper agrItemMapper;
    @Autowired
    private CommUpcInfoMapper commUpcInfoMapper;

    @Override
    public DycProCommExecCheckRuleForConsumerRspBO dealCheckRuleExec(DycProCommExecCheckRuleForConsumerReqBO reqBO) {
        DycProCommExecCheckRuleForConsumerRspBO rspBO = new DycProCommExecCheckRuleForConsumerRspBO();
        log.info("\u5f00\u59cb\u6267\u884c\u68c0\u6d4b{}_{}", (Object)reqBO.getCheckRecordForConsumerBO().getCheckRecordId(), (Object)reqBO.getCheckRecordForConsumerBO().getCheckSnId());
        List<DycProCommCheckRecordItemDTO> checkRecordItemDTOs = null;
        DycProCommCheckRuleInfoDTO qryCheckRuleInfoDTO = new DycProCommCheckRuleInfoDTO();
        qryCheckRuleInfoDTO.setCheckRuleId(reqBO.getCheckRecordForConsumerBO().getCheckRuleId());
        DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO = this.dycProCommCheckRuleInfoRepository.queryCheckRuleInfoMain(qryCheckRuleInfoDTO);
        if (dycProCommCheckRuleInfoDTO.getCheckRuleType().equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()))) {
            log.info("\u5f00\u59cb\u6267\u884c\u4ef7\u683c\u68c0\u6d4b{}_{}", (Object)reqBO.getCheckRecordForConsumerBO().getCheckSnId(), (Object)reqBO.getCheckRecordForConsumerBO().getCheckRecordId());
            checkRecordItemDTOs = this.execPriceCheck(reqBO, dycProCommCheckRuleInfoDTO);
            log.info("\u4ef7\u683c\u68c0\u6d4b\u7ed3\u675f{}_{}", (Object)reqBO.getCheckRecordForConsumerBO().getCheckSnId(), (Object)reqBO.getCheckRecordForConsumerBO().getCheckRecordId());
        } else {
            log.info("\u5f00\u59cb\u6267\u884c\u56fe\u6587\u68c0\u6d4b{}_{}", (Object)reqBO.getCheckRecordForConsumerBO().getCheckSnId(), (Object)reqBO.getCheckRecordForConsumerBO().getCheckRecordId());
            checkRecordItemDTOs = this.execImageOrTextCheck(reqBO);
            log.info("\u56fe\u6587\u68c0\u6d4b\u7ed3\u675f{}_{}", (Object)reqBO.getCheckRecordForConsumerBO().getCheckSnId(), (Object)reqBO.getCheckRecordForConsumerBO().getCheckRecordId());
        }
        DycProCommCheckRuleInfoDTO finalCheckRuleInfoDTO = this.updateCheckResultAndGetCheckAction(checkRecordItemDTOs, dycProCommCheckRuleInfoDTO, reqBO);
        rspBO.setSkuId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
        rspBO.setSendNoticeFlag(0);
        if (finalCheckRuleInfoDTO != null && !reqBO.getCheckRecordForConsumerBO().getCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()))) {
            rspBO.setSendNoticeFlag(finalCheckRuleInfoDTO.getSendNoticeFlag());
            rspBO.setExecActionCode(reqBO.getCheckRecordForConsumerBO().getCheckExecActionCode());
        }
        return rspBO;
    }

    private DycProCommCheckRuleInfoDTO updateCheckResultAndGetCheckAction(List<DycProCommCheckRecordItemDTO> checkRecordItemDTOs, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO, DycProCommExecCheckRuleForConsumerReqBO reqBO) {
        DycProCommCheckRecordForConsumerBO checkRecordForConsumerBO = reqBO.getCheckRecordForConsumerBO();
        HashSet<String> verificationIndexNames = new HashSet<String>();
        int errorCont = 0;
        boolean isConfirmErrorFlag = false;
        for (DycProCommCheckRecordItemDTO dycProCommCheckRecordItemDTO : checkRecordItemDTOs) {
            if (dycProCommCheckRecordItemDTO.getCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()))) continue;
            ++errorCont;
            verificationIndexNames.add(dycProCommCheckRecordItemDTO.getVerificationIndexName());
            if (!dycProCommCheckRecordItemDTO.getCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode()))) continue;
            isConfirmErrorFlag = true;
        }
        if (dycProCommCheckRuleInfoDTO.getCheckRuleType().equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()))) {
            if (errorCont == checkRecordItemDTOs.size()) {
                if (isConfirmErrorFlag) {
                    checkRecordForConsumerBO.setCheckResult(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode()));
                } else {
                    checkRecordForConsumerBO.setCheckResult(Integer.parseInt(DmcCommCheckResultEnum.SUSPECT.getCode()));
                }
            } else {
                checkRecordForConsumerBO.setCheckResult(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()));
            }
        } else {
            if (errorCont > 0) {
                if (isConfirmErrorFlag) {
                    checkRecordForConsumerBO.setCheckResult(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode()));
                } else {
                    checkRecordForConsumerBO.setCheckResult(Integer.parseInt(DmcCommCheckResultEnum.SUSPECT.getCode()));
                }
            } else {
                checkRecordForConsumerBO.setCheckResult(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()));
            }
            if (!dycProCommCheckRuleInfoDTO.getCheckResultCode().equals(checkRecordForConsumerBO.getCheckResult().toString()) && checkRecordForConsumerBO.getCheckRuleIds().size() > 1) {
                Long checkRuleId = checkRecordForConsumerBO.getCheckRuleIds().get(0);
                if (checkRuleId.equals(checkRecordForConsumerBO.getCheckRuleId())) {
                    checkRuleId = checkRecordForConsumerBO.getCheckRuleIds().get(1);
                }
                DycProCommCheckRuleInfoDTO qryCheckRuleInfoDTO = new DycProCommCheckRuleInfoDTO();
                qryCheckRuleInfoDTO.setCheckRuleId(checkRuleId);
                DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO1 = this.dycProCommCheckRuleInfoRepository.queryCheckRuleInfoMain(qryCheckRuleInfoDTO);
                dycProCommCheckRuleInfoDTO = dycProCommCheckRuleInfoDTO1 != null && dycProCommCheckRuleInfoDTO1.getCheckResultCode().equals(checkRecordForConsumerBO.getCheckResult().toString()) ? dycProCommCheckRuleInfoDTO1 : null;
            }
        }
        DycProCommCheckRecordDTO dycProCommCheckRecordDTO = new DycProCommCheckRecordDTO();
        if (dycProCommCheckRuleInfoDTO != null && !checkRecordForConsumerBO.getCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()))) {
            dycProCommCheckRecordDTO = (DycProCommCheckRecordDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommCheckRuleInfoDTO), DycProCommCheckRecordDTO.class);
            checkRecordForConsumerBO.setVerificationIndexNameList(((Object)verificationIndexNames).toString().replace("[", "").replace("]", ""));
            checkRecordForConsumerBO.setCheckExecActionCode(dycProCommCheckRuleInfoDTO.getCheckExecActionCode());
        }
        dycProCommCheckRecordDTO.setCheckRecordId(checkRecordForConsumerBO.getCheckRecordId());
        dycProCommCheckRecordDTO.setCheckResult(checkRecordForConsumerBO.getCheckResult());
        dycProCommCheckRecordDTO.setCheckExecActionCode(checkRecordForConsumerBO.getCheckExecActionCode());
        dycProCommCheckRecordDTO.setCheckStatus(DycProCommConstants.checkRuleCheckStatus.FINISH);
        this.dycProCommCheckRecordRepository.updateCheckRecordById(dycProCommCheckRecordDTO);
        this.dycProCommCheckRecordRepository.deleteCheckRecordItemAndAdd(checkRecordItemDTOs);
        DycProCommCheckObjCheckRecordDTO dycProCommCheckObjCheckRecordDTO = new DycProCommCheckObjCheckRecordDTO();
        dycProCommCheckObjCheckRecordDTO.setCheckSnId(checkRecordForConsumerBO.getCheckSnId());
        this.dycProCommCheckRecordRepository.updateCheckObjCheckRecordCheckRuleNum(dycProCommCheckObjCheckRecordDTO);
        return dycProCommCheckRuleInfoDTO;
    }

    private List<DycProCommCheckRecordItemDTO> execPriceCheck(DycProCommExecCheckRuleForConsumerReqBO reqBO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        ArrayList<DycProCommCheckRecordItemDTO> checkRecordItemDTOs = new ArrayList<DycProCommCheckRecordItemDTO>();
        DycProCommCheckRecordForConsumerBO checkRecordForConsumerBO = reqBO.getCheckRecordForConsumerBO();
        DycProCommSkuQryDTO dycProCommSkuReqDTO = new DycProCommSkuQryDTO();
        dycProCommSkuReqDTO.setSkuId(checkRecordForConsumerBO.getCheckObjId());
        DycProCommSkuDTO dycProCommSkuDTO = this.dycProCommSkuRepository.getSkuMainAndManageCatalog(dycProCommSkuReqDTO);
        DycProCommSkuPriceInfoQryDTO skuPriceInfoQryDTO = new DycProCommSkuPriceInfoQryDTO();
        skuPriceInfoQryDTO.setSkuId(checkRecordForConsumerBO.getCheckObjId());
        DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO = this.dycProCommPriceRuleInfoRepository.getSkuPriceInfo(skuPriceInfoQryDTO);
        DycProCommPriceCheckRuleParamQryDTO priceCheckRuleParamQryDTO2 = new DycProCommPriceCheckRuleParamQryDTO();
        priceCheckRuleParamQryDTO2.setAgrId(dycProCommSkuDTO.getAgrId());
        priceCheckRuleParamQryDTO2.setCatalogId(dycProCommSkuDTO.getManageCatalogId());
        DycProCommPriceCheckRuleVerifyValueDTO dycProCommPriceCheckRuleVerifyValueDTO = this.dycProCommCheckRecordRepository.queryAgrDiscountRate(priceCheckRuleParamQryDTO2);
        checkRecordForConsumerBO.getCheckRecordItemDTOList().forEach(checkRecordItemBO -> {
            String switchKey = checkRecordItemBO.getCheckIndexCode() + "_" + checkRecordItemBO.getVerificationIndexCode();
            DycProCommCheckRecordItemDTO checkRecordItemDTO = (DycProCommCheckRecordItemDTO)JSON.parseObject((String)JSON.toJSONString((Object)checkRecordItemBO), DycProCommCheckRecordItemDTO.class);
            checkRecordItemDTOs.add(checkRecordItemDTO);
            switch (switchKey) {
                case "1_1": {
                    this.checkSupplierPriceDiscountRate(dycProCommPriceCheckRuleVerifyValueDTO, checkRecordItemDTO, dycProCommSkuPriceInfoDTO, dycProCommCheckRuleInfoDTO);
                    break;
                }
                case "1_2": {
                    this.checkSupplierPriceSingleChangRate(checkRecordItemDTO, dycProCommSkuPriceInfoDTO, dycProCommCheckRuleInfoDTO);
                    break;
                }
                case "1_3": {
                    DycProCommPriceCheckRuleParamQryDTO priceCheckRuleParamQryDTO = new DycProCommPriceCheckRuleParamQryDTO();
                    priceCheckRuleParamQryDTO.setSkuId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
                    this.getCycleTime("month", 3, priceCheckRuleParamQryDTO);
                    this.checkSupplierPriceCycleChangRate(priceCheckRuleParamQryDTO, checkRecordItemDTO, dycProCommSkuPriceInfoDTO, dycProCommCheckRuleInfoDTO);
                    break;
                }
                case "1_4": {
                    DycProCommPriceCheckRuleParamQryDTO priceCheckRuleParamQryDTO1 = new DycProCommPriceCheckRuleParamQryDTO();
                    priceCheckRuleParamQryDTO1.setSkuId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
                    this.getCycleTime("week", 1, priceCheckRuleParamQryDTO1);
                    this.checkSupplierPriceCycleChangNum(dycProCommSkuPriceInfoDTO, "\u6bcf\u5468\u4ec5\u5141\u8bb8\u53d8\u4ef72\u6b21", 2, priceCheckRuleParamQryDTO1, checkRecordItemDTO, dycProCommCheckRuleInfoDTO);
                    break;
                }
                case "1_5": {
                    this.checkSupplierPriceFixedPrice(checkRecordItemDTO, dycProCommSkuDTO, dycProCommSkuPriceInfoDTO, dycProCommCheckRuleInfoDTO);
                    break;
                }
                case "1_6": {
                    this.checkSupplierPriceReferPrice(checkRecordItemDTO, dycProCommSkuDTO, dycProCommSkuPriceInfoDTO, dycProCommCheckRuleInfoDTO);
                    break;
                }
                case "1_7": {
                    this.checkVisitorPrice(dycProCommPriceCheckRuleVerifyValueDTO, checkRecordItemDTO, dycProCommSkuPriceInfoDTO, dycProCommCheckRuleInfoDTO);
                    break;
                }
                case "1_8": {
                    this.jdPriceDiscountRate(dycProCommPriceCheckRuleVerifyValueDTO, checkRecordItemDTO, dycProCommSkuPriceInfoDTO, dycProCommCheckRuleInfoDTO);
                    break;
                }
                case "1_9": {
                    this.checkReferPrice(checkRecordItemDTO, dycProCommSkuDTO, dycProCommSkuPriceInfoDTO, dycProCommCheckRuleInfoDTO);
                }
            }
        });
        return checkRecordItemDTOs;
    }

    private void jdPriceDiscountRate(DycProCommPriceCheckRuleVerifyValueDTO dycProCommPriceCheckRuleVerifyValueDTO, DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        if (dycProCommSkuPriceInfoDTO.getJdPrice() != null && dycProCommPriceCheckRuleVerifyValueDTO.getJdDiscountRate() != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("currentValue", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
            jsonObject.put("config", (Object)checkRecordItemDTO.getCheckItemContent());
            String config = checkRecordItemDTO.getCheckItemContent();
            JSONObject jsonObjectResult = new JSONObject();
            jsonObjectResult.put("referValue", null);
            jsonObjectResult.put("config", (Object)config.replace("confVale", "\u6d6e\u52a8\u7387"));
            jsonObjectResult.put("result", (Object)"0%");
            jsonObjectResult.put("supplierPrice", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
            jsonObjectResult.put("marketPrice", (Object)dycProCommSkuPriceInfoDTO.getMarketPrice());
            jsonObjectResult.put("salePrice", (Object)dycProCommSkuPriceInfoDTO.getSalePrice());
            if (config.contains("%confVale%")) {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            } else {
                BigDecimal discountRate = dycProCommSkuPriceInfoDTO.getSupplierPrice().divide(dycProCommSkuPriceInfoDTO.getJdPrice(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                BigDecimal changRate = discountRate.subtract(dycProCommPriceCheckRuleVerifyValueDTO.getJdDiscountRate()).divide(dycProCommPriceCheckRuleVerifyValueDTO.getJdDiscountRate(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                String changRateStr = this.deleteZero(changRate.toString());
                String replaceStr = changRateStr + "&&" + changRateStr;
                SpelExpressionParser parser = new SpelExpressionParser();
                String expressStr = config.replace("%", "").replace("confVale", replaceStr);
                Expression expression = parser.parseExpression(expressStr);
                if (Boolean.FALSE.equals(expression.getValue(Boolean.class))) {
                    checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                    jsonObjectResult.put("exceptionActionName", (Object)DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRuleInfoDTO.getCheckExecActionCode()));
                } else {
                    checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
                }
                jsonObjectResult.put("referValue", (Object)dycProCommPriceCheckRuleVerifyValueDTO.getAgrDiscountRate());
                jsonObjectResult.put("result", (Object)(changRateStr + "%"));
                if (changRate.compareTo(new BigDecimal(0)) > 0) {
                    jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "up"));
                } else {
                    jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "down"));
                }
            }
            checkRecordItemDTO.setCheckResultJson(jsonObjectResult.toJSONString());
            checkRecordItemDTO.setCheckContent(jsonObject.toJSONString());
        } else {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        }
    }

    private void checkSupplierPriceReferPrice(DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommSkuDTO dycProCommSkuDTO, DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
    }

    private void checkVisitorPrice(DycProCommPriceCheckRuleVerifyValueDTO dycProCommPriceCheckRuleVerifyValueDTO, DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        if (dycProCommSkuPriceInfoDTO.getVisitorPrice() != null && dycProCommPriceCheckRuleVerifyValueDTO.getSaleDiscountRate() != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("currentValue", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
            jsonObject.put("config", (Object)checkRecordItemDTO.getCheckItemContent());
            String config = checkRecordItemDTO.getCheckItemContent();
            JSONObject jsonObjectResult = new JSONObject();
            jsonObjectResult.put("referValue", null);
            jsonObjectResult.put("config", (Object)config.replace("confVale", "\u6d6e\u52a8\u7387"));
            jsonObjectResult.put("result", (Object)"0%");
            jsonObjectResult.put("supplierPrice", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
            jsonObjectResult.put("marketPrice", (Object)dycProCommSkuPriceInfoDTO.getMarketPrice());
            jsonObjectResult.put("salePrice", (Object)dycProCommSkuPriceInfoDTO.getSalePrice());
            if (config.contains("%confVale%")) {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            } else {
                BigDecimal discountRate = dycProCommSkuPriceInfoDTO.getSupplierPrice().divide(dycProCommSkuPriceInfoDTO.getVisitorPrice(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                BigDecimal changRate = discountRate.subtract(dycProCommPriceCheckRuleVerifyValueDTO.getSaleDiscountRate()).divide(dycProCommPriceCheckRuleVerifyValueDTO.getSaleDiscountRate(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                String changRateStr = this.deleteZero(changRate.toString());
                String replaceStr = changRateStr + "&&" + changRateStr;
                SpelExpressionParser parser = new SpelExpressionParser();
                String expressStr = config.replace("%", "").replace("confVale", replaceStr);
                Expression expression = parser.parseExpression(expressStr);
                if (Boolean.FALSE.equals(expression.getValue(Boolean.class))) {
                    checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                    jsonObjectResult.put("exceptionActionName", (Object)DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRuleInfoDTO.getCheckExecActionCode()));
                } else {
                    checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
                }
                jsonObjectResult.put("referValue", (Object)dycProCommPriceCheckRuleVerifyValueDTO.getAgrDiscountRate());
                jsonObjectResult.put("result", (Object)(changRateStr + "%"));
                if (changRate.compareTo(new BigDecimal(0)) > 0) {
                    jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "up"));
                } else {
                    jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "down"));
                }
            }
            checkRecordItemDTO.setCheckResultJson(jsonObjectResult.toJSONString());
            checkRecordItemDTO.setCheckContent(jsonObject.toJSONString());
        } else {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        }
    }

    private void checkReferPrice(DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommSkuDTO dycProCommSkuDTO, DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        CommUpcInfoPO commUpcInfoPO;
        checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        if (dycProCommSkuDTO.getUpcId() != null && (commUpcInfoPO = (CommUpcInfoPO)this.commUpcInfoMapper.selectById((Serializable)dycProCommSkuDTO.getUpcId())) != null && commUpcInfoPO.getReferencePrice() != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("currentValue", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
            jsonObject.put("config", (Object)checkRecordItemDTO.getCheckItemContent());
            String config = checkRecordItemDTO.getCheckItemContent();
            JSONObject jsonObjectResult = new JSONObject();
            jsonObjectResult.put("referValue", null);
            jsonObjectResult.put("config", (Object)config.replace("confVale", "\u6d6e\u52a8\u7387"));
            jsonObjectResult.put("result", (Object)"0%");
            jsonObjectResult.put("supplierPrice", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
            jsonObjectResult.put("marketPrice", (Object)dycProCommSkuPriceInfoDTO.getMarketPrice());
            jsonObjectResult.put("salePrice", (Object)dycProCommSkuPriceInfoDTO.getSalePrice());
            if (config.contains("%confVale%")) {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            } else {
                BigDecimal changRate = dycProCommSkuPriceInfoDTO.getSupplierPrice().subtract(commUpcInfoPO.getReferencePrice()).divide(commUpcInfoPO.getReferencePrice(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                String changRateStr = this.deleteZero(changRate.toString());
                String replaceStr = changRateStr + "&&" + changRateStr;
                SpelExpressionParser parser = new SpelExpressionParser();
                String expressStr = config.replace("%", "").replace("confVale", replaceStr);
                Expression expression = parser.parseExpression(expressStr);
                if (Boolean.FALSE.equals(expression.getValue(Boolean.class))) {
                    checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                    jsonObjectResult.put("exceptionActionName", (Object)DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRuleInfoDTO.getCheckExecActionCode()));
                } else {
                    checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
                }
                jsonObjectResult.put("referValue", (Object)commUpcInfoPO.getReferencePrice());
                jsonObjectResult.put("result", (Object)(changRateStr + "%"));
                if (changRate.compareTo(new BigDecimal(0)) > 0) {
                    jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "up"));
                } else {
                    jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "down"));
                }
            }
            checkRecordItemDTO.setCheckResultJson(jsonObjectResult.toJSONString());
            checkRecordItemDTO.setCheckContent(jsonObject.toJSONString());
        }
    }

    private void checkSupplierPriceFixedPrice(DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommSkuDTO dycProCommSkuDTO, DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        if (DmcAgrMainAgrType.DSXY.getCode().equals(dycProCommSkuDTO.getAgrType().toString())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("currentValue", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
            jsonObject.put("config", (Object)checkRecordItemDTO.getCheckItemContent());
            String config = checkRecordItemDTO.getCheckItemContent();
            JSONObject jsonObjectResult = new JSONObject();
            jsonObjectResult.put("referValue", null);
            jsonObjectResult.put("config", (Object)config.replace("confVale", "\u6d6e\u52a8\u7387"));
            jsonObjectResult.put("result", (Object)"0%");
            jsonObjectResult.put("supplierPrice", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
            jsonObjectResult.put("marketPrice", (Object)dycProCommSkuPriceInfoDTO.getMarketPrice());
            jsonObjectResult.put("salePrice", (Object)dycProCommSkuPriceInfoDTO.getSalePrice());
            if (config.contains("%confVale%")) {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            } else {
                BigDecimal changRate = dycProCommSkuPriceInfoDTO.getSupplierPrice().subtract(dycProCommSkuPriceInfoDTO.getFixedPrice()).divide(dycProCommSkuPriceInfoDTO.getFixedPrice(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                String changRateStr = this.deleteZero(changRate.toString());
                String replaceStr = changRateStr + "&&" + changRateStr;
                SpelExpressionParser parser = new SpelExpressionParser();
                String expressStr = config.replace("%", "").replace("confVale", replaceStr);
                Expression expression = parser.parseExpression(expressStr);
                if (Boolean.FALSE.equals(expression.getValue(Boolean.class))) {
                    checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                    jsonObjectResult.put("exceptionActionName", (Object)DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRuleInfoDTO.getCheckExecActionCode()));
                } else {
                    checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
                }
                jsonObjectResult.put("referValue", (Object)dycProCommSkuPriceInfoDTO.getFixedPrice());
                jsonObjectResult.put("result", (Object)(changRateStr + "%"));
                if (changRate.compareTo(new BigDecimal(0)) > 0) {
                    jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "up"));
                } else {
                    jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "down"));
                }
            }
            checkRecordItemDTO.setCheckResultJson(jsonObjectResult.toJSONString());
            checkRecordItemDTO.setCheckContent(jsonObject.toJSONString());
        }
    }

    private List<DycProCommCheckRecordItemDTO> execImageOrTextCheck(DycProCommExecCheckRuleForConsumerReqBO reqBO) {
        DycProCommSkuDTO dycProCommSkuReqDTO = new DycProCommSkuDTO();
        dycProCommSkuReqDTO.setSkuId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
        DycProCommSkuDTO dycProCommSkuDTO = this.dycProCommSkuRepository.getSkuMainInfoByCondition(dycProCommSkuReqDTO);
        Date execTime = new Date();
        ArrayList<DycProCommCheckRecordItemDTO> recordItemDTOS = new ArrayList<DycProCommCheckRecordItemDTO>();
        DycProCommCheckRecordForConsumerBO checkRecordForConsumerBO = reqBO.getCheckRecordForConsumerBO();
        String checkText = dycProCommSkuDTO.getSkuName();
        if (StringUtils.hasText((String)checkText)) {
            ArrayList<String> labels = new ArrayList<String>(Arrays.asList("spam", "politics", "abuse", "terrorism", "porn", "contraband", "ad"));
            List<String> labelNames = Arrays.asList("\u6587\u5b57\u6d89\u5783\u573e\u4fe1\u606f", "\u6587\u5b57\u6d89\u654f\u611f\u8bcd", "\u6587\u5b57\u6d89\u8fb1\u9a82", "\u6587\u5b57\u6d89\u66b4\u6050", "\u6587\u5b57\u6d89\u9ec4", "\u6587\u5b57\u6d89\u8fdd\u7981\u4fe1\u606f", "\u6587\u5b57\u6d89\u5e7f\u544a");
            DycProContentReviewTextScanReqBO dycProContentReviewTextScanReqBO = new DycProContentReviewTextScanReqBO();
            ArrayList<String> content = new ArrayList<String>();
            content.add(checkText);
            dycProContentReviewTextScanReqBO.setContent(content);
            dycProContentReviewTextScanReqBO.setLabels(labels);
            DycProCommCheckRecordItemDTO bo = new DycProCommCheckRecordItemDTO();
            bo.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            bo.setCheckSnId(checkRecordForConsumerBO.getCheckSnId());
            bo.setCheckRecordId(checkRecordForConsumerBO.getCheckRecordId());
            bo.setCheckContent(checkText);
            bo.setCheckRuleId(checkRecordForConsumerBO.getCheckRuleId());
            bo.setCheckRuleName(checkRecordForConsumerBO.getCheckRuleName());
            bo.setCheckItemId(checkRecordForConsumerBO.getCheckRuleId());
            bo.setCheckIndexCode(DmcCommCheckItemCheckIndexEnum.TEXT.getCode());
            bo.setCheckIndexName(DmcCommCheckItemCheckIndexEnum.TEXT.getValue());
            bo.setVerificationIndexCode(((Object)labels).toString());
            bo.setVerificationIndexName(labelNames.toString());
            bo.setCreateTime(execTime);
            recordItemDTOS.add(bo);
            try {
                DycProContentReviewTextScanRspBO textScanRspBO = this.dycProContentReviewAliyunTextScanService.textScan(dycProContentReviewTextScanReqBO);
                if (textScanRspBO.getRespCode().equals("0000")) {
                    if (!CollectionUtils.isEmpty((Collection)((DycProContentReviewTextScanSubResultBO)textScanRspBO.getResults().get(0)).getContexts())) {
                        bo.setCheckResultJson(((DycProContentReviewTextScanSubResultBO)textScanRspBO.getResults().get(0)).getContexts().toString());
                    }
                    if (!"pass".equals(((DycProContentReviewTextScanSubResultBO)textScanRspBO.getResults().get(0)).getSuggestion())) {
                        if ("review".equals(((DycProContentReviewTextScanSubResultBO)textScanRspBO.getResults().get(0)).getSuggestion())) {
                            bo.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.SUSPECT.getCode())));
                        } else {
                            bo.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                        }
                    }
                    if (StringUtils.hasText((String)((DycProContentReviewTextScanSubResultBO)textScanRspBO.getResults().get(0)).getLabel())) {
                        bo.setRiskTypeCode(((DycProContentReviewTextScanSubResultBO)textScanRspBO.getResults().get(0)).getLabel());
                        bo.setRiskTypeName(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckItemVarificationIndexEnum", (String)("text_" + ((DycProContentReviewTextScanSubResultBO)textScanRspBO.getResults().get(0)).getLabel())));
                    }
                } else {
                    bo.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                    if (StringUtils.hasText((String)textScanRspBO.getRespDesc()) && textScanRspBO.getRespDesc().length() > 512) {
                        bo.setCheckResultJson("\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38" + textScanRspBO.getRespDesc().substring(0, 511));
                    } else {
                        bo.setCheckResultJson("\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38" + textScanRspBO.getRespDesc());
                    }
                    log.error("\u6587\u672c\u68c0\u6d4b\u5f02\u5e38" + textScanRspBO.getRespDesc());
                }
            }
            catch (Exception e) {
                bo.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                if (StringUtils.hasText((String)e.getMessage()) && e.getMessage().length() > 512) {
                    bo.setCheckResultJson("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e.getMessage().substring(0, 511));
                } else {
                    bo.setCheckResultJson("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e.getMessage());
                }
                log.error("\u6587\u672c\u68c0\u6d4b\u5f02\u5e38" + e.getMessage());
            }
        }
        DycProCommSkuPicInfoDTO qrySkuPicDTO = new DycProCommSkuPicInfoDTO();
        qrySkuPicDTO.setSkuId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
        qrySkuPicDTO.setPicType(DycProCommConstants.PicType.MAIN_IMG);
        List picList = this.dycProCommSkuRepository.getSkuPicList(qrySkuPicDTO);
        List<String> imgList = picList.stream().map(DycProCommSkuPicInfoDTO::getPicUrl).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(imgList)) {
            ArrayList<String> scenes = new ArrayList<String>(Arrays.asList("porn", "terrorism", "ad", "live"));
            List<String> scenesNames = Arrays.asList("\u56fe\u7247\u6d89\u9ec4", "\u56fe\u7247\u6d89\u654f\u611f\u5185\u5bb9\u6216\u98ce\u9669\u4eba\u7269", "\u56fe\u7247\u6d89\u5e7f\u544a", "\u56fe\u7247\u6d89\u4e0d\u826f\u573a\u666f");
            ArrayList imageScanTaskBOS = new ArrayList();
            HashMap checkRecordItemMap = new HashMap();
            imgList.forEach(imageUrl -> {
                DycProCommCheckRecordItemDTO recordItemDTO = new DycProCommCheckRecordItemDTO();
                recordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
                recordItemDTO.setCheckSnId(checkRecordForConsumerBO.getCheckSnId());
                recordItemDTO.setCheckRecordId(checkRecordForConsumerBO.getCheckRecordId());
                recordItemDTO.setCheckContent(imageUrl);
                recordItemDTO.setCheckRuleId(checkRecordForConsumerBO.getCheckRuleId());
                recordItemDTO.setCheckRuleName(checkRecordForConsumerBO.getCheckRuleName());
                recordItemDTO.setCheckItemId(checkRecordForConsumerBO.getCheckRuleId());
                recordItemDTO.setCheckIndexCode(DmcCommCheckItemCheckIndexEnum.IMAGE.getCode());
                recordItemDTO.setCheckIndexName(DmcCommCheckItemCheckIndexEnum.IMAGE.getValue());
                recordItemDTO.setCreateTime(execTime);
                recordItemDTOS.add(recordItemDTO);
                checkRecordItemMap.put(imageUrl, recordItemDTO);
                DycProContentReviewImageScanTaskBO bo = new DycProContentReviewImageScanTaskBO();
                bo.setImageURL(imageUrl);
                imageScanTaskBOS.add(bo);
            });
            try {
                DycProContentReviewImageScanReqBO dycProContentReviewImageScanReqBO = new DycProContentReviewImageScanReqBO();
                dycProContentReviewImageScanReqBO.setScene(scenes);
                dycProContentReviewImageScanReqBO.setTask(imageScanTaskBOS);
                DycProContentReviewImageScanRspBO imageScanRspBO = this.dycProContentReviewAliyunImageScanService.imageScan(dycProContentReviewImageScanReqBO);
                if (imageScanRspBO.getRespCode().equals("0000")) {
                    HashMap<String, DycProContentReviewImageScanResultItemBO> imageSceneMap = new HashMap<String, DycProContentReviewImageScanResultItemBO>();
                    for (DycProContentReviewImageScanResultItemBO bo : imageScanRspBO.getData()) {
                        imageSceneMap.put(bo.getImageURL(), bo);
                    }
                    imgList.forEach(imageUrl -> {
                        HashSet<String> errorLabelStr = new HashSet<String>();
                        HashSet<String> sceneStr = new HashSet<String>();
                        HashSet<String> scene = new HashSet<String>();
                        String checkResult = "";
                        String checkResult1 = "";
                        for (DycProContentReviewImageScanSubResultBO dycProContentReviewImageScanSubResultBO : ((DycProContentReviewImageScanResultItemBO)imageSceneMap.get(imageUrl)).getResultItems()) {
                            if ("normal".equals(dycProContentReviewImageScanSubResultBO.getLabel()) || "pass".equals(dycProContentReviewImageScanSubResultBO.getSuggestion())) continue;
                            if ("block".equals(dycProContentReviewImageScanSubResultBO.getSuggestion())) {
                                checkResult = "block";
                            } else {
                                checkResult1 = "review";
                            }
                            errorLabelStr.add(dycProContentReviewImageScanSubResultBO.getLabelStr());
                            if (!StringUtils.hasText((String)dycProContentReviewImageScanSubResultBO.getScene())) continue;
                            scene.add(dycProContentReviewImageScanSubResultBO.getScene());
                            String sceneStr1 = DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckItemVarificationIndexEnum", (String)("image_" + dycProContentReviewImageScanSubResultBO.getScene()));
                            if (!StringUtils.hasText((String)sceneStr1)) continue;
                            sceneStr.add(sceneStr1);
                        }
                        DycProCommCheckRecordItemDTO recordItemDTO = (DycProCommCheckRecordItemDTO)checkRecordItemMap.get(imageUrl);
                        if (checkResult.equals("block")) {
                            recordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                        } else if (checkResult1.equals("review")) {
                            recordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.SUSPECT.getCode())));
                        }
                        recordItemDTO.setCheckResultJson(((Object)errorLabelStr).toString().replace("[", "").replace("]", ""));
                        if (!CollectionUtils.isEmpty(scene)) {
                            recordItemDTO.setRiskTypeCode(((Object)scene).toString().replace("[", "").replace("]", ""));
                        }
                        if (!CollectionUtils.isEmpty(sceneStr)) {
                            recordItemDTO.setRiskTypeName(((Object)sceneStr).toString().replace("[", "").replace("]", ""));
                        }
                        recordItemDTO.setVerificationIndexCode(scenes.toString());
                        recordItemDTO.setVerificationIndexName(scenesNames.toString());
                    });
                } else {
                    recordItemDTOS.forEach(dycProCommCheckRecordItemDTO -> {
                        dycProCommCheckRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                        if (StringUtils.hasText((String)imageScanRspBO.getRespDesc()) && imageScanRspBO.getRespDesc().length() > 512) {
                            dycProCommCheckRecordItemDTO.setCheckResultJson("\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38" + imageScanRspBO.getRespDesc().substring(0, 511));
                        } else {
                            dycProCommCheckRecordItemDTO.setCheckResultJson("\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38" + imageScanRspBO.getRespDesc());
                        }
                    });
                    log.error("\u56fe\u7247\u68c0\u6d4b\u5f02\u5e38" + imageScanRspBO.getRespDesc());
                }
            }
            catch (Exception e) {
                recordItemDTOS.forEach(dycProCommCheckRecordItemDTO -> {
                    if (StringUtils.hasText((String)e.getMessage()) && e.getMessage().length() > 512) {
                        dycProCommCheckRecordItemDTO.setCheckResultJson("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e.getMessage().substring(0, 511));
                    } else {
                        dycProCommCheckRecordItemDTO.setCheckResultJson("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e.getMessage());
                    }
                    dycProCommCheckRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                });
                log.error("\u56fe\u7247\u68c0\u6d4b\u5f02\u5e38" + e.getMessage());
            }
        }
        return recordItemDTOS;
    }

    private void checkSupplierPriceCycleChangNum(DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, String config, Integer num, DycProCommPriceCheckRuleParamQryDTO priceCheckRuleParamQryDTO, DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        DycProCommPriceCheckRuleVerifyValueDTO ruleVerifyValueDTO = this.dycProCommCheckRecordRepository.querySkuPriceCycleChangeNum(priceCheckRuleParamQryDTO);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("currentValue", null);
        jsonObject.put("chngTimeStart", (Object)priceCheckRuleParamQryDTO.getChngTimeStart());
        jsonObject.put("chngTimeEnd", (Object)priceCheckRuleParamQryDTO.getChngTimeEnd());
        jsonObject.put("config", (Object)config);
        JSONObject jsonObjectResult = new JSONObject();
        jsonObjectResult.put("referValue", null);
        jsonObjectResult.put("config", (Object)config);
        jsonObjectResult.put("result", (Object)0);
        jsonObjectResult.put("supplierPrice", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
        jsonObjectResult.put("marketPrice", (Object)dycProCommSkuPriceInfoDTO.getMarketPrice());
        jsonObjectResult.put("salePrice", (Object)dycProCommSkuPriceInfoDTO.getSalePrice());
        if (ruleVerifyValueDTO == null) {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        } else {
            Integer supplierPriceCycleChangeNum = ruleVerifyValueDTO.getSupplierPriceCycleChangeNum();
            jsonObjectResult.put("result", (Object)supplierPriceCycleChangeNum);
            if (supplierPriceCycleChangeNum.compareTo(num) > 0) {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                jsonObjectResult.put("exceptionActionName", (Object)DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRuleInfoDTO.getCheckExecActionCode()));
            } else {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            }
            jsonObjectResult.put("result", (Object)supplierPriceCycleChangeNum);
            jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + ">" + num));
        }
        checkRecordItemDTO.setCheckResultJson(jsonObjectResult.toJSONString());
        checkRecordItemDTO.setCheckContent(jsonObject.toJSONString());
    }

    private void checkSupplierPriceCycleChangRate(DycProCommPriceCheckRuleParamQryDTO priceCheckRuleParamQryDTO, DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        DycProCommPriceCheckRuleVerifyValueDTO ruleVerifyValueDTO = this.dycProCommCheckRecordRepository.querFirstSkuPriceChangeRecord(priceCheckRuleParamQryDTO);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("currentValue", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
        jsonObject.put("config", (Object)checkRecordItemDTO.getCheckItemContent());
        jsonObject.put("chngTimeStart", (Object)priceCheckRuleParamQryDTO.getChngTimeStart());
        jsonObject.put("chngTimeEnd", (Object)priceCheckRuleParamQryDTO.getChngTimeEnd());
        String config = checkRecordItemDTO.getCheckItemContent();
        JSONObject jsonObjectResult = new JSONObject();
        jsonObjectResult.put("referValue", null);
        jsonObjectResult.put("config", (Object)config.replace("confVale", "\u6d6e\u52a8\u7387"));
        jsonObjectResult.put("result", (Object)"0%");
        jsonObjectResult.put("supplierPrice", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
        jsonObjectResult.put("marketPrice", (Object)dycProCommSkuPriceInfoDTO.getMarketPrice());
        jsonObjectResult.put("salePrice", (Object)dycProCommSkuPriceInfoDTO.getSalePrice());
        if (ruleVerifyValueDTO == null) {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        } else if (config.contains("%confVale%")) {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        } else {
            BigDecimal changRate = dycProCommSkuPriceInfoDTO.getSupplierPrice().subtract(ruleVerifyValueDTO.getSupplierPrice()).multiply(new BigDecimal(100)).divide(ruleVerifyValueDTO.getSupplierPrice(), 3, RoundingMode.HALF_UP);
            String changRateStr = this.deleteZero(changRate.toString());
            String replaceStr = changRateStr + "&&" + changRateStr;
            SpelExpressionParser parser = new SpelExpressionParser();
            String expressStr = config.replace("%", "").replace("confVale", replaceStr);
            Expression expression = parser.parseExpression(expressStr);
            if (Boolean.FALSE.equals(expression.getValue(Boolean.class))) {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                jsonObjectResult.put("exceptionActionName", (Object)DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRuleInfoDTO.getCheckExecActionCode()));
            } else {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            }
            jsonObjectResult.put("referValue", (Object)ruleVerifyValueDTO.getSupplierPrice());
            jsonObjectResult.put("result", (Object)(changRateStr + "%"));
            if (changRate.compareTo(new BigDecimal(0)) > 0) {
                jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "up"));
            } else {
                jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "down"));
            }
        }
        checkRecordItemDTO.setCheckResultJson(jsonObjectResult.toJSONString());
        checkRecordItemDTO.setCheckContent(jsonObject.toJSONString());
    }

    private void checkSupplierPriceSingleChangRate(DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        BigDecimal oldSupplierPrice = null;
        DycProCommSkuPriceInfoQryDTO skuPriceInfoQryDTO = new DycProCommSkuPriceInfoQryDTO();
        skuPriceInfoQryDTO.setPageNo(Integer.valueOf(1));
        skuPriceInfoQryDTO.setPageSize(Integer.valueOf(2));
        RspPage rspPage = this.dycProCommPriceRuleInfoRepository.querySkuPriceChangeListPage(skuPriceInfoQryDTO);
        if (rspPage != null && !CollectionUtils.isEmpty((Collection)rspPage.getRows()) && rspPage.getRows().size() >= 2) {
            oldSupplierPrice = ((DycProCommSkuPriceChngRecordDTO)rspPage.getRows().get(1)).getSupplierPrice();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("currentValue", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
        jsonObject.put("config", (Object)checkRecordItemDTO.getCheckItemContent());
        String config = checkRecordItemDTO.getCheckItemContent();
        JSONObject jsonObjectResult = new JSONObject();
        jsonObjectResult.put("referValue", null);
        jsonObjectResult.put("config", (Object)config.replace("confVale", "\u6d6e\u52a8\u7387"));
        jsonObjectResult.put("result", (Object)"0%");
        jsonObjectResult.put("supplierPrice", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
        jsonObjectResult.put("marketPrice", (Object)dycProCommSkuPriceInfoDTO.getMarketPrice());
        jsonObjectResult.put("salePrice", (Object)dycProCommSkuPriceInfoDTO.getSalePrice());
        if (oldSupplierPrice == null) {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        } else if (config.contains("%confVale%")) {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        } else {
            BigDecimal changRate = dycProCommSkuPriceInfoDTO.getSupplierPrice().subtract(oldSupplierPrice).multiply(new BigDecimal(100)).divide(oldSupplierPrice, 3, RoundingMode.HALF_UP);
            String changRateStr = this.deleteZero(changRate.toString());
            String replaceStr = changRateStr + "&&" + changRateStr;
            SpelExpressionParser parser = new SpelExpressionParser();
            String expressStr = config.replace("%", "").replace("confVale", replaceStr);
            Expression expression = parser.parseExpression(expressStr);
            if (Boolean.FALSE.equals(expression.getValue(Boolean.class))) {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                jsonObjectResult.put("exceptionActionName", (Object)DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRuleInfoDTO.getCheckExecActionCode()));
            } else {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            }
            jsonObjectResult.put("referValue", (Object)oldSupplierPrice);
            jsonObjectResult.put("result", (Object)(changRateStr + "%"));
            if (changRate.compareTo(new BigDecimal(0)) > 0) {
                jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "up"));
            } else {
                jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "down"));
            }
        }
        checkRecordItemDTO.setCheckResultJson(jsonObjectResult.toJSONString());
        checkRecordItemDTO.setCheckContent(jsonObject.toJSONString());
    }

    private void getCycleTime(String type, Integer num, DycProCommPriceCheckRuleParamQryDTO priceCheckRuleParamQryDTO) {
        LocalDate pastDate = null;
        if (type.equals("day")) {
            pastDate = LocalDate.now().minusDays(num.intValue());
        } else if (type.equals("week")) {
            pastDate = LocalDate.now().minusWeeks(num.intValue());
        } else if (type.equals("month")) {
            pastDate = LocalDate.now().minusMonths(num.intValue());
        }
        if (pastDate != null) {
            Date chngTimeStart = Date.from(pastDate.atStartOfDay().atZone(ZoneId.of("Asia/Shanghai")).toInstant());
            Date chngTimeEnd = Date.from(LocalDate.now().atTime(LocalTime.MAX).atZone(ZoneId.of("Asia/Shanghai")).toInstant());
            priceCheckRuleParamQryDTO.setChngTimeStart(chngTimeStart);
            priceCheckRuleParamQryDTO.setChngTimeEnd(chngTimeEnd);
        }
    }

    private void checkSupplierPriceDiscountRate(DycProCommPriceCheckRuleVerifyValueDTO dycProCommPriceCheckRuleVerifyValueDTO, DycProCommCheckRecordItemDTO checkRecordItemDTO, DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO, DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("currentValue", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
        jsonObject.put("config", (Object)checkRecordItemDTO.getCheckItemContent());
        String config = checkRecordItemDTO.getCheckItemContent();
        JSONObject jsonObjectResult = new JSONObject();
        jsonObjectResult.put("referValue", null);
        jsonObjectResult.put("config", (Object)config.replace("confVale", "\u6d6e\u52a8\u7387"));
        jsonObjectResult.put("result", (Object)"0%");
        jsonObjectResult.put("supplierPrice", (Object)dycProCommSkuPriceInfoDTO.getSupplierPrice());
        jsonObjectResult.put("marketPrice", (Object)dycProCommSkuPriceInfoDTO.getMarketPrice());
        jsonObjectResult.put("salePrice", (Object)dycProCommSkuPriceInfoDTO.getSalePrice());
        if (dycProCommPriceCheckRuleVerifyValueDTO == null) {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        } else if (config.contains("%confVale%")) {
            checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
        } else {
            BigDecimal changRate = dycProCommSkuPriceInfoDTO.getDiscountRate().subtract(dycProCommPriceCheckRuleVerifyValueDTO.getAgrDiscountRate()).divide(dycProCommPriceCheckRuleVerifyValueDTO.getAgrDiscountRate(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            String changRateStr = this.deleteZero(changRate.toString());
            String replaceStr = changRateStr + "&&" + changRateStr;
            SpelExpressionParser parser = new SpelExpressionParser();
            String expressStr = config.replace("%", "").replace("confVale", replaceStr);
            Expression expression = parser.parseExpression(expressStr);
            if (Boolean.FALSE.equals(expression.getValue(Boolean.class))) {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                jsonObjectResult.put("exceptionActionName", (Object)DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRuleInfoDTO.getCheckExecActionCode()));
            } else {
                checkRecordItemDTO.setCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode())));
            }
            jsonObjectResult.put("referValue", (Object)dycProCommPriceCheckRuleVerifyValueDTO.getAgrDiscountRate());
            jsonObjectResult.put("result", (Object)(changRateStr + "%"));
            if (changRate.compareTo(new BigDecimal(0)) > 0) {
                jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "up"));
            } else {
                jsonObjectResult.put("errorShow", (Object)(jsonObjectResult.get((Object)"result") + "down"));
            }
        }
        checkRecordItemDTO.setCheckResultJson(jsonObjectResult.toJSONString());
        checkRecordItemDTO.setCheckContent(jsonObject.toJSONString());
    }

    private String deleteZero(String str) {
        int length = str.length();
        if (str.contains(".")) {
            int endIndex;
            for (int i = 0; i < length && str.substring((endIndex = str.length()) - 1).equals("0"); ++i) {
                str = str.substring(0, endIndex - 1);
            }
        }
        if (str.endsWith(".")) {
            str = str.replace(".", "");
        }
        return str;
    }
}

