/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckExecActionEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckItemCheckIndexEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckResultEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuInfoExamineStatus;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.bansrecord.api.DycProCommBansRecordRepository;
import com.tydic.dyc.pro.dmc.repository.bansrecord.bo.DycProCommBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRecordRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckObjCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRecordQryDTO;
import com.tydic.dyc.pro.dmc.repository.checkrule.dto.DycProCommCheckRuleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.service.api.DycProCommUpdateCheckResultForConsumerService;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommUpdateCheckResultForConsumerReqBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommUpdateCheckResultForConsumerRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycProCommUpdateCheckResultForConsumerServiceImpl
implements DycProCommUpdateCheckResultForConsumerService {
    @Autowired
    private DycProCommCheckRecordRepository dycProCommCheckRecordRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommBansRecordRepository dycProCommBansRecordRepository;
    @Autowired
    private DycProCommCheckRuleInfoRepository dycProCommCheckRuleInfoRepository;

    @Override
    public DycProCommUpdateCheckResultForConsumerRspBO updateCheckResult(DycProCommUpdateCheckResultForConsumerReqBO reqBO) {
        DycProCommCheckObjCheckRecordDTO recordDTO;
        DycProCommCheckRuleInfoDTO qryCheckRuleInfoDTO = new DycProCommCheckRuleInfoDTO();
        qryCheckRuleInfoDTO.setCheckRuleId(reqBO.getCheckRecordForConsumerBO().getCheckRuleId());
        DycProCommCheckRuleInfoDTO dycProCommCheckRuleInfoDTO = this.dycProCommCheckRuleInfoRepository.queryCheckRuleInfoMain(qryCheckRuleInfoDTO);
        DycProCommCheckObjCheckRecordDTO objCheckRecordDTO = new DycProCommCheckObjCheckRecordDTO();
        objCheckRecordDTO.setCheckSnId(reqBO.getCheckRecordForConsumerBO().getCheckSnId());
        DycProCommCheckObjCheckRecordDTO checkObjCheckRecordResultDto = this.dycProCommCheckRecordRepository.queryCheckObjCheckRecordByConditon(objCheckRecordDTO);
        if (checkObjCheckRecordResultDto == null) {
            return null;
        }
        if (!DycProCommConstants.checkRuleCheckStatus.CHECKIING.equals(checkObjCheckRecordResultDto.getCheckStatus())) {
            return null;
        }
        DycProCommCheckObjCheckRecordDTO qryDto = new DycProCommCheckObjCheckRecordDTO();
        qryDto.setCheckSnId(reqBO.getCheckRecordForConsumerBO().getCheckSnId());
        DycProCommCheckObjCheckRecordDTO resultDto = this.dycProCommCheckRecordRepository.selectObjCheckRecord(qryDto);
        if (!resultDto.getCheckRuleNum().equals(reqBO.getCheckRuleNum())) {
            return new DycProCommUpdateCheckResultForConsumerRspBO();
        }
        DycProCommCheckRecordQryDTO recordQryDTO = new DycProCommCheckRecordQryDTO();
        recordQryDTO.setCheckSnId(reqBO.getCheckRecordForConsumerBO().getCheckSnId());
        List checkRecordDTOs = this.dycProCommCheckRecordRepository.queryCheckRecordInfoListByCondition(recordQryDTO);
        HashSet checkResultNameList = new HashSet();
        HashSet checkExecActionNameList = new HashSet();
        HashSet riskTypeCode = new HashSet();
        HashSet riskTypeName = new HashSet();
        HashSet verificationIndexNameList = new HashSet();
        HashSet checkRuleTypeList = new HashSet();
        ArrayList bansRecordInfoDTOS = new ArrayList();
        int count = 0;
        checkRecordDTOs.forEach(dycProCommCheckRecordDTO -> {
            checkRuleTypeList.add(dycProCommCheckRecordDTO.getCheckRuleType());
            if (StringUtils.hasText((String)dycProCommCheckRecordDTO.getCheckExecActionCode()) && !dycProCommCheckRecordDTO.getCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()))) {
                checkResultNameList.add(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckResultEnum", (String)dycProCommCheckRecordDTO.getCheckResult().toString()));
                checkExecActionNameList.add(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommCheckExecActionEnum", (String)dycProCommCheckRecordDTO.getCheckExecActionCode()));
                dycProCommCheckRecordDTO.getCheckRecordItemDTOList().forEach(dycProCommCheckRecordItemDTO -> {
                    if (!dycProCommCheckRecordItemDTO.getCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()))) {
                        if (StringUtils.hasText((String)dycProCommCheckRecordItemDTO.getVerificationIndexName()) && !dycProCommCheckRecordItemDTO.getVerificationIndexName().equals("null")) {
                            verificationIndexNameList.add(dycProCommCheckRecordItemDTO.getVerificationIndexName());
                        }
                        if (StringUtils.hasText((String)dycProCommCheckRecordItemDTO.getRiskTypeCode())) {
                            if (dycProCommCheckRecordItemDTO.getCheckIndexCode().equals(DmcCommCheckItemCheckIndexEnum.TEXT.getCode())) {
                                riskTypeCode.add("text_" + dycProCommCheckRecordItemDTO.getRiskTypeCode());
                            } else {
                                riskTypeCode.add("image_" + dycProCommCheckRecordItemDTO.getRiskTypeCode());
                            }
                            if (StringUtils.hasText((String)dycProCommCheckRecordItemDTO.getRiskTypeName()) && !dycProCommCheckRecordItemDTO.getRiskTypeName().equals("null")) {
                                riskTypeName.add(dycProCommCheckRecordItemDTO.getRiskTypeName());
                            }
                        }
                    }
                });
                if (dycProCommCheckRecordDTO.getCheckExecActionCode().equals(DmcCommCheckExecActionEnum.BANS.getCode())) {
                    DycProCommBansRecordInfoDTO recordInfoDTO = new DycProCommBansRecordInfoDTO();
                    recordInfoDTO.setSkuId(dycProCommCheckRecordDTO.getCheckObjId());
                    if (dycProCommCheckRecordDTO.getCheckRuleType().equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()))) {
                        recordInfoDTO.setBansType(DycProCommConstants.bansRuleType.PRICE_DETECTION);
                        recordInfoDTO.setBansReason("\u4ef7\u683c\u5f02\u5e38");
                    } else {
                        recordInfoDTO.setBansType(DycProCommConstants.bansRuleType.PIC_TEXT_DETECTION);
                        recordInfoDTO.setBansReason("\u56fe\u6587\u5f02\u5e38");
                    }
                    recordInfoDTO.setBansRuleId(dycProCommCheckRecordDTO.getCheckRuleId());
                    recordInfoDTO.setBansStartDate(new Date());
                    recordInfoDTO.setBansEndDate(DateUtils.strToDateLong((String)"2099-12-12 23:23:59"));
                    recordInfoDTO.setCreateTime(new Date());
                    bansRecordInfoDTOS.add(recordInfoDTO);
                }
            }
        });
        if (!checkResultNameList.isEmpty()) {
            recordDTO = new DycProCommCheckObjCheckRecordDTO();
            recordDTO.setCheckSnId(reqBO.getCheckRecordForConsumerBO().getCheckSnId());
            recordDTO.setVerificationIndexNameList(((Object)verificationIndexNameList).toString().replace("[", "").replace("]", ""));
            recordDTO.setCheckExecActionNameList(((Object)checkExecActionNameList).toString().replace("[", "").replace("]", ""));
            if (checkResultNameList.contains(DmcCommCheckResultEnum.CONFIRM.getValue())) {
                recordDTO.setPersonAuditCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.CONFIRM.getCode())));
                recordDTO.setCheckResultNameList(DmcCommCheckResultEnum.CONFIRM.getValue());
            } else if (checkResultNameList.contains(DmcCommCheckResultEnum.SUSPECT.getValue())) {
                recordDTO.setPersonAuditCheckResult(Integer.valueOf(Integer.parseInt(DmcCommCheckResultEnum.SUSPECT.getCode())));
                recordDTO.setCheckResultNameList(DmcCommCheckResultEnum.SUSPECT.getValue());
            }
            if (dycProCommCheckRuleInfoDTO.getNeedAuditFlag() != null && dycProCommCheckRuleInfoDTO.getNeedAuditFlag().equals(DycProCommConstants.YesOrNo.YES)) {
                recordDTO.setCheckStatus(DycProCommConstants.checkRuleCheckStatus.AUDIT);
            } else {
                recordDTO.setCheckStatus(DycProCommConstants.checkRuleCheckStatus.FINISH);
            }
            recordDTO.setCheckObjId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
            recordDTO.setCheckRuleType(reqBO.getCheckRecordForConsumerBO().getCheckRuleType());
            recordDTO.setClearExceptionFlag(DycProCommConstants.YesOrNo.NO);
            if (!CollectionUtils.isEmpty(riskTypeCode)) {
                recordDTO.setRiskTypeCode(((Object)riskTypeCode).toString().replace("[", "").replace("]", ""));
            }
            if (!CollectionUtils.isEmpty(riskTypeName)) {
                recordDTO.setRiskTypeName(((Object)riskTypeName).toString().replace("[", "").replace("]", ""));
            }
            count = this.dycProCommCheckRecordRepository.updateCheckObjCheckRecordExceptionNum(recordDTO);
        } else {
            recordDTO = new DycProCommCheckObjCheckRecordDTO();
            recordDTO.setCheckSnId(reqBO.getCheckRecordForConsumerBO().getCheckSnId());
            count = this.dycProCommCheckRecordRepository.deleteCheckObjCheckRecordById(recordDTO);
            if (count > 0 && !CollectionUtils.isEmpty(reqBO.getCheckSnIds())) {
                DycProCommCheckObjCheckRecordDTO recordDTO1 = new DycProCommCheckObjCheckRecordDTO();
                recordDTO1.setCheckSnIds(reqBO.getCheckSnIds());
                this.dycProCommCheckRecordRepository.updateCheckObjCheckRecordExceptionFlag(recordDTO1);
            }
        }
        if (count == 0) {
            return null;
        }
        DycProCommCheckRecordQryDTO recordQryDTO1 = new DycProCommCheckRecordQryDTO();
        recordQryDTO1.setCheckObjId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
        recordQryDTO1.setIsLastFlag(DycProCommConstants.YesOrNo.YES);
        List checkRecordDTOs1 = this.dycProCommCheckRecordRepository.queryCheckRecordInfoList(recordQryDTO1);
        boolean updateSkuEsFlag = true;
        ArrayList<String> actionCodes = new ArrayList<String>();
        if (!checkRecordDTOs1.isEmpty()) {
            for (DycProCommCheckRecordDTO checkRecordDTO : checkRecordDTOs1) {
                if (checkRecordDTO.getCheckStatus().equals(DycProCommConstants.checkRuleCheckStatus.CHECKIING)) {
                    updateSkuEsFlag = false;
                    break;
                }
                if (!StringUtils.hasText((String)checkRecordDTO.getCheckExecActionCode()) || checkRecordDTO.getCheckResult().equals(Integer.parseInt(DmcCommCheckResultEnum.NORMAL.getCode()))) continue;
                actionCodes.add(checkRecordDTO.getCheckExecActionCode());
            }
        }
        if (updateSkuEsFlag) {
            ArrayList<DycProCommSkuDTO> dycProCommSkuDTOS = new ArrayList<DycProCommSkuDTO>();
            DycProCommSkuDTO dycProCommSkuDTO = new DycProCommSkuDTO();
            dycProCommSkuDTOS.add(dycProCommSkuDTO);
            dycProCommSkuDTO.setSkuId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
            if (actionCodes.contains(DmcCommCheckExecActionEnum.BANS.getCode())) {
                dycProCommSkuDTO.setExamineStatus(Integer.valueOf(Integer.parseInt(DmcCommSkuInfoExamineStatus.CHECK_REJECT.getCode())));
            } else if (actionCodes.contains(DmcCommCheckExecActionEnum.WARN.getCode())) {
                dycProCommSkuDTO.setExamineStatus(Integer.valueOf(Integer.parseInt(DmcCommSkuInfoExamineStatus.CHECK_WORN_PASS.getCode())));
            } else {
                dycProCommSkuDTO.setExamineStatus(Integer.valueOf(Integer.parseInt(DmcCommSkuInfoExamineStatus.CHECK_PASS.getCode())));
            }
            this.dycProCommSkuRepository.updateSkuMainInfoBatchAndSyncNosql(dycProCommSkuDTOS);
        }
        checkRuleTypeList.forEach(checkRuleType -> {
            DycProCommBansRecordInfoDTO dycProCommBansRecordInfoDTO = new DycProCommBansRecordInfoDTO();
            dycProCommBansRecordInfoDTO.setSkuId(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
            if (checkRuleType.equals(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()))) {
                dycProCommBansRecordInfoDTO.setBansType(DycProCommConstants.bansRuleType.PRICE_DETECTION);
            } else {
                dycProCommBansRecordInfoDTO.setBansType(DycProCommConstants.bansRuleType.PIC_TEXT_DETECTION);
            }
            this.dycProCommBansRecordRepository.deleteBansRecord(dycProCommBansRecordInfoDTO);
        });
        if (!CollectionUtils.isEmpty(bansRecordInfoDTOS)) {
            this.dycProCommBansRecordRepository.addBansRecord(bansRecordInfoDTOS);
        }
        this.dycProCommBansRecordRepository.syncNosql(reqBO.getCheckRecordForConsumerBO().getCheckObjId());
        return new DycProCommUpdateCheckResultForConsumerRspBO();
    }
}

