/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.sync.pricerule.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.mq.proxy.util.ExecutorServiceFactory;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleHighMarketPriceRuleEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleRoundRuleEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleSkuRangeTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommPriceRuleStatusEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleChngRecordRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleChngQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleSkuRangeChngRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommPriceRuleSkuRangeInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoQryDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuQryDTO;
import com.tydic.dyc.pro.dmc.sync.pricerule.api.DycProCommPriceRuleSyncService;
import com.tydic.dyc.pro.dmc.sync.pricerule.bo.DycProCommPriceRuleSyncReqBO;
import com.tydic.dyc.pro.dmc.sync.pricerule.bo.DycProCommPriceRuleSyncRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.sync.pricerule.api.DycProCommPriceRuleSyncService"})
public class DycProCommPriceRuleSyncServiceImpl
implements DycProCommPriceRuleSyncService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommPriceRuleSyncServiceImpl.class);
    @Autowired
    private DycProCommPriceRuleChngRecordRepository dycProCommPriceRuleChngRecordRepository;
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    private static ExecutorService executorService;

    @PostConstruct
    public void initTaskService() {
        log.info("\u521d\u59cb\u5316initTaskService......");
        executorService = ExecutorServiceFactory.getInstance().createCustomThreadPool(10);
    }

    @Override
    @PostMapping(value={"syncPriceRule"})
    public DycProCommPriceRuleSyncRspBO syncPriceRule(@RequestBody DycProCommPriceRuleSyncReqBO reqBO) {
        DycProCommPriceRuleChngQryDTO ruleChngQryDTO = new DycProCommPriceRuleChngQryDTO();
        ruleChngQryDTO.setPriceRuleId(reqBO.getPriceRuleId());
        ruleChngQryDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PENDING);
        ruleChngQryDTO.setNotPriceRuleStatus(Integer.valueOf(Integer.parseInt(DmcCommPriceRuleStatusEnum.DRAFT.getCode())));
        List dtoList = this.dycProCommPriceRuleChngRecordRepository.queryPriceRuleChngRecordList(ruleChngQryDTO);
        if (!CollectionUtils.isEmpty((Collection)dtoList)) {
            dtoList.forEach(priceRuleChngRecordDTO -> {
                try {
                    DycProCommPriceRuleChngRecordDTO updateDto = new DycProCommPriceRuleChngRecordDTO();
                    updateDto.setPriceRuleChngRecordId(priceRuleChngRecordDTO.getPriceRuleChngRecordId());
                    updateDto.setExecStatus(DycProCommConstants.PriceRuleExecStatus.PROGRESS);
                    updateDto.setWhereExecStatus(DycProCommConstants.PriceRuleExecStatus.PENDING);
                    int count = this.dycProCommPriceRuleChngRecordRepository.updatePriceRuleChngRecord(updateDto);
                    if (count > 0) {
                        if (priceRuleChngRecordDTO.getPriceRuleStatus().equals(Integer.parseInt(DmcCommPriceRuleStatusEnum.ENABLE.getCode())) && !priceRuleChngRecordDTO.getPriceRuleStatusOld().equals(Integer.parseInt(DmcCommPriceRuleStatusEnum.ENABLE.getCode()))) {
                            this.dealReComputePriceBySkuRnage((DycProCommPriceRuleChngRecordDTO)priceRuleChngRecordDTO);
                        }
                        if (priceRuleChngRecordDTO.getPriceRuleStatus().equals(Integer.parseInt(DmcCommPriceRuleStatusEnum.DIS_ENABLE.getCode())) && priceRuleChngRecordDTO.getPriceRuleStatusOld().equals(Integer.parseInt(DmcCommPriceRuleStatusEnum.ENABLE.getCode()))) {
                            this.dealReComputePriceBySkuPriceInfo((DycProCommPriceRuleChngRecordDTO)priceRuleChngRecordDTO);
                        }
                        if (priceRuleChngRecordDTO.getPriceRuleStatus().equals(Integer.parseInt(DmcCommPriceRuleStatusEnum.ENABLE.getCode())) && priceRuleChngRecordDTO.getPriceRuleStatusOld().equals(Integer.parseInt(DmcCommPriceRuleStatusEnum.ENABLE.getCode()))) {
                            this.dealUpdate((DycProCommPriceRuleChngRecordDTO)priceRuleChngRecordDTO);
                        }
                    }
                    DycProCommPriceRuleChngRecordDTO dycProCommPriceRuleChngRecordDTO = new DycProCommPriceRuleChngRecordDTO();
                    dycProCommPriceRuleChngRecordDTO.setPriceRuleChngRecordId(priceRuleChngRecordDTO.getPriceRuleChngRecordId());
                    dycProCommPriceRuleChngRecordDTO.setExecStatus(DycProCommConstants.PriceRuleExecStatus.SUCCESS);
                    this.dycProCommPriceRuleChngRecordRepository.updatePriceRuleChngRecord(dycProCommPriceRuleChngRecordDTO);
                }
                catch (RuntimeException e) {
                    log.error("\u89c4\u5219\u6267\u884c\u5931\u8d25{}_{}", (Object)priceRuleChngRecordDTO.getPriceRuleChngRecordId(), (Object)e.getMessage());
                }
                catch (Exception e) {
                    log.error("\u89c4\u5219\u6267\u884c\u5931\u8d25{}_{}", (Object)priceRuleChngRecordDTO.getPriceRuleChngRecordId(), (Object)e.getMessage());
                }
            });
        }
        return new DycProCommPriceRuleSyncRspBO();
    }

    private void dealUpdate(DycProCommPriceRuleChngRecordDTO priceRuleChngRecordDTO) {
        String newParam;
        String oldParam = "" + priceRuleChngRecordDTO.getEnableHigherMarketPriceFlagOld() + priceRuleChngRecordDTO.getRoundRuleOld();
        if (!oldParam.equals(newParam = "" + priceRuleChngRecordDTO.getEnableHigherMarketPriceFlag() + priceRuleChngRecordDTO.getRoundRule())) {
            this.dealReComputePriceBySkuPriceInfo(priceRuleChngRecordDTO);
            this.dealReComputePriceBySkuRangeChngRecord(priceRuleChngRecordDTO, 1);
        } else if (priceRuleChngRecordDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.DEFAULT.getCode()))) {
            this.dealReComputePriceBySkuPriceInfo(priceRuleChngRecordDTO);
        } else {
            this.dealReComputePriceBySkuRangeChngRecord(priceRuleChngRecordDTO, null);
        }
    }

    private void dealReComputePriceBySkuRangeChngRecord(DycProCommPriceRuleChngRecordDTO priceRuleChngRecordDTO, Integer chngType) {
        DycProCommPriceRuleChngQryDTO dycProCommPriceRuleChngQryDTO = new DycProCommPriceRuleChngQryDTO();
        dycProCommPriceRuleChngQryDTO.setPriceRuleChngRecordId(priceRuleChngRecordDTO.getPriceRuleChngRecordId());
        dycProCommPriceRuleChngQryDTO.setChngType(chngType);
        List skuRangeChngRecordDTO = priceRuleChngRecordDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode())) || priceRuleChngRecordDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode())) || priceRuleChngRecordDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode())) ? this.dycProCommPriceRuleChngRecordRepository.queryPriceRuleLastCatalogList(dycProCommPriceRuleChngQryDTO) : this.dycProCommPriceRuleChngRecordRepository.queryPriceRuleSkuRangeChngRecordList(dycProCommPriceRuleChngQryDTO);
        if (!CollectionUtils.isEmpty((Collection)skuRangeChngRecordDTO)) {
            skuRangeChngRecordDTO.forEach(dycProCommPriceRuleSkuRangeChngRecordDTO -> {
                DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO = (DycProCommPriceRuleSkuRangeInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)dycProCommPriceRuleSkuRangeChngRecordDTO), DycProCommPriceRuleSkuRangeInfoDTO.class);
                this.queryEsSkuAndComputeSalePrice(dycProCommPriceRuleSkuRangeInfoDTO);
            });
        }
    }

    private void dealReComputePriceBySkuPriceInfo(DycProCommPriceRuleChngRecordDTO priceRuleChngRecordDTO) {
        DycProCommSkuPriceInfoQryDTO dycProCommSkuPriceInfoQryDTO = new DycProCommSkuPriceInfoQryDTO();
        dycProCommSkuPriceInfoQryDTO.setPriceRuleId(priceRuleChngRecordDTO.getPriceRuleId());
        dycProCommSkuPriceInfoQryDTO.setPageNo(Integer.valueOf(0));
        dycProCommSkuPriceInfoQryDTO.setPageSize(Integer.valueOf(500));
        RspPage rspPage = this.dycProCommPriceRuleInfoRepository.getSkuPriceInfoListPage(dycProCommSkuPriceInfoQryDTO);
        int total = rspPage.getTotal();
        if (total > 0) {
            for (int i = 0; i <= total; ++i) {
                dycProCommSkuPriceInfoQryDTO.setPageNo(Integer.valueOf(1));
                dycProCommSkuPriceInfoQryDTO.setPageSize(Integer.valueOf(500));
                RspPage rspPage1 = this.dycProCommPriceRuleInfoRepository.getSkuPriceInfoListPage(dycProCommSkuPriceInfoQryDTO);
                if (CollectionUtils.isEmpty((Collection)rspPage1.getRows())) continue;
                rspPage1.getRows().forEach(this::invokeComputeSalePriceAndUpdateSalePrice);
            }
        }
    }

    private void dealReComputePriceBySkuRnage(DycProCommPriceRuleChngRecordDTO priceRuleChngRecordDTO) {
        List skuRangeInfoDTO = null;
        if (priceRuleChngRecordDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.CATALOG.getCode())) || priceRuleChngRecordDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.SUPPLIER_CATALOG.getCode())) || priceRuleChngRecordDTO.getSkuRangeType().equals(Integer.parseInt(DmcCommPriceRuleSkuRangeTypeEnum.AGR_CATALOG.getCode()))) {
            DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO = new DycProCommPriceRuleInfoQryDTO();
            dycProCommPriceRuleInfoQryDTO.setPriceRuleId(priceRuleChngRecordDTO.getPriceRuleId());
            skuRangeInfoDTO = this.dycProCommPriceRuleInfoRepository.queryPriceRuleLastCatalogList(dycProCommPriceRuleInfoQryDTO);
        } else {
            DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO = new DycProCommPriceRuleInfoQryDTO();
            dycProCommPriceRuleInfoQryDTO.setPriceRuleId(priceRuleChngRecordDTO.getPriceRuleId());
            skuRangeInfoDTO = this.dycProCommPriceRuleInfoRepository.queryPriceRuleSkuRangeList(dycProCommPriceRuleInfoQryDTO);
        }
        if (!CollectionUtils.isEmpty((Collection)skuRangeInfoDTO)) {
            skuRangeInfoDTO.forEach(this::queryEsSkuAndComputeSalePrice);
        }
    }

    private void queryEsSkuAndComputeSalePrice(DycProCommPriceRuleSkuRangeInfoDTO dycProCommPriceRuleSkuRangeInfoDTO) {
        if (dycProCommPriceRuleSkuRangeInfoDTO.getSkuId() != null) {
            DycProCommSkuPriceInfoQryDTO skuPriceInfoQryDTO = new DycProCommSkuPriceInfoQryDTO();
            skuPriceInfoQryDTO.setSkuId(dycProCommPriceRuleSkuRangeInfoDTO.getSkuId());
            DycProCommSkuPriceInfoDTO skuPriceInfoDTO = this.dycProCommPriceRuleInfoRepository.getSkuPriceInfo(skuPriceInfoQryDTO);
            if (skuPriceInfoDTO != null) {
                this.invokeComputeSalePriceAndUpdateSalePrice(skuPriceInfoDTO);
            }
        } else {
            DycProCommPriceRuleInfoQryDTO dycProCommPriceRuleInfoQryDTO = new DycProCommPriceRuleInfoQryDTO();
            dycProCommPriceRuleInfoQryDTO.setSupplierId(dycProCommPriceRuleSkuRangeInfoDTO.getSupplierId());
            dycProCommPriceRuleInfoQryDTO.setAgrId(dycProCommPriceRuleSkuRangeInfoDTO.getAgrId());
            dycProCommPriceRuleInfoQryDTO.setCatalogId(dycProCommPriceRuleSkuRangeInfoDTO.getCatalogId());
            dycProCommPriceRuleInfoQryDTO.setPageNo(Integer.valueOf(0));
            dycProCommPriceRuleInfoQryDTO.setPageSize(Integer.valueOf(500));
            RspPage skuInfoListPage = this.dycProCommPriceRuleInfoRepository.getSkuInfoListPage(dycProCommPriceRuleInfoQryDTO);
            int total1 = skuInfoListPage.getTotal();
            if (total1 > 0) {
                int j = 0;
                while (j <= total1) {
                    int currentPage = j++;
                    CompletionStage future = CompletableFuture.runAsync(() -> {
                        dycProCommPriceRuleInfoQryDTO.setPageNo(Integer.valueOf(currentPage));
                        dycProCommPriceRuleInfoQryDTO.setPageSize(Integer.valueOf(500));
                        RspPage skuInfoListPage1 = this.dycProCommPriceRuleInfoRepository.getSkuInfoListPage(dycProCommPriceRuleInfoQryDTO);
                        for (DycProCommPriceRuleSkuRangeInfoDTO skuRangeInfoDTO : skuInfoListPage1.getRows()) {
                            DycProCommSkuPriceInfoQryDTO skuPriceInfoQryDTO = new DycProCommSkuPriceInfoQryDTO();
                            skuPriceInfoQryDTO.setSkuId(skuRangeInfoDTO.getSkuId());
                            DycProCommSkuPriceInfoDTO skuPriceInfoDTO = this.dycProCommPriceRuleInfoRepository.getSkuPriceInfo(skuPriceInfoQryDTO);
                            if (skuPriceInfoDTO == null) continue;
                            this.invokeComputeSalePriceAndUpdateSalePrice(skuPriceInfoDTO);
                        }
                    }, executorService).exceptionally(e -> {
                        log.info("\u9875\u7801 {} \u5904\u7406\u5f02\u5e38", (Object)currentPage);
                        return null;
                    });
                    ((CompletableFuture)future).whenComplete((result, e) -> log.error("\u9875\u7801 {} \u5904\u7406\u5b8c\u6210", (Object)currentPage, e));
                }
            }
        }
    }

    private void invokeComputeSalePriceAndUpdateSalePrice(DycProCommSkuPriceInfoDTO skuPriceInfoDTO) {
        try {
            DycProCommSkuQryDTO commSkuQryDTO = new DycProCommSkuQryDTO();
            commSkuQryDTO.setSkuId(skuPriceInfoDTO.getSkuId());
            DycProCommSkuDTO skuDTO = this.dycProCommSkuRepository.getSkuMainAndManageCatalog(commSkuQryDTO);
            DycProCommSkuPriceInfoHandleDTO dycProCommSkuPriceInfoHandleDTO = new DycProCommSkuPriceInfoHandleDTO();
            dycProCommSkuPriceInfoHandleDTO.setSkuId(skuPriceInfoDTO.getSkuId());
            dycProCommSkuPriceInfoHandleDTO.setMarketPrice(skuPriceInfoDTO.getMarketPrice());
            dycProCommSkuPriceInfoHandleDTO.setSupplierPrice(skuPriceInfoDTO.getSupplierPrice());
            dycProCommSkuPriceInfoHandleDTO.setManageCatalogPath(skuDTO.getManageCatalogPath());
            dycProCommSkuPriceInfoHandleDTO.setSupplierId(skuDTO.getSupplierId());
            dycProCommSkuPriceInfoHandleDTO.setAgrId(skuDTO.getAgrId());
            if (skuDTO.getSkuSource().equals(DycProCommConstants.SkuSource.AGR_SKU)) {
                dycProCommSkuPriceInfoHandleDTO.setPriceRuleType(DycProCommConstants.PriceRuleType.AGR);
            } else if (skuDTO.getSkuSource().equals(DycProCommConstants.SkuSource.E_SKU)) {
                dycProCommSkuPriceInfoHandleDTO.setPriceRuleType(DycProCommConstants.PriceRuleType.EC);
            }
            DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO = this.dycProCommPriceRuleInfoRepository.computeSkuPrice(dycProCommSkuPriceInfoHandleDTO);
            DycProCommSkuPriceInfoDTO updateSkuPriceInfoDTO = (DycProCommSkuPriceInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)skuPriceInfoDTO), DycProCommSkuPriceInfoDTO.class);
            updateSkuPriceInfoDTO.setPriceId(skuPriceInfoDTO.getPriceId());
            updateSkuPriceInfoDTO.setPriceRuleId(dycProCommSkuPriceInfoDTO.getPriceRuleId());
            updateSkuPriceInfoDTO.setSalePrice(dycProCommSkuPriceInfoDTO.getSalePrice());
            updateSkuPriceInfoDTO.setLadderPriceRule(dycProCommSkuPriceInfoDTO.getLadderPriceRule());
            updateSkuPriceInfoDTO.setPriceRiseType(dycProCommSkuPriceInfoDTO.getPriceRiseType());
            updateSkuPriceInfoDTO.setPriceRiseRate(dycProCommSkuPriceInfoDTO.getPriceRiseRate());
            updateSkuPriceInfoDTO.setChngReason("\u52a0\u4ef7\u89c4\u5219\u53d8\u66f4");
            DycProCommSkuDTO skuDTO1 = new DycProCommSkuDTO();
            skuDTO1.setSkuId(skuDTO.getSkuId());
            skuDTO1.setSkuStatus(skuDTO.getSkuStatus());
            skuDTO1.setPriceInfo(updateSkuPriceInfoDTO);
            this.dycProCommSkuRepository.updateSkuPriceInfoAndSyncNosql(skuDTO1);
        }
        catch (Exception e) {
            log.error("\u4ef7\u683c\u66f4\u65b0\u5f02\u5e38{}", (Object)skuPriceInfoDTO.getSkuId());
        }
    }

    private void updateSalePrice(DycProEsIndexMappingSkuBO esIndexMappingSkuBO, DycProCommSkuPriceInfoDTO skuPriceInfoDTO, DycProCommPriceRuleSkuRangeChngRecordDTO skuPriceChngRecordDTO, DycProCommPriceRuleChngRecordDTO priceRuleChngRecordDTO) {
        if (!skuPriceInfoDTO.getPriceRuleId().equals(priceRuleChngRecordDTO.getPriceRuleId())) {
            return;
        }
        BigDecimal priceRiseRate = new BigDecimal(skuPriceChngRecordDTO.getPriceRiseRate());
        BigDecimal salePrice = null;
        if (skuPriceChngRecordDTO.getPriceRiseType().equals(DycProCommConstants.PriceRiseType.RATE)) {
            BigDecimal temp = new BigDecimal(1).add(priceRiseRate.divide(new BigDecimal(100), 4, RoundingMode.HALF_UP));
            salePrice = priceRuleChngRecordDTO.getRoundRule().equals(Integer.parseInt(DmcCommPriceRuleRoundRuleEnum.FOUR_FIVE.getCode())) ? skuPriceInfoDTO.getSupplierPrice().multiply(temp).setScale(2, RoundingMode.HALF_UP) : skuPriceInfoDTO.getSupplierPrice().multiply(temp).setScale(2, RoundingMode.CEILING);
        } else {
            salePrice = priceRuleChngRecordDTO.getRoundRule().equals(Integer.parseInt(DmcCommPriceRuleRoundRuleEnum.FOUR_FIVE.getCode())) ? skuPriceInfoDTO.getSupplierPrice().add(priceRiseRate).setScale(2, RoundingMode.HALF_UP) : skuPriceInfoDTO.getSupplierPrice().add(priceRiseRate).setScale(2, RoundingMode.HALF_UP);
        }
        if (salePrice.compareTo(skuPriceInfoDTO.getMarketPrice()) > 0) {
            if (priceRuleChngRecordDTO.getEnableHigherMarketPriceFlag().equals(Integer.parseInt(DmcCommPriceRuleHighMarketPriceRuleEnum.USER_MARKET_PRICE.getCode()))) {
                salePrice = skuPriceInfoDTO.getMarketPrice();
            } else if (priceRuleChngRecordDTO.getEnableHigherMarketPriceFlag().equals(Integer.parseInt(DmcCommPriceRuleHighMarketPriceRuleEnum.USER_SUPPLIER_PRICE.getCode()))) {
                salePrice = skuPriceInfoDTO.getSupplierPrice();
            }
        }
        DycProCommSkuPriceInfoDTO updateSkuPriceInfoDTO = (DycProCommSkuPriceInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)skuPriceInfoDTO), DycProCommSkuPriceInfoDTO.class);
        updateSkuPriceInfoDTO.setSalePrice(salePrice);
        updateSkuPriceInfoDTO.setPriceRuleId(priceRuleChngRecordDTO.getPriceRuleId());
        updateSkuPriceInfoDTO.setLadderPriceRule(skuPriceChngRecordDTO.getLadderPriceRule());
        updateSkuPriceInfoDTO.setPriceRiseType(skuPriceChngRecordDTO.getPriceRiseType());
        updateSkuPriceInfoDTO.setPriceRiseRate(skuPriceChngRecordDTO.getPriceRiseRate());
        updateSkuPriceInfoDTO.setChngReason("\u52a0\u4ef7\u89c4\u5219\u53d8\u66f4");
        DycProCommSkuDTO skuDTO = new DycProCommSkuDTO();
        skuDTO.setSkuId(esIndexMappingSkuBO.getSkuId());
        skuDTO.setSkuStatus(esIndexMappingSkuBO.getSkuStatus());
        skuDTO.setPriceInfo(updateSkuPriceInfoDTO);
        this.dycProCommSkuRepository.updateSkuPriceInfoAndSyncNosql(skuDTO);
    }
}

