/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.ecs.timetask.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckObjEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckSenceEnum;
import com.tydic.dyc.pro.dmc.ecs.constants.ECommoditySyncConstant;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommDealSkuMsgWhenNotExistService;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommDealSkuMsgWhenSkuDisableService;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommDealSkuMsgWhenSkuOffShelvesService;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommDealSkuMsgWhenSkuOnShelvesService;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommDealSkuMsgWhenSkuTobeOnShelvesService;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommPreDealMsgService;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealSkuMsgReqBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealSkuMsgRspBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommPreDealMsgReqBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommPreDealMsgRspBO;
import com.tydic.dyc.pro.dmc.ecs.timetask.api.DycProCommDealMsgTimeService;
import com.tydic.dyc.pro.dmc.ecs.timetask.bo.DycProCommDealMsgTimeReqBO;
import com.tydic.dyc.pro.dmc.ecs.timetask.bo.DycProCommDealMsgTimeRspBO;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.api.DycProCommExtSkuMessageRecordsRepository;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.dto.DycProCommExtSkuMessageRecordsDTO;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.dto.DycProCommExtSkuMessageRecordsQueryDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"COMMODITY_SYNC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.ecs.timetask.api.DycProCommDealMsgTimeService"})
public class DycProCommDealMsgTimeServiceImpl
implements DycProCommDealMsgTimeService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommDealMsgTimeServiceImpl.class);
    @Value(value="${deal.msg.max.count}")
    private Integer dealMsgMaxCount;
    @Value(value="${is.need.image-text.check}")
    private String isNeedImageTextCheck;
    @Value(value="${is.need.price.check}")
    private String isNeedPriceCheck;
    @Autowired
    private DycProCommExtSkuMessageRecordsRepository dycProCommExtSkuMessageRecordsRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommPreDealMsgService dycProCommPreDealMsgService;
    @Autowired
    private DycProCommDealSkuMsgWhenNotExistService dycProCommDealSkuMsgWhenNotExistService;
    @Autowired
    private DycProCommDealSkuMsgWhenSkuTobeOnShelvesService dycProCommDealSkuMsgWhenSkuTobeOnShelvesService;
    @Autowired
    private DycProCommDealSkuMsgWhenSkuDisableService dycProCommDealSkuMsgWhenSkuDisableService;
    @Autowired
    private DycProCommDealSkuMsgWhenSkuOnShelvesService dycProCommDealSkuMsgWhenSkuOnShelvesService;
    @Autowired
    private DycProCommDealSkuMsgWhenSkuOffShelvesService dycProCommDealSkuMsgWhenSkuOffShelvesService;
    @Value(value="${comm.checkrule.topic}")
    private String commCheckRuleTopic;
    @Value(value="${comm.checkrule.tag}")
    private String commCheckRuleTag;
    @Resource(name="dycProCmmCheckRuleMqServiceProvider")
    private ProxyMessageProducer dycProCmmCheckRuleMqServiceProvider;

    @Override
    @Async
    @PostMapping(value={"dealMsg"})
    public DycProCommDealMsgTimeRspBO dealMsg(@RequestBody DycProCommDealMsgTimeReqBO reqBO) {
        DycProCommExtSkuMessageRecordsDTO recordsDTO;
        log.info("\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2{}", (Object)reqBO.toString());
        this.dealMsgParamVerify(reqBO);
        for (int i = 0; i < this.dealMsgMaxCount && null != (recordsDTO = this.queryUndealSkuMsg(reqBO)) && StringUtils.isNotBlank((String)recordsDTO.getExtSkuId()); ++i) {
            DycProCommDealSkuMsgReqBO dycProCommDealSkuMsgReqBO;
            DycProCommPreDealMsgReqBO dycProCommPreDealMsgReqBO = new DycProCommPreDealMsgReqBO();
            dycProCommPreDealMsgReqBO.setExtSkuId(recordsDTO.getExtSkuId());
            dycProCommPreDealMsgReqBO.setSupplierHsn(recordsDTO.getSupplierHsn());
            DycProCommPreDealMsgRspBO dycProCommPreDealMsgRspBO = this.dycProCommPreDealMsgService.preDealMsg(dycProCommPreDealMsgReqBO);
            if (!"0000".equals(dycProCommPreDealMsgRspBO.getRespCode())) break;
            DycProCommDealSkuMsgRspBO dealSkuMsgRspBO = new DycProCommDealSkuMsgRspBO();
            DycProCommSkuDTO reqDto = new DycProCommSkuDTO();
            reqDto.setExtSkuId(recordsDTO.getExtSkuId());
            DycProCommSkuDTO skuMainInfoDto = this.dycProCommSkuRepository.getSkuMainInfoByCondition(reqDto);
            if (null == skuMainInfoDto) {
                dycProCommDealSkuMsgReqBO = new DycProCommDealSkuMsgReqBO();
                dycProCommDealSkuMsgReqBO.setExtSkuId(recordsDTO.getExtSkuId());
                dycProCommDealSkuMsgReqBO.setSupplierHsn(reqBO.getSupplierHsn());
                dycProCommDealSkuMsgReqBO.setSkuMsgList(dycProCommPreDealMsgRspBO.getMsgRecords());
                dycProCommDealSkuMsgReqBO.setSupplierId(reqBO.getSupplierId());
                dycProCommDealSkuMsgReqBO.setSupplierName(reqBO.getSupplierName());
                dycProCommDealSkuMsgReqBO.setTradeMode(reqBO.getTradeMode());
                dycProCommDealSkuMsgReqBO.setAgrId(reqBO.getAgrId());
                dealSkuMsgRspBO = this.dycProCommDealSkuMsgWhenNotExistService.dealSkuMsgWhenNotExist(dycProCommDealSkuMsgReqBO);
            } else if (ECommoditySyncConstant.SkuStatus.DISABLE.equals(skuMainInfoDto.getSkuStatus())) {
                dycProCommDealSkuMsgReqBO = new DycProCommDealSkuMsgReqBO();
                dycProCommDealSkuMsgReqBO.setSkuMsgList(dycProCommPreDealMsgRspBO.getMsgRecords());
                if (ECommoditySyncConstant.DelFlag.YES.equals(skuMainInfoDto.getDelFlag())) {
                    dycProCommDealSkuMsgReqBO.setFailReason("\u8be5\u5546\u54c1\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u5904\u7406\u8be5\u6d88\u606f");
                } else {
                    dycProCommDealSkuMsgReqBO.setFailReason("\u8be5\u5546\u54c1\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u5904\u7406\u8be5\u6d88\u606f");
                }
                dealSkuMsgRspBO = this.dycProCommDealSkuMsgWhenSkuDisableService.dealSkuMsgWhenSkuDisable(dycProCommDealSkuMsgReqBO);
            } else if (ECommoditySyncConstant.SkuStatus.TOBE_ON_SHELVES.equals(skuMainInfoDto.getSkuStatus())) {
                dycProCommDealSkuMsgReqBO = new DycProCommDealSkuMsgReqBO();
                dycProCommDealSkuMsgReqBO.setExtSkuId(recordsDTO.getExtSkuId());
                dycProCommDealSkuMsgReqBO.setSupplierHsn(reqBO.getSupplierHsn());
                dycProCommDealSkuMsgReqBO.setSkuMsgList(dycProCommPreDealMsgRspBO.getMsgRecords());
                dycProCommDealSkuMsgReqBO.setSupplierId(reqBO.getSupplierId());
                dycProCommDealSkuMsgReqBO.setSupplierName(reqBO.getSupplierName());
                dycProCommDealSkuMsgReqBO.setTradeMode(reqBO.getTradeMode());
                dycProCommDealSkuMsgReqBO.setSkuId(skuMainInfoDto.getSkuId());
                dycProCommDealSkuMsgReqBO.setSkuCode(skuMainInfoDto.getSkuCode());
                dycProCommDealSkuMsgReqBO.setAgrId(reqBO.getAgrId());
                dealSkuMsgRspBO = this.dycProCommDealSkuMsgWhenSkuTobeOnShelvesService.dealSkuMsgWhenSkuTobeOnShelves(dycProCommDealSkuMsgReqBO);
            } else if (ECommoditySyncConstant.SkuStatus.ON_SHELVES.equals(skuMainInfoDto.getSkuStatus())) {
                dycProCommDealSkuMsgReqBO = new DycProCommDealSkuMsgReqBO();
                dycProCommDealSkuMsgReqBO.setExtSkuId(recordsDTO.getExtSkuId());
                dycProCommDealSkuMsgReqBO.setSupplierHsn(reqBO.getSupplierHsn());
                dycProCommDealSkuMsgReqBO.setSkuMsgList(dycProCommPreDealMsgRspBO.getMsgRecords());
                dycProCommDealSkuMsgReqBO.setSupplierId(reqBO.getSupplierId());
                dycProCommDealSkuMsgReqBO.setSupplierName(reqBO.getSupplierName());
                dycProCommDealSkuMsgReqBO.setTradeMode(reqBO.getTradeMode());
                dycProCommDealSkuMsgReqBO.setSkuId(skuMainInfoDto.getSkuId());
                dycProCommDealSkuMsgReqBO.setSkuCode(skuMainInfoDto.getSkuCode());
                dycProCommDealSkuMsgReqBO.setAgrId(reqBO.getAgrId());
                dealSkuMsgRspBO = this.dycProCommDealSkuMsgWhenSkuOnShelvesService.dealSkuMsgWhenSkuOnShelves(dycProCommDealSkuMsgReqBO);
            } else if (ECommoditySyncConstant.SkuStatus.OFF_SHELVES.equals(skuMainInfoDto.getSkuStatus())) {
                dycProCommDealSkuMsgReqBO = new DycProCommDealSkuMsgReqBO();
                dycProCommDealSkuMsgReqBO.setExtSkuId(recordsDTO.getExtSkuId());
                dycProCommDealSkuMsgReqBO.setSupplierHsn(reqBO.getSupplierHsn());
                dycProCommDealSkuMsgReqBO.setSkuMsgList(dycProCommPreDealMsgRspBO.getMsgRecords());
                dycProCommDealSkuMsgReqBO.setSupplierId(reqBO.getSupplierId());
                dycProCommDealSkuMsgReqBO.setSupplierName(reqBO.getSupplierName());
                dycProCommDealSkuMsgReqBO.setTradeMode(reqBO.getTradeMode());
                dycProCommDealSkuMsgReqBO.setSkuId(skuMainInfoDto.getSkuId());
                dycProCommDealSkuMsgReqBO.setSkuCode(skuMainInfoDto.getSkuCode());
                dealSkuMsgRspBO = this.dycProCommDealSkuMsgWhenSkuOffShelvesService.dealSkuMsgWhenSkuOffShelves(dycProCommDealSkuMsgReqBO);
            }
            if (!"0000".equals(dealSkuMsgRspBO.getRespCode())) break;
            if (CollectionUtils.isEmpty(dealSkuMsgRspBO.getDealSkuMsgForCheckParamBOS())) continue;
            if ("YES".equals(this.isNeedPriceCheck)) {
                dealSkuMsgRspBO.getDealSkuMsgForCheckParamBOS().forEach(dealSkuMsgForCheckParamBO -> {
                    dealSkuMsgForCheckParamBO.setCheckObjType(Integer.parseInt(DmcCommCheckObjEnum.EC_GOODS.getCode()));
                    dealSkuMsgForCheckParamBO.setCheckRuleType(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()));
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("type", (Object)"addCheckRecord");
                    jsonObject.put("execCheckRuleParamBO", dealSkuMsgForCheckParamBO);
                    this.dycProCmmCheckRuleMqServiceProvider.send(new ProxyMessage(this.commCheckRuleTopic, this.commCheckRuleTag, jsonObject.toJSONString()));
                });
            }
            if (!"YES".equals(this.isNeedImageTextCheck)) continue;
            dealSkuMsgRspBO.getDealSkuMsgForCheckParamBOS().forEach(dealSkuMsgForCheckParamBO -> {
                if (dealSkuMsgForCheckParamBO.getCheckSceneCode().equals(DmcCommCheckSenceEnum.ADD_GOODS.getCode()) || dealSkuMsgForCheckParamBO.getCheckSceneCode().equals(DmcCommCheckSenceEnum.CHANGE_GOODS.getCode())) {
                    dealSkuMsgForCheckParamBO.setCheckObjType(Integer.parseInt(DmcCommCheckObjEnum.EC_GOODS.getCode()));
                    dealSkuMsgForCheckParamBO.setCheckRuleType(Integer.parseInt(DmcCommCheckRuleTypeEnum.IMAGE_CHECK.getCode()));
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("type", (Object)"addCheckRecord");
                    jsonObject.put("execCheckRuleParamBO", dealSkuMsgForCheckParamBO);
                    this.dycProCmmCheckRuleMqServiceProvider.send(new ProxyMessage(this.commCheckRuleTopic, this.commCheckRuleTag, jsonObject.toJSONString()));
                }
            });
        }
        return new DycProCommDealMsgTimeRspBO();
    }

    private DycProCommExtSkuMessageRecordsDTO queryUndealSkuMsg(DycProCommDealMsgTimeReqBO reqBO) {
        DycProCommExtSkuMessageRecordsQueryDTO queryDTO = new DycProCommExtSkuMessageRecordsQueryDTO();
        queryDTO.setDealMsgMaxCount(Integer.valueOf(1));
        queryDTO.setMod(reqBO.getMod());
        queryDTO.setTotalThread(reqBO.getTotalThread());
        DycProCommExtSkuMessageRecordsDTO dycProCommExtSkuMessageRecordsDTO = new DycProCommExtSkuMessageRecordsDTO();
        dycProCommExtSkuMessageRecordsDTO.setSupplierHsn(reqBO.getSupplierHsn());
        queryDTO.setDycProCommExtSkuMessageRecordsDTO(dycProCommExtSkuMessageRecordsDTO);
        DycProCommExtSkuMessageRecordsDTO recordsDTO = this.dycProCommExtSkuMessageRecordsRepository.selectUndealMsgForTimeTask(queryDTO);
        return recordsDTO;
    }

    private void dealMsgParamVerify(DycProCommDealMsgTimeReqBO reqBO) {
        if (StringUtils.isBlank((String)reqBO.getSupplierHsn())) {
            throw new ZTBusinessException("\u7535\u5546\u8bc6\u522b\u7f16\u7801[supplierHsn]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalThread()) {
            throw new ZTBusinessException("\u603b\u5e76\u53d1\u6570[totalThread]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getMod()) {
            throw new ZTBusinessException("\u53d6\u6a21\u6570[mod]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

