/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.approve.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcSscConsultStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcSscSupplyApplyInfoStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscSupplyApplyRepository;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscWorkDayRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSupplierInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscSupplyApplyInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscWorkDayInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscWorkDayQryDTO;
import com.tydic.dyc.pro.dmc.service.approve.api.DycProSscCompleteApproveTaskService;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProSscCompleteApproveTaskReqBO;
import com.tydic.dyc.pro.dmc.service.approve.bo.DycProSscCompleteApproveTaskRspBO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscCutPointDomService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscCutPointDomReqBO;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.approve.api.DycProSscCompleteApproveTaskService"})
public class DycProSscCompleteApproveTaskServiceImpl
implements DycProSscCompleteApproveTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycProSscCompleteApproveTaskServiceImpl.class);
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProSscSupplyApplyRepository dycProSscSupplyApplyRepository;
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;
    @Autowired
    private DycProSscWorkDayRepository dycProSscWorkDayRepository;
    @Autowired
    private DycProSscCutPointDomService dycProSscCutPointDomService;
    @Resource
    private DycProEncodeSerialService encodeSerialService;

    @PostMapping(value={"completeApproveTask"})
    public DycProSscCompleteApproveTaskRspBO completeApproveTask(@RequestBody DycProSscCompleteApproveTaskReqBO reqBO) {
        DycProPublicTaskInstHandleDTO flowTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
        BeanUtils.copyProperties((Object)reqBO, (Object)flowTaskInstHandleDto);
        this.dycProPublicTaskInstRepository.completeFlowTask(flowTaskInstHandleDto);
        if (reqBO.getIsFinish().booleanValue()) {
            DycProSscConsultDTO updateConsult;
            DycProSscSupplyApplyInfoDTO updateSupplyApply;
            if ("pass".equals(reqBO.getDealResult())) {
                if (PublicProcInstBusiType.SUPPLY_APPLY_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    updateSupplyApply = new DycProSscSupplyApplyInfoDTO();
                    updateSupplyApply.setSupplyApplyId(reqBO.getObjId());
                    updateSupplyApply.setStatus(Integer.valueOf(Integer.parseInt(DmcSscSupplyApplyInfoStatus.PASS_APPROVAL.getCode())));
                    this.dycProSscSupplyApplyRepository.updateSupplyApplyStatus(updateSupplyApply);
                } else if (PublicProcInstBusiType.CONSULT_INQUIRY_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.CONSULT_BIDDING_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    updateConsult = new DycProSscConsultDTO();
                    updateConsult.setConsultId(reqBO.getObjId());
                    updateConsult.setConsultStatus(Integer.valueOf(Integer.parseInt(DmcSscConsultStatus.TO_BE_PUBLISHED.getCode())));
                    if (PublicProcInstBusiType.CONSULT_BIDDING_APPROVE.getCode().equals(reqBO.getBusiType())) {
                        DycProSscConsultDTO consultBaseInfo = this.dycProSscConsultRepository.queryConsultBaseInfo(updateConsult);
                        log.info(" \u7ade\u4ef7\u9700\u8981\u5904\u7406\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)consultBaseInfo));
                        DycProSscWorkDayQryDTO qryDTO = new DycProSscWorkDayQryDTO();
                        Date now = new Date();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                        qryDTO.setWorkDayDate(Long.valueOf(Long.parseLong(sdf.format(now))));
                        Calendar calendar = Calendar.getInstance();
                        int hour = calendar.get(11);
                        int minute = calendar.get(12);
                        DycProSscWorkDayInfoDTO dycProSscWorkDayInfoNowDTO = this.dycProSscWorkDayRepository.selectWorkDayInfoByDateAndWorkDay(qryDTO);
                        if (dycProSscWorkDayInfoNowDTO == null) {
                            throw new ZTBusinessException("\u5de5\u4f5c\u65e5\u4fe1\u606f\u65e0\u6570\u636e");
                        }
                        if (dycProSscWorkDayInfoNowDTO.getIsWorkDay() == 0) {
                            if (hour > 14 || hour == 14 && minute > 0) {
                                qryDTO.setWorkDayNum(Integer.valueOf(1));
                            } else {
                                qryDTO.setWorkDayNum(Integer.valueOf(0));
                            }
                        } else if (hour > 14 || hour == 14 && minute > 0) {
                            qryDTO.setWorkDayNum(Integer.valueOf(2));
                        } else {
                            qryDTO.setWorkDayNum(Integer.valueOf(1));
                        }
                        log.info(" \u7ade\u4ef7\u9700\u8981\u5904\u7406\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)qryDTO));
                        DycProSscWorkDayInfoDTO dycProSscWorkDayInfoDTO = this.dycProSscWorkDayRepository.selectWorkDayInfoByDateAndWorkDay(qryDTO);
                        log.info(" \u7ade\u4ef7\u9700\u8981\u5904\u7406\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4 \u5de5\u4f5c\u65e5 \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)dycProSscWorkDayInfoDTO));
                        long dateLong = dycProSscWorkDayInfoDTO.getWorkDayDate();
                        String dateString = String.valueOf(dateLong);
                        int year = Integer.parseInt(dateString.substring(0, 4));
                        int month = Integer.parseInt(dateString.substring(4, 6));
                        int day = Integer.parseInt(dateString.substring(6, 8));
                        LocalDate localDate = LocalDate.of(year, month, day);
                        LocalTime fixedTime = LocalTime.of(14, 0, 0);
                        LocalDateTime dateTime = LocalDateTime.of(localDate, fixedTime);
                        Date startDate = Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
                        updateConsult.setQuoteStartTime(startDate);
                        consultBaseInfo.getBiddingDurationMinutes();
                        LocalDateTime sourceDateTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                        LocalDateTime endDateTime = sourceDateTime.plusHours(consultBaseInfo.getBiddingDurationMinutes().intValue());
                        Date endDate = Date.from(endDateTime.atZone(ZoneId.systemDefault()).toInstant());
                        updateConsult.setQuoteEndTime(endDate);
                        log.info(" \u7ade\u4ef7\u9700\u8981\u5904\u7406\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)updateConsult));
                        DycProSscConsultQryDTO queryDTO = new DycProSscConsultQryDTO();
                        queryDTO.setConsultId(reqBO.getObjId());
                        DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultDetailById(queryDTO);
                        List supplierList = dycProSscConsultDTO.getSupplierInfoList();
                        for (DycProSscConsultSupplierInfoDTO supplier : supplierList) {
                            DycProSscCutPointDomReqBO dycProSscCutPointReqBO = new DycProSscCutPointDomReqBO();
                            dycProSscCutPointReqBO.setConsultId(dycProSscConsultDTO.getConsultId());
                            dycProSscCutPointReqBO.setSupplierId(supplier.getSupplierId());
                            dycProSscCutPointReqBO.setTodoType("SscJjQuote");
                            dycProSscCutPointReqBO.setCenter("SSC");
                            dycProSscCutPointReqBO.setShareId(dycProSscCutPointReqBO.getConsultId());
                            dycProSscCutPointReqBO.setObjId(dycProSscCutPointReqBO.getConsultId());
                            dycProSscCutPointReqBO.setObjType("2");
                            dycProSscCutPointReqBO.setBusiType(dycProSscCutPointReqBO.getTodoType());
                            dycProSscCutPointReqBO.setAuditOrderCode(dycProSscConsultDTO.getConsultNo());
                            log.info(" \u7ade\u4ef7\u9700\u8981\u53d1\u9001\u901a\u77e5\u5f85\u529e\u4fe1\u606f :{}", (Object)JSON.toJSONString((Object)dycProSscCutPointReqBO));
                            this.dycProSscCutPointDomService.todoCutPoint(dycProSscCutPointReqBO);
                        }
                    }
                    this.dycProSscConsultRepository.updateConsultBaseInfoById(updateConsult);
                } else if (PublicProcInstBusiType.CONSULT_INQUIRY_RESULT_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.CONSULT_BIDDING_RESULT_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    updateConsult = new DycProSscConsultDTO();
                    updateConsult.setConsultId(reqBO.getObjId());
                    updateConsult.setConsultStatus(Integer.valueOf(Integer.parseInt(DmcSscConsultStatus.RESULT_PENDING_PUBLICATION.getCode())));
                    this.dycProSscConsultRepository.updateConsultBaseInfoById(updateConsult);
                    this.dealNotifyInfoUpdate(reqBO);
                }
            } else if ("reject".equals(reqBO.getDealResult())) {
                if (PublicProcInstBusiType.SUPPLY_APPLY_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    updateSupplyApply = new DycProSscSupplyApplyInfoDTO();
                    updateSupplyApply.setSupplyApplyId(reqBO.getObjId());
                    updateSupplyApply.setStatus(Integer.valueOf(Integer.parseInt(DmcSscSupplyApplyInfoStatus.REJECT_APPROVAL.getCode())));
                    this.dycProSscSupplyApplyRepository.updateSupplyApplyStatus(updateSupplyApply);
                } else if (PublicProcInstBusiType.CONSULT_INQUIRY_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.CONSULT_BIDDING_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    updateConsult = new DycProSscConsultDTO();
                    updateConsult.setConsultId(reqBO.getObjId());
                    updateConsult.setConsultStatus(Integer.valueOf(Integer.parseInt(DmcSscConsultStatus.APPROVAL_REJECTED.getCode())));
                    this.dycProSscConsultRepository.updateConsultBaseInfoById(updateConsult);
                } else if (PublicProcInstBusiType.CONSULT_INQUIRY_RESULT_APPROVE.getCode().equals(reqBO.getBusiType()) || PublicProcInstBusiType.CONSULT_BIDDING_RESULT_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    updateConsult = new DycProSscConsultDTO();
                    updateConsult.setConsultId(reqBO.getObjId());
                    updateConsult.setConsultStatus(Integer.valueOf(Integer.parseInt(DmcSscConsultStatus.QUOTATION_APPROVAL_REJECTED.getCode())));
                    this.dycProSscConsultRepository.updateConsultBaseInfoById(updateConsult);
                }
            }
        }
        DycProSscCompleteApproveTaskRspBO rspBO = new DycProSscCompleteApproveTaskRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealNotifyInfoUpdate(DycProSscCompleteApproveTaskReqBO reqBO) {
        DycProSscConsultDTO consult = new DycProSscConsultDTO();
        consult.setConsultId(reqBO.getObjId());
        DycProSscConsultDTO consultBaseInfo = this.dycProSscConsultRepository.queryConsultBaseInfo(consult);
        if (consultBaseInfo == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u534f\u5546\u5355\u65e0\u6570\u636e");
        }
        DycProSscConsultSupplierInfoDTO qrySupplierInfoDTO = new DycProSscConsultSupplierInfoDTO();
        qrySupplierInfoDTO.setConsultId(reqBO.getObjId());
        qrySupplierInfoDTO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
        List supplierInfoDTOS = this.dycProSscConsultRepository.queryConsultSupplierList(qrySupplierInfoDTO);
        if (!CollectionUtils.isEmpty((Collection)supplierInfoDTOS)) {
            for (DycProSscConsultSupplierInfoDTO supplierInfoDTO : supplierInfoDTOS) {
                DycProSscConsultSupplierInfoDTO updateSupplier = new DycProSscConsultSupplierInfoDTO();
                updateSupplier.setInvitedId(supplierInfoDTO.getInvitedId());
                DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
                encodeSerialReqBO.setCenterCode("SSC");
                encodeSerialReqBO.setEncodeRuleCode("SSC_CONSULT_TYPE_RN");
                encodeSerialReqBO.setNum(Long.valueOf(1L));
                DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
                updateSupplier.setNotificationCode((String)encode.getSerialNoList().get(0));
                if (PublicProcInstBusiType.CONSULT_INQUIRY_RESULT_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    updateSupplier.setNotificationName(supplierInfoDTO.getSupplierName() + "-" + consultBaseInfo.getConsultName() + "\u8be2\u4ef7\u7ed3\u679c\u901a\u77e5");
                } else if (PublicProcInstBusiType.CONSULT_BIDDING_RESULT_APPROVE.getCode().equals(reqBO.getBusiType())) {
                    updateSupplier.setNotificationName(supplierInfoDTO.getSupplierName() + "-" + consultBaseInfo.getConsultName() + "\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5");
                }
                this.dycProSscConsultRepository.updateConsultSupplier(updateSupplier);
            }
        }
    }
}

