/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultAuditQryDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQryConsultAuditListPageService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscConsultAuditInfoBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQryConsultAuditListPageReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQryConsultAuditListPageRspBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQryConsultAuditListPageService"})
public class DycProSscQryConsultAuditListPageServiceImpl
implements DycProSscQryConsultAuditListPageService {
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;

    @Override
    @PostMapping(value={"qryConsultAuditListPage"})
    public DycProSscQryConsultAuditListPageRspBO qryConsultAuditListPage(@RequestBody DycProSscQryConsultAuditListPageReqBO reqBO) {
        this.checkParam(reqBO);
        DycProSscConsultAuditQryDTO consultAuditQryDTO = (DycProSscConsultAuditQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSscConsultAuditQryDTO.class);
        if (reqBO.getTabId() == 1) {
            consultAuditQryDTO.setFinishTag(Integer.valueOf(0));
            consultAuditQryDTO.setTaskUserId(reqBO.getUserId());
        } else if (reqBO.getTabId() == 2) {
            consultAuditQryDTO.setFinishTag(Integer.valueOf(1));
            consultAuditQryDTO.setDealUserId(reqBO.getUserId());
        }
        RspPage auditInfoBORspPage = this.dycProSscConsultRepository.queryConsultUniTaskPageList(consultAuditQryDTO);
        DycProSscQryConsultAuditListPageRspBO rspBO = new DycProSscQryConsultAuditListPageRspBO();
        rspBO.setTotal(auditInfoBORspPage.getTotal());
        rspBO.setRecordsTotal(auditInfoBORspPage.getRecordsTotal());
        rspBO.setRows(JSONArray.parseArray((String)JSON.toJSONString((Object)auditInfoBORspPage.getRows()), DycProSscConsultAuditInfoBO.class));
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            rspBO.getRows().forEach(auditInfoBO -> {
                if (!StringUtils.isEmpty((CharSequence)auditInfoBO.getBusiType())) {
                    auditInfoBO.setBusiTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"PublicProcInstBusiType", (String)auditInfoBO.getBusiType()));
                }
                if (auditInfoBO.getConsultStatus() != null) {
                    this.translateAuditStatus(reqBO.getTabId(), (DycProSscConsultAuditInfoBO)auditInfoBO);
                }
                if (!StringUtils.isEmpty((CharSequence)auditInfoBO.getDealResult())) {
                    auditInfoBO.setDealResultStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscAuditDealResult", (String)auditInfoBO.getDealResult().toString()));
                }
            });
        }
        return rspBO;
    }

    private void checkParam(DycProSscQryConsultAuditListPageReqBO reqBO) {
        if (reqBO == null) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTabId() == null) {
            throw new RuntimeException("\u5165\u53c2\u9875\u7b7eID\u4f20\u503c\u4e3a\u7a7a");
        }
    }

    private void translateAuditStatus(Integer tabId, DycProSscConsultAuditInfoBO auditInfoBO) {
        if (PublicProcInstBusiType.CONSULT_INQUIRY_APPROVE.getCode().equals(auditInfoBO.getBusiType()) || PublicProcInstBusiType.CONSULT_BIDDING_APPROVE.getCode().equals(auditInfoBO.getBusiType())) {
            if (tabId == 1) {
                if (auditInfoBO.getConsultStatus() == 1) {
                    auditInfoBO.setConsultStatusStr("\u5ba1\u6279\u4e2d");
                }
            } else if (auditInfoBO.getConsultStatus() == 1) {
                auditInfoBO.setConsultStatusStr("-");
            } else if (auditInfoBO.getConsultStatus() == 2) {
                auditInfoBO.setConsultStatusStr("\u5ba1\u6279\u901a\u8fc7");
            } else if (auditInfoBO.getConsultStatus() == 3) {
                auditInfoBO.setConsultStatusStr("\u5ba1\u6279\u9a73\u56de");
            }
        }
    }
}

