/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSupplierInfoDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQueryConsultQuoteInfoListService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscConsultQuoteInfoBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQueryConsultQuoteInfoListReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQueryConsultQuoteInfoListRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQueryConsultQuoteInfoListService"})
public class DycProSscQueryConsultQuoteInfoListServiceImpl
implements DycProSscQueryConsultQuoteInfoListService {
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;

    @Override
    @PostMapping(value={"queryConsultQuoteInfoList"})
    public DycProSscQueryConsultQuoteInfoListRspBO queryConsultQuoteInfoList(@RequestBody DycProSscQueryConsultQuoteInfoListReqBO reqBO) {
        if (reqBO.getConsultId() == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProSscConsultDTO consultDTO = new DycProSscConsultDTO();
        consultDTO.setConsultId(reqBO.getConsultId());
        DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultBaseInfo(consultDTO);
        DycProSscConsultSupplierInfoDTO qryDTO = (DycProSscConsultSupplierInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSscConsultSupplierInfoDTO.class);
        qryDTO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
        List dycProSscConsultQuoteInfoDTOS = this.dycProSscConsultRepository.queryConsultSupplierList(qryDTO);
        ArrayList dycProSscConsultQuoteInfoBOS = JSON.parseArray((String)JSON.toJSONString((Object)dycProSscConsultQuoteInfoDTOS), DycProSscConsultQuoteInfoBO.class);
        DycProSscQueryConsultQuoteInfoListRspBO rspBO = new DycProSscQueryConsultQuoteInfoListRspBO();
        if (!CollectionUtils.isEmpty((Collection)dycProSscConsultQuoteInfoBOS)) {
            rspBO.setAllRows(dycProSscConsultQuoteInfoBOS);
            for (DycProSscConsultQuoteInfoBO row : dycProSscConsultQuoteInfoBOS) {
                if (null != row.getQuoteTurn()) {
                    row.setQuoteTurnStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultQuoteTurn", (String)String.valueOf(row.getQuoteTurn())));
                }
                if (null != row.getQuoteStatus()) {
                    row.setQuoteStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultQuoteStatus", (String)String.valueOf(row.getQuoteStatus())));
                } else if (row.getQuoteCount() > 0L) {
                    row.setQuoteStatusStr("\u5df2\u62a5\u4ef7");
                } else {
                    row.setQuoteStatusStr("\u672a\u62a5\u4ef7");
                }
                if (!dycProSscConsultDTO.getQuoteEndTime().after(new Date())) continue;
                row.setQuoteTotalAmount(null);
            }
            dycProSscConsultQuoteInfoBOS = new ArrayList(dycProSscConsultQuoteInfoBOS.stream().collect(Collectors.toMap(DycProSscConsultQuoteInfoBO::getSupplierId, Function.identity(), (a, b) -> a.getQuoteTurn() > b.getQuoteTurn() ? a : b)).values());
        }
        rspBO.setRows(dycProSscConsultQuoteInfoBOS);
        rspBO.setConsultItemCount(dycProSscConsultDTO.getConsultItemCount());
        rspBO.setQuoteStartTime(dycProSscConsultDTO.getQuoteStartTime());
        rspBO.setQuoteEndTime(dycProSscConsultDTO.getQuoteEndTime());
        return rspBO;
    }
}

