/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultHandleDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSupplierInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscFileInfoDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscCutPointService;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscReleaseConsultService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscCutPointReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscReleaseConsultReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscReleaseConsultRspBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.UocFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.xhtmlrenderer.pdf.ITextRenderer;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscReleaseConsultService"})
public class DycProSscReleaseConsultServiceImpl
implements DycProSscReleaseConsultService {
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;
    @Autowired
    private DycProSscCutPointService dycProSscCutPointService;
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Autowired
    private FileClient fileClient;

    @Override
    @PostMapping(value={"releaseConsult"})
    public DycProSscReleaseConsultRspBO releaseConsult(@RequestBody DycProSscReleaseConsultReqBO reqBO) {
        if (reqBO == null || reqBO.getConsultId() == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQuoteStartTime() == null) {
            throw new ZTBusinessException("\u62a5\u4ef7\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQuoteEndTime() == null) {
            throw new ZTBusinessException("\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProSscConsultDTO consultDTO = new DycProSscConsultDTO();
        consultDTO.setConsultId(reqBO.getConsultId());
        consultDTO.setPublishTime(new Date());
        consultDTO.setPublishUserId(reqBO.getUserId());
        consultDTO.setPublishUserName(reqBO.getName());
        consultDTO.setPublishOrgId(reqBO.getOrgId());
        consultDTO.setPublishOrgName(reqBO.getOrgName());
        consultDTO.setPublishOrgPath(reqBO.getOrgPath());
        consultDTO.setPublishCompanyId(reqBO.getCompanyId());
        consultDTO.setPublishCompanyName(reqBO.getCompanyName());
        consultDTO.setQuoteStartTime(reqBO.getQuoteStartTime());
        consultDTO.setQuoteEndTime(reqBO.getQuoteEndTime());
        consultDTO.setConsultStatus(DycProSscConstants.ConsultStatus.NOT_STARTED);
        this.dycProSscConsultRepository.updateConsultBaseInfoById(consultDTO);
        this.consultInvitationPDF(reqBO);
        DycProSscConsultQryDTO queryDTO = new DycProSscConsultQryDTO();
        queryDTO.setConsultId(reqBO.getConsultId());
        DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultDetailById(queryDTO);
        List supplierList = dycProSscConsultDTO.getSupplierInfoList();
        for (DycProSscConsultSupplierInfoDTO supplier : supplierList) {
            DycProSscCutPointReqBO dycProSscCutPointReqBO = new DycProSscCutPointReqBO();
            dycProSscCutPointReqBO.setConsultId(reqBO.getConsultId());
            dycProSscCutPointReqBO.setSupplierId(supplier.getSupplierId());
            if (DycProSscConstants.ConsultType.CONSULT_TYPE_XJ.equals(dycProSscConsultDTO.getConsultType())) {
                dycProSscCutPointReqBO.setTodoType("SscXjQuote");
            } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(dycProSscConsultDTO.getConsultType())) {
                dycProSscCutPointReqBO.setTodoType("SscJjQuote");
            } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(dycProSscConsultDTO.getConsultType())) {
                dycProSscCutPointReqBO.setTodoType("SendYjTurn");
            }
            dycProSscCutPointReqBO.setCenter("SSC");
            dycProSscCutPointReqBO.setShareId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjType("2");
            dycProSscCutPointReqBO.setBusiType(dycProSscCutPointReqBO.getTodoType());
            this.dycProSscCutPointService.todoCutPoint(dycProSscCutPointReqBO);
        }
        return new DycProSscReleaseConsultRspBO();
    }

    private void consultInvitationPDF(DycProSscReleaseConsultReqBO reqBO) {
        UocFile uocFile = this.convertHtmlToPdfBytes(reqBO);
        DycProSscConsultHandleDTO dto = new DycProSscConsultHandleDTO();
        dto.setObjId(reqBO.getConsultId());
        dto.setObjType(DycProSscConstants.SscFileObjType.CONSULT_INVITATION);
        ArrayList<DycProSscFileInfoDTO> fileInfoList = new ArrayList<DycProSscFileInfoDTO>();
        DycProSscFileInfoDTO dycProSscFileInfoDTO = new DycProSscFileInfoDTO();
        dycProSscFileInfoDTO.setFileUrl(uocFile.getUrl());
        dycProSscFileInfoDTO.setFileName(uocFile.getFilename());
        dycProSscFileInfoDTO.setModelInfo(reqBO.getModelInfo());
        fileInfoList.add(dycProSscFileInfoDTO);
        if (!CollectionUtils.isEmpty(reqBO.getFileInfoList())) {
            fileInfoList.addAll(JSON.parseArray((String)JSON.toJSONString(reqBO.getFileInfoList()), DycProSscFileInfoDTO.class));
        }
        dto.setFileInfoList(fileInfoList);
        this.dycProSscConsultRepository.updateFileByObj(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UocFile convertHtmlToPdfBytes(DycProSscReleaseConsultReqBO reqBO) {
        DycProSscConsultDTO dycProSscConsultDTO = new DycProSscConsultDTO();
        dycProSscConsultDTO.setConsultId(reqBO.getConsultId());
        dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultBaseInfo(dycProSscConsultDTO);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String html = reqBO.getModelInfo();
        UocFile uocFile1 = new UocFile();
        try {
            ITextRenderer renderer = new ITextRenderer();
            renderer.getFontResolver().addFont("templates/font/simsun.ttc", "Identity-H", false);
            renderer.setDocumentFromString(html);
            renderer.layout();
            renderer.getSharedContext().getTextRenderer().setSmoothingThreshold(0.0f);
            renderer.createPDF((OutputStream)os, false);
            renderer.finishPDF();
            os.flush();
            byte[] pdfBytes = os.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            UocFile uocFile = new UocFile();
            uocFile.setPath(this.instDataPath);
            uocFile.setInputStream(inputStream);
            uocFile.setFilename(dycProSscConsultDTO.getConsultNo() + "_" + dycProSscConsultDTO.getConsultName() + "_\u9080\u8bf7\u51fd.pdf");
            uocFile1 = this.uploadFile(uocFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return uocFile1;
    }

    private UocFile uploadFile(UocFile uocFile) {
        String fileUrl = this.fileClient.uploadFileByInputStream(uocFile.getPath() + "/" + UUID.randomUUID().toString().replace("-", ""), uocFile.getFilename(), uocFile.getInputStream());
        UocFile uocF = new UocFile();
        uocF.setUrl(fileUrl);
        uocF.setInputStream(uocFile.getInputStream());
        uocF.setFilename(uocFile.getFilename());
        return uocF;
    }
}

