/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.tydic.dyc.pro.dmc.service.consult.bo.CreatePDFBO;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PDFTemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(PDFTemplateUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreatePDFBO createPDF(Map<String, Object> data, String templateFileName) throws Exception {
        CreatePDFBO createPDFBo = new CreatePDFBO();
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setClassForTemplateLoading(PDFTemplateUtil.class, "/templates");
        ITextRenderer renderer = new ITextRenderer();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            renderer.getFontResolver().addFont("templates/font/simsun.ttc", "Identity-H", false);
            cfg.setEncoding(Locale.CHINA, "UTF-8");
            Template template = cfg.getTemplate(templateFileName, "UTF-8");
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            writer.flush();
            String html = writer.toString();
            log.info("html\u5185\u5bb9 {}", (Object)html);
            createPDFBo.setModelInfo(html);
            renderer.setDocumentFromString(html);
            renderer.layout();
            renderer.createPDF((OutputStream)out, false);
            renderer.finishPDF();
            out.flush();
            createPDFBo.setByteArrayOutputStream(out);
            CreatePDFBO createPDFBO = createPDFBo;
            return createPDFBO;
        }
    }

    @Test
    public void testCreatePDF() {
        File fontFile = new File("templates/font/simsun.ttc");
        if (!fontFile.exists()) {
            System.err.println("\u5b57\u4f53\u6587\u4ef6\u4e0d\u5b58\u5728");
        } else if (!fontFile.canRead()) {
            System.err.println("\u65e0\u6cd5\u8bfb\u53d6\u5b57\u4f53\u6587\u4ef6");
        } else {
            System.out.println("\u6587\u4ef6\u5927\u5c0f: " + fontFile.length() + " bytes");
        }
    }
}

