/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultHandleDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscFileInfoDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscSaveReleaseInviteService;
import com.tydic.dyc.pro.dmc.service.consult.bo.CreatePDFBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQueryConsultDetailRspBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscReleaseConsultReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscReleaseConsultRspBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.UocFile;
import com.tydic.dyc.pro.dmc.service.consult.impl.PDFTemplateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscSaveReleaseInviteService"})
public class DycProSscSaveReleaseInviteServiceImpl
implements DycProSscSaveReleaseInviteService {
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Autowired
    private FileClient fileClient;

    @Override
    @PostMapping(value={"saveReleaseInvite"})
    public DycProSscReleaseConsultRspBO saveReleaseInvite(@RequestBody DycProSscReleaseConsultReqBO reqBO) {
        if (reqBO == null || reqBO.getConsultId() == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProSscReleaseConsultRspBO rspBO = new DycProSscReleaseConsultRspBO();
        DycProSscFileInfoDTO dycProSscFileInfoDTO = new DycProSscFileInfoDTO();
        dycProSscFileInfoDTO.setObjId(reqBO.getConsultId());
        dycProSscFileInfoDTO.setObjType(DycProSscConstants.SscFileObjType.CONSULT_INVITATION);
        List dycProSscFileInfoDTOS = this.dycProSscConsultRepository.qryFileByObj(dycProSscFileInfoDTO);
        if (!CollectionUtils.isEmpty((Collection)dycProSscFileInfoDTOS)) {
            for (DycProSscFileInfoDTO proSscFileInfoDTO : dycProSscFileInfoDTOS) {
                if (!StringUtils.isNotBlank((CharSequence)proSscFileInfoDTO.getModelInfo())) continue;
                rspBO.setModelInfo(proSscFileInfoDTO.getModelInfo());
                return rspBO;
            }
        } else {
            UocFile uocFile = this.consultInvitationPDF(reqBO);
            DycProSscConsultHandleDTO dto = this.getDycProSscConsultHandleDTO(uocFile, reqBO.getConsultId());
            this.dycProSscConsultRepository.createFile(dto);
            rspBO.setModelInfo(uocFile.getModelInfo());
        }
        return rspBO;
    }

    private DycProSscConsultHandleDTO getDycProSscConsultHandleDTO(UocFile uocFile, Long consultId) {
        ArrayList<DycProSscFileInfoDTO> fileInfoList = new ArrayList<DycProSscFileInfoDTO>();
        DycProSscFileInfoDTO dycProSscFileInfoBO = new DycProSscFileInfoDTO();
        dycProSscFileInfoBO.setFileName(uocFile.getFilename());
        dycProSscFileInfoBO.setFileUrl(uocFile.getUrl());
        dycProSscFileInfoBO.setModelInfo(uocFile.getModelInfo());
        fileInfoList.add(dycProSscFileInfoBO);
        DycProSscConsultHandleDTO dto = new DycProSscConsultHandleDTO();
        dto.setObjId(consultId);
        dto.setObjType(DycProSscConstants.SscFileObjType.CONSULT_INVITATION);
        dto.setFileInfoList(fileInfoList);
        return dto;
    }

    private UocFile consultInvitationPDF(DycProSscReleaseConsultReqBO reqBO) {
        DycProSscConsultQryDTO dycProSscConsultQryDTO = new DycProSscConsultQryDTO();
        dycProSscConsultQryDTO.setConsultId(reqBO.getConsultId());
        DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultDetailById(dycProSscConsultQryDTO);
        DycProSscQueryConsultDetailRspBO rspBO = (DycProSscQueryConsultDetailRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)dycProSscConsultDTO), DycProSscQueryConsultDetailRspBO.class));
        if (rspBO.getAllowMissingItems() != null) {
            rspBO.setAllowMissingItemsStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultAllowMissingItems", (String)rspBO.getAllowMissingItems().toString()));
        }
        if (rspBO.getProductScopeType() != null) {
            rspBO.setProductScopeTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultProductScopeType", (String)rspBO.getProductScopeType().toString()));
        }
        if (rspBO.getConsultStatus() != null) {
            rspBO.setConsultStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultStatus", (String)rspBO.getConsultStatus().toString()));
        }
        ByteArrayOutputStream baos = null;
        OutputStream out = null;
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_XJ)) {
                data.put("consultName", dycProSscConsultDTO.getConsultName() + "\u8be2\u4ef7");
            } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
                data.put("consultName", dycProSscConsultDTO.getConsultName() + "\u7ade\u4ef7");
            } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_YJ)) {
                data.put("consultName", dycProSscConsultDTO.getConsultName() + "\u8bae\u4ef7");
            }
            data.put("rspBO", (Object)rspBO);
            data.put("reqBO", (Object)reqBO);
            data.put("consultItemInfoList", rspBO.getConsultItemInfoList());
            String filetemplateName = "consultInvitation.ftl";
            CreatePDFBO createPDFBo = PDFTemplateUtil.createPDF(data, filetemplateName);
            baos = createPDFBo.getByteArrayOutputStream();
            byte[] pdfBytes = baos.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            UocFile uocFile = new UocFile();
            uocFile.setPath(this.instDataPath);
            uocFile.setInputStream(inputStream);
            uocFile.setFilename(dycProSscConsultDTO.getConsultNo() + "_" + dycProSscConsultDTO.getConsultName() + "_\u9080\u8bf7\u51fd.pdf");
            UocFile uocFile1 = this.uploadFile(uocFile);
            uocFile1.setModelInfo(createPDFBo.getModelInfo());
            baos.close();
            UocFile uocFile2 = uocFile1;
            return uocFile2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private UocFile uploadFile(UocFile uocFile) {
        String fileUrl = this.fileClient.uploadFileByInputStream(uocFile.getPath() + "/" + UUID.randomUUID().toString().replace("-", ""), uocFile.getFilename(), uocFile.getInputStream());
        UocFile uocF = new UocFile();
        uocF.setUrl(fileUrl);
        uocF.setInputStream(uocFile.getInputStream());
        uocF.setFilename(uocFile.getFilename());
        return uocF;
    }
}

