/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.supplyapply.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscSupplyApplyRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscSupplyApplyItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscSupplyApplyQryDTO;
import com.tydic.dyc.pro.dmc.service.supplyapply.api.DycProSscReturnSupplyApplyItemService;
import com.tydic.dyc.pro.dmc.service.supplyapply.bo.DycProSscReturnSupplyApplyItemReqBO;
import com.tydic.dyc.pro.dmc.service.supplyapply.bo.DycProSscReturnSupplyApplyItemRspBO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.supplyapply.api.DycProSscReturnSupplyApplyItemService"})
public class DycProSscReturnSupplyApplyItemServiceImpl
implements DycProSscReturnSupplyApplyItemService {
    @Autowired
    private DycProSscSupplyApplyRepository dycProSscSupplyApplyRepository;

    @Override
    @PostMapping(value={"returnSupplyApplyItem"})
    public DycProSscReturnSupplyApplyItemRspBO returnSupplyApplyItem(@RequestBody DycProSscReturnSupplyApplyItemReqBO reqBO) {
        if (reqBO.getSupplyApplyItemIdList().isEmpty()) {
            throw new ZTBusinessException("\u5165\u53c2[supplyApplyItemIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getReturnReason())) {
            throw new ZTBusinessException("\u5165\u53c2[returnReason]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date now = new Date();
        List list = reqBO.getSupplyApplyItemIdList().stream().map(itemId -> {
            DycProSscSupplyApplyItemInfoDTO dto = new DycProSscSupplyApplyItemInfoDTO();
            dto.setSupplyApplyItemId(itemId);
            dto.setStatus(DycProSscConstants.SupplyApplyDetailStatus.RETURNED);
            dto.setReturnReason(reqBO.getReturnReason());
            dto.setReturnUserId(reqBO.getUserId());
            dto.setReturnUserName(reqBO.getUserName());
            dto.setReturnUserAccount(reqBO.getName());
            dto.setReturnOrgId(reqBO.getOrgId());
            dto.setReturnOrgName(reqBO.getOrgName());
            dto.setReturnOrgPath(reqBO.getOrgPath());
            dto.setReturnCompanyId(reqBO.getCompanyId());
            dto.setReturnCompanyName(reqBO.getCompanyName());
            dto.setReturnTime(now);
            return dto;
        }).collect(Collectors.toList());
        DycProSscSupplyApplyQryDTO qryDTO = new DycProSscSupplyApplyQryDTO();
        qryDTO.setItemList(list);
        this.dycProSscSupplyApplyRepository.updateSupplyApplyItem(qryDTO);
        return new DycProSscReturnSupplyApplyItemRspBO();
    }
}

