/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.dao.SscFileInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscSupplyApplyInfoMapper;
import com.tydic.dyc.pro.dmc.dao.SscSupplyApplyItemInfoMapper;
import com.tydic.dyc.pro.dmc.po.DycProQrySupplyApplyUniTaskPageUnAuditListQryPO;
import com.tydic.dyc.pro.dmc.po.SscFileInfoPO;
import com.tydic.dyc.pro.dmc.po.SscQrySupplyApplyUnionItemListPageReqPO;
import com.tydic.dyc.pro.dmc.po.SscSupplyApplyInfoPO;
import com.tydic.dyc.pro.dmc.po.SscSupplyApplyItemInfoPO;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscSupplyApplyRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscFileInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQrySupplyApplyUniTaskRspDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQrySupplyApplyUnionItemRspDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscSupplyApplyInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscSupplyApplyItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscSupplyApplyQryDTO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProSscSupplyApplyRepositoryImpl
implements DycProSscSupplyApplyRepository {
    @Autowired
    private SscSupplyApplyInfoMapper sscSupplyApplyInfoMapper;
    @Autowired
    private SscSupplyApplyItemInfoMapper sscSupplyApplyItemInfoMapper;
    @Autowired
    private SscFileInfoMapper sscFileInfoMapper;
    @Resource
    private DycProEncodeSerialService encodeSerialService;

    @Override
    public DycProSscSupplyApplyInfoDTO createSupplyApply(DycProSscSupplyApplyInfoDTO supplyApplyInfoDTO) {
        SscSupplyApplyInfoPO sscSupplyApplyInfoPO = (SscSupplyApplyInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)supplyApplyInfoDTO), SscSupplyApplyInfoPO.class);
        sscSupplyApplyInfoPO.setSupplyApplyId(Long.valueOf(Sequence.getInstance().nextId()));
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("SSC");
        encodeSerialReqBO.setEncodeRuleCode("SSC_SUPPLY_APPLY_CODE");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        sscSupplyApplyInfoPO.setSupplyApplyNo((String)encode.getSerialNoList().get(0));
        sscSupplyApplyInfoPO.setApplyTime(new Date());
        sscSupplyApplyInfoPO.setCreateTime(new Date());
        sscSupplyApplyInfoPO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
        this.sscSupplyApplyInfoMapper.insert((Object)sscSupplyApplyInfoPO);
        List detailInfoPOList = JSON.parseArray((String)JSON.toJSONString(supplyApplyInfoDTO.getItemList()), SscSupplyApplyItemInfoPO.class);
        detailInfoPOList.forEach(item -> {
            item.setSupplyApplyItemId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setSupplyApplyId(sscSupplyApplyInfoPO.getSupplyApplyId());
        });
        this.sscSupplyApplyItemInfoMapper.insertBatch((Collection)detailInfoPOList);
        this.addSscFileInfo(supplyApplyInfoDTO, sscSupplyApplyInfoPO.getSupplyApplyId());
        supplyApplyInfoDTO.setSupplyApplyId(sscSupplyApplyInfoPO.getSupplyApplyId());
        supplyApplyInfoDTO.setSupplyApplyNo(sscSupplyApplyInfoPO.getSupplyApplyNo());
        return supplyApplyInfoDTO;
    }

    @Override
    public void updateSupplyApply(DycProSscSupplyApplyInfoDTO supplyApplyInfoDTO) {
        SscSupplyApplyInfoPO sscSupplyApplyInfoPO = (SscSupplyApplyInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)supplyApplyInfoDTO), SscSupplyApplyInfoPO.class);
        sscSupplyApplyInfoPO.setUpdateTime(new Date());
        this.sscSupplyApplyInfoMapper.updateById((Object)sscSupplyApplyInfoPO);
        this.sscSupplyApplyItemInfoMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(null != supplyApplyInfoDTO.getSupplyApplyId(), SscSupplyApplyItemInfoPO::getSupplyApplyId, (Object)supplyApplyInfoDTO.getSupplyApplyId()));
        List detailInfoPOList = JSON.parseArray((String)JSON.toJSONString(supplyApplyInfoDTO.getItemList()), SscSupplyApplyItemInfoPO.class);
        detailInfoPOList.forEach(item -> {
            item.setSupplyApplyItemId(Long.valueOf(Sequence.getInstance().nextId()));
            item.setSupplyApplyId(sscSupplyApplyInfoPO.getSupplyApplyId());
        });
        this.sscSupplyApplyItemInfoMapper.insertBatch((Collection)detailInfoPOList);
        this.sscFileInfoMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != supplyApplyInfoDTO.getSupplyApplyId(), SscFileInfoPO::getObjId, (Object)supplyApplyInfoDTO.getSupplyApplyId())).eq(SscFileInfoPO::getObjType, (Object)DycProSscConstants.SscFileObjType.SUPPLY_APPLY));
        this.addSscFileInfo(supplyApplyInfoDTO, sscSupplyApplyInfoPO.getSupplyApplyId());
    }

    @Override
    public DycProSscSupplyApplyInfoDTO queryApplyMainInfo(DycProSscSupplyApplyInfoDTO qryDTO) {
        SscSupplyApplyInfoPO sscSupplyApplyInfoPO = (SscSupplyApplyInfoPO)this.sscSupplyApplyInfoMapper.selectById((Serializable)qryDTO.getSupplyApplyId());
        DycProSscSupplyApplyInfoDTO dycProSscSupplyApplyInfoDTO = new DycProSscSupplyApplyInfoDTO();
        BeanUtils.copyProperties((Object)sscSupplyApplyInfoPO, (Object)dycProSscSupplyApplyInfoDTO);
        List sscFileInfoPOList = this.sscFileInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscFileInfoPO::getObjId, (Object)qryDTO.getSupplyApplyId())).eq(SscFileInfoPO::getObjType, (Object)DycProSscConstants.SscFileObjType.SUPPLY_APPLY));
        if (!CollectionUtils.isEmpty((Collection)sscFileInfoPOList)) {
            dycProSscSupplyApplyInfoDTO.setFileInfoList(JSON.parseArray((String)JSON.toJSONString((Object)sscFileInfoPOList), DycProSscFileInfoDTO.class));
        }
        return dycProSscSupplyApplyInfoDTO;
    }

    private void addSscFileInfo(DycProSscSupplyApplyInfoDTO DycProSscSupplyApplyInfoDTO2, Long supplyApplyId) {
        List fileInfoPOS = DycProSscSupplyApplyInfoDTO2.getFileInfoList().stream().map(fileInfo -> {
            SscFileInfoPO sscFileInfoPO = (SscFileInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)fileInfo), SscFileInfoPO.class);
            sscFileInfoPO.setSscFileId(Long.valueOf(Sequence.getInstance().nextId()));
            sscFileInfoPO.setObjId(supplyApplyId);
            sscFileInfoPO.setObjType(DycProSscConstants.SscFileObjType.SUPPLY_APPLY);
            return sscFileInfoPO;
        }).collect(Collectors.toList());
        this.sscFileInfoMapper.insertBatch(fileInfoPOS);
    }

    @Override
    public RspPage<DycProSscQrySupplyApplyUnionItemRspDTO> qrySupplyApplyUnionItemPageList(DycProSscSupplyApplyQryDTO qryDTO) {
        RspPage rspPage = new RspPage();
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        SscQrySupplyApplyUnionItemListPageReqPO sscQrySupplyApplyUnionItemListPageReqPO = (SscQrySupplyApplyUnionItemListPageReqPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDTO), SscQrySupplyApplyUnionItemListPageReqPO.class);
        if (!qryDTO.getItemList().isEmpty()) {
            DycProSscSupplyApplyItemInfoDTO dycProSscSupplyApplyItemInfoDTO = qryDTO.getItemList().get(0);
            sscQrySupplyApplyUnionItemListPageReqPO.setManageCatalogId(dycProSscSupplyApplyItemInfoDTO.getManageCatalogId());
            sscQrySupplyApplyUnionItemListPageReqPO.setManageCatalogPath(dycProSscSupplyApplyItemInfoDTO.getManageCatalogPath());
            sscQrySupplyApplyUnionItemListPageReqPO.setContactName(dycProSscSupplyApplyItemInfoDTO.getContactName());
            sscQrySupplyApplyUnionItemListPageReqPO.setStatus(dycProSscSupplyApplyItemInfoDTO.getStatus());
            sscQrySupplyApplyUnionItemListPageReqPO.setProductName(dycProSscSupplyApplyItemInfoDTO.getProductName());
        }
        if (CollectionUtils.isEmpty((Collection)(page = this.sscSupplyApplyItemInfoMapper.qrySupplyApplyUnionItemPageList(page, sscQrySupplyApplyUnionItemListPageReqPO)).getRecords())) {
            return rspPage;
        }
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()), DycProSscQrySupplyApplyUnionItemRspDTO.class));
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<DycProSscSupplyApplyItemInfoDTO> queryApplyItemListPage(DycProSscSupplyApplyQryDTO qryDTO) {
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        Page sscSupplyApplyItemInfoPOPage = (Page)this.sscSupplyApplyItemInfoMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SscSupplyApplyItemInfoPO::getSupplyApplyId, (Object)qryDTO.getSupplyApplyId())).orderByAsc(SscSupplyApplyItemInfoPO::getNum));
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)sscSupplyApplyItemInfoPOPage.getRecords())) {
            rspPage.setPageNo(Math.toIntExact(sscSupplyApplyItemInfoPOPage.getCurrent()));
            rspPage.setTotal(Math.toIntExact(sscSupplyApplyItemInfoPOPage.getPages()));
            rspPage.setRecordsTotal(Math.toIntExact(sscSupplyApplyItemInfoPOPage.getTotal()));
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)sscSupplyApplyItemInfoPOPage.getRecords()), DycProSscSupplyApplyItemInfoDTO.class));
        }
        return rspPage;
    }

    @Override
    public void updateSupplyApplyItem(DycProSscSupplyApplyQryDTO qryDTO) {
        this.sscSupplyApplyItemInfoMapper.updateBatchByIds((Collection)JSON.parseArray((String)JSON.toJSONString(qryDTO.getItemList()), SscSupplyApplyItemInfoPO.class));
    }

    @Override
    public void deleteApply(DycProSscSupplyApplyInfoDTO dycProSscSupplyApplyInfoDTO) {
        SscSupplyApplyInfoPO sscSupplyApplyInfoPO = (SscSupplyApplyInfoPO)this.sscSupplyApplyInfoMapper.selectById((Serializable)dycProSscSupplyApplyInfoDTO.getSupplyApplyId());
        if (DycProSscConstants.SupplyApplyStatus.AUDITING.equals(sscSupplyApplyInfoPO.getStatus())) {
            throw new ZTBusinessException("\u4f9b\u8d27\u7533\u8bf7\u6b63\u5728\u5ba1\u6279\u4e2d\uff0c\u8bf7\u52ff\u5220\u9664");
        }
        SscSupplyApplyInfoPO updateSscSupplyApplyInfo = new SscSupplyApplyInfoPO();
        BeanUtils.copyProperties((Object)dycProSscSupplyApplyInfoDTO, (Object)updateSscSupplyApplyInfo);
        updateSscSupplyApplyInfo.setDelFlag(DycProSscConstants.DEL_FLAG.DELETE);
        updateSscSupplyApplyInfo.setUpdateTime(new Date());
        this.sscSupplyApplyInfoMapper.updateById((Object)updateSscSupplyApplyInfo);
    }

    @Override
    public RspPage<DycProSscSupplyApplyInfoDTO> queryApplyListPage(DycProSscSupplyApplyQryDTO qryDTO) {
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        Page sscSupplyApplyInfoPOPage = (Page)this.sscSupplyApplyInfoMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(StringUtils.isNotEmpty((CharSequence)qryDTO.getSupplyApplyNo()), SscSupplyApplyInfoPO::getSupplyApplyNo, (Object)qryDTO.getSupplyApplyNo())).like(StringUtils.isNotEmpty((CharSequence)qryDTO.getSupplyApplyTitle()), SscSupplyApplyInfoPO::getSupplyApplyTitle, (Object)qryDTO.getSupplyApplyTitle())).eq(null != qryDTO.getPurchaseForm(), SscSupplyApplyInfoPO::getPurchaseForm, (Object)qryDTO.getPurchaseForm())).eq(null != qryDTO.getStatus(), SscSupplyApplyInfoPO::getStatus, (Object)qryDTO.getStatus())).eq(null != qryDTO.getCreateUserId(), SscSupplyApplyInfoPO::getCreateUserId, (Object)qryDTO.getCreateUserId())).eq(SscSupplyApplyInfoPO::getDelFlag, (Object)DycProSscConstants.DEL_FLAG.UN_DELETE)).orderByDesc(SscSupplyApplyInfoPO::getCreateTime));
        RspPage rspPage = new RspPage();
        if (!CollectionUtils.isEmpty((Collection)sscSupplyApplyInfoPOPage.getRecords())) {
            rspPage.setPageNo(Math.toIntExact(sscSupplyApplyInfoPOPage.getCurrent()));
            rspPage.setTotal(Math.toIntExact(sscSupplyApplyInfoPOPage.getPages()));
            rspPage.setRecordsTotal(Math.toIntExact(sscSupplyApplyInfoPOPage.getTotal()));
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)sscSupplyApplyInfoPOPage.getRecords()), DycProSscSupplyApplyInfoDTO.class));
        }
        return rspPage;
    }

    @Override
    public RspPage<DycProSscQrySupplyApplyUniTaskRspDTO> querySupplyApplyUniTaskPageList(DycProSscSupplyApplyQryDTO qryDTO) {
        DycProQrySupplyApplyUniTaskPageUnAuditListQryPO qryPO = new DycProQrySupplyApplyUniTaskPageUnAuditListQryPO();
        BeanUtils.copyProperties((Object)qryDTO, (Object)qryPO);
        RspPage rspPage = new RspPage();
        Page page = new Page((long)qryDTO.getPageNo(), (long)qryDTO.getPageSize());
        if (qryDTO.getTabId() == 1) {
            page = this.sscSupplyApplyInfoMapper.qrySupplyApplyUniTaskPageUnAuditList(page, qryPO);
        } else if (qryDTO.getTabId() == 2) {
            page = this.sscSupplyApplyInfoMapper.qrySupplyApplyUniTaskAuditedPageList(page, qryPO);
        }
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return rspPage;
        }
        rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)page.getRecords()), DycProSscQrySupplyApplyUniTaskRspDTO.class));
        rspPage.setPageNo((int)page.getCurrent());
        rspPage.setTotal((int)page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Override
    public void updateSupplyApplyStatus(DycProSscSupplyApplyInfoDTO dycProSscSupplyApplyInfoDTO) {
        SscSupplyApplyInfoPO updateSscSupplyApplyInfo = new SscSupplyApplyInfoPO();
        BeanUtils.copyProperties((Object)dycProSscSupplyApplyInfoDTO, (Object)updateSscSupplyApplyInfo);
        updateSscSupplyApplyInfo.setUpdateTime(new Date());
        this.sscSupplyApplyInfoMapper.updateById((Object)updateSscSupplyApplyInfo);
        this.sscSupplyApplyItemInfoMapper.update((Object)new SscSupplyApplyItemInfoPO(), (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(SscSupplyApplyItemInfoPO::getSupplyApplyId, (Object)dycProSscSupplyApplyInfoDTO.getSupplyApplyId())).set(SscSupplyApplyItemInfoPO::getStatus, (Object)DycProSscConstants.SupplyApplyDetailStatus.UNINQUIRY));
    }
}

