/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.approve.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderApprovalObjDTO;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.approve.api.DycProOrderCompleteApproveTaskService;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderCompleteApproveTaskReqBO;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderCompleteApproveTaskRspBO;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderPublicTaskInstBO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderAccessoryApiBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.approve.api.DycProOrderCompleteApproveTaskService"})
public class DycProOrderCompleteApproveTaskServiceImpl
implements DycProOrderCompleteApproveTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCompleteApproveTaskServiceImpl.class);
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;

    @PostMapping(value={"completeApproveTask"})
    public DycProOrderCompleteApproveTaskRspBO completeApproveTask(@RequestBody DycProOrderCompleteApproveTaskReqBO reqBO) {
        DycProOrderCompleteApproveTaskRspBO rspBO = new DycProOrderCompleteApproveTaskRspBO();
        DycProPublicTaskInstHandleDTO flowTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
        BeanUtils.copyProperties((Object)reqBO, (Object)flowTaskInstHandleDto);
        this.dycProPublicTaskInstRepository.completeFlowTask(flowTaskInstHandleDto);
        if (reqBO.getIsFinish().booleanValue()) {
            if ("BudgetApprove".equals(reqBO.getBusiType())) {
                log.info("\u5904\u7406\u9884\u7b97\u5ba1\u6279\uff0c\u9884\u7b97ID: {}, \u5ba1\u6279\u7ed3\u679c: {}", (Object)reqBO.getObjId(), (Object)reqBO.getDealResult());
                Integer budgetStatus = "pass".equals(reqBO.getDealResult()) ? DycProOrderApiServiceConstant.BudgetStatus.PENDING_EFFECTIVE : DycProOrderApiServiceConstant.BudgetStatus.REJECTED;
                int updateResult = this.dycProOrderBudgetRepository.updateBudgetStatus(reqBO.getObjId(), budgetStatus);
                if (updateResult <= 0) {
                    throw new ZTBusinessException("\u9884\u7b97\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u9884\u7b97ID: " + reqBO.getObjId());
                }
                log.info("\u9884\u7b97\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff0c\u9884\u7b97ID: {}, \u65b0\u72b6\u6001: {}", (Object)reqBO.getObjId(), (Object)budgetStatus);
            } else {
                DycProOrderApprovalObjDTO approvalObjDTO = new DycProOrderApprovalObjDTO();
                approvalObjDTO.setAuditOrderId(reqBO.getObjId());
                DycProOrderApprovalObjDTO approvalObjDto = this.dycProOrderApproveRepository.queryApprovalObjOneById(approvalObjDTO);
                if (DycProOrderApiServiceConstant.OBJ_BUSI_TYPE.ORDER.equals(approvalObjDto.getObjBusiType())) {
                    ArrayList<Object> taskInsts = new ArrayList<Object>();
                    DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
                    saleOrderDTO.setOrderId(Long.valueOf(approvalObjDto.getObjId()));
                    List saleOrderDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderListByCondition(saleOrderDTO);
                    for (DycProOrderSaleOrderDTO saleOrder : saleOrderDTOList) {
                        if ("XS_QX_QX".equals(saleOrder.getSaleOrderState()) || "XS_XD_SB".equals(saleOrder.getSaleOrderState())) continue;
                        DycProPublicTaskInstDTO publicTaskInstDTO = new DycProPublicTaskInstDTO();
                        publicTaskInstDTO.setObjId(saleOrder.getSaleOrderId());
                        publicTaskInstDTO.setObjType("salesOrder");
                        publicTaskInstDTO.setFinishTag(Integer.valueOf(0));
                        List taskInstDTOS = this.dycProPublicTaskInstRepository.queryFlowTaskList(publicTaskInstDTO);
                        if (CollectionUtils.isEmpty((Collection)taskInstDTOS) || taskInstDTOS.size() != 1) {
                            throw new ZTBusinessException("\u67e5\u8be2\u5f85\u5904\u7406\u4e1a\u52a1\u6d41\u4efb\u52a1\u9519\u8bef\uff01");
                        }
                        DycProPublicTaskInstDTO taskInstDTO = (DycProPublicTaskInstDTO)taskInstDTOS.get(0);
                        taskInsts.add(JSON.parseObject((String)JSON.toJSONString((Object)taskInstDTO), DycProOrderPublicTaskInstBO.class));
                        DycProPublicTaskInstHandleDTO busiTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
                        busiTaskInstHandleDto.setTaskInstId(taskInstDTO.getTaskInstId());
                        this.dycProPublicTaskInstRepository.completeBusiFlowTask(busiTaskInstHandleDto);
                        if (!"reject".equals(reqBO.getDealResult())) continue;
                        DycProOrderSaleOrderDTO updaeSaleOrderDTO = new DycProOrderSaleOrderDTO();
                        updaeSaleOrderDTO.setSaleOrderId(saleOrder.getSaleOrderId());
                        updaeSaleOrderDTO.setSaleOrderState("XS_QX_QX");
                        updaeSaleOrderDTO.setCancelReason(reqBO.getDealRemark());
                        updaeSaleOrderDTO.setCancelOperId(reqBO.getDealUserId().toString());
                        updaeSaleOrderDTO.setCancelOperName(reqBO.getDealUserName());
                        updaeSaleOrderDTO.setCancelTime(new Date());
                        updaeSaleOrderDTO.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.APPROVE_CANCEL);
                        updaeSaleOrderDTO.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
                        this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updaeSaleOrderDTO, true);
                        if (CollectionUtils.isEmpty((Collection)reqBO.getApprovelOrderFileList())) continue;
                        ArrayList<DycProOrderOrderAccessoryDTO> cancelOrderFileList = new ArrayList<DycProOrderOrderAccessoryDTO>();
                        for (DycProOrderAccessoryApiBO accessoryBO : reqBO.getApprovelOrderFileList()) {
                            DycProOrderOrderAccessoryDTO addAccessoryDTO = new DycProOrderOrderAccessoryDTO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)addAccessoryDTO);
                            addAccessoryDTO.setObjId(saleOrder.getSaleOrderId());
                            addAccessoryDTO.setOrderId(saleOrder.getOrderId());
                            addAccessoryDTO.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.SALE_ORDER_CANCEL);
                            cancelOrderFileList.add(addAccessoryDTO);
                        }
                        this.dycProOrderOrderRepository.addAllKindsAccessoryBatch(cancelOrderFileList);
                    }
                    rspBO.setTaskInsts(taskInsts);
                }
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

