/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.budget.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetFileInfoDTO;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetInfoDTO;
import com.tydic.dyc.pro.egc.service.budget.api.DycProOrderSubmitBudgetService;
import com.tydic.dyc.pro.egc.service.budget.bo.DycProOrderSubmitBudgetReqBO;
import com.tydic.dyc.pro.egc.service.budget.bo.DycProOrderSubmitBudgetRspBO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.budget.api.DycProOrderSubmitBudgetService"})
public class DycProOrderSubmitBudgetServiceImpl
implements DycProOrderSubmitBudgetService {
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;

    @PostMapping(value={"submitBudget"})
    public DycProOrderSubmitBudgetRspBO submitBudget(@RequestBody DycProOrderSubmitBudgetReqBO reqBO) {
        this.val(reqBO);
        DycProOrderSubmitBudgetRspBO rspBO = new DycProOrderSubmitBudgetRspBO();
        try {
            DycProOrderBudgetInfoDTO budgetInfoDTO = this.buildBudgetInfoDTO(reqBO);
            List fileInfoList = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getFileInfoList()), DycProOrderBudgetFileInfoDTO.class);
            budgetInfoDTO.setBudgetFileInfoList(fileInfoList);
            Long budgetId = this.dycProOrderBudgetRepository.addBudgetAllInfo(budgetInfoDTO);
            rspBO.setBudgetId(budgetId);
            rspBO.setBudgetCode(budgetInfoDTO.getBudgetCode());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u9884\u7b97\u63d0\u4ea4\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rspBO;
    }

    private DycProOrderBudgetInfoDTO buildBudgetInfoDTO(DycProOrderSubmitBudgetReqBO reqBO) {
        DycProOrderBudgetInfoDTO budgetInfoDTO = new DycProOrderBudgetInfoDTO();
        budgetInfoDTO.setBudgetName(reqBO.getBudgetName());
        budgetInfoDTO.setBudgetOriginalAmount(reqBO.getBudgetOriginalAmount());
        budgetInfoDTO.setBudgetTotalAmount(reqBO.getBudgetOriginalAmount());
        budgetInfoDTO.setBudgetUsedAmount(BigDecimal.ZERO);
        budgetInfoDTO.setBudgetSurplusAmount(reqBO.getBudgetOriginalAmount());
        budgetInfoDTO.setBudgetStatus(DycProOrderApiServiceConstant.BudgetStatus.DRAFT);
        budgetInfoDTO.setEffectiveTime(reqBO.getEffectiveTime());
        budgetInfoDTO.setInvalidTime(reqBO.getInvalidTime());
        budgetInfoDTO.setRemark(reqBO.getRemark());
        budgetInfoDTO.setCreateUserId(String.valueOf(reqBO.getUserId()));
        budgetInfoDTO.setCreateUserName(reqBO.getName());
        budgetInfoDTO.setCreateUserAccount(reqBO.getUserName());
        budgetInfoDTO.setCreateOrgId(reqBO.getOrgId());
        budgetInfoDTO.setCreateOrgName(reqBO.getOrgName());
        budgetInfoDTO.setCreateOrgPath(reqBO.getOrgPath());
        budgetInfoDTO.setCreateCompanyId(reqBO.getCompanyId());
        budgetInfoDTO.setCreateCompanyName(reqBO.getCompanyName());
        budgetInfoDTO.setCreateTime(new Date());
        return budgetInfoDTO;
    }

    private void val(DycProOrderSubmitBudgetReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBudgetName() == null || reqBO.getBudgetName().trim().isEmpty()) {
            throw new ZTBusinessException("\u9884\u7b97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal budgetAmount = reqBO.getBudgetOriginalAmount();
        if (budgetAmount == null || budgetAmount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ZTBusinessException("\u9884\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (budgetAmount.scale() > 2) {
            throw new ZTBusinessException("\u9884\u7b97\u91d1\u989d\u5c0f\u6570\u4e0d\u80fd\u8d85\u8fc7\u4e24\u4f4d");
        }
        BigDecimal normalized = budgetAmount.abs().stripTrailingZeros();
        int integerDigits = normalized.precision() - normalized.scale();
        if (integerDigits > 15) {
            throw new ZTBusinessException("\u9884\u7b97\u91d1\u989d\u6574\u6570\u4e0d\u80fd\u8d85\u8fc715\u4f4d");
        }
        if (reqBO.getEffectiveTime() == null) {
            throw new ZTBusinessException("\u9884\u7b97\u751f\u6548\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvalidTime() == null) {
            throw new ZTBusinessException("\u9884\u7b97\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LocalDate effectiveDate = this.toLocalDate(reqBO.getEffectiveTime());
        LocalDate invalidDate = this.toLocalDate(reqBO.getInvalidTime());
        LocalDate today = LocalDate.now();
        if (effectiveDate.isBefore(today)) {
            throw new ZTBusinessException("\u9884\u7b97\u751f\u6548\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        if (!invalidDate.isAfter(effectiveDate)) {
            throw new ZTBusinessException("\u9884\u7b97\u5931\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u751f\u6548\u8d77\u59cb\u65e5\u671f");
        }
        if (this.dycProOrderBudgetRepository.existsByBudgetNameAndCompanyId(reqBO.getBudgetName(), reqBO.getCompanyId())) {
            throw new ZTBusinessException("\u9884\u7b97\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }

    private LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

