/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderAdjustPurApplyItemCountDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderInterLogDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderDealAfOrderMsgApiService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealAfOrderMsgAfOrderItemApiBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealAfOrderMsgApiReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealAfOrderMsgApiRspBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealAfOrderMsgResultApiBO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderDealAfOrderMsgApiService"})
public class DycProOrderDealAfOrderMsgApiServiceImpl
implements DycProOrderDealAfOrderMsgApiService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderDealAfOrderMsgApiServiceImpl.class);
    @Value(value="${call.ty.url.deleteContractUrlForTy}")
    private String deleteContractUrlForTy;
    @Value(value="${call.ty.deleteContractMethodNameForTy}")
    private String deleteContractMethodNameForTy;
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;

    @PostMapping(value={"dealAfOrderMsg"})
    public DycProOrderDealAfOrderMsgApiRspBO dealAfOrderMsg(@RequestBody DycProOrderDealAfOrderMsgApiReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderOrderQueryIndexDTO orderQueryIndexInfo = this.getOrderQueryIndexInfo(reqBO.getExtAfId());
        DycProOrderAfOrderDTO afOrderMainInfo = this.getAfOrderMainInfo(orderQueryIndexInfo.getObjId());
        DycProOrderDealAfOrderMsgResultApiBO dealAfOrderMsgResultBO = this.dealAfOrderRelatedData(reqBO, afOrderMainInfo);
        DycProOrderDealAfOrderMsgApiRspBO rspBO = new DycProOrderDealAfOrderMsgApiRspBO();
        rspBO.setConsumeFlag(dealAfOrderMsgResultBO.getConsumeFlag());
        rspBO.setServType(afOrderMainInfo.getServType());
        rspBO.setMsgAfOrderItemList(dealAfOrderMsgResultBO.getMsgAfOrderItemList());
        return rspBO;
    }

    private void paramVerify(DycProOrderDealAfOrderMsgApiReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getExtAfId())) {
            throw new ZTBusinessException("\u5916\u90e8\u552e\u540e\u670d\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getEcDealFlag()) {
            throw new ZTBusinessException("\u7535\u5546\u5904\u7406\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getEcPushTime()) {
            throw new ZTBusinessException("\u7535\u5546\u63a8\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private DycProOrderOrderQueryIndexDTO getOrderQueryIndexInfo(String extAfId) {
        DycProOrderOrderQueryIndexDTO queryOrderQueryIndex = new DycProOrderOrderQueryIndexDTO();
        queryOrderQueryIndex.setOutObjId(extAfId);
        queryOrderQueryIndex.setObjType(DycProOrderApiServiceConstant.ObjType.AFTER);
        DycProOrderOrderQueryIndexDTO orderQueryIndexDTO = this.dycProOrderOrderRepository.queryOrderQueryIndexQryOneByCondition(queryOrderQueryIndex);
        if (null == orderQueryIndexDTO) {
            throw new ZTBusinessException("\u5916\u90e8\u552e\u540e\u5355\u53f7\u5173\u8054\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return orderQueryIndexDTO;
    }

    private DycProOrderAfOrderDTO getAfOrderMainInfo(Long afOrderId) {
        DycProOrderAfOrderDTO queryAfOrder = new DycProOrderAfOrderDTO();
        queryAfOrder.setAfOrderId(afOrderId);
        DycProOrderAfOrderDTO afOrderDTO = this.dycProOrderAfOrderRepository.queryAfOrderOneByCondition(queryAfOrder);
        if (null == afOrderDTO) {
            throw new ZTBusinessException("\u67e5\u8be2\u552e\u540e\u5355\u4e3b\u4f53\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return afOrderDTO;
    }

    private List<DycProOrderAfOrderItemDTO> getAfOrderItemList(Long afOrderId) {
        DycProOrderAfOrderItemDTO queryAfOrderItem = new DycProOrderAfOrderItemDTO();
        queryAfOrderItem.setAfOrderId(afOrderId);
        List afOrderItemDTOList = this.dycProOrderAfOrderRepository.queryAfOrderItemListByCondition(queryAfOrderItem);
        if (CollectionUtils.isEmpty((Collection)afOrderItemDTOList)) {
            throw new ZTBusinessException("\u552e\u540e\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        return afOrderItemDTOList;
    }

    private DycProOrderAfOrderObjDTO getAfOrderObjInfo(Long afOrderId) {
        DycProOrderAfOrderObjDTO queryAfOrderObj = new DycProOrderAfOrderObjDTO();
        queryAfOrderObj.setAfOrderId(afOrderId);
        queryAfOrderObj.setDelTag(DycProOrderApiServiceConstant.DelTag.NOT_DEL);
        DycProOrderAfOrderObjDTO afOrderObjDTO = this.dycProOrderAfOrderRepository.queryAfOrderObjOneByCondition(queryAfOrderObj);
        if (null == afOrderObjDTO) {
            throw new ZTBusinessException("\u552e\u540e\u5355\u5bf9\u8c61\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return afOrderObjDTO;
    }

    private List<DycProOrderShipOrderItemDTO> getShipOrderItemList(Long shipOrderId) {
        DycProOrderShipOrderItemQryDTO queryShipOrderItem = new DycProOrderShipOrderItemQryDTO();
        queryShipOrderItem.setShipOrderId(shipOrderId);
        List shipOrderItemDTOList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(queryShipOrderItem);
        if (CollectionUtils.isEmpty((Collection)shipOrderItemDTOList)) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        return shipOrderItemDTOList;
    }

    private List<DycProOrderSaleOrderItemDTO> getSaleOrderItemList(Long saleOrderId) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItem = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItem.setSaleOrderId(saleOrderId);
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItem);
        if (CollectionUtils.isEmpty((Collection)saleOrderItemDTOList)) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        return saleOrderItemDTOList;
    }

    private DycProOrderSaleOrderDTO getSaleOrderMainInfo(Long saleOrderId) {
        DycProOrderSaleOrderDTO querySaleOrder = new DycProOrderSaleOrderDTO();
        querySaleOrder.setSaleOrderId(saleOrderId);
        DycProOrderSaleOrderDTO saleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrder);
        if (null == saleOrderDTO) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return saleOrderDTO;
    }

    private DycProOrderDealAfOrderMsgResultApiBO dealAfOrderRelatedData(DycProOrderDealAfOrderMsgApiReqBO reqBO, DycProOrderAfOrderDTO afOrderMainInfo) {
        DycProOrderDealAfOrderMsgResultApiBO dealAfOrderMsgResultBO = new DycProOrderDealAfOrderMsgResultApiBO();
        if (DycProOrderApiServiceConstant.AfOrderMsgEcDealFlag.DEAL_IN.equals(reqBO.getEcDealFlag())) {
            if (DycProOrderApiServiceConstant.ServiceState.REMARK_COMPLATE.equals(afOrderMainInfo.getServState()) || DycProOrderApiServiceConstant.ServiceState.COMPLATE.equals(afOrderMainInfo.getServState()) || DycProOrderApiServiceConstant.ServiceState.APPROVAL_PASS.equals(afOrderMainInfo.getServState()) || DycProOrderApiServiceConstant.ServiceState.CANCEL.equals(afOrderMainInfo.getServState())) {
                dealAfOrderMsgResultBO.setConsumeFlag(Boolean.valueOf(false));
            } else {
                DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
                updateAfOrderDTO.setAfOrderId(afOrderMainInfo.getAfOrderId());
                updateAfOrderDTO.setServState(DycProOrderApiServiceConstant.ServiceState.APPROVAL_PASS);
                updateAfOrderDTO.setConfirmTime(reqBO.getEcPushTime());
                if (DycProOrderApiServiceConstant.PickwareType.CUSTOM_SHIP.equals(afOrderMainInfo.getPickwareType())) {
                    updateAfOrderDTO.setWaybillFlag(DycProOrderApiServiceConstant.WaybillFlag.CAN_MAINTAIN);
                }
                updateAfOrderDTO.setUpdateTime(new Date());
                this.dycProOrderAfOrderRepository.updateAfOrderByIdAndSyncNosql(updateAfOrderDTO);
                dealAfOrderMsgResultBO.setConsumeFlag(Boolean.valueOf(true));
            }
            return dealAfOrderMsgResultBO;
        }
        if (DycProOrderApiServiceConstant.AfOrderMsgEcDealFlag.DEAL_FINISH.equals(reqBO.getEcDealFlag())) {
            if (DycProOrderApiServiceConstant.ServiceState.REMARK_COMPLATE.equals(afOrderMainInfo.getServState()) || DycProOrderApiServiceConstant.ServiceState.CANCEL.equals(afOrderMainInfo.getServState())) {
                dealAfOrderMsgResultBO.setConsumeFlag(Boolean.valueOf(false));
            } else {
                DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
                updateAfOrderDTO.setAfOrderId(afOrderMainInfo.getAfOrderId());
                updateAfOrderDTO.setServState(DycProOrderApiServiceConstant.ServiceState.REMARK_COMPLATE);
                updateAfOrderDTO.setWaybillFlag(DycProOrderApiServiceConstant.WaybillFlag.CAN_NOT_MAINTAIN);
                if (null == afOrderMainInfo.getConfirmTime()) {
                    updateAfOrderDTO.setConfirmTime(reqBO.getEcPushTime());
                }
                updateAfOrderDTO.setUpdateTime(new Date());
                this.dycProOrderAfOrderRepository.updateAfOrderByIdAndSyncNosql(updateAfOrderDTO);
                List<DycProOrderDealAfOrderMsgAfOrderItemApiBO> dealAfOrderMsgAfOrderItemList = this.updateAfterCount(reqBO, afOrderMainInfo);
                DycProOrderSaleOrderDTO saleOrderDTO = this.getSaleOrderMainInfo(afOrderMainInfo.getSaleOrderId());
                if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrderMainInfo.getServType()) && null != saleOrderDTO.getBudgetId()) {
                    this.deductBudget(afOrderMainInfo, dealAfOrderMsgAfOrderItemList, saleOrderDTO);
                }
                List<DycProOrderAfOrderItemDTO> afOrderItemList = this.getAfOrderItemList(afOrderMainInfo.getAfOrderId());
                if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrderMainInfo.getServType()) && DycProOrderApiServiceConstant.OrderType.MALL_PUR_APPLY.equals(saleOrderDTO.getOrderType())) {
                    this.returnPurApply(saleOrderDTO, afOrderItemList);
                }
                if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrderMainInfo.getServType()) && "1".equals(saleOrderDTO.getProfessionalCompanyType()) && DycProOrderApiServiceConstant.PurchaseType.MRO_CENTRALIZED_PROCUREMENT.equals(saleOrderDTO.getPurchaseType())) {
                    this.pushAfterReturnForTy(afOrderMainInfo, afOrderItemList, saleOrderDTO);
                }
                dealAfOrderMsgResultBO.setConsumeFlag(Boolean.valueOf(true));
                dealAfOrderMsgResultBO.setMsgAfOrderItemList(dealAfOrderMsgAfOrderItemList);
            }
            return dealAfOrderMsgResultBO;
        }
        if (DycProOrderApiServiceConstant.AfOrderMsgEcDealFlag.DEAL_FAIL.equals(reqBO.getEcDealFlag())) {
            if (DycProOrderApiServiceConstant.ServiceState.CANCEL.equals(afOrderMainInfo.getServState())) {
                dealAfOrderMsgResultBO.setConsumeFlag(Boolean.valueOf(false));
            } else {
                DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
                updateAfOrderDTO.setAfOrderId(afOrderMainInfo.getAfOrderId());
                updateAfOrderDTO.setServState(DycProOrderApiServiceConstant.ServiceState.APPROVAL_NOT_PASS);
                updateAfOrderDTO.setCancelTime(reqBO.getEcPushTime());
                updateAfOrderDTO.setWaybillFlag(DycProOrderApiServiceConstant.WaybillFlag.CAN_NOT_MAINTAIN);
                updateAfOrderDTO.setUpdateTime(new Date());
                this.dycProOrderAfOrderRepository.updateAfOrderByIdAndSyncNosql(updateAfOrderDTO);
                List<DycProOrderDealAfOrderMsgAfOrderItemApiBO> dealAfOrderMsgAfOrderItemList = this.updateAfterCount(reqBO, afOrderMainInfo);
                dealAfOrderMsgResultBO.setConsumeFlag(Boolean.valueOf(true));
                dealAfOrderMsgResultBO.setMsgAfOrderItemList(dealAfOrderMsgAfOrderItemList);
            }
            return dealAfOrderMsgResultBO;
        }
        throw new ZTBusinessException("\u7535\u5546\u5904\u7406\u6807\u8bc6\u9519\u8bef");
    }

    private void deductBudget(DycProOrderAfOrderDTO afOrderMainInfo, List<DycProOrderDealAfOrderMsgAfOrderItemApiBO> dealAfOrderMsgAfOrderItemList, DycProOrderSaleOrderDTO saleOrderDTO) {
        BigDecimal afTotalSaleFee = dealAfOrderMsgAfOrderItemList.stream().map(DycProOrderDealAfOrderMsgAfOrderItemApiBO::getRetSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrderDTO.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(afTotalSaleFee.negate());
        dycProOrderBudgetUsedRecordDTO.setObjId(afOrderMainInfo.getAfOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(afOrderMainInfo.getAfServCode());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(4));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private List<DycProOrderDealAfOrderMsgAfOrderItemApiBO> updateAfterCount(DycProOrderDealAfOrderMsgApiReqBO reqBO, DycProOrderAfOrderDTO afOrderMainInfo) {
        DycProOrderAfOrderObjDTO afOrderObjInfo = this.getAfOrderObjInfo(afOrderMainInfo.getAfOrderId());
        List<DycProOrderAfOrderItemDTO> afOrderItemList = this.getAfOrderItemList(afOrderMainInfo.getAfOrderId());
        List<DycProOrderShipOrderItemDTO> shipOrderItemList = this.getShipOrderItemList(afOrderObjInfo.getShipOrderId());
        List<DycProOrderSaleOrderItemDTO> saleOrderItemList = this.getSaleOrderItemList(afOrderObjInfo.getSaleOrderId());
        Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(DycProOrderShipOrderItemDTO::getShipOrderItemId, shipOrderItem -> shipOrderItem, (k1, k2) -> k1));
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, saleOrderItem -> saleOrderItem, (k1, k2) -> k1));
        ArrayList<DycProOrderShipOrderItemDTO> updateBatchShipOrderItemDtoList = new ArrayList<DycProOrderShipOrderItemDTO>(1);
        ArrayList<DycProOrderSaleOrderItemDTO> updateBatchSaleOrderItemDtoList = new ArrayList<DycProOrderSaleOrderItemDTO>(1);
        for (DycProOrderAfOrderItemDTO afOrderItem : afOrderItemList) {
            DycProOrderShipOrderItemDTO thisShipOrderItem = shipOrderItemMap.get(afOrderItem.getShipItemId());
            DycProOrderSaleOrderItemDTO thisSaleOrderItem = saleOrderItemMap.get(afOrderItem.getSaleOrderItemId());
            DycProOrderShipOrderItemDTO updateShipOrderItem = new DycProOrderShipOrderItemDTO();
            updateShipOrderItem.setShipOrderItemId(thisShipOrderItem.getShipOrderItemId());
            updateShipOrderItem.setAfterServingCount(thisShipOrderItem.getAfterServingCount().subtract(afOrderItem.getReturnCount()));
            updateShipOrderItem.setUpdateTime(new Date());
            updateShipOrderItem.setUpdateOperId("1L");
            if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrderMainInfo.getServType()) && DycProOrderApiServiceConstant.AfOrderMsgEcDealFlag.DEAL_FINISH.equals(reqBO.getEcDealFlag())) {
                updateShipOrderItem.setReturnCount(thisShipOrderItem.getReturnCount().add(afOrderItem.getReturnCount()));
                updateShipOrderItem.setArriveCount(thisShipOrderItem.getArriveCount().subtract(afOrderItem.getReturnCount()));
            }
            updateBatchShipOrderItemDtoList.add(updateShipOrderItem);
            DycProOrderSaleOrderItemDTO updateSaleOrderItem = new DycProOrderSaleOrderItemDTO();
            updateSaleOrderItem.setSaleOrderItemId(afOrderItem.getSaleOrderItemId());
            updateSaleOrderItem.setAfterServingCount(thisSaleOrderItem.getAfterServingCount().subtract(afOrderItem.getReturnCount()));
            updateSaleOrderItem.setUpdateTime(new Date());
            updateSaleOrderItem.setUpdateOperId("1L");
            if (DycProOrderApiServiceConstant.AfterOrderSerType.RETURN.equals(afOrderMainInfo.getServType()) && DycProOrderApiServiceConstant.AfOrderMsgEcDealFlag.DEAL_FINISH.equals(reqBO.getEcDealFlag())) {
                updateSaleOrderItem.setReturnCount(thisSaleOrderItem.getReturnCount().add(afOrderItem.getReturnCount()));
                updateSaleOrderItem.setArriveCount(thisSaleOrderItem.getArriveCount().subtract(afOrderItem.getReturnCount()));
            }
            updateBatchSaleOrderItemDtoList.add(updateSaleOrderItem);
        }
        DycProOrderShipOrderDTO updateShipOrderItemAndSyncNosql = new DycProOrderShipOrderDTO();
        updateShipOrderItemAndSyncNosql.setShipOrderId(afOrderObjInfo.getShipOrderId());
        updateShipOrderItemAndSyncNosql.setShipItemList(updateBatchShipOrderItemDtoList);
        this.dycProOrderShipOrderRepository.updateShipOrderItemBatchByIdsAndSyncNosql(updateShipOrderItemAndSyncNosql);
        this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(updateBatchSaleOrderItemDtoList);
        this.syncSaleOrderNosql(afOrderObjInfo);
        return JSON.parseArray((String)JSON.toJSONString(afOrderItemList)).toJavaList(DycProOrderDealAfOrderMsgAfOrderItemApiBO.class);
    }

    private void syncSaleOrderNosql(DycProOrderAfOrderObjDTO afOrderObj) {
        DycProOrderAfOrderDTO afOrderMainInfo = this.getAfOrderMainInfo(afOrderObj.getAfOrderId());
        ArrayList<DycProOrderAfOrderDTO> afOrderList = new ArrayList<DycProOrderAfOrderDTO>(1);
        afOrderList.add(afOrderMainInfo);
        DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
        updateSaleOrderDTO.setSaleOrderId(afOrderObj.getSaleOrderId());
        updateSaleOrderDTO.setAfOrderList(afOrderList);
        this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDTO);
    }

    private void returnPurApply(DycProOrderSaleOrderDTO saleOrderDTO, List<DycProOrderAfOrderItemDTO> afOrderItemDTOList) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        Map<Long, DycProOrderSaleOrderItemDTO> idVsSaleOrderItemMap = saleOrderItemDTOList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        for (DycProOrderAfOrderItemDTO afOrderItemDTO : afOrderItemDTOList) {
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = idVsSaleOrderItemMap.get(afOrderItemDTO.getSaleOrderItemId());
            DycProOrderAdjustPurApplyItemCountDTO adjustPurApplyItemCountDTO = new DycProOrderAdjustPurApplyItemCountDTO();
            adjustPurApplyItemCountDTO.setPurApplyItemId(saleOrderItemDTO.getPurApplyItemId());
            adjustPurApplyItemCountDTO.setOccupyNum(afOrderItemDTO.getReturnCount().negate());
            adjustPurApplyItemCountDTO.setOccupyType(Integer.valueOf(4));
            this.dycProOrderSaleOrderRepository.adjustPurchaseApplyItemCounts(adjustPurApplyItemCountDTO);
        }
    }

    private void pushAfterReturnForTy(DycProOrderAfOrderDTO afOrderDTO, List<DycProOrderAfOrderItemDTO> afOrderItemDTOList, DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        Map<Long, DycProOrderSaleOrderItemDTO> idVsSaleOrderItemMap = saleOrderItemDTOList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        for (DycProOrderAfOrderItemDTO afOrderItemDTO : afOrderItemDTOList) {
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = idVsSaleOrderItemMap.get(afOrderItemDTO.getSaleOrderItemId());
            DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
            dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            dycProOrderInterLogDTO.setObjId(afOrderDTO.getAfOrderId());
            dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.AFTER);
            dycProOrderInterLogDTO.setOrderId(afOrderDTO.getOrderId());
            dycProOrderInterLogDTO.setInterSn(this.deleteContractUrlForTy);
            DycProBaseCallEsbUtilDeleteContractForTyReqBO dycProBaseCallEsbUtilDeleteContractForTyReqBO = new DycProBaseCallEsbUtilDeleteContractForTyReqBO();
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setUrl(this.deleteContractUrlForTy);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setMethodName(this.deleteContractMethodNameForTy);
            DycProBaseCallEsbUtilDeleteContractForTyBO dycProBaseCallEsbUtilDeleteContractForTyBO = new DycProBaseCallEsbUtilDeleteContractForTyBO();
            dycProBaseCallEsbUtilDeleteContractForTyBO.setId(afOrderDTO.getAfOrderId());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setGoodsName(saleOrderItemDTO.getSkuName());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setGoodsNum(afOrderItemDTO.getReturnCount());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSku(saleOrderItemDTO.getSkuCode());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSourceType(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setYctOrderCode(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setServiceCode(afOrderDTO.getAfServCode());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setCreateDate(afOrderDTO.getCreateTime());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setTimeStamp(Long.valueOf(new Date().getTime()));
            dycProBaseCallEsbUtilDeleteContractForTyBO.setMaterialType(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setMaterialCode(saleOrderItemDTO.getMCode());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setJsonStr(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyBO));
            dycProOrderInterLogDTO.setInContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyReqBO));
            try {
                DycProBaseCallEsbUtilDeleteContractForTyRspBO dycProBaseCallEsbUtilDeleteContractForTyRspBO = DycProBaseCallEsbUtil.deleteContractForTy((DycProBaseCallEsbUtilDeleteContractForTyReqBO)dycProBaseCallEsbUtilDeleteContractForTyReqBO);
                dycProOrderInterLogDTO.setOutContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyRspBO));
                if (null == dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess() || !dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultCode())) {
                    log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    throw new ZTBusinessException("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                }
            }
            catch (Exception e) {
                log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5f02\u5e38: {}", (Object)e.getMessage());
                dycProOrderInterLogDTO.setErrDetail(e.getMessage());
            }
            this.dycProOrderSaleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
        }
    }
}

