/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.chngorder.impl;

import com.alibaba.fastjson.JSONArray;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.api.DycProOrderChngOrderRepository;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderObjQryDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderQryDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderAdjustPurApplyItemCountDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderInterLogDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderQryDTO;
import com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderConfirmOrRefuseApplyCancelService;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderConfirmOrRefuseApplyCancelReqBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderConfirmOrRefuseApplyCancelRspBO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleOrderItemApiBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderConfirmOrRefuseApplyCancelService"})
public class DycProOrderConfirmOrRefuseApplyCancelServiceImpl
implements DycProOrderConfirmOrRefuseApplyCancelService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderConfirmOrRefuseApplyCancelServiceImpl.class);
    @Value(value="${call.ty.url.deleteContractUrlForTy}")
    private String deleteContractUrlForTy;
    @Value(value="${call.ty.deleteContractMethodNameForTy}")
    private String deleteContractMethodNameForTy;
    @Autowired
    private DycProOrderChngOrderRepository dycProOrderChngOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;

    @PostMapping(value={"confirmOrRefuseApplyCancel"})
    public DycProOrderConfirmOrRefuseApplyCancelRspBO confirmOrRefuseApplyCancel(@RequestBody DycProOrderConfirmOrRefuseApplyCancelReqBO reqBO) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getSetSaleOrderNoExt()})) {
            this.getChngOrderId(reqBO);
        }
        this.verifyParam(reqBO);
        DycProOrderChngOrderDTO updateChngOrderDto = new DycProOrderChngOrderDTO();
        if (reqBO.getOperType().equals(0)) {
            updateChngOrderDto.setChngOrderState("CHNG_XS_YQR");
        } else if (reqBO.getOperType().equals(1)) {
            updateChngOrderDto.setChngOrderState("CHNG_XS_YJJ");
        } else {
            throw new ZTBusinessException("\u65e0\u6cd5\u8bc6\u522b\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        updateChngOrderDto.setChngOrderId(reqBO.getChngOrderId());
        updateChngOrderDto.setRejectReason(reqBO.getRejectReason());
        updateChngOrderDto.setRejectTime(new Date());
        this.dycProOrderChngOrderRepository.updateChngOrderAndSyncNosql(updateChngOrderDto);
        DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
        updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        if (reqBO.getOperType().equals(0)) {
            updateSaleOrderDto.setSaleOrderState("XS_QX_QX");
            updateSaleOrderDto.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.APPLY_CANCEL);
            updateSaleOrderDto.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
            DycProOrderSaleOrderDTO dycProOrderSaleOrderDTO = new DycProOrderSaleOrderDTO();
            dycProOrderSaleOrderDTO.setSaleOrderId(reqBO.getSaleOrderId());
            DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(dycProOrderSaleOrderDTO);
            updateSaleOrderDto.setCancelReason(saleOrderDto.getRejectReason());
            updateSaleOrderDto.setCancelOperId(saleOrderDto.getRejectOperId());
            updateSaleOrderDto.setCancelOperName(saleOrderDto.getRejectOperName());
            updateSaleOrderDto.setCancelTime(new Date());
            if (null != saleOrderDto.getBudgetId()) {
                this.deductBudget(saleOrderDto);
            }
            if (DycProOrderApiServiceConstant.OrderType.MALL_PUR_APPLY.equals(saleOrderDto.getOrderType())) {
                this.returnPurApply(saleOrderDto);
            }
            DycProOrderOrderAccessoryDTO dycProOrderOrderAccessoryDTO = new DycProOrderOrderAccessoryDTO();
            dycProOrderOrderAccessoryDTO.setObjId(reqBO.getChngOrderId());
            dycProOrderOrderAccessoryDTO.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.APPLY_CANCEL_FILE);
            List applyCancelFile = this.dycProOrderOrderRepository.queryOrderAccessoryList(dycProOrderOrderAccessoryDTO);
            if (!CollectionUtils.isEmpty((Collection)applyCancelFile)) {
                List applyCancelFileForSale = applyCancelFile.stream().map(bo -> {
                    bo.setObjId(reqBO.getSaleOrderId());
                    bo.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.SALE_ORDER_CANCEL);
                    bo.setOrderId(reqBO.getSaleOrderId());
                    return bo;
                }).collect(Collectors.toList());
                this.dycProOrderOrderRepository.addAllKindsAccessoryBatch(applyCancelFileForSale);
            }
        } else if (reqBO.getOperType().equals(1)) {
            updateSaleOrderDto.setSaleOrderState("XS_FH_DFH");
        }
        this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
        DycProOrderConfirmOrRefuseApplyCancelRspBO rspBO = new DycProOrderConfirmOrRefuseApplyCancelRspBO();
        if (DycProOrderApiServiceConstant.OrderSource.AGR_ORDER.equals(reqBO.getOrderSource()) && reqBO.getOperType().equals(0)) {
            DycProOrderSaleOrderItemQryDTO querySaleItemReqDto = new DycProOrderSaleOrderItemQryDTO();
            querySaleItemReqDto.setSaleOrderId(reqBO.getSaleOrderId());
            List dycProOrderSaleOrderItemDTOS = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleItemReqDto);
            if (!CollectionUtils.isEmpty((Collection)dycProOrderSaleOrderItemDTOS)) {
                List saleItemList = JSONArray.parseArray((String)JSON.toJSONString((Object)dycProOrderSaleOrderItemDTOS)).toJavaList(DycProOrderSaleOrderItemApiBO.class);
                rspBO.setSaleItemList(saleItemList);
            }
        }
        DycProPublicTaskInstDTO taskInstDTO = new DycProPublicTaskInstDTO();
        taskInstDTO.setObjId(reqBO.getSaleOrderId());
        taskInstDTO.setObjType("salesOrder");
        taskInstDTO.setFinishTag(Integer.valueOf(0));
        List dycProPublicTaskInstDTOS = this.dycProPublicTaskInstRepository.queryFlowTaskList(taskInstDTO);
        if (CollectionUtils.isEmpty((Collection)dycProPublicTaskInstDTOS) || dycProPublicTaskInstDTOS.size() != 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1\u5b9e\u4f8b\u9519\u8bef!");
        }
        if (null != reqBO.getOperType() && reqBO.getOperType() == 0) {
            DycProOrderSaleOrderQryDTO querySaleOrderDTO = new DycProOrderSaleOrderQryDTO();
            querySaleOrderDTO.setSaleOrderId(reqBO.getSaleOrderId());
            DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition((DycProOrderSaleOrderDTO)querySaleOrderDTO);
            if ("1".equals(saleOrderDto.getProfessionalCompanyType()) && DycProOrderApiServiceConstant.PurchaseType.MRO_CENTRALIZED_PROCUREMENT.equals(saleOrderDto.getPurchaseType())) {
                this.pushAfterReturnForTy(saleOrderDto);
            }
        }
        rspBO.setProcInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0)).getProcInstId());
        return rspBO;
    }

    private void deductBudget(DycProOrderSaleOrderDTO saleOrder) {
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrder.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(saleOrder.getTotalSaleFee().negate());
        dycProOrderBudgetUsedRecordDTO.setObjId(saleOrder.getSaleOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(saleOrder.getSaleOrderNo());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(2));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private void getChngOrderId(DycProOrderConfirmOrRefuseApplyCancelReqBO reqBO) {
        DycProOrderOrderQueryIndexQryDTO queryIndexQryDTO = new DycProOrderOrderQueryIndexQryDTO();
        queryIndexQryDTO.setOutObjId(reqBO.getSetSaleOrderNoExt());
        queryIndexQryDTO.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
        List uocOrderQueryIndexList = this.dycProOrderSaleOrderRepository.qryOrderQueryIndexList(queryIndexQryDTO);
        if (CollectionUtils.isEmpty((Collection)uocOrderQueryIndexList) || uocOrderQueryIndexList.size() != 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u5916\u90e8\u8ba2\u5355" + reqBO.getSetSaleOrderNoExt() + "\u5173\u8054\u8868\u9519\u8bef");
        }
        reqBO.setSaleOrderId(((DycProOrderOrderQueryIndexDTO)uocOrderQueryIndexList.get(0)).getObjId());
        DycProOrderChngOrderObjQryDTO dycProOrderChngOrderObjQryDTO = new DycProOrderChngOrderObjQryDTO();
        dycProOrderChngOrderObjQryDTO.setSaleOrderId(((DycProOrderOrderQueryIndexDTO)uocOrderQueryIndexList.get(0)).getObjId());
        List chngOrderObjDTOList = this.dycProOrderChngOrderRepository.getListChngOrderObjWithOutItem(dycProOrderChngOrderObjQryDTO);
        if (CollectionUtils.isEmpty((Collection)chngOrderObjDTOList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u53d8\u66f4\u5355\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
        }
        DycProOrderChngOrderQryDTO dycProOrderChngOrderQryDTO = new DycProOrderChngOrderQryDTO();
        dycProOrderChngOrderQryDTO.setBusiType(DycProOrderApiServiceConstant.ChngOrderBusiType.APPLY_CANCEL);
        dycProOrderChngOrderQryDTO.setChngOrderState("CHNG_XS_QXSQZ");
        dycProOrderChngOrderQryDTO.setChngOrderIdList(chngOrderObjDTOList.stream().map(DycProOrderChngOrderObjDTO::getChngOrderId).collect(Collectors.toList()));
        DycProOrderChngOrderDTO chngOrderDTO = this.dycProOrderChngOrderRepository.getChngOrder(dycProOrderChngOrderQryDTO);
        reqBO.setChngOrderId(chngOrderDTO.getChngOrderId());
    }

    private void verifyParam(DycProOrderConfirmOrRefuseApplyCancelReqBO reqBO) {
        if (null == reqBO.getOperType()) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getChngOrderId()) {
            throw new ZTBusinessException("\u53d6\u6d88\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void returnPurApply(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDTOList) {
            DycProOrderAdjustPurApplyItemCountDTO adjustPurApplyItemCountDTO = new DycProOrderAdjustPurApplyItemCountDTO();
            adjustPurApplyItemCountDTO.setPurApplyItemId(saleOrderItemDTO.getPurApplyItemId());
            adjustPurApplyItemCountDTO.setOccupyNum(saleOrderItemDTO.getPurchaseCount().negate());
            adjustPurApplyItemCountDTO.setOccupyType(Integer.valueOf(4));
            this.dycProOrderSaleOrderRepository.adjustPurchaseApplyItemCounts(adjustPurApplyItemCountDTO);
        }
    }

    private void pushAfterReturnForTy(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDTOList) {
            DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
            dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            dycProOrderInterLogDTO.setObjId(saleOrderDTO.getSaleOrderId());
            dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.SALE);
            dycProOrderInterLogDTO.setOrderId(saleOrderDTO.getOrderId());
            dycProOrderInterLogDTO.setInterSn(this.deleteContractUrlForTy);
            DycProBaseCallEsbUtilDeleteContractForTyReqBO dycProBaseCallEsbUtilDeleteContractForTyReqBO = new DycProBaseCallEsbUtilDeleteContractForTyReqBO();
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setUrl(this.deleteContractUrlForTy);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setMethodName(this.deleteContractMethodNameForTy);
            DycProBaseCallEsbUtilDeleteContractForTyBO dycProBaseCallEsbUtilDeleteContractForTyBO = new DycProBaseCallEsbUtilDeleteContractForTyBO();
            dycProBaseCallEsbUtilDeleteContractForTyBO.setId(saleOrderDTO.getSaleOrderId());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setGoodsName(saleOrderItemDTO.getSkuName());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setGoodsNum(saleOrderItemDTO.getPurchaseCount());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSku(saleOrderItemDTO.getSkuCode());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSourceType(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setYctOrderCode(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setServiceCode(saleOrderDTO.getSaleOrderNo());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setCreateDate(saleOrderDTO.getCreateTime());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setTimeStamp(Long.valueOf(new Date().getTime()));
            dycProBaseCallEsbUtilDeleteContractForTyBO.setMaterialType(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setMaterialCode(saleOrderItemDTO.getMCode());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setJsonStr(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyBO));
            dycProOrderInterLogDTO.setInContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyReqBO));
            try {
                DycProBaseCallEsbUtilDeleteContractForTyRspBO dycProBaseCallEsbUtilDeleteContractForTyRspBO = DycProBaseCallEsbUtil.deleteContractForTy((DycProBaseCallEsbUtilDeleteContractForTyReqBO)dycProBaseCallEsbUtilDeleteContractForTyReqBO);
                dycProOrderInterLogDTO.setOutContent(com.alibaba.fastjson.JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyRspBO));
                if (null == dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess() || !dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultCode())) {
                    log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    throw new ZTBusinessException("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                }
            }
            catch (Exception e) {
                log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5f02\u5e38: {}", (Object)e.getMessage());
                dycProOrderInterLogDTO.setErrDetail(e.getMessage());
            }
            this.dycProOrderSaleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
        }
    }
}

