/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.shiporder.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderQryShipOrderDetailsApiService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQryShipOrderDetailsReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQryShipOrderDetailsRspBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQryShipOrderDetailsRspDataBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQryShipOrderLogisticsDetailsRspDataBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderShipOrderItemApiBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderQryShipOrderDetailsApiService"})
public class DycProOrderQryShipOrderDetailsApiServiceImpl
implements DycProOrderQryShipOrderDetailsApiService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderQryShipOrderDetailsApiServiceImpl.class);
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @PostMapping(value={"qryShipOrderDetails"})
    public DycProOrderQryShipOrderDetailsRspBO qryShipOrderDetails(@RequestBody DycProOrderQryShipOrderDetailsReqBO reqBo) {
        log.info("\u67e5\u8be2\u53d1\u8d27\u5355\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        DycProOrderQryShipOrderDetailsRspDataBO shipOrderDetailsInfo = this.queryShipOrderInfo(reqBo);
        DycProOrderQryShipOrderLogisticsDetailsRspDataBO orderLogisicsInfo = this.queryLogisticsInfo(reqBo.getOrderId());
        DycProOrderQryShipOrderDetailsRspBO rspBo = new DycProOrderQryShipOrderDetailsRspBO();
        rspBo.setShipOrderInfo(shipOrderDetailsInfo);
        rspBo.setOrdLogisticsRela(orderLogisicsInfo);
        log.info("\u67e5\u8be2\u53d1\u8d27\u5355\u8be6\u60c5\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)rspBo));
        DycProOrderQryShipOrderDetailsRspDataBO shipOrderInfo = rspBo.getShipOrderInfo();
        if (ObjectUtil.isNotEmpty((Object)shipOrderInfo)) {
            ArrayList realShipOrderItemBoList = new ArrayList();
            List shipOrderItemBoList = shipOrderInfo.getShipOrderItemBoList();
            Map<Long, DycProOrderShipOrderItemApiBO> shipItemMaps = shipOrderItemBoList.stream().collect(Collectors.toMap(DycProOrderShipOrderItemApiBO::getShipOrderItemId, o -> o));
            List shipOrderItemIds = reqBo.getShipOrderItemIds();
            if (CollectionUtil.isNotEmpty((Collection)shipOrderItemIds)) {
                shipOrderItemIds.forEach(shipOrderItemId -> {
                    DycProOrderShipOrderItemApiBO dycProOrderQryShipOrderDetailsRspItemBO = (DycProOrderShipOrderItemApiBO)shipItemMaps.get(shipOrderItemId);
                    if (ObjectUtil.isNotEmpty((Object)dycProOrderQryShipOrderDetailsRspItemBO)) {
                        realShipOrderItemBoList.add(dycProOrderQryShipOrderDetailsRspItemBO);
                    }
                });
            } else {
                realShipOrderItemBoList.addAll(shipOrderItemBoList);
            }
            shipOrderInfo.setShipOrderItemBoList(realShipOrderItemBoList);
        }
        return rspBo;
    }

    private DycProOrderQryShipOrderDetailsRspDataBO queryShipOrderInfo(DycProOrderQryShipOrderDetailsReqBO reqBo) {
        DycProOrderShipOrderQryDTO uocShipOrderQryBo = new DycProOrderShipOrderQryDTO();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        DycProOrderShipOrderDTO shipOrderInfo = this.dycProOrderShipOrderRepository.getShipOrderById(uocShipOrderQryBo);
        if (null != shipOrderInfo) {
            DycProOrderQryShipOrderDetailsRspDataBO uocQryShipOrderDetailsRspDetailBo = (DycProOrderQryShipOrderDetailsRspDataBO)JSONObject.parseObject((String)JSON.toJSONString((Object)shipOrderInfo), DycProOrderQryShipOrderDetailsRspDataBO.class);
            DycProOrderSaleOrderDTO saleOrderInfo = this.getSaleOrderDo(shipOrderInfo.getSaleOrderId(), shipOrderInfo.getOrderId());
            if (ObjectUtil.isNotEmpty((Object)saleOrderInfo.getSaleStakeholder())) {
                BeanUtils.copyProperties((Object)saleOrderInfo.getSaleStakeholder(), (Object)uocQryShipOrderDetailsRspDetailBo);
                uocQryShipOrderDetailsRspDetailBo.setSaleOrderNo(saleOrderInfo.getSaleOrderNo());
            }
            List<DycProOrderSaleOrderItemDTO> saleOrderItemInfos = this.getSaleOrderItemInfos(shipOrderInfo.getSaleOrderId(), shipOrderInfo.getOrderId());
            Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemInfos.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, o -> o));
            List<DycProOrderShipOrderItemDTO> shipOrderItemInfos = this.getShipOrderItemInfos(reqBo.getShipOrderId(), reqBo.getOrderId());
            ArrayList<DycProOrderShipOrderItemApiBO> shipOrderItemBoList = new ArrayList<DycProOrderShipOrderItemApiBO>();
            for (DycProOrderShipOrderItemDTO shipOrderItem : shipOrderItemInfos) {
                DycProOrderShipOrderItemApiBO rspItemBo = new DycProOrderShipOrderItemApiBO();
                BeanUtils.copyProperties((Object)shipOrderItem, (Object)rspItemBo);
                if (saleOrderItemMap.containsKey(shipOrderItem.getSaleOrderItemId())) {
                    DycProOrderSaleOrderItemDTO saleOrderItem = saleOrderItemMap.get(shipOrderItem.getSaleOrderItemId());
                    if (shipOrderItem.getSendCount() != null && shipOrderItem.getReturnCount() != null && saleOrderItem.getAfterServingCount() != null) {
                        BigDecimal afterCountEnable = shipOrderItem.getSendCount().subtract(shipOrderItem.getReturnCount()).subtract(shipOrderItem.getAfterServingCount());
                        rspItemBo.setAvailableAfServCount(afterCountEnable);
                    }
                    BeanUtils.copyProperties((Object)saleOrderItem, (Object)rspItemBo);
                    rspItemBo.setRefuseCount(shipOrderItem.getRefuseCount());
                    rspItemBo.setSendCount(shipOrderItem.getSendCount());
                    rspItemBo.setReturnCount(shipOrderItem.getReturnCount());
                    rspItemBo.setAfterServingCount(shipOrderItem.getAfterServingCount());
                    rspItemBo.setInspCount(shipOrderItem.getInspCount());
                    rspItemBo.setArriveCount(shipOrderItem.getArriveCount());
                    rspItemBo.setChngingCount(shipOrderItem.getChngingCount());
                    rspItemBo.setUnitDigit(StringUtils.isEmpty((CharSequence)saleOrderItem.getUnitDigit()) ? "" : saleOrderItem.getUnitDigit());
                    if (shipOrderItem.getInspCount() != null) {
                        rspItemBo.setInspSaleFee(shipOrderItem.getInspCount().multiply(saleOrderItem.getSalePrice()));
                    }
                }
                shipOrderItemBoList.add(rspItemBo);
            }
            uocQryShipOrderDetailsRspDetailBo.setShipOrderItemBoList(shipOrderItemBoList);
            return uocQryShipOrderDetailsRspDetailBo;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u5931\u8d25");
    }

    private DycProOrderQryShipOrderLogisticsDetailsRspDataBO queryLogisticsInfo(Long orderId) {
        DycProOrderOrderDTO uocOrderDo = new DycProOrderOrderDTO();
        uocOrderDo.setOrderId(orderId);
        uocOrderDo = this.dycProOrderSaleOrderRepository.getOrderBy(uocOrderDo);
        DycProOrderOrdLogisticsRelaDTO uocOrdLogisticsRelaQryBo = new DycProOrderOrdLogisticsRelaDTO();
        uocOrdLogisticsRelaQryBo.setOrderId(orderId);
        uocOrdLogisticsRelaQryBo.setContactId(uocOrderDo.getContactId());
        DycProOrderOrdLogisticsRelaDTO uocOrdLogisticsRela = this.dycProOrderSaleOrderRepository.getOrderLogisticsRela(uocOrdLogisticsRelaQryBo);
        if (null != uocOrdLogisticsRela) {
            DycProOrderQryShipOrderLogisticsDetailsRspDataBO uocQryShipOrderDetailsLogisticsRelaBo = new DycProOrderQryShipOrderLogisticsDetailsRspDataBO();
            BeanUtils.copyProperties((Object)uocOrdLogisticsRela, (Object)uocQryShipOrderDetailsLogisticsRelaBo);
            return uocQryShipOrderDetailsLogisticsRelaBo;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4fe1\u606f\u5931\u8d25");
    }

    private DycProOrderSaleOrderDTO getSaleOrderDo(Long saleOrderId, Long orderId) {
        DycProOrderSaleOrderQryDTO uocSaleOrderQryBo = new DycProOrderSaleOrderQryDTO();
        uocSaleOrderQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderQryBo.setOrderId(orderId);
        DycProOrderSaleOrderDTO uocSaleOrderDo = this.dycProOrderSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
        if (null != uocSaleOrderDo) {
            return uocSaleOrderDo;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25");
    }

    private List<DycProOrderSaleOrderItemDTO> getSaleOrderItemInfos(Long saleOrderId, Long orderId) {
        DycProOrderSaleOrderItemQryDTO uocSaleOrderItemQryBo = new DycProOrderSaleOrderItemQryDTO();
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderItemQryBo.setOrderId(orderId);
        DycProOrderSaleOrderDTO saleOrderItems = this.dycProOrderSaleOrderRepository.queryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != saleOrderItems) {
            return saleOrderItems.getSaleItemList();
        }
        throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
    }

    private List<DycProOrderShipOrderItemDTO> getShipOrderItemInfos(Long shipOrderId, Long orderId) {
        DycProOrderShipOrderItemQryDTO qryItemListBo = new DycProOrderShipOrderItemQryDTO();
        qryItemListBo.setShipOrderId(shipOrderId);
        qryItemListBo.setOrderId(orderId);
        DycProOrderShipOrderDTO shipOrderItems = this.dycProOrderShipOrderRepository.queryListShipOrder(qryItemListBo);
        if (null != shipOrderItems) {
            return shipOrderItems.getShipItemList();
        }
        throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
    }
}

