/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.shiporder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetPromiseTipsReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetPromiseTipsRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderQryPackageBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderQryPackageDeliveryItemBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderQryPackageReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderQryPackageRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderQrySubOrderReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderQrySubOrderRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderSkuBO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleStakeholderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderCreateEsShipOrderService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderCreateEsShipOrderReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderCreateEsShipOrderRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderCreateEsShipOrderService"})
public class DycProOrderCreateEsShipOrderServiceImpl
implements DycProOrderCreateEsShipOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCreateEsShipOrderServiceImpl.class);
    @Autowired
    private DycProOrderShipOrderRepository shipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository saleOrderRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private Environment environment;
    @Value(value="${call.esb.url.qrySubOrder}")
    private String qrySubOrderUrl;
    @Value(value="${call.esb.url.getPromiseTips}")
    private String getPromiseTipsUrl;
    @Value(value="${call.esb.url.package}")
    private String qryPackageUrl;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"createEsShipOrder"})
    public DycProOrderCreateEsShipOrderRspBO createEsShipOrder(@RequestBody DycProOrderCreateEsShipOrderReqBO reqBO) {
        DycProOrderCreateEsShipOrderRspBO rspBO = new DycProOrderCreateEsShipOrderRspBO();
        List<DycProOrderOrderQueryIndexDTO> uocOrderQueryIndexList = this.qryOrderQueryIndex(reqBO);
        DycProOrderSaleOrderDTO salOrderDetail = this.qrySalOrderDetail(uocOrderQueryIndexList.get(0).getObjId());
        DycProOrderSaleStakeholderDTO saleStakeholder = this.qrySaleStakeholder(salOrderDetail.getStakeholderId());
        salOrderDetail.setSaleStakeholder(saleStakeholder);
        DycProOrderOrdLogisticsRelaDTO dycProOrderOrdLogisticsRelaDTO = this.qryReceiveAddress(salOrderDetail.getContactId());
        salOrderDetail.setReceiverAddress(dycProOrderOrdLogisticsRelaDTO);
        DycProOrderShipOrderDTO createdShipOrder = new DycProOrderShipOrderDTO();
        if (!this.environment.getProperty("SUPPLIER_JD_ID").equals(saleStakeholder.getSupId()) && !this.environment.getProperty("SUPPLIER_JDVOP_ID").equals(saleStakeholder.getSupId())) {
            log.info("\u975e\u4eac\u4e1c\u8ba2\u5355\u53d1\u8d27\u5f00\u59cb");
            DycProBaseCallEsbUtilOrderQrySubOrderRspBO qrySubOrderRspBO = this.getExtOrderInfo(reqBO, salOrderDetail);
            DycProBaseCallEsbUtilOrderQryPackageRspBO qryPackageRspBO = this.getOutDeliverInfo(reqBO, salOrderDetail);
            List extOrderSaleItemRspBOList = null;
            if (qrySubOrderRspBO.getResult() != null) {
                extOrderSaleItemRspBOList = qrySubOrderRspBO.getResult().getSku();
            }
            Map<Object, Object> extSkuIdSaleOrderItemMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)extOrderSaleItemRspBOList)) {
                extSkuIdSaleOrderItemMap = extOrderSaleItemRspBOList.stream().collect(Collectors.toMap(DycProBaseCallEsbUtilOrderSkuBO::getSkuId, Function.identity()));
            }
            HashMap<String, BigDecimal> skuSendNumMap = new HashMap<String, BigDecimal>();
            ArrayList<DycProOrderSaleOrderItemDTO> needShipSaleOrderItemList = new ArrayList<DycProOrderSaleOrderItemDTO>();
            DycProOrderSaleOrderItemQryDTO saleOrderItemQryDTO = new DycProOrderSaleOrderItemQryDTO();
            saleOrderItemQryDTO.setSaleOrderId(salOrderDetail.getSaleOrderId());
            List saleOrderItemList = this.saleOrderRepository.getSaleOrderItemList(saleOrderItemQryDTO);
            Map saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSkuExtSkuId, Function.identity()));
            for (DycProBaseCallEsbUtilOrderQryPackageDeliveryItemBO deliveryItemsBO : qryPackageRspBO.getResult().getDeliveryItems()) {
                BigDecimal thisTimeSendCount = new BigDecimal(deliveryItemsBO.getNum());
                if (!saleOrderItemMap.containsKey(deliveryItemsBO.getSkuId())) continue;
                DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemMap.get(deliveryItemsBO.getSkuId());
                skuSendNumMap.put(saleOrderItemDTO.getSkuId(), thisTimeSendCount);
                if (!extSkuIdSaleOrderItemMap.containsKey(deliveryItemsBO.getSkuId())) continue;
                DycProBaseCallEsbUtilOrderSkuBO extOrderSaleItem = (DycProBaseCallEsbUtilOrderSkuBO)extSkuIdSaleOrderItemMap.get(deliveryItemsBO.getSkuId());
                if (extOrderSaleItem.getTaxPrice() != null) {
                    saleOrderItemDTO.setTaxPrice(extOrderSaleItem.getTaxPrice());
                }
                if (extOrderSaleItem.getTax() != null) {
                    saleOrderItemDTO.setTax(new BigDecimal(extOrderSaleItem.getTax()));
                }
                boolean needShip = true;
                log.info(saleOrderItemDTO.getSaleOrderItemId() + "\u9500\u552e\u5355\u660e\u7ec6id\u662f\u5426\u9700\u8981\u53d1\u8d27: {},\u91c7\u8d2d\u6570\u91cf: {}\uff0c\u4e4b\u524d\u7684\u53d1\u8d27\u6570\u91cf: {}\uff0c\u8fd9\u6b21\u7684\u53d1\u8d27\u6570\u91cf\uff1a{}\uff0c\u9000\u8d27\u6570\u91cf\uff1a{}", new Object[]{needShip, saleOrderItemDTO.getPurchaseCount(), saleOrderItemDTO.getSendCount(), thisTimeSendCount, saleOrderItemDTO.getReturnCount()});
                if (saleOrderItemDTO.getPurchaseCount().compareTo(saleOrderItemDTO.getSendCount().add(thisTimeSendCount)) < 0) {
                    needShip = false;
                    throw new ZTBusinessException("\u9500\u552e\u660e\u7ec6\uff1a" + saleOrderItemDTO.getSaleOrderItemId() + "\u5df2\u8d85\u8fc7\u53ef\u53d1\u8d27\u7684\u6570\u91cf");
                }
                needShipSaleOrderItemList.add(saleOrderItemDTO);
            }
            log.info("\u672c\u6b21\u9700\u8981\u53d1\u8d27\u7684\u9500\u552e\u5355\u660e\u7ec6________________________________: {}", needShipSaleOrderItemList);
            if (CollectionUtils.isEmpty(needShipSaleOrderItemList)) throw new ZTBusinessException("\u672c\u6b21\u65e0\u9700\u53d1\u8d27");
            try {
                DycProOrderShipOrderDTO shipOrderDTO = this.buildShipAndItemData(salOrderDetail, needShipSaleOrderItemList, qryPackageRspBO.getResult(), skuSendNumMap);
                salOrderDetail.setSaleItemList(needShipSaleOrderItemList);
                this.qryEstimateArrivalTime(shipOrderDTO, salOrderDetail);
                createdShipOrder = this.ceateShipOrder(shipOrderDTO, salOrderDetail);
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u7535\u5546\u53d1\u8d27\u5355\u5f02\u5e38\uff1a", (Throwable)e);
                throw new ZTBusinessException("\u7535\u5546\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u5931\u8d25!" + e.getMessage());
            }
        } else {
            log.info("\u4eac\u4e1c\u8ba2\u5355\u53d1\u8d27\u5f00\u59cb");
            DycProOrderShipOrderQryDTO shipOrderQryDTO = new DycProOrderShipOrderQryDTO();
            shipOrderQryDTO.setOrderId(salOrderDetail.getOrderId());
            shipOrderQryDTO.setSaleOrderId(salOrderDetail.getSaleOrderId());
            List shipOrderDoList = this.shipOrderRepository.getListShipOrder(shipOrderQryDTO);
            if (ObjectUtil.isNotEmpty((Object)shipOrderDoList)) {
                throw new ZTBusinessException("\u8ba2\u5355\u660e\u7ec6\u5df2\u5168\u90e8\u53d1\u8d27\u5b8c\u6bd5\uff0c\u5df2\u4e0d\u80fd\u518d\u8fdb\u884c\u53d1\u8d27\u64cd\u4f5c");
            }
            DycProOrderSaleOrderItemQryDTO uocSaleOrderItemQryDto = new DycProOrderSaleOrderItemQryDTO();
            uocSaleOrderItemQryDto.setSaleOrderId(salOrderDetail.getSaleOrderId());
            List saleOrderItemDTOList = this.saleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryDto);
            DycProOrderShipOrderDTO shipOrderDTO = this.buildShipAndItemDataForJd(salOrderDetail, saleOrderItemDTOList, reqBO.getResult().getOrderId());
            salOrderDetail.setSaleItemList(saleOrderItemDTOList);
            createdShipOrder = this.ceateShipOrder(shipOrderDTO, salOrderDetail);
        }
        Boolean finish = this.checkSaleOrderIsFinish(salOrderDetail);
        DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
        saleOrderDTO.setOrderId(salOrderDetail.getOrderId());
        saleOrderDTO.setSaleOrderId(salOrderDetail.getSaleOrderId());
        saleOrderDTO.setShiporderList(Collections.singletonList(createdShipOrder));
        if (finish.booleanValue()) {
            saleOrderDTO.setSaleOrderState("XS_FH_FHWC");
        } else {
            saleOrderDTO.setSaleOrderState("XS_FH_FHZ");
        }
        this.saleOrderRepository.updateSaleOrderByCondition(saleOrderDTO, true);
        return rspBO;
    }

    private DycProOrderOrdLogisticsRelaDTO qryReceiveAddress(Long contactId) {
        DycProOrderOrdLogisticsRelaDTO dycProOrderOrdLogisticsRelaDTO = new DycProOrderOrdLogisticsRelaDTO();
        dycProOrderOrdLogisticsRelaDTO.setContactId(contactId);
        DycProOrderOrdLogisticsRelaDTO receiveAddress = this.saleOrderRepository.getOrderLogisticsRela(dycProOrderOrdLogisticsRelaDTO);
        return receiveAddress;
    }

    private DycProOrderShipOrderDTO buildShipAndItemDataForJd(DycProOrderSaleOrderDTO salOrderDetail, List<DycProOrderSaleOrderItemDTO> saleOrderItemDTOList, String pakageId) {
        DycProOrderShipOrderDTO shipOrderDTO = new DycProOrderShipOrderDTO();
        shipOrderDTO.setSaleOrderId(salOrderDetail.getSaleOrderId());
        shipOrderDTO.setOrderId(salOrderDetail.getOrderId());
        shipOrderDTO.setShipOrderState("FH_FH_FH");
        shipOrderDTO.setCreateTime(new Date());
        shipOrderDTO.setShipOrderNoExt(pakageId);
        shipOrderDTO.setShipTime(new Date());
        shipOrderDTO.setShipRemark("\u4eac\u4e1c\u5916\u90e8\u7535\u5546\u53d1\u8d27");
        ArrayList<DycProOrderShipOrderItemDTO> shipItemList = new ArrayList<DycProOrderShipOrderItemDTO>();
        for (DycProOrderSaleOrderItemDTO saleOrderItem : saleOrderItemDTOList) {
            Long saleOrderItemId = saleOrderItem.getSaleOrderItemId();
            DycProOrderShipOrderItemDTO shipOrderItem = new DycProOrderShipOrderItemDTO();
            shipOrderItem.setShipOrderId(shipOrderDTO.getShipOrderId());
            shipOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
            shipOrderItem.setShipOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
            shipOrderItem.setSaleOrderItemId(saleOrderItemId);
            shipOrderItem.setOrderId(saleOrderItem.getOrderId());
            shipOrderItem.setUnitName(saleOrderItem.getUnitName());
            shipOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
            shipOrderItem.setArriveCount(BigDecimal.ZERO);
            shipOrderItem.setRefuseCount(BigDecimal.ZERO);
            shipOrderItem.setReturnCount(BigDecimal.ZERO);
            shipOrderItem.setInspCount(BigDecimal.ZERO);
            shipOrderItem.setCreateTime(new Date());
            shipOrderItem.setRemark("\u4eac\u4e1c\u5916\u90e8\u7535\u5546\u53d1\u8d27");
            shipOrderItem.setShipItemState("FH_FH_FH");
            shipItemList.add(shipOrderItem);
        }
        shipOrderDTO.setShipItemList(shipItemList);
        return shipOrderDTO;
    }

    private DycProOrderSaleStakeholderDTO qrySaleStakeholder(Long stakeholderId) {
        DycProOrderSaleOrderDTO reqDto = new DycProOrderSaleOrderDTO();
        reqDto.setStakeholderId(stakeholderId);
        DycProOrderSaleOrderDTO result = this.saleOrderRepository.querySaleOrderStakeholderByCondition(reqDto);
        return result.getSaleStakeholder();
    }

    private List<DycProOrderOrderQueryIndexDTO> qryOrderQueryIndex(DycProOrderCreateEsShipOrderReqBO reqBO) {
        DycProOrderOrderQueryIndexQryDTO queryIndexQryDTO = new DycProOrderOrderQueryIndexQryDTO();
        queryIndexQryDTO.setOutObjId(reqBO.getResult().getOrderId());
        queryIndexQryDTO.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
        List uocOrderQueryIndexList = this.saleOrderRepository.qryOrderQueryIndexList(queryIndexQryDTO);
        if (CollectionUtils.isEmpty((Collection)uocOrderQueryIndexList) || uocOrderQueryIndexList.size() != 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u5916\u90e8\u8ba2\u5355" + reqBO.getResult().getOrderId() + "\u5173\u8054\u8868\u4e3a\u7a7a");
        }
        return uocOrderQueryIndexList;
    }

    private DycProOrderSaleOrderDTO qrySalOrderDetail(Long saleOrderId) {
        DycProOrderSaleOrderDTO saleOrderDetailApiReqBO = new DycProOrderSaleOrderDTO();
        saleOrderDetailApiReqBO.setSaleOrderId(saleOrderId);
        DycProOrderSaleOrderDTO saleOrderDTO = this.saleOrderRepository.querySaleOrderOneByCondition(saleOrderDetailApiReqBO);
        if (saleOrderDTO == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5\u5931\u8d25\uff0c\u9500\u552e\u5355id\u4e3a\uff1a" + saleOrderId);
        }
        if ("XS_QX_QXSQ".equals(saleOrderDTO.getSaleOrderState()) || "XS_QX_QX".equals(saleOrderDTO.getSaleOrderState())) {
            throw new ZTBusinessException("\u8be5\u9500\u552e\u5355\u5df2\u53d6\u6d88\uff0c\u6216\u6b63\u5728\u53d6\u6d88\u7533\u8bf7\u4e2d\uff0c\u9500\u552e\u5355id\u4e3a\uff1a" + saleOrderId);
        }
        return saleOrderDTO;
    }

    public DycProBaseCallEsbUtilOrderQrySubOrderRspBO getExtOrderInfo(DycProOrderCreateEsShipOrderReqBO reqBO, DycProOrderSaleOrderDTO salOrderDetail) {
        DycProBaseCallEsbUtilOrderQrySubOrderReqBO qrySubOrderReqBO = new DycProBaseCallEsbUtilOrderQrySubOrderReqBO();
        qrySubOrderReqBO.setOrderId(reqBO.getResult().getOrderId());
        qrySubOrderReqBO.setUrl(this.qrySubOrderUrl);
        qrySubOrderReqBO.setHsn(this.environment.getProperty("SUPPLIER_ID_" + salOrderDetail.getSaleStakeholder().getSupId()));
        log.debug("\u8c03\u7528\u7535\u5546\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u5165\u53c2{}", (Object)JSON.toJSONString((Object)qrySubOrderReqBO));
        DycProBaseCallEsbUtilOrderQrySubOrderRspBO qrySubOrderRspBO = DycProBaseCallEsbUtil.qrySubOrder((DycProBaseCallEsbUtilOrderQrySubOrderReqBO)qrySubOrderReqBO);
        log.debug("\u8c03\u7528\u7535\u5546\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)qrySubOrderRspBO));
        if (qrySubOrderRspBO.getSuccess() == null || !qrySubOrderRspBO.getSuccess().booleanValue() || !"0000".equals(qrySubOrderRspBO.getResultCode())) {
            log.info("\u5916\u90e8\u8ba2\u5355\uff1a{}\u67e5\u8be2\u7b2c\u4e09\u65b9\u5916\u90e8\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)reqBO.getResult().getOrderId(), (Object)qrySubOrderRspBO.getResultMessage());
            throw new ZTBusinessException("\u5916\u90e8\u8ba2\u5355:" + reqBO.getResult().getOrderId() + "\u67e5\u8be2\u7b2c\u4e09\u65b9\u5916\u90e8\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38:" + qrySubOrderRspBO.getResultMessage());
        }
        return qrySubOrderRspBO;
    }

    public DycProBaseCallEsbUtilOrderQryPackageRspBO getOutDeliverInfo(DycProOrderCreateEsShipOrderReqBO reqBO, DycProOrderSaleOrderDTO salOrderDetail) {
        DycProBaseCallEsbUtilOrderQryPackageReqBO qryPackageReqBO = new DycProBaseCallEsbUtilOrderQryPackageReqBO();
        qryPackageReqBO.setPackageId(reqBO.getResult().getPackageId());
        qryPackageReqBO.setUrl(this.qryPackageUrl);
        qryPackageReqBO.setHsn(this.environment.getProperty("SUPPLIER_ID_" + salOrderDetail.getSaleStakeholder().getSupId()));
        log.debug("\u8c03\u7528\u7535\u5546\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u5165\u53c2{}", (Object)JSON.toJSONString((Object)qryPackageReqBO));
        DycProBaseCallEsbUtilOrderQryPackageRspBO qryPackageRspBO = DycProBaseCallEsbUtil.qryPackage((DycProBaseCallEsbUtilOrderQryPackageReqBO)qryPackageReqBO);
        log.debug("\u8c03\u7528\u7535\u5546\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u5165\u53c2{}", (Object)JSON.toJSONString((Object)qryPackageRspBO));
        if (qryPackageRspBO.getSuccess() == null || !qryPackageRspBO.getSuccess().booleanValue() || !"0000".equals(qryPackageRspBO.getResultCode())) {
            log.info("\u5916\u90e8\u53d1\u8d27\u5355\uff1a{}\u67e5\u8be2\u7b2c\u4e09\u65b9\u5916\u90e8\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)reqBO.getResult().getPackageId(), (Object)qryPackageRspBO.getResultMessage());
            throw new ZTBusinessException("\u5916\u90e8\u53d1\u8d27\u5355:" + reqBO.getResult().getPackageId() + "\u67e5\u8be2\u7b2c\u4e09\u65b9\u5916\u90e8\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38:" + qryPackageRspBO.getResultMessage());
        }
        return qryPackageRspBO;
    }

    public DycProOrderShipOrderDTO buildShipAndItemData(DycProOrderSaleOrderDTO salOrderDetail, List<DycProOrderSaleOrderItemDTO> needShipSaleOrderItemList, DycProBaseCallEsbUtilOrderQryPackageBO packageInfo, Map<String, BigDecimal> skuSendNumMap) {
        DycProOrderShipOrderDTO shipOrderDTO = new DycProOrderShipOrderDTO();
        shipOrderDTO.setSaleOrderId(salOrderDetail.getSaleOrderId());
        shipOrderDTO.setOrderId(salOrderDetail.getOrderId());
        shipOrderDTO.setShipOrderState("FH_FH_FH");
        shipOrderDTO.setCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)packageInfo.getPackageId())) {
            shipOrderDTO.setShipOrderNoExt(packageInfo.getOrderId());
        } else {
            shipOrderDTO.setShipOrderNoExt(packageInfo.getPackageId());
        }
        shipOrderDTO.setShipCompanyName(packageInfo.getDeliveryName());
        shipOrderDTO.setShipCompanyId(packageInfo.getDeliveryCode());
        log.debug("\u53d1\u8d27\u65e5\u671f1{}", (Object)JSON.toJSONString((Object)packageInfo.getDeliverytime()));
        log.debug("\u53d1\u8d27\u65e5\u671f2{}", (Object)JSON.toJSONString((Object)DateUtils.strToDateLong((String)packageInfo.getDeliverytime())));
        shipOrderDTO.setShipTime(DateUtils.strToDateLong((String)packageInfo.getDeliverytime()));
        shipOrderDTO.setShipRemark("\u5916\u90e8\u7535\u5546\u53d1\u8d27");
        ArrayList<DycProOrderShipOrderItemDTO> shipItemList = new ArrayList<DycProOrderShipOrderItemDTO>();
        for (DycProOrderSaleOrderItemDTO saleOrderItem : needShipSaleOrderItemList) {
            Long saleOrderItemId = saleOrderItem.getSaleOrderItemId();
            DycProOrderShipOrderItemDTO shipOrderItem = new DycProOrderShipOrderItemDTO();
            shipOrderItem.setShipOrderId(shipOrderDTO.getShipOrderId());
            shipOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
            shipOrderItem.setShipOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
            shipOrderItem.setSaleOrderItemId(saleOrderItemId);
            shipOrderItem.setOrderId(saleOrderItem.getOrderId());
            shipOrderItem.setUnitName(saleOrderItem.getUnitName());
            if (skuSendNumMap.get(saleOrderItem.getSkuId()) != null) {
                if (saleOrderItem.getPurchaseCount().compareTo(skuSendNumMap.get(saleOrderItem.getSkuId())) < 0) {
                    shipOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
                    skuSendNumMap.put(saleOrderItem.getSkuId(), skuSendNumMap.get(saleOrderItem.getSkuId()).subtract(saleOrderItem.getPurchaseCount()));
                } else {
                    shipOrderItem.setSendCount(skuSendNumMap.get(saleOrderItem.getSkuId()));
                }
            } else {
                shipOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
            }
            shipOrderItem.setArriveCount(BigDecimal.ZERO);
            shipOrderItem.setRefuseCount(BigDecimal.ZERO);
            shipOrderItem.setReturnCount(BigDecimal.ZERO);
            shipOrderItem.setInspCount(BigDecimal.ZERO);
            shipOrderItem.setCreateTime(new Date());
            shipOrderItem.setRemark("\u5916\u90e8\u7535\u5546\u53d1\u8d27");
            shipOrderItem.setShipItemState("FH_FH_FH");
            shipItemList.add(shipOrderItem);
        }
        shipOrderDTO.setShipItemList(shipItemList);
        return shipOrderDTO;
    }

    public DycProOrderShipOrderDTO ceateShipOrder(DycProOrderShipOrderDTO shipOrderDTO, DycProOrderSaleOrderDTO salOrderDetail) {
        log.debug("\u53d1\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shipOrderDTO));
        DycProOrderShipOrderDTO shipOrder = this.shipOrderRepository.addShipOrderAllInfoAndSyncNosql(shipOrderDTO, salOrderDetail);
        DycProOrderOrderQueryIndexDTO uocOrderQueryIndex = new DycProOrderOrderQueryIndexDTO();
        uocOrderQueryIndex.setObjId(shipOrder.getShipOrderId());
        uocOrderQueryIndex.setOrderSystem(DycProOrderApiServiceConstant.OBJ_TYPE.SHIP.toString());
        uocOrderQueryIndex.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SHIP);
        uocOrderQueryIndex.setOutObjId(shipOrder.getShipOrderNoExt());
        uocOrderQueryIndex.setOrderId(shipOrder.getOrderId());
        uocOrderQueryIndex.setId(Long.valueOf(Sequence.getInstance().nextId()));
        this.saleOrderRepository.addOrderQueryIndex(uocOrderQueryIndex);
        DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
        ArrayList<DycProOrderSaleOrderItemDTO> saleOrderItems = new ArrayList<DycProOrderSaleOrderItemDTO>();
        for (DycProOrderShipOrderItemDTO item : shipOrderDTO.getShipItemList()) {
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = new DycProOrderSaleOrderItemDTO();
            saleOrderItemDTO.setSaleOrderItemId(item.getSaleOrderItemId());
            saleOrderItemDTO.setSendCount(item.getSendCount());
            saleOrderItems.add(saleOrderItemDTO);
        }
        saleOrderDTO.setSaleItemList(saleOrderItems);
        this.saleOrderRepository.updateBatchSaleOrderItemSendCount(saleOrderDTO);
        return shipOrder;
    }

    private void qryEstimateArrivalTime(DycProOrderShipOrderDTO shipOrderDTO, DycProOrderSaleOrderDTO salOrderDetail) {
        ArrayList<Date> estimateArrivalTimes = new ArrayList<Date>();
        Map saleOrderItemDTOMap = salOrderDetail.getSaleItemList().stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, Function.identity()));
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + salOrderDetail.getSaleStakeholder().getSupId());
        for (DycProOrderShipOrderItemDTO shipItem : shipOrderDTO.getShipItemList()) {
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemDTOMap.get(shipItem.getSaleOrderItemId());
            DycProBaseCallEsbUtilGetPromiseTipsReqBO dycProBaseCallEsbUtilGetPromiseTipsReqBO = new DycProBaseCallEsbUtilGetPromiseTipsReqBO();
            dycProBaseCallEsbUtilGetPromiseTipsReqBO.setSkuId(saleOrderItemDTO.getSkuExtSkuId());
            dycProBaseCallEsbUtilGetPromiseTipsReqBO.setNum(shipItem.getSendCount().toString());
            dycProBaseCallEsbUtilGetPromiseTipsReqBO.setProvince(StringUtils.isBlank((CharSequence)salOrderDetail.getReceiverAddress().getContactProvinceId()) ? 0 : Integer.parseInt(salOrderDetail.getReceiverAddress().getContactProvinceId()));
            dycProBaseCallEsbUtilGetPromiseTipsReqBO.setCity(StringUtils.isBlank((CharSequence)salOrderDetail.getReceiverAddress().getContactCityId()) ? 0 : Integer.parseInt(salOrderDetail.getReceiverAddress().getContactCityId()));
            dycProBaseCallEsbUtilGetPromiseTipsReqBO.setCounty(StringUtils.isBlank((CharSequence)salOrderDetail.getReceiverAddress().getContactCountyId()) ? 0 : Integer.parseInt(salOrderDetail.getReceiverAddress().getContactCountyId()));
            dycProBaseCallEsbUtilGetPromiseTipsReqBO.setTown(StringUtils.isBlank((CharSequence)salOrderDetail.getReceiverAddress().getContactTownId()) ? 0 : Integer.parseInt(salOrderDetail.getReceiverAddress().getContactTownId()));
            dycProBaseCallEsbUtilGetPromiseTipsReqBO.setHsn(hsn);
            dycProBaseCallEsbUtilGetPromiseTipsReqBO.setUrl(this.getPromiseTipsUrl);
            log.debug("\u8c03\u7528\u7535\u5546\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u67e5\u8be2\u63a5\u53e3\u5165\u53c2{}", (Object)JSON.toJSONString((Object)dycProBaseCallEsbUtilGetPromiseTipsReqBO));
            DycProBaseCallEsbUtilGetPromiseTipsRspBO result = DycProBaseCallEsbUtil.getPromiseTips((DycProBaseCallEsbUtilGetPromiseTipsReqBO)dycProBaseCallEsbUtilGetPromiseTipsReqBO);
            log.debug("\u8c03\u7528\u7535\u5546\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)result));
            if (result.getSuccess() == null || !result.getSuccess().booleanValue()) {
                throw new ZTBusinessException("\u9500\u552e\u5355id:" + saleOrderItemDTO.getSkuExtSkuId() + "\u67e5\u8be2\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u4fe1\u606f\u5f02\u5e38:" + result.getResultMessage());
            }
            try {
                Date date = DateUtils.strToDate((String)result.getEta(), (String)"yyyy-MM-dd HH:mm:ss");
                estimateArrivalTimes.add(date);
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25\uff01");
            }
        }
        log.debug("\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString(estimateArrivalTimes));
        shipOrderDTO.setEstimateArrivalTime((Date)estimateArrivalTimes.stream().max(Comparator.naturalOrder()).orElse(null));
    }

    private boolean checkSaleOrderIsFinish(DycProOrderSaleOrderDTO salOrderDetail) {
        DycProOrderSaleOrderItemDTO saleOrderItemDTO = new DycProOrderSaleOrderItemDTO();
        saleOrderItemDTO.setSaleOrderId(salOrderDetail.getSaleOrderId());
        DycProOrderSaleOrderItemDTO saleOrderItemCollectSum = this.saleOrderRepository.getSaleOrderItemCollectSum(saleOrderItemDTO);
        if (saleOrderItemCollectSum == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
        }
        return saleOrderItemCollectSum.getPurchaseCount().compareTo(saleOrderItemCollectSum.getSendCount().add(saleOrderItemCollectSum.getReturnCount())) <= 0;
    }
}

