/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.config.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.config.api.DycProOrderZlConfigRepository;
import com.tydic.dyc.pro.egc.repository.config.dto.DycProOrderCreateZlCostCenterInfoDTO;
import com.tydic.dyc.pro.egc.repository.config.dto.DycProOrderQueryZlCostCenterInfoDTO;
import com.tydic.dyc.pro.egc.service.config.api.DycProOrderExtCostCenterSyncService;
import com.tydic.dyc.pro.egc.service.config.bo.DycProOrderExtCostCenterSyncReqBO;
import com.tydic.dyc.pro.egc.service.config.bo.DycProOrderExtCostCenterSyncRspBO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.config.api.DycProOrderExtCostCenterSyncService"})
public class DycProOrderExtCostCenterSyncServiceImpl
implements DycProOrderExtCostCenterSyncService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderExtCostCenterSyncServiceImpl.class);
    @Autowired
    private DycProOrderZlConfigRepository zlConfigRepository;

    @PostMapping(value={"syncCostCenter"})
    public DycProOrderExtCostCenterSyncRspBO syncCostCenter(@RequestBody DycProOrderExtCostCenterSyncReqBO reqBO) {
        log.info("syncCostCenter syncType={}, code={}, orgId={}, orgCode={}", new Object[]{reqBO.getSyncType(), reqBO.getCostCenterCode(), reqBO.getOrgId(), reqBO.getOrgCode()});
        Integer syncType = reqBO.getSyncType();
        switch (syncType) {
            case 1: {
                DycProOrderQueryZlCostCenterInfoDTO queryReq = new DycProOrderQueryZlCostCenterInfoDTO();
                queryReq.setCostCenterCode(reqBO.getCostCenterCode());
                queryReq.setOrgId(reqBO.getOrgId());
                if (this.zlConfigRepository.getCostCenterByCodeAndOrg(queryReq) != null) break;
                DycProOrderCreateZlCostCenterInfoDTO dto = new DycProOrderCreateZlCostCenterInfoDTO();
                BeanUtils.copyProperties((Object)reqBO, (Object)dto);
                this.zlConfigRepository.createZlCostCenterInfo(dto);
                break;
            }
            case 2: {
                DycProOrderQueryZlCostCenterInfoDTO queryReq2 = new DycProOrderQueryZlCostCenterInfoDTO();
                queryReq2.setCostCenterCode(reqBO.getCostCenterCode());
                queryReq2.setOrgId(reqBO.getOrgId());
                DycProOrderQueryZlCostCenterInfoDTO exist = this.zlConfigRepository.getCostCenterByCodeAndOrg(queryReq2);
                if (exist == null) {
                    DycProOrderCreateZlCostCenterInfoDTO dto = new DycProOrderCreateZlCostCenterInfoDTO();
                    BeanUtils.copyProperties((Object)reqBO, (Object)dto);
                    this.zlConfigRepository.createZlCostCenterInfo(dto);
                    break;
                }
                BeanUtils.copyProperties((Object)reqBO, (Object)exist);
                this.zlConfigRepository.updateCostCenter(exist);
                break;
            }
            case 3: {
                DycProOrderQueryZlCostCenterInfoDTO deleteReq = new DycProOrderQueryZlCostCenterInfoDTO();
                deleteReq.setCostCenterCode(reqBO.getCostCenterCode());
                deleteReq.setOrgId(reqBO.getOrgId());
                this.zlConfigRepository.deleteCostCenterByCodeAndOrg(deleteReq);
                break;
            }
            default: {
                throw new ZTBusinessException("\u975e\u6cd5\u7684syncType: " + syncType);
            }
        }
        return new DycProOrderExtCostCenterSyncRspBO();
    }

    @PostMapping(value={"batchCreateCostCenter"})
    public DycProOrderExtCostCenterSyncRspBO batchCreateCostCenter(@RequestBody List<DycProOrderExtCostCenterSyncReqBO> reqBOList) {
        log.info("batchCreateCostCenter start, size={}", (Object)(reqBOList != null ? reqBOList.size() : 0));
        if (reqBOList == null || reqBOList.isEmpty()) {
            return new DycProOrderExtCostCenterSyncRspBO();
        }
        try {
            List insertList = reqBOList.stream().map(reqBO -> {
                DycProOrderCreateZlCostCenterInfoDTO dto = new DycProOrderCreateZlCostCenterInfoDTO();
                BeanUtils.copyProperties((Object)reqBO, (Object)dto);
                return dto;
            }).collect(Collectors.toList());
            if (!insertList.isEmpty()) {
                log.info("batchCreateCostCenter inserting {} records", (Object)insertList.size());
                this.zlConfigRepository.batchCreateZlCostCenterInfo(insertList);
            }
            log.info("batchCreateCostCenter completed successfully");
            return new DycProOrderExtCostCenterSyncRspBO();
        }
        catch (Exception e) {
            log.error("batchCreateCostCenter failed", (Throwable)e);
            throw new ZTBusinessException("\u6279\u91cf\u65b0\u589e\u6210\u672c\u4e2d\u5fc3\u5931\u8d25: " + e.getMessage());
        }
    }
}

