/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.approve.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.ZlUocOutApprovalRecordDTO;
import com.tydic.dyc.pro.egc.service.approve.api.DycProOrderDealReadyApprovalOrderResultApiService;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderDealReadyApprovalOrderResultApiReqBO;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderDealReadyApprovalOrderResultApiRspBO;
import com.tydic.dyc.pro.egc.service.approve.bo.DycProOrderDealReadyApprovalOrderStepApiBO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.approve.api.DycProOrderDealReadyApprovalOrderResultApiService"})
public class DycProOrderDealReadyApprovalOrderResultApiServiceImpl
implements DycProOrderDealReadyApprovalOrderResultApiService {
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;

    @PostMapping(value={"dealReadyApprovalOrderResult"})
    public DycProOrderDealReadyApprovalOrderResultApiRspBO dealReadyApprovalOrderResult(@RequestBody DycProOrderDealReadyApprovalOrderResultApiReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderSaleOrderDTO querySaleOrderDTO = new DycProOrderSaleOrderDTO();
        querySaleOrderDTO.setSaleOrderNo(reqBO.getOrderNo());
        DycProOrderSaleOrderDTO saleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDTO);
        if (null == saleOrderDTO) {
            throw new ZTBusinessException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        ArrayList<ZlUocOutApprovalRecordDTO> zlUocOutApprovalRecordDTOList = new ArrayList<ZlUocOutApprovalRecordDTO>(1);
        for (DycProOrderDealReadyApprovalOrderStepApiBO stepApiBO : reqBO.getApprovalStepList()) {
            ZlUocOutApprovalRecordDTO zlUocOutApprovalRecordDTO = new ZlUocOutApprovalRecordDTO();
            BeanUtils.copyProperties((Object)stepApiBO, (Object)zlUocOutApprovalRecordDTO);
            zlUocOutApprovalRecordDTOList.add(zlUocOutApprovalRecordDTO);
        }
        this.dycProOrderApproveRepository.addBatchOutApprovalRecord(zlUocOutApprovalRecordDTOList);
        DycProPublicTaskInstDTO dycProPublicTaskInstDTO = new DycProPublicTaskInstDTO();
        dycProPublicTaskInstDTO.setObjId(saleOrderDTO.getSaleOrderId());
        dycProPublicTaskInstDTO.setObjType("salesOrder");
        dycProPublicTaskInstDTO.setFinishTag(Integer.valueOf(0));
        List dycProPublicTaskInstDTOList = this.dycProPublicTaskInstRepository.queryFlowTaskList(dycProPublicTaskInstDTO);
        if (CollectionUtils.isEmpty((Collection)dycProPublicTaskInstDTOList)) {
            throw new ZTBusinessException("\u672a\u627e\u5230\u4efb\u52a1\u5b9e\u4f8b");
        }
        DycProPublicTaskInstHandleDTO dycProPublicTaskInstHandleDTO = new DycProPublicTaskInstHandleDTO();
        dycProPublicTaskInstHandleDTO.setTaskInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOList.get(0)).getTaskInstId());
        this.dycProPublicTaskInstRepository.completeBusiFlowTask(dycProPublicTaskInstHandleDTO);
        if (reqBO.getFinallyApprovalFlag() == 0) {
            ZlUocOutApprovalRecordDTO lastZlUocOutApprovalRecordDTO = (ZlUocOutApprovalRecordDTO)zlUocOutApprovalRecordDTOList.get(zlUocOutApprovalRecordDTOList.size() - 1);
            DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
            updateSaleOrderDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
            updateSaleOrderDTO.setSaleOrderState("XS_QX_QX");
            updateSaleOrderDTO.setCancelReason(lastZlUocOutApprovalRecordDTO.getApproverRemark());
            updateSaleOrderDTO.setCancelOperId(lastZlUocOutApprovalRecordDTO.getApproverUserId());
            updateSaleOrderDTO.setCancelOperName(lastZlUocOutApprovalRecordDTO.getApproverUserName());
            updateSaleOrderDTO.setCancelTime(lastZlUocOutApprovalRecordDTO.getApproverTime());
            updateSaleOrderDTO.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.APPROVE_CANCEL);
            updateSaleOrderDTO.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
            this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDTO, true);
            if (null != saleOrderDTO.getBudgetId()) {
                this.deductBudget(saleOrderDTO);
            }
        }
        DycProOrderDealReadyApprovalOrderResultApiRspBO rspBO = new DycProOrderDealReadyApprovalOrderResultApiRspBO();
        rspBO.setTaskId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOList.get(0)).getTaskInstId());
        rspBO.setProcInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOList.get(0)).getProcInstId());
        return rspBO;
    }

    private void paramVerify(DycProOrderDealReadyApprovalOrderResultApiReqBO reqBO) {
        if (StringUtils.isBlank((String)reqBO.getOrderNo())) {
            throw new ZTBusinessException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getFinallyApprovalFlag()) {
            throw new ZTBusinessException("\u662f\u5426\u662f\u6700\u7ec8\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFinallyApprovalFlag() != 1 && reqBO.getFinallyApprovalFlag() != 0) {
            throw new ZTBusinessException("\u662f\u5426\u662f\u6700\u7ec8\u5ba1\u6279\u7ed3\u679c\u53c2\u6570\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getApprovalStepList())) {
            throw new ZTBusinessException("\u5ba1\u6279\u6d41\u7a0b\u6b65\u9aa4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProOrderDealReadyApprovalOrderStepApiBO readyApprovalOrderStepApiBO : reqBO.getApprovalStepList()) {
            if (StringUtils.isBlank((String)readyApprovalOrderStepApiBO.getApproverUserId())) {
                throw new ZTBusinessException("\u5ba1\u6279\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)readyApprovalOrderStepApiBO.getApproverUserName())) {
                throw new ZTBusinessException("\u5ba1\u6279\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)readyApprovalOrderStepApiBO.getApproverStep())) {
                throw new ZTBusinessException("\u5ba1\u6279\u6b65\u9aa4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == readyApprovalOrderStepApiBO.getApproverTime()) {
                throw new ZTBusinessException("\u5ba1\u6279\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != readyApprovalOrderStepApiBO.getApproverResult()) continue;
            throw new ZTBusinessException("\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void deductBudget(DycProOrderSaleOrderDTO saleOrder) {
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrder.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(saleOrder.getTotalSaleFee().negate());
        dycProOrderBudgetUsedRecordDTO.setObjId(saleOrder.getSaleOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(saleOrder.getSaleOrderNo());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(2));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }
}

