/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.tydic.dyc.pro.egc.dao.UocSaleOrderItemMapper;
import com.tydic.dyc.pro.egc.dao.UocSaleOrderMapper;
import com.tydic.dyc.pro.egc.po.UocSaleOrderItemPO;
import com.tydic.dyc.pro.egc.repository.report.api.DycProReportDataRepository;
import com.tydic.dyc.pro.egc.repository.report.dto.DycProReportDataDTO;
import com.tydic.dyc.pro.egc.service.report.api.DycProCreateReportDataService;
import com.tydic.dyc.pro.egc.service.report.bo.DycProCreateReportDataReqBO;
import com.tydic.dyc.pro.egc.service.report.bo.DycProCreateReportDataRspBO;
import com.tydic.dyc.pro.egc.service.report.bo.DycProQryOrderInfoReqBO;
import com.tydic.dyc.pro.egc.service.report.bo.DycProQryOrderInfoRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.report.api.DycProCreateReportDataService"})
public class DycProCreateReportDataServiceImpl
implements DycProCreateReportDataService {
    private static final Logger log = LoggerFactory.getLogger(DycProCreateReportDataServiceImpl.class);
    @Autowired
    private DycProReportDataRepository dycProReportDataRepository;
    @Autowired
    private UocSaleOrderMapper uocSaleOrderMapper;
    @Autowired
    private UocSaleOrderItemMapper uocSaleOrderItemMapper;

    @PostMapping(value={"createReportDetail"})
    public DycProCreateReportDataRspBO createReportDetail(@RequestBody DycProCreateReportDataReqBO reqBO) {
        DycProReportDataDTO dycProReportDataDTOReq = new DycProReportDataDTO();
        dycProReportDataDTOReq.setSeqId(reqBO.getSeqId());
        DycProReportDataDTO dycProReportDataDTO = this.dycProReportDataRepository.createReportDetail(dycProReportDataDTOReq);
        return (DycProCreateReportDataRspBO)JSON.parseObject((String)JSON.toJSONString((Object)dycProReportDataDTO), DycProCreateReportDataRspBO.class);
    }

    @PostMapping(value={"qryOrderInfo"})
    public DycProQryOrderInfoRspBO qryOrderInfo(@RequestBody DycProQryOrderInfoReqBO reqBO) {
        DycProQryOrderInfoRspBO orderRspBO = new DycProQryOrderInfoRspBO();
        DycProReportDataDTO dycProReportDataDTOReq = new DycProReportDataDTO();
        dycProReportDataDTOReq.setSeqId(reqBO.getSaleOrderId());
        DycProReportDataDTO dycProReportDataDTO = this.dycProReportDataRepository.qryReportDetailByOrderId(dycProReportDataDTOReq);
        if (dycProReportDataDTO != null && dycProReportDataDTO.getSaleOrderId() != null) {
            return orderRspBO;
        }
        orderRspBO.setSaleOrderId(reqBO.getSaleOrderId());
        List uocSaleOrderItemPOList = this.uocSaleOrderItemMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(null != reqBO.getSaleOrderId(), UocSaleOrderItemPO::getSaleOrderId, (Object)reqBO.getSaleOrderId()));
        if (!CollectionUtils.isEmpty((Collection)uocSaleOrderItemPOList)) {
            List distinctAgreementIds = uocSaleOrderItemPOList.stream().map(UocSaleOrderItemPO::getAgreementId).filter(Objects::nonNull).map(String::trim).filter(id -> !id.isEmpty()).distinct().collect(Collectors.toList());
            orderRspBO.setAgreementId(distinctAgreementIds);
        }
        return orderRspBO;
    }

    @PostMapping(value={"createReportBaseInfo"})
    public DycProQryOrderInfoRspBO createReportBaseInfo(@RequestBody DycProQryOrderInfoReqBO reqBO) {
        DycProReportDataDTO dycProReportDataDTOReq = new DycProReportDataDTO();
        dycProReportDataDTOReq.setSaleOrderId(reqBO.getSaleOrderId());
        dycProReportDataDTOReq.setAgreementId(reqBO.getAgreementId());
        dycProReportDataDTOReq.setAgrCode(reqBO.getAgrCode());
        DycProReportDataDTO dycProReportDataDTO = this.dycProReportDataRepository.createReportBaseDetail(dycProReportDataDTOReq);
        return new DycProQryOrderInfoRspBO();
    }
}

