/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.cmporder.impl;

import com.alibaba.fastjson.JSONObject;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.cmporder.api.DycProOrderCmpOrderRepository;
import com.tydic.dyc.pro.egc.repository.cmporder.dto.DycProOrderCmpOrderDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyItemDTO;
import com.tydic.dyc.pro.egc.service.cmporder.api.DycProOrderCreateCmpOrderService;
import com.tydic.dyc.pro.egc.service.cmporder.bo.DycProOrderCreateCmpOrderItemBO;
import com.tydic.dyc.pro.egc.service.cmporder.bo.DycProOrderCreateCmpOrderReqBO;
import com.tydic.dyc.pro.egc.service.cmporder.bo.DycProOrderCreateCmpOrderRspBO;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.cmporder.api.DycProOrderCreateCmpOrderService"})
public class DycProOrderCreateCmpOrderServiceImpl
implements DycProOrderCreateCmpOrderService {
    @Autowired
    private DycProOrderCmpOrderRepository dycProOrderCmpOrderRepository;
    @Autowired
    private DycProOrderPurchaseApplyRepository dycProOrderPurchaseApplyRepository;

    @PostMapping(value={"createCmpOrder"})
    public DycProOrderCreateCmpOrderRspBO createCmpOrder(@RequestBody DycProOrderCreateCmpOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        DycProOrderCmpOrderDTO addCmpOrderDto = (DycProOrderCmpOrderDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), DycProOrderCmpOrderDTO.class);
        addCmpOrderDto.setCreateOperId(String.valueOf(reqBO.getUserId()));
        addCmpOrderDto.setCreateOperName(reqBO.getName());
        addCmpOrderDto.setCreateOrgId(String.valueOf(reqBO.getOrgId()));
        addCmpOrderDto.setCreateOrgName(reqBO.getOrgName());
        DycProOrderCmpOrderDTO cmpOrderInfoDto = this.dycProOrderCmpOrderRepository.createCmpOrderAllInfo(addCmpOrderDto);
        if (null != cmpOrderInfoDto) {
            this.updatePurchaseApplyCmpOrderNo(reqBO, cmpOrderInfoDto);
            DycProOrderCreateCmpOrderRspBO rspBO = new DycProOrderCreateCmpOrderRspBO();
            rspBO.setCmpOrderId(cmpOrderInfoDto.getCmpOrderId());
            rspBO.setCmpOrderNo(cmpOrderInfoDto.getCmpOrderNo());
            return rspBO;
        }
        throw new ZTBusinessException("\u521b\u5efa\u6bd4\u9009\u5355\u5931\u8d25");
    }

    private void verifyParam(DycProOrderCreateCmpOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCmpOrderItemList())) {
            throw new ZTBusinessException("\u6bd4\u9009\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updatePurchaseApplyCmpOrderNo(DycProOrderCreateCmpOrderReqBO reqBO, DycProOrderCmpOrderDTO cmpOrderInfoDto) {
        if (null == reqBO.getCmpSource() || reqBO.getCmpSource() != 2) {
            return;
        }
        ArrayList<DycProOrderZlPurchaseApplyItemDTO> updateBatchPurchaseApplyDTOList = new ArrayList<DycProOrderZlPurchaseApplyItemDTO>(1);
        for (DycProOrderCreateCmpOrderItemBO createCmpOrderItemBO : reqBO.getCmpOrderItemList()) {
            if (null == createCmpOrderItemBO.getPurApplyItemId()) continue;
            DycProOrderZlPurchaseApplyItemDTO updatePurchaseApplyDTO = new DycProOrderZlPurchaseApplyItemDTO();
            updatePurchaseApplyDTO.setPurApplyItemId(createCmpOrderItemBO.getPurApplyItemId());
            updatePurchaseApplyDTO.setCmpOrderNo(cmpOrderInfoDto.getCmpOrderNo());
            updateBatchPurchaseApplyDTOList.add(updatePurchaseApplyDTO);
        }
        this.dycProOrderPurchaseApplyRepository.updateBatchPurchaseApplyItemByIds(updateBatchPurchaseApplyDTOList);
    }
}

