/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilConfirmOrderReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilConfirmOrderRspBO;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleStakeholderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.ZlUocOutApprovalRecordDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderDealConfirmPreOrderForYzService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderDealConfirmPreOrderForYzApiReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderDealConfirmPreOrderForYzApiRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderDealConfirmPreOrderStepForYzBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderDealConfirmPreOrderForYzService"})
public class DycProOrderDealConfirmPreOrderForYzServiceImpl
implements DycProOrderDealConfirmPreOrderForYzService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderDealConfirmPreOrderForYzServiceImpl.class);
    @Value(value="${call.esb.url.confirmOrder}")
    private String callEsbUrlConfirmOrder;
    @Value(value="${call.esb.url.cancel}")
    private String callEsbUrlCancel;
    @Autowired
    private Environment environment;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;

    @PostMapping(value={"dealConfirmPreOrder"})
    public DycProOrderDealConfirmPreOrderForYzApiRspBO dealConfirmPreOrder(@RequestBody DycProOrderDealConfirmPreOrderForYzApiReqBO reqBO) {
        DycProOrderSaleOrderDTO saleOrderDTO = this.getSaleOrderMainInfo(reqBO.getOrderNo());
        DycProOrderSaleStakeholderDTO saleStakeholderDTO = this.getSaleStakeholderInfo(saleOrderDTO.getStakeholderId());
        List<DycProPublicTaskInstDTO> dycProPublicTaskInstDTOList = this.getFlowTaskList(saleOrderDTO);
        if (reqBO.getFinallyApprovalFlag() == 1) {
            this.confirmOrder(saleOrderDTO, saleStakeholderDTO);
        } else {
            this.cancelOrder(saleOrderDTO, saleStakeholderDTO);
        }
        this.addBatchOutApprovalRecord(reqBO, saleOrderDTO);
        this.completeBusiFlowTask(dycProPublicTaskInstDTOList);
        if (reqBO.getFinallyApprovalFlag() == 0) {
            this.updateSaleOrderCancel(reqBO, saleOrderDTO);
        }
        DycProOrderDealConfirmPreOrderForYzApiRspBO rspBO = new DycProOrderDealConfirmPreOrderForYzApiRspBO();
        rspBO.setTaskId(dycProPublicTaskInstDTOList.get(0).getTaskInstId());
        rspBO.setProcInstId(dycProPublicTaskInstDTOList.get(0).getProcInstId());
        return rspBO;
    }

    private DycProOrderSaleOrderDTO getSaleOrderMainInfo(String saleOrderNo) {
        DycProOrderSaleOrderDTO querySaleOrderDTO = new DycProOrderSaleOrderDTO();
        querySaleOrderDTO.setSaleOrderNo(saleOrderNo);
        DycProOrderSaleOrderDTO saleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDTO);
        if (null == saleOrderDTO) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return saleOrderDTO;
    }

    private DycProOrderSaleStakeholderDTO getSaleStakeholderInfo(Long stakeholderId) {
        DycProOrderSaleOrderDTO querySaleStakeholderDTO = new DycProOrderSaleOrderDTO();
        querySaleStakeholderDTO.setStakeholderId(stakeholderId);
        DycProOrderSaleStakeholderDTO saleStakeholderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderStakeholderByCondition(querySaleStakeholderDTO).getSaleStakeholder();
        if (null == saleStakeholderDTO) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u4e09\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return saleStakeholderDTO;
    }

    private void confirmOrder(DycProOrderSaleOrderDTO saleOrderDTO, DycProOrderSaleStakeholderDTO saleStakeholderDTO) {
        DycProBaseCallEsbUtilConfirmOrderReqBO dycProBaseCallEsbUtilConfirmOrderReqBO = new DycProBaseCallEsbUtilConfirmOrderReqBO();
        dycProBaseCallEsbUtilConfirmOrderReqBO.setHsn(this.environment.getProperty("SUPPLIER_ID_" + saleStakeholderDTO.getSupId()));
        dycProBaseCallEsbUtilConfirmOrderReqBO.setUrl(this.callEsbUrlConfirmOrder);
        dycProBaseCallEsbUtilConfirmOrderReqBO.setOrderId(saleOrderDTO.getSaleOrderNoExt());
        log.debug("\u9884\u5360\u5e93\u5b58\u8ba2\u5355\u786e\u8ba4|\u7535\u5546\u9884\u5b9a\u5355\u786e\u8ba4\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)dycProBaseCallEsbUtilConfirmOrderReqBO));
        DycProBaseCallEsbUtilConfirmOrderRspBO dycProBaseCallEsbUtilConfirmOrderRspBO = DycProBaseCallEsbUtil.confirmOrder((DycProBaseCallEsbUtilConfirmOrderReqBO)dycProBaseCallEsbUtilConfirmOrderReqBO);
        log.debug("\u9884\u5360\u5e93\u5b58\u8ba2\u5355\u786e\u8ba4|\u7535\u5546\u9884\u5b9a\u5355\u786e\u8ba4\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)dycProBaseCallEsbUtilConfirmOrderRspBO));
        if (!dycProBaseCallEsbUtilConfirmOrderRspBO.getSuccess().booleanValue()) {
            throw new ZTBusinessException("\u7535\u5546\u9884\u5b9a\u5355\u786e\u8ba4\u5931\u8d25: " + dycProBaseCallEsbUtilConfirmOrderRspBO.getResultMessage());
        }
    }

    private void addBatchOutApprovalRecord(DycProOrderDealConfirmPreOrderForYzApiReqBO reqBO, DycProOrderSaleOrderDTO saleOrderDTO) {
        ArrayList<ZlUocOutApprovalRecordDTO> zlUocOutApprovalRecordDTOList = new ArrayList<ZlUocOutApprovalRecordDTO>(1);
        for (DycProOrderDealConfirmPreOrderStepForYzBO orderStepForYzBO : reqBO.getApprovalStepList()) {
            ZlUocOutApprovalRecordDTO zlUocOutApprovalRecordDTO = new ZlUocOutApprovalRecordDTO();
            BeanUtils.copyProperties((Object)orderStepForYzBO, (Object)zlUocOutApprovalRecordDTO);
            zlUocOutApprovalRecordDTO.setOutApprovalRecordId(Long.valueOf(Sequence.getInstance().nextId()));
            zlUocOutApprovalRecordDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
            zlUocOutApprovalRecordDTO.setOrderId(saleOrderDTO.getOrderId());
            zlUocOutApprovalRecordDTOList.add(zlUocOutApprovalRecordDTO);
        }
        this.dycProOrderApproveRepository.addBatchOutApprovalRecord(zlUocOutApprovalRecordDTOList);
    }

    private List<DycProPublicTaskInstDTO> getFlowTaskList(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProPublicTaskInstDTO dycProPublicTaskInstDTO = new DycProPublicTaskInstDTO();
        dycProPublicTaskInstDTO.setObjId(saleOrderDTO.getSaleOrderId());
        dycProPublicTaskInstDTO.setObjType("salesOrder");
        dycProPublicTaskInstDTO.setFinishTag(Integer.valueOf(0));
        List dycProPublicTaskInstDTOList = this.dycProPublicTaskInstRepository.queryFlowTaskList(dycProPublicTaskInstDTO);
        if (CollectionUtils.isEmpty((Collection)dycProPublicTaskInstDTOList)) {
            throw new ZTBusinessException("\u672a\u627e\u5230\u4efb\u52a1\u5b9e\u4f8b");
        }
        return dycProPublicTaskInstDTOList;
    }

    private void completeBusiFlowTask(List<DycProPublicTaskInstDTO> dycProPublicTaskInstDTOList) {
        DycProPublicTaskInstHandleDTO dycProPublicTaskInstHandleDTO = new DycProPublicTaskInstHandleDTO();
        dycProPublicTaskInstHandleDTO.setTaskInstId(dycProPublicTaskInstDTOList.get(0).getTaskInstId());
        this.dycProPublicTaskInstRepository.completeBusiFlowTask(dycProPublicTaskInstHandleDTO);
    }

    private void cancelOrder(DycProOrderSaleOrderDTO saleOrderDTO, DycProOrderSaleStakeholderDTO saleStakeholderDTO) {
        DycProBaseCallEsbUtilCancelReqBO dycProBaseCallEsbUtilCancelReqBO = new DycProBaseCallEsbUtilCancelReqBO();
        dycProBaseCallEsbUtilCancelReqBO.setUrl(this.callEsbUrlCancel);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + saleStakeholderDTO.getSupId());
        dycProBaseCallEsbUtilCancelReqBO.setHsn(hsn);
        if ("jd".equals(hsn) || "jdvop".equals(hsn)) {
            dycProBaseCallEsbUtilCancelReqBO.setJdOrderId(saleOrderDTO.getSaleOrderNoExt());
            dycProBaseCallEsbUtilCancelReqBO.setCancelReason("\u5ba1\u6279\u9a73\u56de");
        } else {
            dycProBaseCallEsbUtilCancelReqBO.setOrderId(saleOrderDTO.getSaleOrderNoExt());
        }
        log.debug("\u9884\u5360\u5e93\u5b58\u8ba2\u5355\u786e\u8ba4|\u53d6\u6d88\u7535\u5546\u8ba2\u5355\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)dycProBaseCallEsbUtilCancelReqBO));
        DycProBaseCallEsbUtilCancelRspBO dycProBaseCallEsbUtilCancelRspBO = DycProBaseCallEsbUtil.cancel((DycProBaseCallEsbUtilCancelReqBO)dycProBaseCallEsbUtilCancelReqBO);
        log.debug("\u9884\u5360\u5e93\u5b58\u8ba2\u5355\u786e\u8ba4|\u53d6\u6d88\u7535\u5546\u8ba2\u5355\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)dycProBaseCallEsbUtilCancelRspBO));
        if (!dycProBaseCallEsbUtilCancelRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilCancelRspBO.getResultCode()) && !"0002".equals(dycProBaseCallEsbUtilCancelRspBO.getResultCode())) {
            throw new ZTBusinessException("\u53d6\u6d88\u7535\u5546\u8ba2\u5355\u5931\u8d25: " + dycProBaseCallEsbUtilCancelRspBO.getResultMessage());
        }
    }

    private void updateSaleOrderCancel(DycProOrderDealConfirmPreOrderForYzApiReqBO reqBO, DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderDealConfirmPreOrderStepForYzBO lastDealConfirmPreOrderStepForYzBO = (DycProOrderDealConfirmPreOrderStepForYzBO)reqBO.getApprovalStepList().get(reqBO.getApprovalStepList().size() - 1);
        DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
        updateSaleOrderDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        updateSaleOrderDTO.setSaleOrderState("XS_QX_QX");
        updateSaleOrderDTO.setCancelReason("\u5ba1\u6279\u9a73\u56de");
        updateSaleOrderDTO.setCancelOperId(lastDealConfirmPreOrderStepForYzBO.getApproverUserId());
        updateSaleOrderDTO.setCancelOperName(lastDealConfirmPreOrderStepForYzBO.getApproverUserName());
        updateSaleOrderDTO.setCancelTime(lastDealConfirmPreOrderStepForYzBO.getApproverTime());
        updateSaleOrderDTO.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.APPROVE_CANCEL);
        updateSaleOrderDTO.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
        this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDTO, true);
    }
}

