/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.purchaseapply.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderImportFileService;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderImportFileReqBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderImportFileRspBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderPurchaseApplyItemInfoBO;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Service
@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderImportFileService"})
public class DycProOrderImportFileServiceImpl
implements DycProOrderImportFileService {
    private static final long MAX_FILE_SIZE = 0x1400000L;
    private static final int MAX_ROWS = 1000;
    private static final Map<String, String> HEADER_MAPPING = new HashMap<String, String>(){
        {
            this.put("\u5546\u54c1\u7f16\u7801", "skuCode");
            this.put("\u5546\u54c1\u540d\u79f0", "skuName");
            this.put("\u96c6\u56e2\u7269\u6599\u7f16\u7801", "materialCode");
            this.put("\u7269\u6599\u63cf\u8ff0", "materailDesc");
            this.put("\u4f9b\u5e94\u5546\u540d\u79f0", "supplierName");
            this.put("\u7533\u8bf7\u6570\u91cf", "applyAmount");
            this.put("\u8ba1\u91cf\u5355\u4f4d", "measureName");
            this.put("\u9884\u8ba1\u4ea4\u8d27\u65e5\u671f", "expectedDeliveryTime");
            this.put("\u7533\u8bf7\u5907\u6ce8", "applyItemRemark");
        }
    };

    @Override
    @PostMapping(value={"importFile"})
    public DycProOrderImportFileRspBO importFile(@RequestBody DycProOrderImportFileReqBO reqBO) {
        MultipartFile file = reqBO.getFile();
        DycProOrderImportFileRspBO rspBO = new DycProOrderImportFileRspBO();
        ArrayList<DycProOrderPurchaseApplyItemInfoBO> importItems = new ArrayList<DycProOrderPurchaseApplyItemInfoBO>();
        this.validateFile(file);
        try (Workbook workbook = WorkbookFactory.create((InputStream)file.getInputStream());){
            Sheet sheet = workbook.getSheetAt(0);
            Map<String, Integer> columnIndexMap = this.parseHeaderRow(sheet.getRow(1));
            this.validateProductCodeNotEmpty(sheet, columnIndexMap.get("skuCode"));
            for (int rowIndex = 2; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                Row row = sheet.getRow(rowIndex);
                if (row == null || this.isEmptyRow(row)) continue;
                DycProOrderPurchaseApplyItemInfoBO item = this.parseRowData(row, columnIndexMap);
                importItems.add(item);
            }
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u6587\u4ef6\u5904\u7406\u5931\u8d25: " + e.getMessage());
        }
        return rspBO;
    }

    private void validateFile(MultipartFile file) {
        if (file.isEmpty()) {
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!file.getOriginalFilename().endsWith(".xlsx") && !file.getOriginalFilename().endsWith(".xls")) {
            throw new ZTBusinessException("\u4ec5\u652f\u6301Excel\u683c\u5f0f\u6587\u4ef6(xlsx/xls)");
        }
        if (file.getSize() > 0x1400000L) {
            throw new ZTBusinessException("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc720MB\u9650\u5236");
        }
    }

    private Map<String, Integer> parseHeaderRow(Row headerRow) {
        if (headerRow == null) {
            throw new ZTBusinessException("\u7f3a\u5c11\u8868\u5934\u884c");
        }
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        HashSet<String> resolvedHeaders = new HashSet<String>();
        for (int cellIndex = 0; cellIndex < headerRow.getLastCellNum(); ++cellIndex) {
            Cell cell = headerRow.getCell(cellIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            String headerName = this.getCellValueAsString(cell);
            for (String allowedHeader : HEADER_MAPPING.keySet()) {
                if (!this.cleanHeaderName(headerName).contains(allowedHeader)) continue;
                columnMap.put(HEADER_MAPPING.get(allowedHeader), cellIndex);
                resolvedHeaders.add(allowedHeader);
            }
        }
        if (!resolvedHeaders.contains("skuCode")) {
            throw new ZTBusinessException("\u8868\u5934\u7f3a\u5c11\u5fc5\u8981\u7684\u5217: \u5546\u54c1\u7f16\u7801");
        }
        return columnMap;
    }

    private void validateProductCodeNotEmpty(Sheet sheet, int productCodeIndex) {
        if (1000 < sheet.getLastRowNum()) {
            throw new ZTBusinessException("\u5bfc\u5165\u6570\u636e\u884c\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u5141\u8bb8 1000 \u884c");
        }
        for (int rowIndex = 1; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            Cell cell;
            String value;
            Row row = sheet.getRow(rowIndex);
            if (row == null || !(value = this.getCellValueAsString(cell = row.getCell(productCodeIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)).trim()).isEmpty()) continue;
            throw new ZTBusinessException("\u7b2c " + (rowIndex + 1) + " \u884c\u7684\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String cleanHeaderName(String headerName) {
        if (headerName == null) {
            return "";
        }
        return headerName.replaceAll("[()*\uff08\uff09\u3010\u3011\\s]", "");
    }

    private boolean isEmptyRow(Row row) {
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            String value;
            Cell cell = row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (cell == null || cell.getCellType() == CellType.BLANK || !StringUtils.isNotBlank((CharSequence)(value = this.getCellValueAsString(cell)))) continue;
            return false;
        }
        return true;
    }

    private DycProOrderPurchaseApplyItemInfoBO parseRowData(Row row, Map<String, Integer> columnIndexMap) {
        DycProOrderPurchaseApplyItemInfoBO item = new DycProOrderPurchaseApplyItemInfoBO();
        if (columnIndexMap.containsKey("skuCode")) {
            String productCode = this.getStringValue(row, columnIndexMap.get("skuCode"));
            item.setSkuCode(this.handleRequiredField(productCode, "\u5546\u54c1\u7f16\u7801"));
        }
        if (columnIndexMap.containsKey("skuName")) {
            item.setSkuName(this.getStringValue(row, columnIndexMap.get("skuName")));
        }
        if (columnIndexMap.containsKey("materialCode")) {
            item.setMaterialCode(this.getStringValue(row, columnIndexMap.get("materialCode")));
        }
        if (columnIndexMap.containsKey("materailDesc")) {
            item.setMaterailDesc(this.getStringValue(row, columnIndexMap.get("materailDesc")));
        }
        if (columnIndexMap.containsKey("supplierName")) {
            String supplierName = this.getStringValue(row, columnIndexMap.get("supplierName"));
            item.setSupplierName(this.handleRequiredField(supplierName, "\u4f9b\u5e94\u5546\u540d\u79f0"));
        }
        if (columnIndexMap.containsKey("applyAmount")) {
            String quantityValue = this.getStringValue(row, columnIndexMap.get("applyAmount"));
            item.setApplyAmount(this.handleQuantityField(quantityValue));
        }
        if (columnIndexMap.containsKey("measureName")) {
            item.setMeasureName(this.getStringValue(row, columnIndexMap.get("measureName")));
        }
        if (columnIndexMap.containsKey("expectedDeliveryTime")) {
            item.setExpectedDeliveryTime(this.formatDateValue(row, columnIndexMap.get("expectedDeliveryTime")));
        }
        if (columnIndexMap.containsKey("applyItemRemark")) {
            item.setApplyItemRemark(this.getStringValue(row, columnIndexMap.get("applyItemRemark")));
        }
        return item;
    }

    private String handleRequiredField(String value, String fieldName) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return value;
    }

    private BigDecimal handleQuantityField(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            String cleanValue = value.replace(",", "");
            return new BigDecimal(cleanValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Date formatDateValue(Row row, int cellIndex) {
        try {
            Cell cell = row.getCell(cellIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)cell)) {
                return cell.getDateCellValue();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getStringValue(Row row, int columnIndex) {
        if (row == null) {
            return "";
        }
        Cell cell = row.getCell(columnIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        return this.getCellValueAsString(cell);
    }

    private String getCellValueAsString(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue().trim();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return new SimpleDateFormat("yyyy-MM-dd").format(cell.getDateCellValue());
                }
                double numValue = cell.getNumericCellValue();
                if (numValue == Math.floor(numValue)) {
                    return String.valueOf((int)numValue);
                }
                return String.valueOf(numValue);
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                try {
                    return cell.getStringCellValue().trim();
                }
                catch (IllegalStateException e) {
                    return String.valueOf(cell.getNumericCellValue());
                }
            }
            case BLANK: {
                return "";
            }
        }
        return "";
    }
}

