/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.purchaseapply.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderQueryPurchaseApplyItemDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyItemDTO;
import com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderUpdatePurchaseApplyService;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderPurchaseApplyItemInfoBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderUpdatePurchaseApplyReqBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderUpdatePurchaseApplyRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderUpdatePurchaseApplyService"})
public class DycProOrderUpdatePurchaseApplyServiceImpl
implements DycProOrderUpdatePurchaseApplyService {
    @Autowired
    private DycProOrderPurchaseApplyRepository dycProOrderPurchaseApplyRepository;
    @Autowired
    private DycProEncodeSerialService dycProEncodeSerialService;

    @Override
    @PostMapping(value={"updatePurchaseApply"})
    public DycProOrderUpdatePurchaseApplyRspBO updatePurchaseApply(@RequestBody DycProOrderUpdatePurchaseApplyReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderUpdatePurchaseApplyRspBO rspBO = new DycProOrderUpdatePurchaseApplyRspBO();
        DycProOrderZlPurchaseApplyDTO dycProOrderZlPurchaseApplyDTO = new DycProOrderZlPurchaseApplyDTO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)dycProOrderZlPurchaseApplyDTO);
        dycProOrderZlPurchaseApplyDTO.setUpdateUserName(reqBO.getUserName());
        dycProOrderZlPurchaseApplyDTO.setUpdateUserId(reqBO.getUserId().toString());
        dycProOrderZlPurchaseApplyDTO.setUpdateCompanyId(reqBO.getCompanyId());
        dycProOrderZlPurchaseApplyDTO.setUpdateCompanyName(reqBO.getCompanyName());
        dycProOrderZlPurchaseApplyDTO.setUpdateOrgId(reqBO.getOrgId());
        dycProOrderZlPurchaseApplyDTO.setUpdateOrgName(reqBO.getOrgName());
        dycProOrderZlPurchaseApplyDTO.setUpdateOrgPath(reqBO.getOrgPath());
        dycProOrderZlPurchaseApplyDTO.setUpdateTime(new Date());
        this.dycProOrderPurchaseApplyRepository.updatePurchaseApply(dycProOrderZlPurchaseApplyDTO);
        this.updatePurchaseApplyItems(reqBO);
        return rspBO;
    }

    private void updatePurchaseApplyItems(DycProOrderUpdatePurchaseApplyReqBO reqBO) {
        Long purApplyId = reqBO.getPurApplyId();
        List<DycProOrderPurchaseApplyItemInfoBO> itemDTOs = reqBO.getItems();
        String purApplyCode = reqBO.getPurApplyCode();
        DycProOrderQueryPurchaseApplyItemDTO dycProOrderZlPurchaseApplyItemDTO = new DycProOrderQueryPurchaseApplyItemDTO();
        dycProOrderZlPurchaseApplyItemDTO.setPurApplyId(purApplyId);
        List existingItems = this.dycProOrderPurchaseApplyRepository.queryPurchaseApplyItemList((DycProOrderZlPurchaseApplyItemDTO)dycProOrderZlPurchaseApplyItemDTO);
        List existingItemIds = existingItems.stream().map(DycProOrderZlPurchaseApplyItemDTO::getPurApplyItemId).collect(Collectors.toList());
        List requestItemIds = itemDTOs.stream().map(DycProOrderPurchaseApplyItemInfoBO::getPurApplyItemId).filter(Objects::nonNull).collect(Collectors.toList());
        List itemsToDelete = existingItemIds.stream().filter(id -> !requestItemIds.contains(id)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(itemsToDelete)) {
            this.dycProOrderPurchaseApplyRepository.deleteBatchPurchaseApply(itemsToDelete);
        }
        ArrayList<DycProOrderQueryPurchaseApplyItemDTO> itemsToInsert = new ArrayList<DycProOrderQueryPurchaseApplyItemDTO>();
        ArrayList<DycProOrderQueryPurchaseApplyItemDTO> itemsToUpdate = new ArrayList<DycProOrderQueryPurchaseApplyItemDTO>();
        for (DycProOrderPurchaseApplyItemInfoBO itemDTO : itemDTOs) {
            DycProOrderQueryPurchaseApplyItemDTO dycProOrderZlPurchaseApplyItemDTO1 = new DycProOrderQueryPurchaseApplyItemDTO();
            BeanUtils.copyProperties((Object)itemDTO, (Object)dycProOrderZlPurchaseApplyItemDTO1);
            if (dycProOrderZlPurchaseApplyItemDTO1.getPurApplyItemId() == null) {
                dycProOrderZlPurchaseApplyItemDTO1.setPurApplyId(purApplyId);
                dycProOrderZlPurchaseApplyItemDTO1.setPurApplyItemCode(this.generatePurchaseApplyItemCode(purApplyCode));
                itemsToInsert.add(dycProOrderZlPurchaseApplyItemDTO1);
                continue;
            }
            itemsToUpdate.add(dycProOrderZlPurchaseApplyItemDTO1);
        }
        if (!CollectionUtils.isEmpty(itemsToInsert)) {
            this.dycProOrderPurchaseApplyRepository.createBatchPurchaseApplyItem(itemsToInsert);
        }
        if (!CollectionUtils.isEmpty(itemsToUpdate)) {
            this.dycProOrderPurchaseApplyRepository.updateBatchPurchaseApply(itemsToUpdate);
        }
    }

    private String generatePurchaseApplyItemCode(String purchaseApplyCode) {
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("EGC");
        encodeSerialReqBO.setEncodeRuleCode("EGC_PURCHASE_APPLY_ITEM_CODE");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.dycProEncodeSerialService.getEncode(encodeSerialReqBO);
        if (encode == null || encode.getSerialNoList() == null || encode.getSerialNoList().isEmpty()) {
            throw new ZTBusinessException("\u91c7\u8d2d\u7533\u8bf7\u660e\u7ec6\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        return String.join((CharSequence)purchaseApplyCode, (CharSequence)encode.getSerialNoList().get(0));
    }

    private void paramVerify(DycProOrderUpdatePurchaseApplyReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPurApplyCode())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u7533\u8bf7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPurApplyName())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u7533\u8bf7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getExecuteUserName())) {
            throw new ZTBusinessException("\u6267\u884c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

