/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQryAfOrderListPageForSupplierService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfOrderEsBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfOrderListPageForSupplierReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfOrderListPageForSupplierRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderTabCountBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQryAfOrderListPageForSupplierService"})
public class DycProOrderQryAfOrderListPageForSupplierServiceImpl
implements DycProOrderQryAfOrderListPageForSupplierService {
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;

    @Override
    @PostMapping(value={"qryAfOrderListPageForSupplier"})
    public DycProOrderQryAfOrderListPageForSupplierRspBO qryAfOrderListPageForSupplier(@RequestBody DycProOrderQryAfOrderListPageForSupplierReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderAfOrderQryDTO qryDTO = (DycProOrderAfOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderAfOrderQryDTO.class);
        qryDTO.setServStateList(this.getTabServState(reqBO.getTabId()));
        RspPage rspPage = this.dycProOrderAfOrderRepository.queryAfOrderEsPageListByCondition(qryDTO);
        DycProOrderQryAfOrderListPageForSupplierRspBO rspBO = new DycProOrderQryAfOrderListPageForSupplierRspBO();
        if (!CollectionUtil.isEmpty((Collection)rspPage.getRows())) {
            rspBO = (DycProOrderQryAfOrderListPageForSupplierRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)rspPage), DycProOrderQryAfOrderListPageForSupplierRspBO.class));
        }
        this.buildTabCount(rspBO, reqBO);
        this.buildRspData(rspBO);
        this.translationRspData(rspBO);
        return rspBO;
    }

    private void paramVerify(DycProOrderQryAfOrderListPageForSupplierReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPageNo() < 1) {
            throw new ZTBusinessException("\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (reqBO.getPageSize() < 1) {
            throw new ZTBusinessException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (null == reqBO.getTabId()) {
            throw new ZTBusinessException("\u9875\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void buildRspData(DycProOrderQryAfOrderListPageForSupplierRspBO rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (DycProOrderAfOrderEsBO row : rspBO.getRows()) {
                row.setPurCompanyName(row.getSaleStakeholder().getPurCompanyName());
                row.setSupName(row.getSaleStakeholder().getSupName());
            }
        }
    }

    private List<Integer> getTabServState(String tabId) {
        ArrayList<Integer> servStateList = new ArrayList<Integer>(1);
        if ("1001".equals(tabId)) {
            servStateList.add(DycProOrderManageServiceConstant.ServiceState.SUMIT_APPLICATION);
        } else if ("1002".equals(tabId)) {
            servStateList.add(DycProOrderManageServiceConstant.ServiceState.APPROVAL_PASS);
        } else if ("1003".equals(tabId)) {
            servStateList.add(DycProOrderManageServiceConstant.ServiceState.APPROVAL_NOT_PASS);
        } else if ("1004".equals(tabId)) {
            servStateList.add(DycProOrderManageServiceConstant.ServiceState.REMARK_COMPLATE);
            servStateList.add(DycProOrderManageServiceConstant.ServiceState.COMPLATE);
        } else {
            throw new ZTBusinessException("\u9519\u8bef\u7684\u9875\u7b7eid,\u65e0\u6cd5\u8bc6\u522b");
        }
        return servStateList;
    }

    private void buildTabCount(DycProOrderQryAfOrderListPageForSupplierRspBO rspBO, DycProOrderQryAfOrderListPageForSupplierReqBO reqBO) {
        DycProOrderAfOrderQryDTO qryTabCountDTO = (DycProOrderAfOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderAfOrderQryDTO.class);
        ArrayList<DycProOrderTabCountBO> tabCountList = new ArrayList<DycProOrderTabCountBO>(1);
        qryTabCountDTO.setServStateList(this.getTabServState("1001"));
        DycProOrderTabCountBO toConfirmOrderTabCountBO = new DycProOrderTabCountBO();
        toConfirmOrderTabCountBO.setTabId("1001");
        toConfirmOrderTabCountBO.setTabName("\u5f85\u786e\u8ba4\u552e\u540e\u7533\u8bf7");
        toConfirmOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
        tabCountList.add(toConfirmOrderTabCountBO);
        qryTabCountDTO.setServStateList(this.getTabServState("1002"));
        DycProOrderTabCountBO toShipOrderTabCountBO = new DycProOrderTabCountBO();
        toShipOrderTabCountBO.setTabId("1002");
        toShipOrderTabCountBO.setTabName("\u5f85\u5b8c\u6210\u552e\u540e\u7533\u8bf7");
        toShipOrderTabCountBO.setTabCount(this.getTabCount(qryTabCountDTO));
        tabCountList.add(toShipOrderTabCountBO);
        rspBO.setTabCountList(tabCountList);
    }

    private Integer getTabCount(DycProOrderAfOrderQryDTO qryDTO) {
        qryDTO.setPageSize(0);
        RspPage baseManagePageRspBO = this.dycProOrderAfOrderRepository.queryAfOrderEsPageListByCondition(qryDTO);
        return baseManagePageRspBO.getRecordsTotal();
    }

    private void translationRspData(DycProOrderQryAfOrderListPageForSupplierRspBO rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (DycProOrderAfOrderEsBO row : rspBO.getRows()) {
                if (null != row.getServState()) {
                    row.setServStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderServState", (String)String.valueOf(row.getServState())));
                }
                if (null != row.getServType()) {
                    row.setServTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderServType", (String)String.valueOf(row.getServType())));
                }
                if (null != row.getPickwareType()) {
                    row.setPickwareTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderPickwareType", (String)String.valueOf(row.getPickwareType())));
                }
                if (null == row.getWaybillFlag()) continue;
                row.setWaybillFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderWaybillFlag", (String)String.valueOf(row.getWaybillFlag())));
            }
        }
    }
}

