/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.budget.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.ZLEgcBudgetStatus;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetInfoDTO;
import com.tydic.dyc.pro.egc.repository.pulicprocinst.api.DycProOrderPublicProcInstRepository;
import com.tydic.dyc.pro.egc.repository.pulicprocinst.dto.PublicProcInstDTO;
import com.tydic.dyc.pro.egc.repository.pulicprocinst.dto.PublicProcInstQryDTO;
import com.tydic.dyc.pro.egc.service.budget.api.DycProOrderQueryBudgetDetailService;
import com.tydic.dyc.pro.egc.service.budget.bo.DycProOrderBudgetFileInfoBO;
import com.tydic.dyc.pro.egc.service.budget.bo.DycProOrderQueryBudgetDetailReqBO;
import com.tydic.dyc.pro.egc.service.budget.bo.DycProOrderQueryBudgetDetailRspBO;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.budget.api.DycProOrderQueryBudgetDetailService"})
public class DycProOrderQueryBudgetDetailServiceImpl
implements DycProOrderQueryBudgetDetailService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderQueryBudgetDetailServiceImpl.class);
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Autowired
    private DycProOrderPublicProcInstRepository publicProcInstRepository;

    @Override
    @PostMapping(value={"queryBudgetDetail"})
    public DycProOrderQueryBudgetDetailRspBO queryBudgetDetail(@RequestBody DycProOrderQueryBudgetDetailReqBO reqBO) {
        this.validateParam(reqBO);
        DycProOrderBudgetInfoDTO queryBudgetInfoDto = new DycProOrderBudgetInfoDTO();
        queryBudgetInfoDto.setBudgetId(reqBO.getBudgetId());
        DycProOrderBudgetInfoDTO budgetInfoDTO = this.dycProOrderBudgetRepository.queryBudgetDetailById(queryBudgetInfoDto);
        if (null == budgetInfoDTO) {
            throw new ZTBusinessException("\u9884\u7b97\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        List fileInfoDTOList = this.dycProOrderBudgetRepository.queryBudgetFileListByBudgetId(reqBO.getBudgetId());
        DycProOrderQueryBudgetDetailRspBO rspBO = (DycProOrderQueryBudgetDetailRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)budgetInfoDTO), DycProOrderQueryBudgetDetailRspBO.class));
        if (rspBO.getBudgetStatus() != null) {
            rspBO.setBudgetStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)ZLEgcBudgetStatus.class.getSimpleName(), (String)String.valueOf(rspBO.getBudgetStatus())));
        }
        if (!CollectionUtils.isEmpty((Collection)fileInfoDTOList)) {
            List fileInfoBOList = JSON.parseArray((String)JSON.toJSONString((Object)fileInfoDTOList), DycProOrderBudgetFileInfoBO.class);
            rspBO.setFileInfoList(fileInfoBOList);
        }
        PublicProcInstQryDTO procQry = new PublicProcInstQryDTO();
        procQry.setObjId(reqBO.getBudgetId());
        RspPage procPage = this.publicProcInstRepository.queryPublicProcInstList(procQry);
        if (procPage != null && !CollectionUtils.isEmpty((Collection)procPage.getRows())) {
            PublicProcInstDTO one = (PublicProcInstDTO)procPage.getRows().get(0);
            rspBO.setProcInstId(one.getProcInstId());
        }
        return rspBO;
    }

    private void validateParam(DycProOrderQueryBudgetDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBudgetId()) {
            throw new ZTBusinessException("\u9884\u7b97ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

