/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.purchaseapply.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyItemDTO;
import com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderCreatePurchaseApplyService;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderCreatePurchaseApplyReqBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderCreatePurchaseApplyRspBO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderCreatePurchaseApplyService"})
public class DycProOrderCreatePurchaseApplyServiceImpl
implements DycProOrderCreatePurchaseApplyService {
    @Autowired
    private DycProOrderPurchaseApplyRepository dycProOrderPurchaseApplyRepository;
    @Autowired
    private DycProEncodeSerialService dycProEncodeSerialService;

    @Override
    @PostMapping(value={"createPurchaseApply"})
    public DycProOrderCreatePurchaseApplyRspBO createPurchaseApply(@RequestBody DycProOrderCreatePurchaseApplyReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderCreatePurchaseApplyRspBO rspBO = new DycProOrderCreatePurchaseApplyRspBO();
        DycProOrderZlPurchaseApplyDTO dycProOrderZlPurchaseApplyDTO = new DycProOrderZlPurchaseApplyDTO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)dycProOrderZlPurchaseApplyDTO);
        dycProOrderZlPurchaseApplyDTO.setCreateUserName(reqBO.getUserName());
        dycProOrderZlPurchaseApplyDTO.setCreateUserId(reqBO.getUserId().toString());
        dycProOrderZlPurchaseApplyDTO.setCreateCompanyId(reqBO.getCompanyId());
        dycProOrderZlPurchaseApplyDTO.setCreateCompanyName(reqBO.getCompanyName());
        dycProOrderZlPurchaseApplyDTO.setCreateOrgId(reqBO.getOrgId());
        dycProOrderZlPurchaseApplyDTO.setCreateOrgName(reqBO.getOrgName());
        dycProOrderZlPurchaseApplyDTO.setCreateOrgPath(reqBO.getOrgPath());
        dycProOrderZlPurchaseApplyDTO.setPurApplyId(Long.valueOf(Sequence.getInstance().nextId()));
        String purchaseApplyCode = this.generatePurchaseApplyCode();
        dycProOrderZlPurchaseApplyDTO.setPurApplyCode(purchaseApplyCode);
        dycProOrderZlPurchaseApplyDTO.setCreateTime(new Date());
        this.dycProOrderPurchaseApplyRepository.createPurchaseApply(dycProOrderZlPurchaseApplyDTO);
        List dycProOrderZlPurchaseApplyItemDTOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getDycProOrderPurchaseApplyItemList()), DycProOrderZlPurchaseApplyItemDTO.class);
        for (DycProOrderZlPurchaseApplyItemDTO dycProOrderZlPurchaseApplyItemDTO : dycProOrderZlPurchaseApplyItemDTOS) {
            dycProOrderZlPurchaseApplyItemDTO.setPurApplyId(dycProOrderZlPurchaseApplyDTO.getPurApplyId());
            dycProOrderZlPurchaseApplyItemDTO.setPurApplyItemCode(this.generatePurchaseApplyItemCode(purchaseApplyCode));
            dycProOrderZlPurchaseApplyItemDTO.setUseAmount(BigDecimal.ZERO);
            dycProOrderZlPurchaseApplyItemDTO.setRemainAmount(dycProOrderZlPurchaseApplyItemDTO.getApplyAmount());
        }
        this.dycProOrderPurchaseApplyRepository.createBatchPurchaseApplyItem(dycProOrderZlPurchaseApplyItemDTOS);
        return rspBO;
    }

    private String generatePurchaseApplyCode() {
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("EGC");
        encodeSerialReqBO.setEncodeRuleCode("EGC_PURCHASE_APPLY_CODE");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.dycProEncodeSerialService.getEncode(encodeSerialReqBO);
        if (encode == null || encode.getSerialNoList() == null || encode.getSerialNoList().isEmpty()) {
            throw new ZTBusinessException("\u91c7\u8d2d\u7533\u8bf7\u8be6\u60c5\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        return (String)encode.getSerialNoList().get(0);
    }

    private String generatePurchaseApplyItemCode(String purchaseApplyCode) {
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("EGC");
        encodeSerialReqBO.setEncodeRuleCode("EGC_PURCHASE_APPLY_ITEM_CODE");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.dycProEncodeSerialService.getEncode(encodeSerialReqBO);
        if (encode == null || encode.getSerialNoList() == null || encode.getSerialNoList().isEmpty()) {
            throw new ZTBusinessException("\u91c7\u8d2d\u7533\u8bf7\u660e\u7ec6\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        return String.join((CharSequence)purchaseApplyCode, (CharSequence)encode.getSerialNoList().get(0));
    }

    private void paramVerify(DycProOrderCreatePurchaseApplyReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPurApplyName())) {
            throw new ZTBusinessException("\u91c7\u8d2d\u7533\u8bf7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

