/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.shiporder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.order.bo.DycProOrderOrderAccessoryBO;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderCreateShipOrderService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderCreateShipOrderReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderCreateShipOrderRspBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderShipOrderItemBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderCreateShipOrderService"})
public class DycProOrderCreateShipOrderServiceImpl
implements DycProOrderCreateShipOrderService {
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;

    @Override
    @PostMapping(value={"createShipOrder"})
    public DycProOrderCreateShipOrderRspBO createShipOrder(@RequestBody DycProOrderCreateShipOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDto.setSaleOrderId(reqBO.getSaleOrderId());
        List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDto);
        if (!CollectionUtil.isEmpty((Collection)saleOrderItemDtoList)) {
            Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemDtoMap = saleOrderItemDtoList.stream().map(obj -> obj).collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, DycProOrderSaleOrderItemDTO2 -> DycProOrderSaleOrderItemDTO2));
            ArrayList<DycProOrderShipOrderItemDTO> addShipItemList = new ArrayList<DycProOrderShipOrderItemDTO>();
            for (DycProOrderShipOrderItemBO shipOrderItemBo : reqBO.getShipOrderItemList()) {
                DycProOrderSaleOrderItemDTO saleOrderItemDto = saleOrderItemDtoMap.get(shipOrderItemBo.getSaleOrderItemId());
                if (shipOrderItemBo.getSendCount().compareTo(saleOrderItemDto.getPurchaseCount().subtract(saleOrderItemDto.getSendCount())) <= 0) {
                    DycProOrderShipOrderItemDTO addShipOrderItemDto = new DycProOrderShipOrderItemDTO();
                    addShipOrderItemDto.setOrderId(saleOrderItemDto.getOrderId());
                    addShipOrderItemDto.setSaleOrderId(saleOrderItemDto.getSaleOrderId());
                    addShipOrderItemDto.setSaleOrderItemId(saleOrderItemDto.getSaleOrderItemId());
                    addShipOrderItemDto.setUnitName(saleOrderItemDto.getUnitName());
                    addShipOrderItemDto.setSendCount(shipOrderItemBo.getSendCount());
                    addShipItemList.add(addShipOrderItemDto);
                    continue;
                }
                throw new ZTBusinessException("\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5f85\u53d1\u8d27\u6570\u91cf");
            }
            DycProOrderShipOrderQryDTO addShipOrderDto = new DycProOrderShipOrderQryDTO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)addShipOrderDto);
            addShipOrderDto.setShipItemList(addShipItemList);
            if (!CollectionUtil.isEmpty(reqBO.getShipOrderAccessoryList())) {
                ArrayList<DycProOrderOrderAccessoryDTO> shipOrderAccessoryList = new ArrayList<DycProOrderOrderAccessoryDTO>();
                for (DycProOrderOrderAccessoryBO accessoryBo : reqBO.getShipOrderAccessoryList()) {
                    DycProOrderOrderAccessoryDTO addShipOrderAccessoryDto = new DycProOrderOrderAccessoryDTO();
                    BeanUtils.copyProperties((Object)accessoryBo, (Object)addShipOrderAccessoryDto);
                    addShipOrderAccessoryDto.setObjType(DycProOrderManageServiceConstant.OrderAccessoryObjType.SHIP_ORDER_FILE);
                    shipOrderAccessoryList.add(addShipOrderAccessoryDto);
                }
                addShipOrderDto.setShipOrderAccessoryList(shipOrderAccessoryList);
            }
            DycProOrderSaleOrderDTO saleOrderDetailApiReqBO = new DycProOrderSaleOrderDTO();
            saleOrderDetailApiReqBO.setSaleOrderId(addShipOrderDto.getSaleOrderId());
            DycProOrderSaleOrderDTO saleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(saleOrderDetailApiReqBO);
            DycProOrderSaleOrderDTO reqDto = new DycProOrderSaleOrderDTO();
            reqDto.setStakeholderId(saleOrderDTO.getStakeholderId());
            DycProOrderSaleOrderDTO stakeholder = this.dycProOrderSaleOrderRepository.querySaleOrderStakeholderByCondition(reqDto);
            saleOrderDTO.setSaleStakeholder(stakeholder.getSaleStakeholder());
            saleOrderDTO.setSaleItemList(saleOrderItemDtoList);
            DycProOrderShipOrderDTO shipOrderDTO = this.dycProOrderShipOrderRepository.addShipOrderAllInfoAndSyncNosql((DycProOrderShipOrderDTO)addShipOrderDto, saleOrderDTO);
            Boolean sendFinish = true;
            Map<Long, DycProOrderShipOrderItemBO> shipItemBoMap = reqBO.getShipOrderItemList().stream().map(obj -> obj).collect(Collectors.toMap(DycProOrderShipOrderItemBO::getSaleOrderItemId, DycProOrderShipOrderItemBO2 -> DycProOrderShipOrderItemBO2));
            for (DycProOrderSaleOrderItemDTO saleOrderItemDto : saleOrderItemDtoList) {
                DycProOrderShipOrderItemBO shipOrderItemBo = shipItemBoMap.get(saleOrderItemDto.getSaleOrderItemId());
                BigDecimal nowShipSendCount = BigDecimal.ZERO;
                if (null != shipOrderItemBo) {
                    nowShipSendCount = shipOrderItemBo.getSendCount();
                }
                if (saleOrderItemDto.getPurchaseCount().compareTo(Optional.ofNullable(saleOrderItemDto.getSendCount()).orElse(BigDecimal.ZERO).add(nowShipSendCount)) <= 0) continue;
                sendFinish = false;
                break;
            }
            DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
            updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
            if (sendFinish.booleanValue()) {
                updateSaleOrderDto.setSaleOrderState("XS_FH_FHWC");
            } else {
                updateSaleOrderDto.setSaleOrderState("XS_FH_FHZ");
            }
            updateSaleOrderDto.setShiporderList(Collections.singletonList(shipOrderDTO));
            this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
            ArrayList<DycProOrderSaleOrderItemDTO> updateSaleOrderItemDtoList = new ArrayList<DycProOrderSaleOrderItemDTO>();
            for (DycProOrderShipOrderItemBO shipOrderItemBo : reqBO.getShipOrderItemList()) {
                DycProOrderSaleOrderItemDTO saleOrderItemDto = saleOrderItemDtoMap.get(shipOrderItemBo.getSaleOrderItemId());
                DycProOrderSaleOrderItemDTO updateSaleOrderItemDto = new DycProOrderSaleOrderItemDTO();
                updateSaleOrderItemDto.setSaleOrderItemId(shipOrderItemBo.getSaleOrderItemId());
                updateSaleOrderItemDto.setSendCount(saleOrderItemDto.getSendCount().add(shipOrderItemBo.getSendCount()));
                updateSaleOrderItemDtoList.add(updateSaleOrderItemDto);
            }
            this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(updateSaleOrderItemDtoList);
            DycProOrderCreateShipOrderRspBO rspBO = new DycProOrderCreateShipOrderRspBO();
            rspBO.setShipOrderId(shipOrderDTO.getShipOrderId());
            return rspBO;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u8be5\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
    }

    private void verifyParam(DycProOrderCreateShipOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(reqBO.getShipOrderItemList())) {
            throw new ZTBusinessException("\u53d1\u8d27\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

