/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilConfirmOrderReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilConfirmOrderRspBO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderConfirmPreOrderService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderConfirmPreOrderReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderConfirmPreOrderRspBO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderConfirmPreOrderService"})
public class DycProOrderConfirmPreOrderServiceImpl
implements DycProOrderConfirmPreOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderConfirmPreOrderServiceImpl.class);
    @Value(value="${call.esb.url.confirmOrder}")
    private String callEsbUrlConfirmOrder;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private Environment environment;
    @Lazy
    @Autowired
    private DycProOrderConfirmPreOrderService dycProOrderConfirmPreOrderService;

    @Override
    @PostMapping(value={"confirmPreOrder"})
    public DycProOrderConfirmPreOrderRspBO confirmPreOrder(@RequestBody DycProOrderConfirmPreOrderReqBO reqBO) {
        if (null == reqBO || null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProOrderConfirmPreOrderRspBO rspBO = new DycProOrderConfirmPreOrderRspBO();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        DycProOrderSaleOrderDTO reqDto = new DycProOrderSaleOrderDTO();
        reqDto.setSaleOrderId(reqBO.getSaleOrderId());
        DycProOrderSaleOrderDTO saleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(reqDto);
        if (null != saleOrderDTO) {
            DycProOrderSaleOrderDTO querySaleOrderDto = new DycProOrderSaleOrderDTO();
            querySaleOrderDto.setStakeholderId(saleOrderDTO.getStakeholderId());
            DycProOrderSaleOrderDTO saleOrderSaleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderStakeholderByCondition(querySaleOrderDto);
            if (null != saleOrderSaleOrderDto) {
                DycProBaseCallEsbUtilConfirmOrderReqBO callEsbReqBo = new DycProBaseCallEsbUtilConfirmOrderReqBO();
                callEsbReqBo.setOrderId(saleOrderDTO.getSaleOrderNoExt());
                String hsn = this.environment.getProperty("SUPPLIER_ID_" + saleOrderSaleOrderDto.getSaleStakeholder().getSupId());
                callEsbReqBo.setHsn(hsn);
                callEsbReqBo.setUrl(this.callEsbUrlConfirmOrder);
                log.debug("\u7535\u5546\u9884\u5b9a\u5355\u786e\u8ba4\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)callEsbReqBo));
                DycProBaseCallEsbUtilConfirmOrderRspBO callEsbRspBO = DycProBaseCallEsbUtil.confirmOrder((DycProBaseCallEsbUtilConfirmOrderReqBO)callEsbReqBo);
                log.debug("\u7535\u5546\u9884\u5b9a\u5355\u786e\u8ba4\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)callEsbRspBO));
                if (callEsbRspBO.getSuccess().booleanValue()) {
                    variables.put("dsOrderCreateSuccess", "1");
                } else {
                    variables.put("dsOrderCreateSuccess", "0");
                }
                rspBO.setVariables(variables);
                this.sendDealTodoNotice(saleOrderSaleOrderDto, String.valueOf(variables.get("dsOrderCreateSuccess")));
                return rspBO;
            }
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u9500\u552e\u5355\u7684\u4e09\u65b9\u4fe1\u606f");
        }
        throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u9500\u552e\u5355\u4fe1\u606f");
    }

    @Override
    @PostMapping(value={"dealTodoNotice"})
    public DycProOrderConfirmPreOrderRspBO dealTodoNotice(@RequestBody JSONObject reqBO) {
        return new DycProOrderConfirmPreOrderRspBO();
    }

    private void sendDealTodoNotice(DycProOrderSaleOrderDTO saleOrderDTO, String dsOrderCreateSuccess) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderId", (Object)saleOrderDTO.getOrderId());
        jsonObject.put("saleOrderId", (Object)saleOrderDTO.getSaleOrderId());
        jsonObject.put("userId", (Object)1L);
        jsonObject.put("dsOrderCreateSuccess", (Object)dsOrderCreateSuccess);
        this.dycProOrderConfirmPreOrderService.dealTodoNotice(jsonObject);
    }
}

