/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelServiceOrderForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelServiceOrderForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelServiceOrderParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelServiceOrderReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelServiceOrderRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderInterLogDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderCancelAfterOrderService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderCancelAfterOrderReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderCancelAfterOrderRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderCancelAfterOrderService"})
public class DycProOrderCancelAfterOrderServiceImpl
implements DycProOrderCancelAfterOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCancelAfterOrderServiceImpl.class);
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private Environment environment;
    @Value(value="${call.esb.url.cancelServiceOrder}")
    private String callEsbUrlCancelServiceOrder;
    @Value(value="${call.ty.url.deleteContractUrlForTy}")
    private String deleteContractUrlForTy;
    @Value(value="${call.ty.deleteContractMethodNameForTy}")
    private String deleteContractMethodNameForTy;

    @Override
    @PostMapping(value={"cancelAfterOrder"})
    public DycProOrderCancelAfterOrderRspBO cancelAfterOrder(@RequestBody DycProOrderCancelAfterOrderReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderAfOrderDTO dycProOrderAfOrderDTO = new DycProOrderAfOrderDTO();
        dycProOrderAfOrderDTO.setAfOrderId(reqBO.getAfOrderId());
        DycProOrderAfOrderDTO afOrderDTO = this.dycProOrderAfOrderRepository.queryAfOrderOneByCondition(dycProOrderAfOrderDTO);
        if (null == afOrderDTO) {
            throw new ZTBusinessException("\u67e5\u8be2\u552e\u540e\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!DycProOrderManageServiceConstant.ServiceState.SUMIT_APPLICATION.equals(afOrderDTO.getServState())) {
            throw new ZTBusinessException("\u552e\u540e\u5355\u4e0d\u53ef\u53d6\u6d88");
        }
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBO.getOrderSource())) {
            String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupId());
            if ("jd".equals(hsn) || "jdvop".equals(hsn)) {
                DycProBaseCallEsbUtilCancelServiceOrderForJdReqBO dycProBaseCallEsbUtilCancelServiceOrderForJdReqBO = new DycProBaseCallEsbUtilCancelServiceOrderForJdReqBO();
                DycProBaseCallEsbUtilCancelServiceOrderParamForJdBO param = new DycProBaseCallEsbUtilCancelServiceOrderParamForJdBO();
                dycProBaseCallEsbUtilCancelServiceOrderForJdReqBO.setUrl(this.callEsbUrlCancelServiceOrder);
                dycProBaseCallEsbUtilCancelServiceOrderForJdReqBO.setHsn(hsn);
                param.setOrderId(Long.valueOf(Long.parseLong(reqBO.getSaleOrderNoExt())));
                param.setThirdApplyId(reqBO.getExtAfId());
                param.setRemark("\u53d6\u6d88");
                dycProBaseCallEsbUtilCancelServiceOrderForJdReqBO.setParam(param);
                DycProBaseCallEsbUtilCancelServiceOrderForJdRspBO dycProBaseCallEsbUtilCancelServiceOrderForJdRspBO = DycProBaseCallEsbUtil.cancelServiceOrderForJd((DycProBaseCallEsbUtilCancelServiceOrderForJdReqBO)dycProBaseCallEsbUtilCancelServiceOrderForJdReqBO);
                if (!dycProBaseCallEsbUtilCancelServiceOrderForJdRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilCancelServiceOrderForJdRspBO.getResultCode())) {
                    throw new ZTBusinessException(dycProBaseCallEsbUtilCancelServiceOrderForJdRspBO.getResultMessage());
                }
            } else {
                DycProBaseCallEsbUtilCancelServiceOrderReqBO dycProBaseCallEsbUtilCancelServiceOrderReqBO = new DycProBaseCallEsbUtilCancelServiceOrderReqBO();
                dycProBaseCallEsbUtilCancelServiceOrderReqBO.setUrl(this.callEsbUrlCancelServiceOrder);
                dycProBaseCallEsbUtilCancelServiceOrderReqBO.setHsn(hsn);
                dycProBaseCallEsbUtilCancelServiceOrderReqBO.setServiceId(reqBO.getExtAfId());
                DycProBaseCallEsbUtilCancelServiceOrderRspBO dycProBaseCallEsbUtilCancelServiceOrderRspBO = DycProBaseCallEsbUtil.cancelServiceOrder((DycProBaseCallEsbUtilCancelServiceOrderReqBO)dycProBaseCallEsbUtilCancelServiceOrderReqBO);
                if (!dycProBaseCallEsbUtilCancelServiceOrderRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilCancelServiceOrderRspBO.getResultCode())) {
                    throw new ZTBusinessException(dycProBaseCallEsbUtilCancelServiceOrderRspBO.getResultMessage());
                }
            }
        }
        DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
        updateAfOrderDTO.setAfOrderId(reqBO.getAfOrderId());
        updateAfOrderDTO.setOrderId(reqBO.getOrderId());
        updateAfOrderDTO.setServState(DycProOrderManageServiceConstant.ServiceState.CANCEL);
        updateAfOrderDTO.setUpdateTime(new Date());
        updateAfOrderDTO.setCancelTime(new Date());
        updateAfOrderDTO.setCancelOperId(String.valueOf(reqBO.getUserId()));
        updateAfOrderDTO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        this.dycProOrderAfOrderRepository.updateAfOrderByIdAndSyncNosql(updateAfOrderDTO);
        DycProOrderAfOrderItemDTO queryAfOrderItem = new DycProOrderAfOrderItemDTO();
        queryAfOrderItem.setAfOrderId(reqBO.getAfOrderId());
        List afOrderItemList = this.dycProOrderAfOrderRepository.queryAfOrderItemListByCondition(queryAfOrderItem);
        DycProOrderAfOrderObjDTO afOrderObjDTO = new DycProOrderAfOrderObjDTO();
        afOrderObjDTO.setAfOrderId(reqBO.getAfOrderId());
        DycProOrderAfOrderObjDTO dycProOrderAfOrderObjDTO = this.dycProOrderAfOrderRepository.queryAfOrderObjOneByCondition(afOrderObjDTO);
        DycProOrderShipOrderItemQryDTO dycProOrderShipOrderItemQryDTO = new DycProOrderShipOrderItemQryDTO();
        dycProOrderShipOrderItemQryDTO.setShipOrderId(dycProOrderAfOrderObjDTO.getShipOrderId());
        List shipOrderItemList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(dycProOrderShipOrderItemQryDTO);
        DycProOrderSaleOrderItemQryDTO saleOrderItemQryDTO = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemQryDTO.setSaleOrderId(dycProOrderAfOrderObjDTO.getSaleOrderId());
        List saleOrderItemList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemQryDTO);
        Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(DycProOrderShipOrderItemDTO::getShipOrderItemId, item -> item, (k1, k2) -> k1));
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        this.updateSaleAndShipItemAfterServingCount(afOrderItemList, reqBO, shipOrderItemMap, saleOrderItemMap, dycProOrderAfOrderObjDTO);
        DycProOrderSaleOrderDTO querySaleOrderDTO = new DycProOrderSaleOrderDTO();
        querySaleOrderDTO.setSaleOrderId(afOrderDTO.getSaleOrderId());
        DycProOrderSaleOrderDTO saleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDTO);
        if (DycProOrderManageServiceConstant.AfterOrderSerType.RETURN.equals(afOrderDTO.getServType()) && "1".equals(saleOrderDTO.getProfessionalCompanyType()) && DycProOrderManageServiceConstant.PurchaseType.MRO_CENTRALIZED_PROCUREMENT.equals(saleOrderDTO.getPurchaseType())) {
            this.pushAfterReturnForTy(afOrderDTO, afOrderItemList, saleOrderDTO);
        }
        return new DycProOrderCancelAfterOrderRspBO();
    }

    private void updateSaleAndShipItemAfterServingCount(List<DycProOrderAfOrderItemDTO> afOrderItemList, DycProOrderCancelAfterOrderReqBO reqBo, Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap, Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap, DycProOrderAfOrderObjDTO dycProOrderAfOrderObjDTO) {
        ArrayList<DycProOrderShipOrderItemDTO> updateShipOrderItemDTOList = new ArrayList<DycProOrderShipOrderItemDTO>(1);
        ArrayList<DycProOrderSaleOrderItemDTO> updateSaleOrderItemDTOList = new ArrayList<DycProOrderSaleOrderItemDTO>(1);
        for (DycProOrderAfOrderItemDTO uocAfOrderItem : afOrderItemList) {
            DycProOrderSaleOrderItemDTO uocSaleOrderItem = new DycProOrderSaleOrderItemDTO();
            uocSaleOrderItem.setOrderId(uocAfOrderItem.getOrderId());
            uocSaleOrderItem.setSaleOrderItemId(uocAfOrderItem.getSaleOrderItemId());
            uocSaleOrderItem.setAfterServingCount(saleOrderItemMap.get(uocAfOrderItem.getSaleOrderItemId()).getAfterServingCount().subtract(uocAfOrderItem.getReturnCount()));
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(null == reqBo.getUserId() ? null : String.valueOf(reqBo.getUserId()));
            updateSaleOrderItemDTOList.add(uocSaleOrderItem);
            DycProOrderShipOrderItemDTO uocShipOrderItem = new DycProOrderShipOrderItemDTO();
            uocShipOrderItem.setOrderId(uocAfOrderItem.getOrderId());
            uocShipOrderItem.setShipOrderItemId(uocAfOrderItem.getShipItemId());
            uocShipOrderItem.setAfterServingCount(shipOrderItemMap.get(uocAfOrderItem.getShipItemId()).getAfterServingCount().subtract(uocAfOrderItem.getReturnCount()));
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(null == reqBo.getUserId() ? null : String.valueOf(reqBo.getUserId()));
            updateShipOrderItemDTOList.add(uocShipOrderItem);
        }
        DycProOrderShipOrderDTO updateShipOrderDTO = new DycProOrderShipOrderDTO();
        updateShipOrderDTO.setShipItemList(updateShipOrderItemDTOList);
        updateShipOrderDTO.setShipOrderId(dycProOrderAfOrderObjDTO.getShipOrderId());
        this.dycProOrderShipOrderRepository.updateShipOrderItemBatchByIdsAndSyncNosql(updateShipOrderDTO);
        this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(updateSaleOrderItemDTOList);
        ArrayList<DycProOrderAfOrderDTO> afOrderList = new ArrayList<DycProOrderAfOrderDTO>(1);
        DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
        updateAfOrderDTO.setAfOrderId(dycProOrderAfOrderObjDTO.getAfOrderId());
        updateAfOrderDTO.setServState(DycProOrderManageServiceConstant.ServiceState.CANCEL);
        afOrderList.add(updateAfOrderDTO);
        DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
        updateSaleOrderDTO.setSaleOrderId(dycProOrderAfOrderObjDTO.getSaleOrderId());
        updateSaleOrderDTO.setAfOrderList(afOrderList);
        this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDTO);
    }

    private void updateSaleAndShipItemReturnCount(List<DycProOrderAfOrderItemDTO> uocAfOrderItemList, DycProOrderCancelAfterOrderReqBO reqBo, Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap, Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap, DycProOrderAfOrderObjDTO dycProOrderAfOrderObjDTO) {
        ArrayList<DycProOrderShipOrderItemDTO> updateShipOrderItemDTOList = new ArrayList<DycProOrderShipOrderItemDTO>();
        ArrayList<DycProOrderSaleOrderItemDTO> updateSaleOrderItemDTOList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        for (DycProOrderAfOrderItemDTO uocAfOrderItem : uocAfOrderItemList) {
            DycProOrderSaleOrderItemDTO uocSaleOrderItem = new DycProOrderSaleOrderItemDTO();
            uocSaleOrderItem.setOrderId(uocAfOrderItem.getOrderId());
            uocSaleOrderItem.setSaleOrderItemId(uocAfOrderItem.getSaleOrderItemId());
            uocSaleOrderItem.setReturnCount(saleOrderItemMap.get(uocAfOrderItem.getSaleOrderItemId()).getReturnCount().subtract(uocAfOrderItem.getReturnCount()));
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(null == reqBo.getUserId() ? null : String.valueOf(reqBo.getUserId()));
            updateSaleOrderItemDTOList.add(uocSaleOrderItem);
            DycProOrderShipOrderItemDTO uocShipOrderItem = new DycProOrderShipOrderItemDTO();
            uocShipOrderItem.setOrderId(uocAfOrderItem.getOrderId());
            uocShipOrderItem.setShipOrderItemId(uocAfOrderItem.getShipItemId());
            uocShipOrderItem.setReturnCount(shipOrderItemMap.get(uocAfOrderItem.getShipItemId()).getReturnCount().subtract(uocAfOrderItem.getReturnCount()));
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(ObjectUtil.isEmpty((Object)reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            updateShipOrderItemDTOList.add(uocShipOrderItem);
        }
        DycProOrderShipOrderDTO updateShipOrderDTO = new DycProOrderShipOrderDTO();
        updateShipOrderDTO.setShipItemList(updateShipOrderItemDTOList);
        updateShipOrderDTO.setShipOrderId(dycProOrderAfOrderObjDTO.getShipOrderId());
        this.dycProOrderShipOrderRepository.updateShipOrderItemBatchByIdsAndSyncNosql(updateShipOrderDTO);
        this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(updateSaleOrderItemDTOList);
        ArrayList<DycProOrderAfOrderDTO> afOrderList = new ArrayList<DycProOrderAfOrderDTO>(1);
        DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
        updateAfOrderDTO.setAfOrderId(dycProOrderAfOrderObjDTO.getAfOrderId());
        updateAfOrderDTO.setServState(DycProOrderManageServiceConstant.ServiceState.CANCEL);
        afOrderList.add(updateAfOrderDTO);
        DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
        updateSaleOrderDTO.setSaleOrderId(dycProOrderAfOrderObjDTO.getSaleOrderId());
        updateSaleOrderDTO.setAfOrderList(afOrderList);
        this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDTO);
    }

    private void pushAfterReturnForTy(DycProOrderAfOrderDTO afOrderDTO, List<DycProOrderAfOrderItemDTO> afOrderItemDTOList, DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        Map<Long, DycProOrderSaleOrderItemDTO> idVsSaleOrderItemMap = saleOrderItemDTOList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        for (DycProOrderAfOrderItemDTO afOrderItemDTO : afOrderItemDTOList) {
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = idVsSaleOrderItemMap.get(afOrderItemDTO.getSaleOrderItemId());
            DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
            dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            dycProOrderInterLogDTO.setObjId(afOrderDTO.getAfOrderId());
            dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.AFTER);
            dycProOrderInterLogDTO.setOrderId(afOrderDTO.getOrderId());
            dycProOrderInterLogDTO.setInterSn(this.deleteContractUrlForTy);
            DycProBaseCallEsbUtilDeleteContractForTyReqBO dycProBaseCallEsbUtilDeleteContractForTyReqBO = new DycProBaseCallEsbUtilDeleteContractForTyReqBO();
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setUrl(this.deleteContractUrlForTy);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setMethodName(this.deleteContractMethodNameForTy);
            DycProBaseCallEsbUtilDeleteContractForTyBO dycProBaseCallEsbUtilDeleteContractForTyBO = new DycProBaseCallEsbUtilDeleteContractForTyBO();
            dycProBaseCallEsbUtilDeleteContractForTyBO.setId(afOrderDTO.getAfOrderId());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setGoodsName(saleOrderItemDTO.getSkuName());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setGoodsNum(afOrderItemDTO.getReturnCount());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSku(saleOrderItemDTO.getSkuCode());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setSourceType(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setYctOrderCode(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setServiceCode(afOrderDTO.getAfServCode());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setCreateDate(afOrderDTO.getCreateTime());
            dycProBaseCallEsbUtilDeleteContractForTyBO.setTimeStamp(Long.valueOf(new Date().getTime()));
            dycProBaseCallEsbUtilDeleteContractForTyBO.setMaterialType(null);
            dycProBaseCallEsbUtilDeleteContractForTyBO.setMaterialCode(saleOrderItemDTO.getMCode());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setJsonStr(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyBO));
            dycProOrderInterLogDTO.setInContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyReqBO));
            try {
                DycProBaseCallEsbUtilDeleteContractForTyRspBO dycProBaseCallEsbUtilDeleteContractForTyRspBO = DycProBaseCallEsbUtil.deleteContractForTy((DycProBaseCallEsbUtilDeleteContractForTyReqBO)dycProBaseCallEsbUtilDeleteContractForTyReqBO);
                dycProOrderInterLogDTO.setOutContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyRspBO));
                if (null == dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess() || !dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultCode())) {
                    log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    throw new ZTBusinessException("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                }
            }
            catch (Exception e) {
                log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5f02\u5e38: {}", (Object)e.getMessage());
                dycProOrderInterLogDTO.setErrDetail(e.getMessage());
            }
            this.dycProOrderSaleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
        }
    }

    private void paramVerify(DycProOrderCancelAfterOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAfOrderId()) {
            throw new ZTBusinessException("\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSupId())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

