/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.chngorder.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelSendOrderConfirmRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.chngorder.api.DycProOrderChngOrderRepository;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderRevokeApplyCancelService;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderRevokeApplyCancelReqBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderRevokeApplyCancelRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderRevokeApplyCancelService"})
public class DycProOrderRevokeApplyCancelServiceImpl
implements DycProOrderRevokeApplyCancelService {
    @Value(value="${call.esb.url.cancelSendOrderConfirm}")
    private String callEsbUrlCancelSendOrderConfirm;
    @Autowired
    private Environment environment;
    @Autowired
    private DycProOrderChngOrderRepository dycProOrderChngOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @Override
    @PostMapping(value={"revokeApplyCancel"})
    public DycProOrderRevokeApplyCancelRspBO revokeApplyCancel(@RequestBody DycProOrderRevokeApplyCancelReqBO reqBO) {
        this.verifyParam(reqBO);
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBO.getOrderSource())) {
            DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO callEsbReqBo = new DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO();
            callEsbReqBo.setUrl(this.callEsbUrlCancelSendOrderConfirm);
            callEsbReqBo.setOrderId(reqBO.getSaleOrderNoExt());
            callEsbReqBo.setCancelFlag(Integer.valueOf(1));
            String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupId());
            callEsbReqBo.setHsn(hsn);
            DycProBaseCallEsbUtilCancelSendOrderConfirmRspBO callEsbRspBo = DycProBaseCallEsbUtil.cancelSendOrderConfirm((DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO)callEsbReqBo);
            if (!callEsbRspBo.getSuccess().booleanValue() && "0000".equals(callEsbRspBo.getResultCode())) {
                throw new ZTBusinessException(callEsbRspBo.getResultMessage());
            }
        }
        DycProOrderChngOrderDTO updateChngOrderDto = new DycProOrderChngOrderDTO();
        updateChngOrderDto.setChngOrderState("CHNG_XS_YCX");
        updateChngOrderDto.setChngOrderId(reqBO.getChngOrderId());
        this.dycProOrderChngOrderRepository.updateChngOrderAndSyncNosql(updateChngOrderDto);
        DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
        updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        updateSaleOrderDto.setSaleOrderState("XS_FH_DFH");
        this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
        return new DycProOrderRevokeApplyCancelRspBO();
    }

    private void verifyParam(DycProOrderRevokeApplyCancelReqBO reqBO) {
        if (null == reqBO.getChngOrderId()) {
            throw new ZTBusinessException("\u53d6\u6d88\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

