/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderHandelDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderWaybillDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderDealWaybillUpholdAfterOrderService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealWaybillUpholdAfterOrderInfoBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealWaybillUpholdAfterOrderReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderDealWaybillUpholdAfterOrderRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderDealWaybillUpholdAfterOrderService"})
public class DycProOrderDealWaybillUpholdAfterOrderServiceImpl
implements DycProOrderDealWaybillUpholdAfterOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderDealWaybillUpholdAfterOrderServiceImpl.class);
    public static final String patton = "YYYY-MM-dd HH:mm:ss";
    @Value(value="${call.esb.url.updateSendSku}")
    private String callEsbUpdateSendSkuUrl;
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private Environment environment;

    @Override
    @PostMapping(value={"dealWaybillUpholdAfterOrder"})
    public DycProOrderDealWaybillUpholdAfterOrderRspBO dealWaybillUpholdAfterOrder(@RequestBody DycProOrderDealWaybillUpholdAfterOrderReqBO reqBo) {
        this.verifyParam(reqBo);
        for (DycProOrderDealWaybillUpholdAfterOrderInfoBO waybillUpholdBo : reqBo.getWaybillUpholdList()) {
            this.applyUpdate(waybillUpholdBo);
        }
        this.dealOrderWaybillUphold(reqBo.getWaybillUpholdList(), reqBo.getUserId());
        return new DycProOrderDealWaybillUpholdAfterOrderRspBO();
    }

    public void applyUpdate(DycProOrderDealWaybillUpholdAfterOrderInfoBO waybillUpholdAfterOrderInfoBO) {
        if (StringUtils.isNotBlank((String)waybillUpholdAfterOrderInfoBO.getExtAfId())) {
            String hsn = this.environment.getProperty("SUPPLIER_ID_" + waybillUpholdAfterOrderInfoBO.getSupId());
            if ("jd".equals(hsn) || "jdvop".equals(hsn)) {
                DycProOrderSaleOrderItemQryDTO saleOrderItemQryDto = new DycProOrderSaleOrderItemQryDTO();
                saleOrderItemQryDto.setSaleOrderId(waybillUpholdAfterOrderInfoBO.getSaleOrderId());
                List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemQryDto);
                DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO callEsbUtilReqBO = new DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO();
                DycProBaseCallEsbUtilUpdateSendSkuParamForJdBO param = new DycProBaseCallEsbUtilUpdateSendSkuParamForJdBO();
                callEsbUtilReqBO.setHsn(hsn);
                callEsbUtilReqBO.setUrl(this.callEsbUpdateSendSkuUrl);
                param.setOrderId(Long.valueOf(waybillUpholdAfterOrderInfoBO.getSaleOrderNoExt()));
                param.setThirdApplyId(waybillUpholdAfterOrderInfoBO.getExtAfId());
                ArrayList<DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO> waybillInfoList = new ArrayList<DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO>();
                DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO waybillInfo = new DycProBaseCallEsbUtilUpdateSendSkuWaybillInfoForJdBO();
                waybillInfo.setExpressCompany(waybillUpholdAfterOrderInfoBO.getForwardCompany());
                waybillInfo.setExpressCode(waybillUpholdAfterOrderInfoBO.getForwardOrderNo());
                waybillInfo.setDeliverDate(DateUtil.format((Date)waybillUpholdAfterOrderInfoBO.getForwardDate(), (String)patton));
                waybillInfo.setFreightMoney(waybillUpholdAfterOrderInfoBO.getFreight());
                waybillInfo.setWareId(Long.valueOf(((DycProOrderSaleOrderItemDTO)saleOrderItemDtoList.get(0)).getSkuExtSkuId()));
                waybillInfo.setWareType(Integer.valueOf(10));
                waybillInfo.setWareNum(Integer.valueOf(waybillUpholdAfterOrderInfoBO.getSendCount()));
                waybillInfoList.add(waybillInfo);
                param.setWaybillInfoList(waybillInfoList);
                callEsbUtilReqBO.setParam(param);
                DycProBaseCallEsbUtilUpdateSendSkuForJdRspBO CallEsbUtilUpdateSendSkuForJdRspBo = DycProBaseCallEsbUtil.updateSendSkuForJd((DycProBaseCallEsbUtilUpdateSendSkuForJdReqBO)callEsbUtilReqBO);
                if (!CallEsbUtilUpdateSendSkuForJdRspBo.getSuccess().booleanValue()) {
                    throw new ZTBusinessException("\u552e\u540e\u53d1\u8fd0\u4fe1\u606f\u586b\u5199\uff08\u4eac\u4e1c\uff09\u54cd\u5e94\u5931\u8d25");
                }
                if (!"0000".equals(CallEsbUtilUpdateSendSkuForJdRspBo.getResultCode())) {
                    throw new ZTBusinessException("\u552e\u540e\u53d1\u8fd0\u4fe1\u606f\u586b\u5199\uff08\u4eac\u4e1c\uff09\u5931\u8d25: " + CallEsbUtilUpdateSendSkuForJdRspBo.getResultMessage());
                }
            } else {
                DycProBaseCallEsbUtilUpdateSendSkuReqBO callEsbUtilUpdateSendSkuReqBo = new DycProBaseCallEsbUtilUpdateSendSkuReqBO();
                callEsbUtilUpdateSendSkuReqBo.setHsn(hsn);
                callEsbUtilUpdateSendSkuReqBo.setUrl(this.callEsbUpdateSendSkuUrl);
                callEsbUtilUpdateSendSkuReqBo.setAfsServiceId(waybillUpholdAfterOrderInfoBO.getExtAfId());
                callEsbUtilUpdateSendSkuReqBo.setFreightMoney(waybillUpholdAfterOrderInfoBO.getFreight());
                callEsbUtilUpdateSendSkuReqBo.setExpressCompany(waybillUpholdAfterOrderInfoBO.getForwardCompany());
                callEsbUtilUpdateSendSkuReqBo.setDeliverDate(DateUtil.format((Date)waybillUpholdAfterOrderInfoBO.getForwardDate(), (String)patton));
                callEsbUtilUpdateSendSkuReqBo.setTrackingCode(waybillUpholdAfterOrderInfoBO.getForwardOrderNo());
                DycProBaseCallEsbUtilUpdateSendSkuRspBO CallEsbUtilUpdateSendSkuRspBO = DycProBaseCallEsbUtil.updateSendSku((DycProBaseCallEsbUtilUpdateSendSkuReqBO)callEsbUtilUpdateSendSkuReqBo);
                if (!CallEsbUtilUpdateSendSkuRspBO.getSuccess().booleanValue()) {
                    throw new ZTBusinessException("\u552e\u540e\u53d1\u8fd0\u4fe1\u606f\u586b\u5199\uff08\u975e\u4eac\u4e1c\uff09\u54cd\u5e94\u5931\u8d25");
                }
                if (!"0000".equals(CallEsbUtilUpdateSendSkuRspBO.getResultCode())) {
                    throw new ZTBusinessException("\u552e\u540e\u53d1\u8fd0\u4fe1\u606f\u586b\u5199\uff08\u975e\u4eac\u4e1c\uff09\u5931\u8d25: " + CallEsbUtilUpdateSendSkuRspBO.getResultMessage());
                }
            }
        }
    }

    public void dealOrderWaybillUphold(List<DycProOrderDealWaybillUpholdAfterOrderInfoBO> waybillUpholdList, Long userId) {
        ArrayList<DycProOrderAfOrderWaybillDTO> afOrderWaybillDtoList = new ArrayList<DycProOrderAfOrderWaybillDTO>();
        ArrayList<Long> afOrderIdList = new ArrayList<Long>();
        for (DycProOrderDealWaybillUpholdAfterOrderInfoBO dealWaybillUpholdAfterOrderInfoBo : waybillUpholdList) {
            DycProOrderAfOrderWaybillDTO afOrderWaybillDto = new DycProOrderAfOrderWaybillDTO();
            BeanUtils.copyProperties((Object)dealWaybillUpholdAfterOrderInfoBo, (Object)afOrderWaybillDto);
            afOrderWaybillDto.setCreateOperId(String.valueOf(userId));
            afOrderWaybillDtoList.add(afOrderWaybillDto);
            afOrderIdList.add(dealWaybillUpholdAfterOrderInfoBo.getAfOrderId());
        }
        this.dycProOrderAfOrderRepository.createAfOrderWayBillBatch(afOrderWaybillDtoList);
        DycProOrderAfOrderHandelDTO updateAfterOrderDto = new DycProOrderAfOrderHandelDTO();
        updateAfterOrderDto.setWaybillFlag(Integer.valueOf(0));
        updateAfterOrderDto.setAfOrderIdList(afOrderIdList);
        this.dycProOrderAfOrderRepository.updateAfOrderByConditionAndSyncNosql(updateAfterOrderDto);
    }

    private void verifyParam(DycProOrderDealWaybillUpholdAfterOrderReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getWaybillUpholdList())) {
            throw new ZTBusinessException("\u552e\u540e\u53d1\u8fd0\u4fe1\u606f\u4e3a\u7a7a");
        }
        for (DycProOrderDealWaybillUpholdAfterOrderInfoBO dealWaybillUpholdAfterOrderInfoBO : reqBo.getWaybillUpholdList()) {
            if (null == dealWaybillUpholdAfterOrderInfoBO.getOrderId()) {
                throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == dealWaybillUpholdAfterOrderInfoBO.getAfOrderId()) {
                throw new ZTBusinessException("\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == dealWaybillUpholdAfterOrderInfoBO.getFreight()) {
                throw new ZTBusinessException("\u8fd0\u8d39\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == dealWaybillUpholdAfterOrderInfoBO.getToPay()) {
                throw new ZTBusinessException("\u662f\u5426\u5230\u4ed8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)dealWaybillUpholdAfterOrderInfoBO.getForwardCompany())) {
                throw new ZTBusinessException("\u53d1\u8fd0\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == dealWaybillUpholdAfterOrderInfoBO.getForwardDate()) {
                throw new ZTBusinessException("\u53d1\u8fd0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)dealWaybillUpholdAfterOrderInfoBO.getForwardOrderNo())) {
                throw new ZTBusinessException("\u8d27\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)dealWaybillUpholdAfterOrderInfoBO.getSendCount())) {
                throw new ZTBusinessException("\u672c\u6b21\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isNotBlank((String)dealWaybillUpholdAfterOrderInfoBO.getExtAfId())) continue;
            if (null == dealWaybillUpholdAfterOrderInfoBO.getSaleOrderId()) {
                throw new ZTBusinessException("\u9500\u552e\u5355id\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)dealWaybillUpholdAfterOrderInfoBO.getSaleOrderNoExt())) {
                throw new ZTBusinessException("\u5916\u90e8\u9500\u552e\u5355\u7f16\u7801\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((String)dealWaybillUpholdAfterOrderInfoBO.getSupId())) continue;
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e3a\u7a7a");
        }
    }
}

