/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderQryDTO;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQrySaleOrderListPageOfItemDimensionService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQrySaleOrderListPageOfItemDimensionReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQrySaleOrderListPageOfItemDimensionRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleOrderOfItemDimensionBO;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQrySaleOrderListPageOfItemDimensionService"})
public class DycProOrderQrySaleOrderListPageOfItemDimensionServiceImpl
implements DycProOrderQrySaleOrderListPageOfItemDimensionService {
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @Override
    @PostMapping(value={"qrySaleOrderListPageOfItemDimension"})
    public DycProOrderQrySaleOrderListPageOfItemDimensionRspBO qrySaleOrderListPageOfItemDimension(@RequestBody DycProOrderQrySaleOrderListPageOfItemDimensionReqBO reqBO) {
        this.paramVerify(reqBO);
        this.setDataAuth(reqBO);
        DycProOrderSaleOrderQryDTO qryDTO = (DycProOrderSaleOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderSaleOrderQryDTO.class);
        qryDTO.setSaleOrderStateList(this.getSaleOrderState());
        RspPage rspPage = this.dycProOrderSaleOrderRepository.querySaleOrderPageListOfItemDimensionByCondition(qryDTO);
        DycProOrderQrySaleOrderListPageOfItemDimensionRspBO rspBO = (DycProOrderQrySaleOrderListPageOfItemDimensionRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)rspPage), DycProOrderQrySaleOrderListPageOfItemDimensionRspBO.class));
        this.translationRspData(rspBO);
        this.buildRspNumValue(rspBO);
        return rspBO;
    }

    private void paramVerify(DycProOrderQrySaleOrderListPageOfItemDimensionReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPageNo() < 1) {
            throw new ZTBusinessException("\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (reqBO.getPageSize() < 1) {
            throw new ZTBusinessException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
    }

    private void setDataAuth(DycProOrderQrySaleOrderListPageOfItemDimensionReqBO reqBO) {
        if ("1".equals(reqBO.getIsprofess())) {
            reqBO.setPurCompanyId(reqBO.getCompanyId());
        }
        if ("2".equals(reqBO.getIsprofess())) {
            reqBO.setSupId(String.valueOf(reqBO.getCompanyId()));
        }
    }

    private List<String> getSaleOrderState() {
        ArrayList<String> saleOrderStateList = new ArrayList<String>(1);
        saleOrderStateList.add("XS_QR_DQR");
        saleOrderStateList.add("XS_QR_JDDCL");
        saleOrderStateList.add("XS_SP_SPZ");
        saleOrderStateList.add("XS_QX_QXSQ");
        saleOrderStateList.add("XS_FH_DFH");
        saleOrderStateList.add("XS_FH_FHZ");
        saleOrderStateList.add("XS_FH_FHWC");
        saleOrderStateList.add("XS_DH_DH");
        saleOrderStateList.add("XS_DH_BFDH");
        saleOrderStateList.add("XS_YS_YS");
        saleOrderStateList.add("XS_YS_BFYS");
        saleOrderStateList.add("XS_DH_JS");
        saleOrderStateList.add("XS_QX_QX");
        saleOrderStateList.add("XS_XD_SB");
        return saleOrderStateList;
    }

    private void buildRspNumValue(DycProOrderQrySaleOrderListPageOfItemDimensionRspBO rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (DycProOrderSaleOrderOfItemDimensionBO saleOrderOfItemDimensionBO : rspBO.getRows()) {
                if (null != saleOrderOfItemDimensionBO.getSalePrice()) {
                    saleOrderOfItemDimensionBO.setSalePrice(saleOrderOfItemDimensionBO.getSalePrice().setScale(2, RoundingMode.HALF_UP));
                }
                if (null != saleOrderOfItemDimensionBO.getPurchasePrice()) {
                    saleOrderOfItemDimensionBO.setPurchasePrice(saleOrderOfItemDimensionBO.getPurchasePrice().setScale(2, RoundingMode.HALF_UP));
                }
                if (null != saleOrderOfItemDimensionBO.getPurchaseCount()) {
                    saleOrderOfItemDimensionBO.setPurchaseCount(saleOrderOfItemDimensionBO.getPurchaseCount().setScale(Integer.parseInt(saleOrderOfItemDimensionBO.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != saleOrderOfItemDimensionBO.getSaleFee()) {
                    saleOrderOfItemDimensionBO.setSaleFee(saleOrderOfItemDimensionBO.getSaleFee().setScale(2, RoundingMode.HALF_UP));
                }
                if (null == saleOrderOfItemDimensionBO.getPurchaseFee()) continue;
                saleOrderOfItemDimensionBO.setPurchaseFee(saleOrderOfItemDimensionBO.getPurchaseFee().setScale(2, RoundingMode.HALF_UP));
            }
        }
    }

    private void translationRspData(DycProOrderQrySaleOrderListPageOfItemDimensionRspBO rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (DycProOrderSaleOrderOfItemDimensionBO row : rspBO.getRows()) {
                if (null != row.getSaleOrderState()) {
                    row.setSaleOrderStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcSaleOrderSaleOrderState", (String)row.getSaleOrderState()));
                }
                if (null != row.getPayState()) {
                    row.setPayStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcSaleOrderPayState", (String)String.valueOf(row.getPayState())));
                }
                if (null != row.getPurchaseType()) {
                    row.setPurchaseTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommManageCatalogInfoPurchaseType", (String)String.valueOf(row.getPurchaseType())));
                }
                if (null == row.getMaterialType()) continue;
                row.setMaterialTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommManageCatalogInfoMaterialType", (String)String.valueOf(row.getMaterialType())));
            }
        }
    }
}

