/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.insporder.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.StringUtils;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.insporder.api.DycProOrderInspOrderRepository;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderQryDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderConfEffectiveDTO;
import com.tydic.dyc.pro.egc.service.insporder.api.DycProOrderQryInspOrderListPageService;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderInspOrderEsBO;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderQryInspOrderListPageReqBO;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderQryInspOrderListPageRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.insporder.api.DycProOrderQryInspOrderListPageService"})
public class DycProOrderQryInspOrderListPageServiceImpl
implements DycProOrderQryInspOrderListPageService {
    @Autowired
    private DycProOrderInspOrderRepository dycProOrderInspOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;

    @Override
    @PostMapping(value={"qryInspOrderListPage"})
    public DycProOrderQryInspOrderListPageRspBO qryInspOrderListPage(@RequestBody DycProOrderQryInspOrderListPageReqBO reqBO) {
        this.paramVerify(reqBO);
        this.setDataAuth(reqBO);
        DycProOrderInspOrderQryDTO qryDTO = (DycProOrderInspOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderInspOrderQryDTO.class);
        RspPage rspPage = this.dycProOrderInspOrderRepository.queryInspOrderEsPageListByCondition(qryDTO);
        DycProOrderQryInspOrderListPageRspBO rspBO = (DycProOrderQryInspOrderListPageRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)rspPage), DycProOrderQryInspOrderListPageRspBO.class));
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            rspBO.getRows().forEach(r -> {
                if (!CollectionUtils.isEmpty(r.getInspItemList())) {
                    HashSet shipOrderNoSet = new HashSet();
                    r.getInspItemList().forEach(dycProEsIndexMappingInspOrderItemBO -> {
                        if (StringUtils.hasText((String)dycProEsIndexMappingInspOrderItemBO.getShipOrderNo())) {
                            shipOrderNoSet.add(dycProEsIndexMappingInspOrderItemBO.getShipOrderNo());
                        }
                    });
                    if (!CollectionUtils.isEmpty(shipOrderNoSet)) {
                        r.setShipOrderNoList(new ArrayList<String>(shipOrderNoSet));
                    }
                }
            });
        }
        this.setConfEffective(rspBO);
        return rspBO;
    }

    private void setConfEffective(DycProOrderQryInspOrderListPageRspBO rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            Map<String, Map<String, Long>> confEffective = this.getConfEffective();
            for (DycProOrderInspOrderEsBO row : rspBO.getRows()) {
                Map<String, Long> allowChngTimeMap;
                if (CollectionUtils.isEmpty(confEffective) || !StringUtils.isNotBlank((String)row.getSaleStakeholder().getSupId()) || null == row.getOrderSource() || null == (allowChngTimeMap = confEffective.get("5" + row.getOrderSource()))) continue;
                Long time = allowChngTimeMap.get(row.getSaleStakeholder().getSupId());
                if (null == time) {
                    time = allowChngTimeMap.get("0");
                }
                row.setAllowChngAging(time);
            }
        }
    }

    private Map<String, Map<String, Long>> getConfEffective() {
        DycProOrderConfEffectiveDTO queryConfEffective = new DycProOrderConfEffectiveDTO();
        List confEffectiveDTOList = this.dycProOrderOrderRepository.queryConfEffectiveListByCondition(queryConfEffective);
        if (CollectionUtils.isEmpty((Collection)confEffectiveDTOList)) {
            return null;
        }
        Map<String, List<DycProOrderConfEffectiveDTO>> confEffectiveMap = confEffectiveDTOList.stream().collect(Collectors.groupingBy(confEffective -> confEffective.getEffectiveCode() + confEffective.getBusinessTypeCode()));
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        confEffectiveMap.forEach((key, value) -> map.put((String)key, value.stream().collect(Collectors.toMap(DycProOrderConfEffectiveDTO::getSupplierNo, DycProOrderConfEffectiveDTO::getAging))));
        return map;
    }

    private void paramVerify(DycProOrderQryInspOrderListPageReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPageNo() < 1) {
            throw new ZTBusinessException("\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (reqBO.getPageSize() < 1) {
            throw new ZTBusinessException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
    }

    private void setDataAuth(DycProOrderQryInspOrderListPageReqBO reqBO) {
        if ("abnormalChangeList".equals(reqBO.getMenuCode()) && "1".equals(reqBO.getIsprofess())) {
            reqBO.setPurUserId(String.valueOf(reqBO.getUserId()));
        }
    }
}

