/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderConfirmAfterOrderService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderConfirmAfterOrderReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderConfirmAfterOrderRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderConfirmAfterOrderService"})
public class DycProOrderConfirmAfterOrderServiceImpl
implements DycProOrderConfirmAfterOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderConfirmAfterOrderServiceImpl.class);
    private static final Integer OP_FLAG_REFUSE = 0;
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @Override
    @PostMapping(value={"confirmAfterOrder"})
    public DycProOrderConfirmAfterOrderRspBO confirmAfterOrder(@RequestBody DycProOrderConfirmAfterOrderReqBO reqBo) {
        this.verifyParam(reqBo);
        this.updateAfOrderInfo(reqBo);
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            this.updateServingCount(reqBo);
        }
        return new DycProOrderConfirmAfterOrderRspBO();
    }

    private void updateServingCount(DycProOrderConfirmAfterOrderReqBO reqBo) {
        DycProOrderAfOrderItemDTO afOrderQryDto = new DycProOrderAfOrderItemDTO();
        afOrderQryDto.setAfOrderId(reqBo.getAfOrderId());
        afOrderQryDto.setOrderId(reqBo.getOrderId());
        List afOrderItemDtoList = this.dycProOrderAfOrderRepository.queryAfOrderItemListByCondition(afOrderQryDto);
        DycProOrderAfOrderObjDTO afOrderObjQryDto = new DycProOrderAfOrderObjDTO();
        afOrderObjQryDto.setAfOrderId(reqBo.getAfOrderId());
        DycProOrderAfOrderObjDTO afOrderObjDto = this.dycProOrderAfOrderRepository.queryAfOrderObjOneByCondition(afOrderObjQryDto);
        DycProOrderShipOrderItemQryDTO shipOrderItemQryDto = new DycProOrderShipOrderItemQryDTO();
        shipOrderItemQryDto.setShipOrderId(afOrderObjDto.getShipOrderId());
        List shipOrderItemDtoList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(shipOrderItemQryDto);
        DycProOrderSaleOrderItemQryDTO saleOrderItemQryDto = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemQryDto.setSaleOrderId(afOrderObjDto.getSaleOrderId());
        List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(saleOrderItemQryDto);
        Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap = shipOrderItemDtoList.stream().collect(Collectors.toMap(DycProOrderShipOrderItemDTO::getShipOrderItemId, item -> item, (k1, k2) -> k1));
        Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleOrderItemDtoList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item, (k1, k2) -> k1));
        ArrayList<DycProOrderShipOrderItemDTO> updateShipOrderItemDTOList = new ArrayList<DycProOrderShipOrderItemDTO>(1);
        ArrayList<DycProOrderSaleOrderItemDTO> updateSaleOrderItemDTOList = new ArrayList<DycProOrderSaleOrderItemDTO>(1);
        for (DycProOrderAfOrderItemDTO afOrderItemDto : afOrderItemDtoList) {
            DycProOrderShipOrderItemDTO thisShipOrderItem = shipOrderItemMap.get(afOrderItemDto.getShipItemId());
            DycProOrderSaleOrderItemDTO thisSaleOrderItem = saleOrderItemMap.get(afOrderItemDto.getSaleOrderItemId());
            BigDecimal returnCount = afOrderItemDto.getReturnCount();
            DycProOrderShipOrderItemDTO uocShipOrderItem = new DycProOrderShipOrderItemDTO();
            uocShipOrderItem.setOrderId(afOrderItemDto.getOrderId());
            uocShipOrderItem.setShipOrderItemId(afOrderItemDto.getShipItemId());
            uocShipOrderItem.setAfterServingCount(thisShipOrderItem.getAfterServingCount().subtract(returnCount));
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            updateShipOrderItemDTOList.add(uocShipOrderItem);
            DycProOrderSaleOrderItemDTO uocSaleOrderItem = new DycProOrderSaleOrderItemDTO();
            uocSaleOrderItem.setOrderId(afOrderItemDto.getOrderId());
            uocSaleOrderItem.setSaleOrderItemId(afOrderItemDto.getSaleOrderItemId());
            uocSaleOrderItem.setAfterServingCount(thisSaleOrderItem.getAfterServingCount().subtract(returnCount));
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
            updateSaleOrderItemDTOList.add(uocSaleOrderItem);
        }
        DycProOrderShipOrderDTO updateShipOrderDTO = new DycProOrderShipOrderDTO();
        updateShipOrderDTO.setShipItemList(updateShipOrderItemDTOList);
        updateShipOrderDTO.setShipOrderId(afOrderObjDto.getShipOrderId());
        this.dycProOrderShipOrderRepository.updateShipOrderItemBatchByIdsAndSyncNosql(updateShipOrderDTO);
        this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(updateSaleOrderItemDTOList);
        ArrayList<DycProOrderAfOrderDTO> afOrderList = new ArrayList<DycProOrderAfOrderDTO>(1);
        DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
        updateAfOrderDTO.setAfOrderId(reqBo.getAfOrderId());
        updateAfOrderDTO.setServState(DycProOrderManageServiceConstant.ServiceState.APPROVAL_NOT_PASS);
        afOrderList.add(updateAfOrderDTO);
        DycProOrderSaleOrderDTO updateSaleOrderDTO = new DycProOrderSaleOrderDTO();
        updateSaleOrderDTO.setSaleOrderId(afOrderObjDto.getSaleOrderId());
        updateSaleOrderDTO.setAfOrderList(afOrderList);
        this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDTO);
    }

    private void updateAfOrderInfo(DycProOrderConfirmAfterOrderReqBO reqBo) {
        DycProOrderAfOrderDTO updateAfOrderDTO = new DycProOrderAfOrderDTO();
        updateAfOrderDTO.setAfOrderId(reqBo.getAfOrderId());
        updateAfOrderDTO.setOrderId(reqBo.getOrderId());
        updateAfOrderDTO.setConfirmTime(new Date());
        if (StringUtils.isNotBlank((String)reqBo.getReturnReason())) {
            updateAfOrderDTO.setReturnReason(reqBo.getReturnReason());
        }
        updateAfOrderDTO.setUpdateTime(new Date());
        if (reqBo.getOpFlag() == 0) {
            updateAfOrderDTO.setWaybillFlag(DycProOrderManageServiceConstant.WaybillFlag.CAN_NOT_MAINTAIN);
            updateAfOrderDTO.setServState(DycProOrderManageServiceConstant.ServiceState.APPROVAL_NOT_PASS);
        } else if (reqBo.getOpFlag() == 1) {
            updateAfOrderDTO.setWaybillFlag(DycProOrderManageServiceConstant.WaybillFlag.CAN_MAINTAIN);
            updateAfOrderDTO.setServState(DycProOrderManageServiceConstant.ServiceState.APPROVAL_PASS);
        } else {
            throw new ZTBusinessException("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        this.dycProOrderAfOrderRepository.updateAfOrderByIdAndSyncNosql(updateAfOrderDTO);
    }

    private void verifyParam(DycProOrderConfirmAfterOrderReqBO reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAfOrderId()) {
            throw new ZTBusinessException("\u552e\u540e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOpFlag().equals(0) && StringUtils.isBlank((String)reqBo.getReturnReason())) {
            throw new ZTBusinessException("\u62d2\u7edd\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

