/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyItemDTO;
import com.tydic.dyc.pro.egc.service.api.DycProOrderItemImportService;
import com.tydic.dyc.pro.egc.service.bo.DycProAgrImportReasonBO;
import com.tydic.dyc.pro.egc.service.bo.DycProOrderItemImportInfoBO;
import com.tydic.dyc.pro.egc.service.bo.DycProOrderItemImportReqBO;
import com.tydic.dyc.pro.egc.service.bo.DycProOrderItemImportRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.api.DycProOrderItemImportService"})
public class DycProOrderItemImportServiceImpl
implements DycProOrderItemImportService {
    @Autowired
    private DycProOrderPurchaseApplyRepository dycProOrderPurchaseApplyRepository;

    @Override
    @PostMapping(value={"itemImportFile"})
    public DycProOrderItemImportRspBO itemImportFile(@RequestBody DycProOrderItemImportReqBO reqBO) {
        ArrayList<DycProOrderItemImportInfoBO> importItemBOS = new ArrayList<DycProOrderItemImportInfoBO>();
        ArrayList<DycProAgrImportReasonBO> failReasonList = new ArrayList<DycProAgrImportReasonBO>();
        DycProOrderItemImportRspBO rspBO = new DycProOrderItemImportRspBO();
        rspBO.setFailReasonList(failReasonList);
        this.judge(reqBO, importItemBOS, failReasonList);
        if (CollectionUtils.isEmpty(importItemBOS)) {
            return rspBO;
        }
        this.importPurchaseItem(reqBO, importItemBOS, failReasonList);
        return rspBO;
    }

    private void importPurchaseItem(DycProOrderItemImportReqBO reqBO, List<DycProOrderItemImportInfoBO> importItemBOS, List<DycProAgrImportReasonBO> failReasonList) {
        importItemBOS.sort(Comparator.comparing(DycProOrderItemImportInfoBO::getSkuCode));
        ArrayList<DycProOrderZlPurchaseApplyItemDTO> createItemDTOS = new ArrayList<DycProOrderZlPurchaseApplyItemDTO>();
        for (DycProOrderItemImportInfoBO dycProOrderItemImportInfoBO : importItemBOS) {
            DycProOrderZlPurchaseApplyItemDTO dycProPurchaseItemDTO = new DycProOrderZlPurchaseApplyItemDTO();
            dycProPurchaseItemDTO.setSkuCode(dycProOrderItemImportInfoBO.getSkuCode());
            dycProPurchaseItemDTO.setApplyAmount(dycProOrderItemImportInfoBO.getApplyAmount());
            dycProPurchaseItemDTO.setApplyItemRemark(dycProOrderItemImportInfoBO.getApplyItemRemark());
            createItemDTOS.add(dycProPurchaseItemDTO);
        }
        if (!CollectionUtils.isEmpty(createItemDTOS)) {
            for (DycProOrderZlPurchaseApplyItemDTO dycProOrderZlPurchaseApplyItemDTO : createItemDTOS) {
                dycProOrderZlPurchaseApplyItemDTO.setPurApplyId(reqBO.getPurApplyId());
            }
            this.dycProOrderPurchaseApplyRepository.createBatchPurchaseApplyItem(createItemDTOS);
        }
    }

    private void judge(DycProOrderItemImportReqBO reqBO, List<DycProOrderItemImportInfoBO> importItemBOS, List<DycProAgrImportReasonBO> failReasonList) {
        if (CollectionUtils.isEmpty(reqBO.getItemList())) {
            throw new ZTBusinessException("\u3010\u91c7\u8d2d\u660e\u7ec6\u5bfc\u5165\u6570\u636e\u884c\u3011\u4e3a\u7a7a");
        }
        if (reqBO.getItemList().size() > 2000) {
            throw new ZTBusinessException("\u6700\u591a\u652f\u63012000\u6761\u660e\u7ec6\u5546\u54c1\u5bfc\u5165");
        }
        for (DycProOrderItemImportInfoBO each : reqBO.getItemList()) {
            if (null == each.getGluttonLineNum()) {
                throw new ZTBusinessException("\u3010\u5bfc\u5165\u4e2d\u5fc3\u884c\u53f7\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)each.getSkuCode())) {
                failReasonList.add(this.setFailReason("\u3010\u5546\u54c1\u7f16\u53f7\u3011\u4e3a\u7a7a\uff0c\u672a\u53d1\u73b0\u6709\u5168\u884c", each.getGluttonLineNum()));
                continue;
            }
            if (null != each.getApplyAmount() && each.getApplyAmount().compareTo(BigDecimal.ZERO) <= 0) {
                failReasonList.add(this.setFailReason("\u3010\u7533\u8bf7\u6570\u91cf\u3011\u5fc5\u987b\u5927\u4e8e0", each.getGluttonLineNum()));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)each.getApplyItemRemark()) && each.getApplyItemRemark().length() > 500) {
                failReasonList.add(this.setFailReason("\u3010\u7533\u8bf7\u5907\u6ce8\u3011\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500\u5b57\u7b26", each.getGluttonLineNum()));
                continue;
            }
            importItemBOS.add(each);
        }
        this.checkDuplicateProductSku(importItemBOS, failReasonList);
    }

    private void checkDuplicateProductSku(List<DycProOrderItemImportInfoBO> importItemBOS, List<DycProAgrImportReasonBO> failReasonList) {
        Map<String, List<DycProOrderItemImportInfoBO>> skuGroupMap = importItemBOS.stream().collect(Collectors.groupingBy(DycProOrderItemImportInfoBO::getSkuCode));
        for (Map.Entry<String, List<DycProOrderItemImportInfoBO>> entry : skuGroupMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            for (DycProOrderItemImportInfoBO item2 : entry.getValue()) {
                failReasonList.add(this.setFailReason("\u3010\u5546\u54c1\u7f16\u53f7\u3011\u5b58\u5728\u91cd\u590d", item2.getGluttonLineNum()));
            }
        }
        importItemBOS.removeIf(item -> ((List)skuGroupMap.get(item.getSkuCode())).size() > 1);
    }

    private DycProAgrImportReasonBO setFailReason(String failReason, Integer lineNum) {
        DycProAgrImportReasonBO failReasonBO = new DycProAgrImportReasonBO();
        failReasonBO.setFailReason(failReason);
        failReasonBO.setLineNum(lineNum);
        return failReasonBO;
    }
}

